"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutput = exports.CdkStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const core_1 = require("@aws-cdk/core");
const actions_1 = require("./actions");
const asset_manifest_1 = require("./private/asset-manifest");
const toposort_1 = require("./private/toposort");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * (experimental) Stage in a CdkPipeline.
 *
 * You don't need to instantiate this class directly. Use
 * `cdkPipeline.addStage()` instead.
 *
 * @experimental
 */
class CdkStage extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this._nextSequentialRunOrder = 1; // Must start at 1 eh
        this._manualApprovalCounter = 1;
        this.stacksToDeploy = new Array();
        this._prepared = false;
        this.stageName = props.stageName;
        this.pipelineStage = props.pipelineStage;
        this.cloudAssemblyArtifact = props.cloudAssemblyArtifact;
        this.host = props.host;
        core_1.Aspects.of(this).add({ visit: () => this.prepareStage() });
    }
    /**
     * (experimental) Add all stacks in the application Stage to this stage.
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     *
     * @experimental
     */
    addApplication(appStage, options = {}) {
        var _c;
        const asm = appStage.synth();
        const extraRunOrderSpace = (_c = options.extraRunOrderSpace) !== null && _c !== void 0 ? _c : 0;
        if (asm.stacks.length === 0) {
            // If we don't check here, a more puzzling "stage contains no actions"
            // error will be thrown come deployment time.
            throw new Error(`The given Stage construct ('${appStage.node.path}') should contain at least one Stack`);
        }
        const sortedTranches = toposort_1.topologicalSort(asm.stacks, stack => stack.id, stack => stack.dependencies.map(d => d.id));
        for (const stacks of sortedTranches) {
            const runOrder = this.nextSequentialRunOrder(extraRunOrderSpace + 2); // 2 actions for Prepare/Execute ChangeSet
            let executeRunOrder = runOrder + extraRunOrderSpace + 1;
            // If we need to insert a manual approval action, then what's the executeRunOrder
            // now is where we add a manual approval step, and we allocate 1 more runOrder
            // for the execute.
            if (options.manualApprovals) {
                this.addManualApprovalAction({ runOrder: runOrder + 1 });
                executeRunOrder = this.nextSequentialRunOrder();
            }
            // These don't have a dependency on each other, so can all be added in parallel
            for (const stack of stacks) {
                this.addStackArtifactDeployment(stack, { runOrder, executeRunOrder });
            }
        }
    }
    /**
     * (experimental) Add a deployment action based on a stack artifact.
     *
     * @experimental
     */
    addStackArtifactDeployment(stackArtifact, options = {}) {
        var _c, _d;
        // Get all assets manifests and add the assets in 'em to the asset publishing stage.
        this.publishAssetDependencies(stackArtifact);
        // Remember for later, see 'prepare()'
        // We know that deploying a stack is going to take up 2 runorder slots later on.
        const runOrder = (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(2);
        const executeRunOrder = (_d = options.executeRunOrder) !== null && _d !== void 0 ? _d : runOrder + 1;
        this.stacksToDeploy.push({
            prepareRunOrder: runOrder,
            executeRunOrder,
            stackArtifact,
        });
        this.advanceRunOrderPast(runOrder);
        this.advanceRunOrderPast(executeRunOrder);
    }
    /**
     * (experimental) Add a manual approval action.
     *
     * If you need more flexibility than what this method offers,
     * use `addAction` with a `ManualApprovalAction`.
     *
     * @experimental
     */
    addManualApprovalAction(options = {}) {
        var _c;
        let actionName = options.actionName;
        if (!actionName) {
            actionName = `ManualApproval${this._manualApprovalCounter > 1 ? this._manualApprovalCounter : ''}`;
            this._manualApprovalCounter += 1;
        }
        this.addActions(new cpactions.ManualApprovalAction({
            actionName,
            runOrder: (_c = options.runOrder) !== null && _c !== void 0 ? _c : this.nextSequentialRunOrder(),
        }));
    }
    /**
     * (experimental) Add one or more CodePipeline Actions.
     *
     * You need to make sure it is created with the right runOrder. Call `nextSequentialRunOrder()`
     * for every action to get actions to execute in sequence.
     *
     * @experimental
     */
    addActions(...actions) {
        for (const action of actions) {
            this.pipelineStage.addAction(action);
        }
    }
    /**
     * (experimental) Return the runOrder number necessary to run the next Action in sequence with the rest.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     *
     * @experimental
     */
    nextSequentialRunOrder(count = 1) {
        const ret = this._nextSequentialRunOrder;
        this._nextSequentialRunOrder += count;
        return ret;
    }
    /**
     * (experimental) Whether this Stage contains an action to deploy the given stack, identified by its artifact ID.
     *
     * @experimental
     */
    deploysStack(artifactId) {
        return this.stacksToDeploy.map(s => s.stackArtifact.id).includes(artifactId);
    }
    /**
     * Actually add all the DeployStack actions to the stage.
     *
     * We do this late because before we can render the actual DeployActions,
     * we need to know whether or not we need to capture the stack outputs.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    prepareStage() {
        // FIXME: Make sure this only gets run once. There seems to be an issue in the reconciliation
        // loop that may trigger this more than once if it throws an error somewhere, and the exception
        // that gets thrown here will then override the actual failure.
        if (this._prepared) {
            return;
        }
        this._prepared = true;
        for (const { prepareRunOrder, stackArtifact, executeRunOrder } of this.stacksToDeploy) {
            const artifact = this.host.stackOutputArtifact(stackArtifact.id);
            this.pipelineStage.addAction(actions_1.DeployCdkStackAction.fromStackArtifact(this, stackArtifact, {
                baseActionName: this.simplifyStackName(stackArtifact.stackName),
                cloudAssemblyInput: this.cloudAssemblyArtifact,
                output: artifact,
                outputFileName: artifact ? 'outputs.json' : undefined,
                prepareRunOrder,
                executeRunOrder,
            }));
        }
    }
    /**
     * Advance the runorder counter so that the next sequential number is higher than the given one
     */
    advanceRunOrderPast(lastUsed) {
        this._nextSequentialRunOrder = Math.max(lastUsed + 1, this._nextSequentialRunOrder);
    }
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    simplifyStackName(s) {
        return stripPrefix(s, `${this.stageName}-`);
    }
    /**
     * Make sure all assets depended on by this stack are published in this pipeline
     *
     * Taking care to exclude the stack template itself -- it is being published
     * as an asset because the CLI needs to know the asset publishing role when
     * pushing the template to S3, but in the case of CodePipeline we always
     * reference the template from the artifact bucket.
     *
     * (NOTE: this is only true for top-level stacks, not nested stacks. Nested
     * Stack templates are always published as assets).
     */
    publishAssetDependencies(stackArtifact) {
        const assetManifests = stackArtifact.dependencies.filter(isAssetManifest);
        for (const manifestArtifact of assetManifests) {
            const manifest = asset_manifest_1.AssetManifestReader.fromFile(manifestArtifact.file);
            for (const entry of manifest.entries) {
                let assetType;
                if (entry instanceof asset_manifest_1.DockerImageManifestEntry) {
                    assetType = actions_1.AssetType.DOCKER_IMAGE;
                }
                else if (entry instanceof asset_manifest_1.FileManifestEntry) {
                    // Don't publishg the template for this stack
                    if (entry.source.packaging === 'file' && entry.source.path === stackArtifact.templateFile) {
                        continue;
                    }
                    assetType = actions_1.AssetType.FILE;
                }
                else {
                    throw new Error(`Unrecognized asset type: ${entry.type}`);
                }
                this.host.publishAsset({
                    assetManifestPath: manifestArtifact.file,
                    assetId: entry.id.assetId,
                    assetSelector: entry.id.toString(),
                    assetType,
                });
            }
        }
    }
}
exports.CdkStage = CdkStage;
_a = JSII_RTTI_SYMBOL_1;
CdkStage[_a] = { fqn: "@aws-cdk/pipelines.CdkStage", version: "1.101.0" };
/**
 * (experimental) A single output of a Stack.
 *
 * @experimental
 */
class StackOutput {
    /**
     * (experimental) Build a StackOutput from a known artifact and an output name.
     *
     * @experimental
     */
    constructor(artifactFile, outputName) {
        this.artifactFile = artifactFile;
        this.outputName = outputName;
    }
}
exports.StackOutput = StackOutput;
_b = JSII_RTTI_SYMBOL_1;
StackOutput[_b] = { fqn: "@aws-cdk/pipelines.StackOutput", version: "1.101.0" };
function stripPrefix(s, prefix) {
    return s.startsWith(prefix) ? s.substr(prefix.length) : s;
}
function isAssetManifest(s) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return s instanceof cxapi.AssetManifestArtifact;
    return s.constructor.name === 'AssetManifestArtifact';
}
//# sourceMappingURL=data:application/json;base64,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