import * as codebuild from '@aws-cdk/aws-codebuild';
import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as events from '@aws-cdk/aws-events';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Configuration options for a SimpleSynth.
 *
 * @experimental
 */
export interface SimpleSynthOptions {
    /**
     * (experimental) The source artifact of the CodePipeline.
     *
     * @experimental
     */
    readonly sourceArtifact: codepipeline.Artifact;
    /**
     * (experimental) The artifact where the CloudAssembly should be emitted.
     *
     * @experimental
     */
    readonly cloudAssemblyArtifact: codepipeline.Artifact;
    /**
     * (experimental) Environment variables to send into build.
     *
     * @default - No additional environment variables
     * @experimental
     */
    readonly environmentVariables?: Record<string, codebuild.BuildEnvironmentVariable>;
    /**
     * (experimental) Environment variables to copy over from parent env.
     *
     * These are environment variables that are being used by the build.
     *
     * @default - No environment variables copied
     * @experimental
     */
    readonly copyEnvironmentVariables?: string[];
    /**
     * (experimental) Name of the build action.
     *
     * @default 'Synth'
     * @experimental
     */
    readonly actionName?: string;
    /**
     * (experimental) Name of the CodeBuild project.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly projectName?: string;
    /**
     * (experimental) Build environment to use for CodeBuild job.
     *
     * @default BuildEnvironment.LinuxBuildImage.STANDARD_5_0
     * @experimental
     */
    readonly environment?: codebuild.BuildEnvironment;
    /**
     * (experimental) Directory inside the source where package.json and cdk.json are located.
     *
     * @default - Repository root
     * @experimental
     */
    readonly subdirectory?: string;
    /**
     * (experimental) Produce additional output artifacts after the build based on the given directories.
     *
     * Can be used to produce additional artifacts during the build step,
     * separate from the cloud assembly, which can be used further on in the
     * pipeline.
     *
     * Directories are evaluated with respect to `subdirectory`.
     *
     * @default - No additional artifacts generated
     * @experimental
     */
    readonly additionalArtifacts?: AdditionalArtifact[];
    /**
     * (experimental) Policy statements to add to role used during the synth.
     *
     * Can be used to add acces to a CodeArtifact repository etc.
     *
     * @default - No policy statements added to CodeBuild Project Role
     * @experimental
     */
    readonly rolePolicyStatements?: iam.PolicyStatement[];
    /**
     * (experimental) The VPC where to execute the SimpleSynth.
     *
     * @default - No VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * (experimental) Construction props for SimpleSynthAction.
 *
 * @experimental
 */
export interface SimpleSynthActionProps extends SimpleSynthOptions {
    /**
     * (experimental) The synth command.
     *
     * @experimental
     */
    readonly synthCommand: string;
    /**
     * (deprecated) The install command.
     *
     * If not provided by the build image or another dependency
     * management tool, at least install the CDK CLI here using
     * `npm install -g aws-cdk`.
     *
     * @default - No install required
     * @deprecated Use `installCommands` instead
     */
    readonly installCommand?: string;
    /**
     * (deprecated) The build command.
     *
     * If your programming language requires a compilation step, put the
     * compilation command here.
     *
     * @default - No build required
     * @deprecated Use `buildCommands` instead
     */
    readonly buildCommand?: string;
    /**
     * (experimental) Install commands.
     *
     * If not provided by the build image or another dependency
     * management tool, at least install the CDK CLI here using
     * `npm install -g aws-cdk`.
     *
     * @default - No install required
     * @experimental
     */
    readonly installCommands?: string[];
    /**
     * (experimental) The build commands.
     *
     * If your programming language requires a compilation step, put the
     * compilation command here.
     *
     * @default - No build required
     * @experimental
     */
    readonly buildCommands?: string[];
    /**
     * (experimental) Test commands.
     *
     * These commands are run after the build commands but before the
     * synth command.
     *
     * @default - No test commands
     * @experimental
     */
    readonly testCommands?: string[];
}
/**
 * (experimental) Specification of an additional artifact to generate.
 *
 * @experimental
 */
export interface AdditionalArtifact {
    /**
     * (experimental) Directory to be packaged.
     *
     * @experimental
     */
    readonly directory: string;
    /**
     * (experimental) Artifact to represent the build directory in the pipeline.
     *
     * @experimental
     */
    readonly artifact: codepipeline.Artifact;
}
/**
 * (experimental) A standard synth with a generated buildspec.
 *
 * @experimental
 */
export declare class SimpleSynthAction implements codepipeline.IAction, iam.IGrantable {
    private readonly props;
    /**
     * (experimental) Create a standard NPM synth action.
     *
     * Uses `npm ci` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'npm run build'`.
     *
     * @experimental
     */
    static standardNpmSynth(options: StandardNpmSynthOptions): SimpleSynthAction;
    /**
     * (experimental) Create a standard Yarn synth action.
     *
     * Uses `yarn install --frozen-lockfile` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'yarn build'`.
     *
     * @experimental
     */
    static standardYarnSynth(options: StandardYarnSynthOptions): SimpleSynthAction;
    private _action?;
    private _actionProperties;
    private _project?;
    /**
     * @experimental
     */
    constructor(props: SimpleSynthActionProps);
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
    /**
     * (experimental) Project generated to run the synth command.
     *
     * @experimental
     */
    get project(): codebuild.IProject;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * (experimental) The CodeBuild Project's principal.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
/**
 * (experimental) Options for a convention-based synth using NPM.
 *
 * @experimental
 */
export interface StandardNpmSynthOptions extends SimpleSynthOptions {
    /**
     * (experimental) The install command.
     *
     * @default 'npm ci'
     * @experimental
     */
    readonly installCommand?: string;
    /**
     * (experimental) The build command.
     *
     * By default, we assume NPM projects are either written in JavaScript or are
     * using `ts-node`, so don't need a build command.
     *
     * Otherwise, put the build command here, for example `npm run build`.
     *
     * @default - No build required
     * @experimental
     */
    readonly buildCommand?: string;
    /**
     * (experimental) The synth command.
     *
     * @default 'npx cdk synth'
     * @experimental
     */
    readonly synthCommand?: string;
}
/**
 * (experimental) Options for a convention-based synth using Yarn.
 *
 * @experimental
 */
export interface StandardYarnSynthOptions extends SimpleSynthOptions {
    /**
     * (experimental) The install command.
     *
     * @default 'yarn install --frozen-lockfile'
     * @experimental
     */
    readonly installCommand?: string;
    /**
     * (experimental) The build command.
     *
     * By default, we assume NPM projects are either written in JavaScript or are
     * using `ts-node`, so don't need a build command.
     *
     * Otherwise, put the build command here, for example `npm run build`.
     *
     * @default - No build required
     * @experimental
     */
    readonly buildCommand?: string;
    /**
     * (experimental) The synth command.
     *
     * @default 'npx cdk synth'
     * @experimental
     */
    readonly synthCommand?: string;
}
