"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleSynthAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const path = require("path");
const codebuild = require("@aws-cdk/aws-codebuild");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const codepipeline_actions = require("@aws-cdk/aws-codepipeline-actions");
const core_1 = require("@aws-cdk/core");
const fs_1 = require("../private/fs");
const _util_1 = require("./_util");
const DEFAULT_OUTPUT_DIR = 'cdk.out';
/**
 * (experimental) A standard synth with a generated buildspec.
 *
 * @experimental
 */
class SimpleSynthAction {
    /**
     * @experimental
     */
    constructor(props) {
        var _b, _c, _d;
        this.props = props;
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: (_b = props.actionName) !== null && _b !== void 0 ? _b : 'Synth',
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [props.sourceArtifact],
            outputs: [props.cloudAssemblyArtifact, ...((_c = props.additionalArtifacts) !== null && _c !== void 0 ? _c : []).map(a => a.artifact)],
        };
        if (this.props.installCommand && this.props.installCommands) {
            throw new Error('Pass either \'installCommand\' or \'installCommands\', but not both');
        }
        if (this.props.buildCommand && this.props.buildCommands) {
            throw new Error('Pass either \'buildCommand\' or \'buildCommands\', but not both');
        }
        const addls = (_d = props.additionalArtifacts) !== null && _d !== void 0 ? _d : [];
        if (Object.keys(addls).length > 0) {
            if (!props.cloudAssemblyArtifact.artifactName) {
                throw new Error('You must give all output artifacts, including the \'cloudAssemblyArtifact\', names when using \'additionalArtifacts\'');
            }
            for (const addl of addls) {
                if (!addl.artifact.artifactName) {
                    throw new Error('You must give all output artifacts passed to SimpleSynthAction names when using \'additionalArtifacts\'');
                }
            }
        }
    }
    /**
     * (experimental) Create a standard NPM synth action.
     *
     * Uses `npm ci` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'npm run build'`.
     *
     * @experimental
     */
    static standardNpmSynth(options) {
        var _b, _c;
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'npm ci',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
        });
    }
    /**
     * (experimental) Create a standard Yarn synth action.
     *
     * Uses `yarn install --frozen-lockfile` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'yarn build'`.
     *
     * @experimental
     */
    static standardYarnSynth(options) {
        var _b, _c;
        return new SimpleSynthAction({
            ...options,
            installCommand: (_b = options.installCommand) !== null && _b !== void 0 ? _b : 'yarn install --frozen-lockfile',
            synthCommand: (_c = options.synthCommand) !== null && _c !== void 0 ? _c : 'npx cdk synth',
            vpc: options.vpc,
            subnetSelection: options.subnetSelection,
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        return this._actionProperties;
    }
    /**
     * (experimental) Project generated to run the synth command.
     *
     * @experimental
     */
    get project() {
        if (!this._project) {
            throw new Error('Project becomes available after SimpleSynthAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        var _b, _c, _d, _e;
        const buildCommands = (_b = this.props.buildCommands) !== null && _b !== void 0 ? _b : [this.props.buildCommand];
        const installCommands = (_c = this.props.installCommands) !== null && _c !== void 0 ? _c : [this.props.installCommand];
        const testCommands = (_d = this.props.testCommands) !== null && _d !== void 0 ? _d : [];
        const synthCommand = this.props.synthCommand;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                pre_build: {
                    commands: _util_1.filterEmpty([
                        this.props.subdirectory ? `cd ${this.props.subdirectory}` : '',
                        ...installCommands,
                    ]),
                },
                build: {
                    commands: _util_1.filterEmpty([
                        ...buildCommands,
                        ...testCommands,
                        synthCommand,
                    ]),
                },
            },
            artifacts: renderArtifacts(this),
        });
        const environment = { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0, ...this.props.environment };
        const environmentVariables = {
            ..._util_1.copyEnvironmentVariables(...this.props.copyEnvironmentVariables || []),
        };
        // A hash over the values that make the CodeBuild Project unique (and necessary
        // to restart the pipeline if one of them changes). projectName is not necessary to include
        // here because the pipeline will definitely restart if projectName changes.
        // (Resolve tokens)
        const projectConfigHash = hash(core_1.Stack.of(scope).resolve({
            environment: serializeBuildEnvironment(environment),
            buildSpecString: buildSpec.toBuildSpec(),
            environmentVariables,
        }));
        const project = new codebuild.PipelineProject(scope, 'CdkBuildProject', {
            projectName: this.props.projectName,
            environment,
            vpc: this.props.vpc,
            subnetSelection: this.props.subnetSelection,
            buildSpec,
            environmentVariables,
        });
        if (this.props.rolePolicyStatements !== undefined) {
            this.props.rolePolicyStatements.forEach(policyStatement => {
                project.addToRolePolicy(policyStatement);
            });
        }
        this._project = project;
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.actionProperties.actionName,
            input: this.props.sourceArtifact,
            outputs: [this.props.cloudAssemblyArtifact, ...((_e = this.props.additionalArtifacts) !== null && _e !== void 0 ? _e : []).map(a => a.artifact)],
            // Inclusion of the hash here will lead to the pipeline structure for any changes
            // made the config of the underlying CodeBuild Project.
            // Hence, the pipeline will be restarted. This is necessary if the users
            // adds (for example) build or test commands to the buildspec.
            environmentVariables: {
                ...this.props.environmentVariables,
                _PROJECT_CONFIG_HASH: { value: projectConfigHash },
            },
            project,
        });
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
        function renderArtifacts(self) {
            // save the generated files in the output artifact
            // This part of the buildspec has to look completely different depending on whether we're
            // using secondary artifacts or not.
            var _b;
            const cloudAsmArtifactSpec = {
                'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', DEFAULT_OUTPUT_DIR)),
                'files': '**/*',
            };
            if (self.props.additionalArtifacts) {
                const secondary = {};
                if (!self.props.cloudAssemblyArtifact.artifactName) {
                    throw new Error('When using additional output artifacts, you must also name the CloudAssembly artifact');
                }
                secondary[self.props.cloudAssemblyArtifact.artifactName] = cloudAsmArtifactSpec;
                self.props.additionalArtifacts.forEach((art) => {
                    var _b;
                    if (!art.artifact.artifactName) {
                        throw new Error('You must give the output artifact a name');
                    }
                    secondary[art.artifact.artifactName] = {
                        'base-directory': fs_1.toPosixPath(path.join((_b = self.props.subdirectory) !== null && _b !== void 0 ? _b : '.', art.directory)),
                        'files': '**/*',
                    };
                });
                return { 'secondary-artifacts': secondary };
            }
            return cloudAsmArtifactSpec;
        }
    }
    /**
     * (experimental) The CodeBuild Project's principal.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.project.grantPrincipal;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
}
exports.SimpleSynthAction = SimpleSynthAction;
_a = JSII_RTTI_SYMBOL_1;
SimpleSynthAction[_a] = { fqn: "@aws-cdk/pipelines.SimpleSynthAction", version: "1.101.0" };
function hash(obj) {
    const d = crypto.createHash('sha256');
    d.update(JSON.stringify(obj));
    return d.digest('hex');
}
/**
 * Serialize a build environment to data (get rid of constructs & objects), so we can JSON.stringify it
 */
function serializeBuildEnvironment(env) {
    var _b, _c, _d, _e, _f;
    return {
        privileged: env.privileged,
        environmentVariables: env.environmentVariables,
        type: (_b = env.buildImage) === null || _b === void 0 ? void 0 : _b.type,
        imageId: (_c = env.buildImage) === null || _c === void 0 ? void 0 : _c.imageId,
        computeType: env.computeType,
        imagePullPrincipalType: (_d = env.buildImage) === null || _d === void 0 ? void 0 : _d.imagePullPrincipalType,
        secretsManagerArn: (_f = (_e = env.buildImage) === null || _e === void 0 ? void 0 : _e.secretsManagerCredentials) === null || _f === void 0 ? void 0 : _f.secretArn,
    };
}
//# sourceMappingURL=data:application/json;base64,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