"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShellScriptAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("@aws-cdk/aws-codebuild");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const codepipeline_actions = require("@aws-cdk/aws-codepipeline-actions");
/**
 * (experimental) Validate a revision using shell commands.
 *
 * @experimental
 */
class ShellScriptAction {
    /**
     * @experimental
     */
    constructor(props) {
        var _b, _c;
        this.props = props;
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: props.actionName,
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [],
            outputs: [],
        };
        if (Object.keys((_b = props.useOutputs) !== null && _b !== void 0 ? _b : {}).length + ((_c = props.additionalArtifacts) !== null && _c !== void 0 ? _c : []).length === 0) {
            throw new Error('You must supply either \'useOutputs\' or \'additionalArtifacts\', since a CodeBuild Action must always have at least one input artifact.');
        }
    }
    /**
     * (experimental) The CodeBuild Project's principal.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.project.grantPrincipal;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        return this._actionProperties;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        var _b, _c, _d, _e, _f;
        const inputs = new Array();
        inputs.push(...(_b = this.props.additionalArtifacts) !== null && _b !== void 0 ? _b : []);
        const envVarCommands = new Array();
        const bashOptions = (_c = this.props.bashOptions) !== null && _c !== void 0 ? _c : '-eu';
        if (bashOptions) {
            envVarCommands.push(`set ${bashOptions}`);
        }
        for (const [varName, output] of Object.entries((_d = this.props.useOutputs) !== null && _d !== void 0 ? _d : {})) {
            const outputArtifact = output.artifactFile;
            // Add the artifact to the list of inputs, if it's not in there already. Determine
            // the location where CodeBuild is going to stick it based on whether it's the first (primary)
            // input or an 'extra input', then parse.
            let artifactIndex = inputs.findIndex(a => a.artifactName === outputArtifact.artifact.artifactName);
            if (artifactIndex === -1) {
                artifactIndex = inputs.push(outputArtifact.artifact) - 1;
            }
            const dirEnv = artifactIndex === 0 ? 'CODEBUILD_SRC_DIR' : `CODEBUILD_SRC_DIR_${outputArtifact.artifact.artifactName}`;
            envVarCommands.push(`export ${varName}="$(node -pe 'require(process.env.${dirEnv} + "/${outputArtifact.fileName}")["${output.outputName}"]')"`);
        }
        this._project = new codebuild.PipelineProject(scope, 'Project', {
            environment: this.props.environment || { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0 },
            vpc: this.props.vpc,
            securityGroups: this.props.securityGroups,
            subnetSelection: this.props.subnetSelection,
            buildSpec: codebuild.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    build: {
                        commands: [
                            ...envVarCommands,
                            ...this.props.commands,
                        ],
                    },
                },
            }),
        });
        for (const statement of (_e = this.props.rolePolicyStatements) !== null && _e !== void 0 ? _e : []) {
            this._project.addToRolePolicy(statement);
        }
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.props.actionName,
            input: inputs[0],
            extraInputs: inputs.slice(1),
            runOrder: (_f = this.props.runOrder) !== null && _f !== void 0 ? _f : 100,
            project: this._project,
            environmentVariables: this.props.environmentVariables,
        });
        // Replace the placeholder actionProperties at the last minute
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
    }
    /**
     * (experimental) Project generated to run the shell script in.
     *
     * @experimental
     */
    get project() {
        if (!this._project) {
            throw new Error('Project becomes available after ShellScriptAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
}
exports.ShellScriptAction = ShellScriptAction;
_a = JSII_RTTI_SYMBOL_1;
ShellScriptAction[_a] = { fqn: "@aws-cdk/pipelines.ShellScriptAction", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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