"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import yandex.cloud.ai.assistants.v1.common_pb2
import yandex.cloud.ai.common.common_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Assistant(google.protobuf.message.Message):
    """Assistant represents an AI assistant configuration with various settings and metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_BY_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    EXPIRATION_CONFIG_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MODEL_URI_FIELD_NUMBER: builtins.int
    INSTRUCTION_FIELD_NUMBER: builtins.int
    PROMPT_TRUNCATION_OPTIONS_FIELD_NUMBER: builtins.int
    COMPLETION_OPTIONS_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    RESPONSE_FORMAT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the assistant."""
    folder_id: builtins.str
    """ID of the folder that the assistant belongs to."""
    name: builtins.str
    """Name of the assistant."""
    description: builtins.str
    """Description of the assistant."""
    created_by: builtins.str
    """Identifier of the subject who created this assistant."""
    updated_by: builtins.str
    """Identifier of the subject who last updated this assistant."""
    model_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/yandexgpt/models) to be used for completion generation."""
    instruction: builtins.str
    """Instructions or guidelines that the assistant should follow when generating responses or performing tasks.
    These instructions can help guide the assistant's behavior and responses.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing when the assistant was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing the last time this assistant was updated."""

    @property
    def expiration_config(self) -> yandex.cloud.ai.common.common_pb2.ExpirationConfig:
        """Configuration for the expiration of the assistant, defining when and how the assistant will expire."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing when the assistant will expire."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Set of key-value pairs that can be used to organize and categorize the assistant."""

    @property
    def prompt_truncation_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions:
        """Configuration options for truncating the prompt when the token count exceeds a specified limit."""

    @property
    def completion_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions:
        """Configuration options for completion generation."""

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.assistants.v1.common_pb2.Tool]:
        """List of tools that the assistant can use to perform additional tasks.
        One example is the SearchIndexTool, which is used for Retrieval-Augmented Generation (RAG).
        """

    @property
    def response_format(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat:
        """Specifies the format of the model's response."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        created_by: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_by: builtins.str = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expiration_config: yandex.cloud.ai.common.common_pb2.ExpirationConfig | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        model_uri: builtins.str = ...,
        instruction: builtins.str = ...,
        prompt_truncation_options: yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions | None = ...,
        completion_options: yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions | None = ...,
        tools: collections.abc.Iterable[yandex.cloud.ai.assistants.v1.common_pb2.Tool] | None = ...,
        response_format: yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["completion_options", b"completion_options", "created_at", b"created_at", "expiration_config", b"expiration_config", "expires_at", b"expires_at", "prompt_truncation_options", b"prompt_truncation_options", "response_format", b"response_format", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["completion_options", b"completion_options", "created_at", b"created_at", "created_by", b"created_by", "description", b"description", "expiration_config", b"expiration_config", "expires_at", b"expires_at", "folder_id", b"folder_id", "id", b"id", "instruction", b"instruction", "labels", b"labels", "model_uri", b"model_uri", "name", b"name", "prompt_truncation_options", b"prompt_truncation_options", "response_format", b"response_format", "tools", b"tools", "updated_at", b"updated_at", "updated_by", b"updated_by"]) -> None: ...

global___Assistant = Assistant
