"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.ai.assistants.v1.common_pb2
import yandex.cloud.ai.assistants.v1.runs.run_pb2
import yandex.cloud.ai.assistants.v1.threads.message_pb2
import yandex.cloud.ai.common.common_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateRunRequest(google.protobuf.message.Message):
    """Request message for creating a new run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ASSISTANT_ID_FIELD_NUMBER: builtins.int
    THREAD_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ADDITIONAL_MESSAGES_FIELD_NUMBER: builtins.int
    CUSTOM_PROMPT_TRUNCATION_OPTIONS_FIELD_NUMBER: builtins.int
    CUSTOM_COMPLETION_OPTIONS_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    CUSTOM_RESPONSE_FORMAT_FIELD_NUMBER: builtins.int
    assistant_id: builtins.str
    """ID of the assistant for which the run is being created"""
    thread_id: builtins.str
    """ID of the thread associated with the run."""
    stream: builtins.bool
    """Enables streaming of intermediate events, such as partial messages."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Set of key-value pairs to label the run."""

    @property
    def additional_messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.assistants.v1.threads.message_pb2.MessageData]:
        """Additional messages that will be written to the thread before the run starts."""

    @property
    def custom_prompt_truncation_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions:
        """Configuration options for truncating the prompt when the token count exceeds a specified limit.
        If specified, these options will override the assistant's prompt truncation settings for this run.
        """

    @property
    def custom_completion_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions:
        """Configuration options for completion generation.
        If specified, these options will override the assistant's completion settings for this run.
        """

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.assistants.v1.common_pb2.Tool]:
        """List of tools that are available for the assistant to use in this run."""

    @property
    def custom_response_format(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat:
        """Specifies the format of the model's response."""

    def __init__(
        self,
        *,
        assistant_id: builtins.str = ...,
        thread_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        additional_messages: collections.abc.Iterable[yandex.cloud.ai.assistants.v1.threads.message_pb2.MessageData] | None = ...,
        custom_prompt_truncation_options: yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions | None = ...,
        custom_completion_options: yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions | None = ...,
        stream: builtins.bool = ...,
        tools: collections.abc.Iterable[yandex.cloud.ai.assistants.v1.common_pb2.Tool] | None = ...,
        custom_response_format: yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["custom_completion_options", b"custom_completion_options", "custom_prompt_truncation_options", b"custom_prompt_truncation_options", "custom_response_format", b"custom_response_format"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_messages", b"additional_messages", "assistant_id", b"assistant_id", "custom_completion_options", b"custom_completion_options", "custom_prompt_truncation_options", b"custom_prompt_truncation_options", "custom_response_format", b"custom_response_format", "labels", b"labels", "stream", b"stream", "thread_id", b"thread_id", "tools", b"tools"]) -> None: ...

global___CreateRunRequest = CreateRunRequest

@typing.final
class ListenRunRequest(google.protobuf.message.Message):
    """Request message for listing to a run events."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    EVENTS_START_IDX_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """ID of the run to listen to."""
    @property
    def events_start_idx(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Starting index for events. If provided, listening will start from this event."""

    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        events_start_idx: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["events_start_idx", b"events_start_idx"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["events_start_idx", b"events_start_idx", "run_id", b"run_id"]) -> None: ...

global___ListenRunRequest = ListenRunRequest

@typing.final
class AttachRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    EVENTS_START_IDX_FIELD_NUMBER: builtins.int
    TOOL_RESULT_LIST_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """ID of the run to listen to."""
    @property
    def events_start_idx(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Starting index for events. If provided, listening will start from this event."""

    @property
    def tool_result_list(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ToolResultList:
        """A list of tool results to submit to the run, such as the output of a function call."""

    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        events_start_idx: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        tool_result_list: yandex.cloud.ai.assistants.v1.common_pb2.ToolResultList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Event", b"Event", "events_start_idx", b"events_start_idx", "tool_result_list", b"tool_result_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Event", b"Event", "events_start_idx", b"events_start_idx", "run_id", b"run_id", "tool_result_list", b"tool_result_list"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Event", b"Event"]) -> typing.Literal["tool_result_list"] | None: ...

global___AttachRunRequest = AttachRunRequest

@typing.final
class GetRunRequest(google.protobuf.message.Message):
    """Request message for retrieving a specific run by its ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """ID of the run to retrieve."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["run_id", b"run_id"]) -> None: ...

global___GetRunRequest = GetRunRequest

@typing.final
class GetLastRunByThreadRequest(google.protobuf.message.Message):
    """Request message for retrieving the last run associated with a specific thread."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THREAD_ID_FIELD_NUMBER: builtins.int
    thread_id: builtins.str
    """ID of the thread for which the last run is being fetched."""
    def __init__(
        self,
        *,
        thread_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thread_id", b"thread_id"]) -> None: ...

global___GetLastRunByThreadRequest = GetLastRunByThreadRequest

@typing.final
class ListRunsRequest(google.protobuf.message.Message):
    """Request message for listing runs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID from which to list runs."""
    page_size: builtins.int
    """Maximum number of threads to return per page."""
    page_token: builtins.str
    """Token to retrieve the next page of results."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListRunsRequest = ListRunsRequest

@typing.final
class ListRunsResponse(google.protobuf.message.Message):
    """Response message for the list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token to retrieve the next page of results."""
    @property
    def runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.assistants.v1.runs.run_pb2.Run]:
        """List of runs in the specified folder."""

    def __init__(
        self,
        *,
        runs: collections.abc.Iterable[yandex.cloud.ai.assistants.v1.runs.run_pb2.Run] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "runs", b"runs"]) -> None: ...

global___ListRunsResponse = ListRunsResponse

@typing.final
class StreamCursor(google.protobuf.message.Message):
    """Represents the cursor position in a stream of events."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_EVENT_IDX_FIELD_NUMBER: builtins.int
    NUM_USER_EVENTS_RECEIVED_FIELD_NUMBER: builtins.int
    current_event_idx: builtins.int
    """Index of the current event in the stream."""
    num_user_events_received: builtins.int
    """The number of user events received so far."""
    def __init__(
        self,
        *,
        current_event_idx: builtins.int = ...,
        num_user_events_received: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["current_event_idx", b"current_event_idx", "num_user_events_received", b"num_user_events_received"]) -> None: ...

global___StreamCursor = StreamCursor

@typing.final
class StreamEvent(google.protobuf.message.Message):
    """Represents an event in the stream of a run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamEvent._EventType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EVENT_TYPE_UNSPECIFIED: StreamEvent._EventType.ValueType  # 0
        """Unspecified event type."""
        PARTIAL_MESSAGE: StreamEvent._EventType.ValueType  # 1
        """Partial message is available."""
        ERROR: StreamEvent._EventType.ValueType  # 2
        """Run has failed due to an error."""
        DONE: StreamEvent._EventType.ValueType  # 3
        """The run has completed."""
        TOOL_CALLS: StreamEvent._EventType.ValueType  # 4
        """The run is waiting for tool calls to be executed and their results to be submitted."""

    class EventType(_EventType, metaclass=_EventTypeEnumTypeWrapper):
        """Enum representing events that can occur in the stream."""

    EVENT_TYPE_UNSPECIFIED: StreamEvent.EventType.ValueType  # 0
    """Unspecified event type."""
    PARTIAL_MESSAGE: StreamEvent.EventType.ValueType  # 1
    """Partial message is available."""
    ERROR: StreamEvent.EventType.ValueType  # 2
    """Run has failed due to an error."""
    DONE: StreamEvent.EventType.ValueType  # 3
    """The run has completed."""
    TOOL_CALLS: StreamEvent.EventType.ValueType  # 4
    """The run is waiting for tool calls to be executed and their results to be submitted."""

    EVENT_TYPE_FIELD_NUMBER: builtins.int
    STREAM_CURSOR_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    PARTIAL_MESSAGE_FIELD_NUMBER: builtins.int
    COMPLETED_MESSAGE_FIELD_NUMBER: builtins.int
    TOOL_CALL_LIST_FIELD_NUMBER: builtins.int
    event_type: global___StreamEvent.EventType.ValueType
    """The type of event."""
    @property
    def stream_cursor(self) -> global___StreamCursor:
        """The current position in the stream."""

    @property
    def error(self) -> yandex.cloud.ai.common.common_pb2.Error:
        """Error information if the run has failed."""

    @property
    def partial_message(self) -> yandex.cloud.ai.assistants.v1.threads.message_pb2.MessageContent:
        """Partially generated message."""

    @property
    def completed_message(self) -> yandex.cloud.ai.assistants.v1.threads.message_pb2.Message:
        """Final message generated by an assistant if a run has completed successfully."""

    @property
    def tool_call_list(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ToolCallList:
        """A list of tool calls requested by the assistant."""

    def __init__(
        self,
        *,
        event_type: global___StreamEvent.EventType.ValueType = ...,
        stream_cursor: global___StreamCursor | None = ...,
        error: yandex.cloud.ai.common.common_pb2.Error | None = ...,
        partial_message: yandex.cloud.ai.assistants.v1.threads.message_pb2.MessageContent | None = ...,
        completed_message: yandex.cloud.ai.assistants.v1.threads.message_pb2.Message | None = ...,
        tool_call_list: yandex.cloud.ai.assistants.v1.common_pb2.ToolCallList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["EventData", b"EventData", "completed_message", b"completed_message", "error", b"error", "partial_message", b"partial_message", "stream_cursor", b"stream_cursor", "tool_call_list", b"tool_call_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["EventData", b"EventData", "completed_message", b"completed_message", "error", b"error", "event_type", b"event_type", "partial_message", b"partial_message", "stream_cursor", b"stream_cursor", "tool_call_list", b"tool_call_list"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["EventData", b"EventData"]) -> typing.Literal["error", "partial_message", "completed_message", "tool_call_list"] | None: ...

global___StreamEvent = StreamEvent

@typing.final
class SubmitToRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    TOOL_RESULT_LIST_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """ID of the run to submit to."""
    @property
    def tool_result_list(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ToolResultList:
        """A list of tool results to submit to the run, such as the output of a function call."""

    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        tool_result_list: yandex.cloud.ai.assistants.v1.common_pb2.ToolResultList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Event", b"Event", "tool_result_list", b"tool_result_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Event", b"Event", "run_id", b"run_id", "tool_result_list", b"tool_result_list"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Event", b"Event"]) -> typing.Literal["tool_result_list"] | None: ...

global___SubmitToRunRequest = SubmitToRunRequest

@typing.final
class SubmitToRunResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SubmitToRunResponse = SubmitToRunResponse
