"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import yandex.cloud.ai.assistants.v1.searchindex.common_pb2
import yandex.cloud.ai.common.common_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SearchIndex(google.protobuf.message.Message):
    """Represents a search index used to store and query data, either using traditional keyword-based text search or vector-based search mechanisms."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_BY_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    EXPIRATION_CONFIG_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TEXT_SEARCH_INDEX_FIELD_NUMBER: builtins.int
    VECTOR_SEARCH_INDEX_FIELD_NUMBER: builtins.int
    HYBRID_SEARCH_INDEX_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the search index."""
    folder_id: builtins.str
    """ID of the folder that the search index belongs to."""
    name: builtins.str
    """Name of the search index."""
    description: builtins.str
    """Description of the search index."""
    created_by: builtins.str
    """Identifier of the subject who created this search index."""
    updated_by: builtins.str
    """Identifier of the subject who last updated this search index."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing when the search index was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing the last time this search index was updated."""

    @property
    def expiration_config(self) -> yandex.cloud.ai.common.common_pb2.ExpirationConfig:
        """Configuration for the expiration of the search index, defining when and how the search index will expire."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing when the search index will expire."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Set of key-value pairs that can be used to organize and categorize the search index."""

    @property
    def text_search_index(self) -> global___TextSearchIndex:
        """Keyword-based text search index configuration.
        This type of index is used for traditional text search, where documents are indexed based on their keywords.
        """

    @property
    def vector_search_index(self) -> global___VectorSearchIndex:
        """Vector-based search index configuration.
        This type is used for vector search, where documents are indexed using vector embeddings.
        """

    @property
    def hybrid_search_index(self) -> global___HybridSearchIndex:
        """Hybrid (vector-based + keyword-based) search index configuration
        This type is used for hybrid search, where documents are indexed using both keyword-based and vector-based search mechanisms.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        created_by: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_by: builtins.str = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expiration_config: yandex.cloud.ai.common.common_pb2.ExpirationConfig | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        text_search_index: global___TextSearchIndex | None = ...,
        vector_search_index: global___VectorSearchIndex | None = ...,
        hybrid_search_index: global___HybridSearchIndex | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["IndexType", b"IndexType", "created_at", b"created_at", "expiration_config", b"expiration_config", "expires_at", b"expires_at", "hybrid_search_index", b"hybrid_search_index", "text_search_index", b"text_search_index", "updated_at", b"updated_at", "vector_search_index", b"vector_search_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["IndexType", b"IndexType", "created_at", b"created_at", "created_by", b"created_by", "description", b"description", "expiration_config", b"expiration_config", "expires_at", b"expires_at", "folder_id", b"folder_id", "hybrid_search_index", b"hybrid_search_index", "id", b"id", "labels", b"labels", "name", b"name", "text_search_index", b"text_search_index", "updated_at", b"updated_at", "updated_by", b"updated_by", "vector_search_index", b"vector_search_index"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["IndexType", b"IndexType"]) -> typing.Literal["text_search_index", "vector_search_index", "hybrid_search_index"] | None: ...

global___SearchIndex = SearchIndex

@typing.final
class TextSearchIndex(google.protobuf.message.Message):
    """Defines the configuration for a traditional keyword-based text search index."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNKING_STRATEGY_FIELD_NUMBER: builtins.int
    NGRAM_TOKENIZER_FIELD_NUMBER: builtins.int
    STANDARD_TOKENIZER_FIELD_NUMBER: builtins.int
    STANDARD_ANALYZER_FIELD_NUMBER: builtins.int
    YANDEX_LEMMER_ANALYZER_FIELD_NUMBER: builtins.int
    @property
    def chunking_strategy(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy:
        """Chunking strategy used to split text into smaller chunks before indexing.
        In the case of text search, tokens are individual text characters.
        """

    @property
    def ngram_tokenizer(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.NgramTokenizer:
        """Tokenizer that generates n-grams."""

    @property
    def standard_tokenizer(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.StandardTokenizer:
        """Tokenizer that generates words."""

    @property
    def standard_analyzer(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.StandardAnalyzer:
        """Standard analyzer that performs common text processing operations to normalize text."""

    @property
    def yandex_lemmer_analyzer(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.YandexLemmerAnalyzer:
        """Specialized analyzer that uses Yandex's lemmatization technology,
        particularly effective for Russian and other Slavic languages.
        """

    def __init__(
        self,
        *,
        chunking_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy | None = ...,
        ngram_tokenizer: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.NgramTokenizer | None = ...,
        standard_tokenizer: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.StandardTokenizer | None = ...,
        standard_analyzer: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.StandardAnalyzer | None = ...,
        yandex_lemmer_analyzer: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.YandexLemmerAnalyzer | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["TextAnalyzer", b"TextAnalyzer", "TextTokenizer", b"TextTokenizer", "chunking_strategy", b"chunking_strategy", "ngram_tokenizer", b"ngram_tokenizer", "standard_analyzer", b"standard_analyzer", "standard_tokenizer", b"standard_tokenizer", "yandex_lemmer_analyzer", b"yandex_lemmer_analyzer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["TextAnalyzer", b"TextAnalyzer", "TextTokenizer", b"TextTokenizer", "chunking_strategy", b"chunking_strategy", "ngram_tokenizer", b"ngram_tokenizer", "standard_analyzer", b"standard_analyzer", "standard_tokenizer", b"standard_tokenizer", "yandex_lemmer_analyzer", b"yandex_lemmer_analyzer"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["TextAnalyzer", b"TextAnalyzer"]) -> typing.Literal["standard_analyzer", "yandex_lemmer_analyzer"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["TextTokenizer", b"TextTokenizer"]) -> typing.Literal["ngram_tokenizer", "standard_tokenizer"] | None: ...

global___TextSearchIndex = TextSearchIndex

@typing.final
class VectorSearchIndex(google.protobuf.message.Message):
    """Defines the configuration for a vector-based search index. This type uses embeddings to represent documents and queries."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOC_EMBEDDER_URI_FIELD_NUMBER: builtins.int
    QUERY_EMBEDDER_URI_FIELD_NUMBER: builtins.int
    CHUNKING_STRATEGY_FIELD_NUMBER: builtins.int
    doc_embedder_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/embeddings) to be used for obtaining document text embeddings."""
    query_embedder_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/embeddings) to be used for obtaining query text embeddings."""
    @property
    def chunking_strategy(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy:
        """Chunking strategy used to split text into smaller chunks before indexing.
        In the case of vector search, tokens are produced by the tokenizer from the embedding model.
        """

    def __init__(
        self,
        *,
        doc_embedder_uri: builtins.str = ...,
        query_embedder_uri: builtins.str = ...,
        chunking_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chunking_strategy", b"chunking_strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chunking_strategy", b"chunking_strategy", "doc_embedder_uri", b"doc_embedder_uri", "query_embedder_uri", b"query_embedder_uri"]) -> None: ...

global___VectorSearchIndex = VectorSearchIndex

@typing.final
class HybridSearchIndex(google.protobuf.message.Message):
    """Defines the configuration for a hybrid (vector-based + keyword-based) search index. This type uses both embeddings and keyword-based search to represent documents and queries."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_SEARCH_INDEX_FIELD_NUMBER: builtins.int
    VECTOR_SEARCH_INDEX_FIELD_NUMBER: builtins.int
    CHUNKING_STRATEGY_FIELD_NUMBER: builtins.int
    NORMALIZATION_STRATEGY_FIELD_NUMBER: builtins.int
    COMBINATION_STRATEGY_FIELD_NUMBER: builtins.int
    normalization_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.NormalizationStrategy.ValueType
    """Normalization strategy for relevance scores from different indices. Default is MIN_MAX_STRATEGY"""
    @property
    def text_search_index(self) -> global___TextSearchIndex:
        """Configuration for a traditional keyword-based text search index."""

    @property
    def vector_search_index(self) -> global___VectorSearchIndex:
        """Configuration for a vector-based search index."""

    @property
    def chunking_strategy(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy:
        """Common chunking strategy that applies to both text and vector search indexes.
        If provided, it overrides the individual chunking strategies in both `text_search_index` and `vector_search_index`.
        In this case, both text and vector search will use token-based chunking, where tokens are produced by the tokenizer of the embedding model.
        """

    @property
    def combination_strategy(self) -> yandex.cloud.ai.assistants.v1.searchindex.common_pb2.CombinationStrategy:
        """Combination strategy for merging rankings from different indices. Default is arithmetic mean"""

    def __init__(
        self,
        *,
        text_search_index: global___TextSearchIndex | None = ...,
        vector_search_index: global___VectorSearchIndex | None = ...,
        chunking_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.ChunkingStrategy | None = ...,
        normalization_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.NormalizationStrategy.ValueType = ...,
        combination_strategy: yandex.cloud.ai.assistants.v1.searchindex.common_pb2.CombinationStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["chunking_strategy", b"chunking_strategy", "combination_strategy", b"combination_strategy", "text_search_index", b"text_search_index", "vector_search_index", b"vector_search_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["chunking_strategy", b"chunking_strategy", "combination_strategy", b"combination_strategy", "normalization_strategy", b"normalization_strategy", "text_search_index", b"text_search_index", "vector_search_index", b"vector_search_index"]) -> None: ...

global___HybridSearchIndex = HybridSearchIndex
