"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.ai.common.common_pb2
import yandex.cloud.ai.files.v1.file_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateFileRequest(google.protobuf.message.Message):
    """Request message for creating a new file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    MIME_TYPE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    EXPIRATION_CONFIG_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    name: builtins.str
    """Name of the file."""
    description: builtins.str
    """Description of the file."""
    mime_type: builtins.str
    """MIME type of the file, indicating the file's format (e.g., "application/pdf").
    If not specified, will be deduced automatically based on the file content.
    """
    content: builtins.bytes
    """Binary content of the file."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Set of key-value pairs to label the file."""

    @property
    def expiration_config(self) -> yandex.cloud.ai.common.common_pb2.ExpirationConfig:
        """Expiration configuration for the file."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        mime_type: builtins.str = ...,
        content: builtins.bytes = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        expiration_config: yandex.cloud.ai.common.common_pb2.ExpirationConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expiration_config", b"expiration_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "description", b"description", "expiration_config", b"expiration_config", "folder_id", b"folder_id", "labels", b"labels", "mime_type", b"mime_type", "name", b"name"]) -> None: ...

global___CreateFileRequest = CreateFileRequest

@typing.final
class GetFileRequest(google.protobuf.message.Message):
    """Request message for retrieving a file by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_ID_FIELD_NUMBER: builtins.int
    file_id: builtins.str
    """ID of the file to retrieve."""
    def __init__(
        self,
        *,
        file_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_id", b"file_id"]) -> None: ...

global___GetFileRequest = GetFileRequest

@typing.final
class GetFileUrlRequest(google.protobuf.message.Message):
    """Request message for retrieving the URL of a specific file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_ID_FIELD_NUMBER: builtins.int
    file_id: builtins.str
    """ID of the file which the URL is requested."""
    def __init__(
        self,
        *,
        file_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_id", b"file_id"]) -> None: ...

global___GetFileUrlRequest = GetFileUrlRequest

@typing.final
class GetFileUrlResponse(google.protobuf.message.Message):
    """Response message containing the URL to access the requested file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """URL that can be used to access or download the file."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___GetFileUrlResponse = GetFileUrlResponse

@typing.final
class UpdateFileRequest(google.protobuf.message.Message):
    """Request message for updating an existing file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FILE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EXPIRATION_CONFIG_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    file_id: builtins.str
    """ID of the file to update."""
    name: builtins.str
    """New name for the file."""
    description: builtins.str
    """New description for the file."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields to update."""

    @property
    def expiration_config(self) -> yandex.cloud.ai.common.common_pb2.ExpirationConfig:
        """New expiration configuration for the file."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New set of labels for the file."""

    def __init__(
        self,
        *,
        file_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        expiration_config: yandex.cloud.ai.common.common_pb2.ExpirationConfig | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expiration_config", b"expiration_config", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "expiration_config", b"expiration_config", "file_id", b"file_id", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateFileRequest = UpdateFileRequest

@typing.final
class DeleteFileRequest(google.protobuf.message.Message):
    """Request message for deleting a file by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_ID_FIELD_NUMBER: builtins.int
    file_id: builtins.str
    """ID of the file to delete."""
    def __init__(
        self,
        *,
        file_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_id", b"file_id"]) -> None: ...

global___DeleteFileRequest = DeleteFileRequest

@typing.final
class DeleteFileResponse(google.protobuf.message.Message):
    """Response message for the delete operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteFileResponse = DeleteFileResponse

@typing.final
class ListFilesRequest(google.protobuf.message.Message):
    """Request message for listing files in a specific folder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID from which to list files."""
    page_size: builtins.int
    """Maximum number of files to return per page."""
    page_token: builtins.str
    """Token to retrieve the next page of results."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListFilesRequest = ListFilesRequest

@typing.final
class ListFilesResponse(google.protobuf.message.Message):
    """Response message for the list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token to retrieve the next page of results."""
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.files.v1.file_pb2.File]:
        """List of files in the specified folder."""

    def __init__(
        self,
        *,
        files: collections.abc.Iterable[yandex.cloud.ai.files.v1.file_pb2.File] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["files", b"files", "next_page_token", b"next_page_token"]) -> None: ...

global___ListFilesResponse = ListFilesResponse
