"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing
import yandex.cloud.ai.foundation_models.v1.batch_inference_task_status_pb2
import yandex.cloud.ai.foundation_models.v1.text_common_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CompletionRequest(google.protobuf.message.Message):
    """Request for the service to generate text completion."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_URI_FIELD_NUMBER: builtins.int
    COMPLETION_OPTIONS_FIELD_NUMBER: builtins.int
    MESSAGES_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    JSON_OBJECT_FIELD_NUMBER: builtins.int
    JSON_SCHEMA_FIELD_NUMBER: builtins.int
    PARALLEL_TOOL_CALLS_FIELD_NUMBER: builtins.int
    TOOL_CHOICE_FIELD_NUMBER: builtins.int
    model_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/yandexgpt/models) to be used for completion generation."""
    json_object: builtins.bool
    """When set to true, the model will respond with a valid JSON object.
    Be sure to explicitly ask the model for JSON.
    Otherwise, it may generate excessive whitespace and run indefinitely until it reaches the token limit.
    """
    @property
    def completion_options(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.CompletionOptions:
        """Configuration options for completion generation."""

    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Message]:
        """A list of messages representing the context for the completion model."""

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Tool]:
        """List of tools that are available for the model to invoke during the completion generation.
        Note: This parameter is not yet supported and will be ignored if provided.
        """

    @property
    def json_schema(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.JsonSchema:
        """Enforces a specific JSON structure for the model's response based on a provided schema."""

    @property
    def parallel_tool_calls(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls whether the model can generate multiple tool calls in a single response. Defaults to true."""

    @property
    def tool_choice(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.ToolChoice:
        """Specifies how the model should select which tool (or tools) to use when generating a response."""

    def __init__(
        self,
        *,
        model_uri: builtins.str = ...,
        completion_options: yandex.cloud.ai.foundation_models.v1.text_common_pb2.CompletionOptions | None = ...,
        messages: collections.abc.Iterable[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Message] | None = ...,
        tools: collections.abc.Iterable[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Tool] | None = ...,
        json_object: builtins.bool = ...,
        json_schema: yandex.cloud.ai.foundation_models.v1.text_common_pb2.JsonSchema | None = ...,
        parallel_tool_calls: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        tool_choice: yandex.cloud.ai.foundation_models.v1.text_common_pb2.ToolChoice | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "completion_options", b"completion_options", "json_object", b"json_object", "json_schema", b"json_schema", "parallel_tool_calls", b"parallel_tool_calls", "tool_choice", b"tool_choice"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "completion_options", b"completion_options", "json_object", b"json_object", "json_schema", b"json_schema", "messages", b"messages", "model_uri", b"model_uri", "parallel_tool_calls", b"parallel_tool_calls", "tool_choice", b"tool_choice", "tools", b"tools"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ResponseFormat", b"ResponseFormat"]) -> typing.Literal["json_object", "json_schema"] | None: ...

global___CompletionRequest = CompletionRequest

@typing.final
class CompletionResponse(google.protobuf.message.Message):
    """Response containing generated text completions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALTERNATIVES_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    model_version: builtins.str
    """The model version changes with each new releases."""
    @property
    def alternatives(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Alternative]:
        """A list of generated completion alternatives."""

    @property
    def usage(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.ContentUsage:
        """A set of statistics describing the number of content tokens used by the completion model."""

    def __init__(
        self,
        *,
        alternatives: collections.abc.Iterable[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Alternative] | None = ...,
        usage: yandex.cloud.ai.foundation_models.v1.text_common_pb2.ContentUsage | None = ...,
        model_version: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["alternatives", b"alternatives", "model_version", b"model_version", "usage", b"usage"]) -> None: ...

global___CompletionResponse = CompletionResponse

@typing.final
class BatchCompletionRequest(google.protobuf.message.Message):
    """Request for the service to generate batch text completion."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_URI_FIELD_NUMBER: builtins.int
    COMPLETION_OPTIONS_FIELD_NUMBER: builtins.int
    SOURCE_DATASET_ID_FIELD_NUMBER: builtins.int
    JSON_OBJECT_FIELD_NUMBER: builtins.int
    JSON_SCHEMA_FIELD_NUMBER: builtins.int
    model_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/yandexgpt/models) to be used for batch completion generation."""
    source_dataset_id: builtins.str
    """ID of the dataset containing the context for the completion model."""
    json_object: builtins.bool
    """When set to true, the model will respond with a valid JSON object.
    Be sure to explicitly ask the model for JSON.
    Otherwise, it may generate excessive whitespace and run indefinitely until it reaches the token limit.
    """
    @property
    def completion_options(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.CompletionOptions:
        """Configuration options for completion generation."""

    @property
    def json_schema(self) -> yandex.cloud.ai.foundation_models.v1.text_common_pb2.JsonSchema:
        """Enforces a specific JSON structure for the model's response based on a provided schema."""

    def __init__(
        self,
        *,
        model_uri: builtins.str = ...,
        completion_options: yandex.cloud.ai.foundation_models.v1.text_common_pb2.CompletionOptions | None = ...,
        source_dataset_id: builtins.str = ...,
        json_object: builtins.bool = ...,
        json_schema: yandex.cloud.ai.foundation_models.v1.text_common_pb2.JsonSchema | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "completion_options", b"completion_options", "json_object", b"json_object", "json_schema", b"json_schema", "request_format", b"request_format", "source_dataset_id", b"source_dataset_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "completion_options", b"completion_options", "json_object", b"json_object", "json_schema", b"json_schema", "model_uri", b"model_uri", "request_format", b"request_format", "source_dataset_id", b"source_dataset_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["ResponseFormat", b"ResponseFormat"]) -> typing.Literal["json_object", "json_schema"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["request_format", b"request_format"]) -> typing.Literal["source_dataset_id"] | None: ...

global___BatchCompletionRequest = BatchCompletionRequest

@typing.final
class BatchCompletionMetadata(google.protobuf.message.Message):
    """Metadata of the batch completion operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    TASK_STATUS_FIELD_NUMBER: builtins.int
    COMPLETED_BATCHES_FIELD_NUMBER: builtins.int
    TOTAL_BATCHES_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The ID of the batch completion task."""
    task_status: yandex.cloud.ai.foundation_models.v1.batch_inference_task_status_pb2.BatchInferenceTaskStatus.ValueType
    """The status of the batch completion task."""
    completed_batches: builtins.int
    """A number of currently completed batches of the completion task."""
    total_batches: builtins.int
    """A number of total batches of the completion task."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        task_status: yandex.cloud.ai.foundation_models.v1.batch_inference_task_status_pb2.BatchInferenceTaskStatus.ValueType = ...,
        completed_batches: builtins.int = ...,
        total_batches: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["completed_batches", b"completed_batches", "task_id", b"task_id", "task_status", b"task_status", "total_batches", b"total_batches"]) -> None: ...

global___BatchCompletionMetadata = BatchCompletionMetadata

@typing.final
class BatchCompletionResponse(google.protobuf.message.Message):
    """Response containing information about completion task."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    TASK_STATUS_FIELD_NUMBER: builtins.int
    RESULT_DATASET_ID_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """The ID of the batch completion task."""
    task_status: yandex.cloud.ai.foundation_models.v1.batch_inference_task_status_pb2.BatchInferenceTaskStatus.ValueType
    """The status of the batch completion task."""
    result_dataset_id: builtins.str
    """The ID of the dataset containing completion results."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        task_status: yandex.cloud.ai.foundation_models.v1.batch_inference_task_status_pb2.BatchInferenceTaskStatus.ValueType = ...,
        result_dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["result_dataset_id", b"result_dataset_id", "task_id", b"task_id", "task_status", b"task_status"]) -> None: ...

global___BatchCompletionResponse = BatchCompletionResponse

@typing.final
class TokenizeRequest(google.protobuf.message.Message):
    """Request for the service to tokenize input text."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_URI_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    model_uri: builtins.str
    """The identifier of the model to be used for tokenization."""
    text: builtins.str
    """Text to be tokenized."""
    def __init__(
        self,
        *,
        model_uri: builtins.str = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["model_uri", b"model_uri", "text", b"text"]) -> None: ...

global___TokenizeRequest = TokenizeRequest

@typing.final
class TokenizeResponse(google.protobuf.message.Message):
    """Response containing tokenized content from request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKENS_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    model_version: builtins.str
    """Model version (changes with model releases)."""
    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Token]:
        """A list of tokens obtained from tokenization."""

    def __init__(
        self,
        *,
        tokens: collections.abc.Iterable[yandex.cloud.ai.foundation_models.v1.text_common_pb2.Token] | None = ...,
        model_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["model_version", b"model_version", "tokens", b"tokens"]) -> None: ...

global___TokenizeResponse = TokenizeResponse
