"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.ai.llm.v1alpha.llm_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class InstructRequest(google.protobuf.message.Message):
    """Request for instructing the model to generate text."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    GENERATION_OPTIONS_FIELD_NUMBER: builtins.int
    INSTRUCTION_TEXT_FIELD_NUMBER: builtins.int
    INSTRUCTION_URI_FIELD_NUMBER: builtins.int
    REQUEST_TEXT_FIELD_NUMBER: builtins.int
    model: builtins.str
    """The name or identifier of the model to be used for text generation.
    Possible value for now: `general`.
    """
    instruction_text: builtins.str
    """The text-based instruction for text generation."""
    instruction_uri: builtins.str
    """A URI containing instructions for text generation."""
    request_text: builtins.str
    """The text-based request for text generation."""
    @property
    def generation_options(self) -> yandex.cloud.ai.llm.v1alpha.llm_pb2.GenerationOptions:
        """Configuration options for text generation."""

    def __init__(
        self,
        *,
        model: builtins.str = ...,
        generation_options: yandex.cloud.ai.llm.v1alpha.llm_pb2.GenerationOptions | None = ...,
        instruction_text: builtins.str = ...,
        instruction_uri: builtins.str = ...,
        request_text: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Instruction", b"Instruction", "Request", b"Request", "generation_options", b"generation_options", "instruction_text", b"instruction_text", "instruction_uri", b"instruction_uri", "request_text", b"request_text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Instruction", b"Instruction", "Request", b"Request", "generation_options", b"generation_options", "instruction_text", b"instruction_text", "instruction_uri", b"instruction_uri", "model", b"model", "request_text", b"request_text"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["Instruction", b"Instruction"]) -> typing.Literal["instruction_text", "instruction_uri"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["Request", b"Request"]) -> typing.Literal["request_text"] | None: ...

global___InstructRequest = InstructRequest

@typing.final
class InstructResponse(google.protobuf.message.Message):
    """Response containing generated text alternatives and token count."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALTERNATIVES_FIELD_NUMBER: builtins.int
    NUM_PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    num_prompt_tokens: builtins.int
    """The number of tokens used in the prompt, including both the [instruction_text] and [request_text]."""
    @property
    def alternatives(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.llm.v1alpha.llm_pb2.Alternative]:
        """A list of alternative text responses."""

    def __init__(
        self,
        *,
        alternatives: collections.abc.Iterable[yandex.cloud.ai.llm.v1alpha.llm_pb2.Alternative] | None = ...,
        num_prompt_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alternatives", b"alternatives", "num_prompt_tokens", b"num_prompt_tokens"]) -> None: ...

global___InstructResponse = InstructResponse

@typing.final
class ChatRequest(google.protobuf.message.Message):
    """Request to engage in a chat conversation with a text generation model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    GENERATION_OPTIONS_FIELD_NUMBER: builtins.int
    INSTRUCTION_TEXT_FIELD_NUMBER: builtins.int
    MESSAGES_FIELD_NUMBER: builtins.int
    model: builtins.str
    """The name or identifier of the model to be used for the chat.
    Possible value for now: `general`.
    """
    instruction_text: builtins.str
    """The text-based instruction for the conversation."""
    @property
    def generation_options(self) -> yandex.cloud.ai.llm.v1alpha.llm_pb2.GenerationOptions:
        """Configuration options for text generation."""

    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.llm.v1alpha.llm_pb2.Message]:
        """A list of messages in the conversation."""

    def __init__(
        self,
        *,
        model: builtins.str = ...,
        generation_options: yandex.cloud.ai.llm.v1alpha.llm_pb2.GenerationOptions | None = ...,
        instruction_text: builtins.str = ...,
        messages: collections.abc.Iterable[yandex.cloud.ai.llm.v1alpha.llm_pb2.Message] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Instruction", b"Instruction", "generation_options", b"generation_options", "instruction_text", b"instruction_text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Instruction", b"Instruction", "generation_options", b"generation_options", "instruction_text", b"instruction_text", "messages", b"messages", "model", b"model"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Instruction", b"Instruction"]) -> typing.Literal["instruction_text"] | None: ...

global___ChatRequest = ChatRequest

@typing.final
class ChatResponse(google.protobuf.message.Message):
    """Contains a model-generated response for a chat query."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    NUM_TOKENS_FIELD_NUMBER: builtins.int
    num_tokens: builtins.int
    """Total number of tokens used in both the chat request and chat response."""
    @property
    def message(self) -> yandex.cloud.ai.llm.v1alpha.llm_pb2.Message:
        """The assistant's message in the chat conversation."""

    def __init__(
        self,
        *,
        message: yandex.cloud.ai.llm.v1alpha.llm_pb2.Message | None = ...,
        num_tokens: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "num_tokens", b"num_tokens"]) -> None: ...

global___ChatResponse = ChatResponse

@typing.final
class TokenizeRequest(google.protobuf.message.Message):
    """Request to tokenize input text."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    model: builtins.str
    """The name or identifier of the model to be used for tokenization.
    Possible values for now: `general`, `general:embedding`.
    """
    text: builtins.str
    """The input text to tokenize."""
    def __init__(
        self,
        *,
        model: builtins.str = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["model", b"model", "text", b"text"]) -> None: ...

global___TokenizeRequest = TokenizeRequest

@typing.final
class TokenizeResponse(google.protobuf.message.Message):
    """Tokenization response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKENS_FIELD_NUMBER: builtins.int
    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.llm.v1alpha.llm_pb2.Token]:
        """A list of tokens obtained from tokenization."""

    def __init__(
        self,
        *,
        tokens: collections.abc.Iterable[yandex.cloud.ai.llm.v1alpha.llm_pb2.Token] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tokens", b"tokens"]) -> None: ...

global___TokenizeResponse = TokenizeResponse

@typing.final
class EmbeddingRequest(google.protobuf.message.Message):
    """Represents a request to obtain embeddings for text data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EmbeddingType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EmbeddingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[EmbeddingRequest._EmbeddingType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EMBEDDING_TYPE_UNSPECIFIED: EmbeddingRequest._EmbeddingType.ValueType  # 0
        """Unspecified embedding type."""
        EMBEDDING_TYPE_QUERY: EmbeddingRequest._EmbeddingType.ValueType  # 1
        """Embedding for a query. Use this when you have a short query or search term
        that you want to obtain an embedding for. Query embeddings are typically
        used in information retrieval and search applications.
        """
        EMBEDDING_TYPE_DOCUMENT: EmbeddingRequest._EmbeddingType.ValueType  # 2
        """Embedding for a document. Use this when you have a longer document or a piece
        of text that you want to obtain an embedding for. Document embeddings are often
        used in natural language understanding and document similarity tasks.
        """

    class EmbeddingType(_EmbeddingType, metaclass=_EmbeddingTypeEnumTypeWrapper):
        """Enum to specify the type of embedding to be generated."""

    EMBEDDING_TYPE_UNSPECIFIED: EmbeddingRequest.EmbeddingType.ValueType  # 0
    """Unspecified embedding type."""
    EMBEDDING_TYPE_QUERY: EmbeddingRequest.EmbeddingType.ValueType  # 1
    """Embedding for a query. Use this when you have a short query or search term
    that you want to obtain an embedding for. Query embeddings are typically
    used in information retrieval and search applications.
    """
    EMBEDDING_TYPE_DOCUMENT: EmbeddingRequest.EmbeddingType.ValueType  # 2
    """Embedding for a document. Use this when you have a longer document or a piece
    of text that you want to obtain an embedding for. Document embeddings are often
    used in natural language understanding and document similarity tasks.
    """

    EMBEDDING_TYPE_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    embedding_type: global___EmbeddingRequest.EmbeddingType.ValueType
    """The type of embedding to be generated."""
    model: builtins.str
    """The name or identifier of the model to be used for embedding. Possible value for now: `general:embedding`."""
    text: builtins.str
    """The input text for which the embedding is requested."""
    def __init__(
        self,
        *,
        embedding_type: global___EmbeddingRequest.EmbeddingType.ValueType = ...,
        model: builtins.str = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["embedding_type", b"embedding_type", "model", b"model", "text", b"text"]) -> None: ...

global___EmbeddingRequest = EmbeddingRequest

@typing.final
class EmbeddingResponse(google.protobuf.message.Message):
    """Represents a response containing embeddings for input text data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMBEDDING_FIELD_NUMBER: builtins.int
    NUM_TOKENS_FIELD_NUMBER: builtins.int
    num_tokens: builtins.int
    """The number of tokens in the input text."""
    @property
    def embedding(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """A repeated list of double values representing the embedding."""

    def __init__(
        self,
        *,
        embedding: collections.abc.Iterable[builtins.float] | None = ...,
        num_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["embedding", b"embedding", "num_tokens", b"num_tokens"]) -> None: ...

global___EmbeddingResponse = EmbeddingResponse
