"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.ai.ocr.v1.ocr_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class RecognizeTextRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    MIME_TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Bytes with data"""
    mime_type: builtins.str
    """Specifications of the ([MIME type](https://en.wikipedia.org/wiki/Media_type)). Each specification contains the file to analyze and features to use for analysis. Restrictions:
    * Supported file formats: `JPEG`, `PNG`, `PDF`.
    * Maximum file size: see [documentation](/docs/vision/concepts/limits).
    * Image size should not exceed 20M pixels (length x width).
    * The number of pages in a PDF file should not exceed 1.
    """
    model: builtins.str
    """[Model](/docs/vision/concepts/ocr/template-recognition#models) to use for text detection."""
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """[List of the languages](/docs/vision/concepts/ocr/supported-languages) to recognize text.
        Specified in [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) format (for example, `ru`).
        """

    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
        mime_type: builtins.str = ...,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        model: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["content", b"content", "source", b"source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "language_codes", b"language_codes", "mime_type", b"mime_type", "model", b"model", "source", b"source"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["content"] | None: ...

global___RecognizeTextRequest = RecognizeTextRequest

@typing.final
class RecognizeTextResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_ANNOTATION_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    page: builtins.int
    """Page number in PDF file."""
    @property
    def text_annotation(self) -> yandex.cloud.ai.ocr.v1.ocr_pb2.TextAnnotation:
        """Recognized text blocks in page or text from entities."""

    def __init__(
        self,
        *,
        text_annotation: yandex.cloud.ai.ocr.v1.ocr_pb2.TextAnnotation | None = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["text_annotation", b"text_annotation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["page", b"page", "text_annotation", b"text_annotation"]) -> None: ...

global___RecognizeTextResponse = RecognizeTextResponse

@typing.final
class GetRecognitionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_ID_FIELD_NUMBER: builtins.int
    operation_id: builtins.str
    """Operation ID of async recognition request."""
    def __init__(
        self,
        *,
        operation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["operation_id", b"operation_id"]) -> None: ...

global___GetRecognitionRequest = GetRecognitionRequest
