"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CodeType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CodeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CodeType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CODE_TYPE_UNSPECIFIED: _CodeType.ValueType  # 0
    WORKING: _CodeType.ValueType  # 1
    """All good."""
    WARNING: _CodeType.ValueType  # 2
    """For example, if speech is sent not in real-time or context is unknown and we've made fallback."""
    CLOSED: _CodeType.ValueType  # 3
    """After session was closed."""

class CodeType(_CodeType, metaclass=_CodeTypeEnumTypeWrapper): ...

CODE_TYPE_UNSPECIFIED: CodeType.ValueType  # 0
WORKING: CodeType.ValueType  # 1
"""All good."""
WARNING: CodeType.ValueType  # 2
"""For example, if speech is sent not in real-time or context is unknown and we've made fallback."""
CLOSED: CodeType.ValueType  # 3
"""After session was closed."""
global___CodeType = CodeType

@typing.final
class TextNormalizationOptions(google.protobuf.message.Message):
    """Options for post-processing text results. The normalization levels depend on the settings and the language.
    For detailed information, see [documentation](/docs/speechkit/stt/normalization).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TextNormalization:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TextNormalizationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TextNormalizationOptions._TextNormalization.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TEXT_NORMALIZATION_UNSPECIFIED: TextNormalizationOptions._TextNormalization.ValueType  # 0
        TEXT_NORMALIZATION_ENABLED: TextNormalizationOptions._TextNormalization.ValueType  # 1
        """Enable converting numbers, dates and time from text to numeric format."""
        TEXT_NORMALIZATION_DISABLED: TextNormalizationOptions._TextNormalization.ValueType  # 2
        """Disable all normalization. Default value."""

    class TextNormalization(_TextNormalization, metaclass=_TextNormalizationEnumTypeWrapper):
        """Base-level normalization."""

    TEXT_NORMALIZATION_UNSPECIFIED: TextNormalizationOptions.TextNormalization.ValueType  # 0
    TEXT_NORMALIZATION_ENABLED: TextNormalizationOptions.TextNormalization.ValueType  # 1
    """Enable converting numbers, dates and time from text to numeric format."""
    TEXT_NORMALIZATION_DISABLED: TextNormalizationOptions.TextNormalization.ValueType  # 2
    """Disable all normalization. Default value."""

    class _PhoneFormattingMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PhoneFormattingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TextNormalizationOptions._PhoneFormattingMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PHONE_FORMATTING_MODE_UNSPECIFIED: TextNormalizationOptions._PhoneFormattingMode.ValueType  # 0
        PHONE_FORMATTING_MODE_DISABLED: TextNormalizationOptions._PhoneFormattingMode.ValueType  # 1
        """Disable phone formatting"""

    class PhoneFormattingMode(_PhoneFormattingMode, metaclass=_PhoneFormattingModeEnumTypeWrapper): ...
    PHONE_FORMATTING_MODE_UNSPECIFIED: TextNormalizationOptions.PhoneFormattingMode.ValueType  # 0
    PHONE_FORMATTING_MODE_DISABLED: TextNormalizationOptions.PhoneFormattingMode.ValueType  # 1
    """Disable phone formatting"""

    TEXT_NORMALIZATION_FIELD_NUMBER: builtins.int
    PROFANITY_FILTER_FIELD_NUMBER: builtins.int
    LITERATURE_TEXT_FIELD_NUMBER: builtins.int
    PHONE_FORMATTING_MODE_FIELD_NUMBER: builtins.int
    text_normalization: global___TextNormalizationOptions.TextNormalization.ValueType
    profanity_filter: builtins.bool
    """Profanity filter (default: false)."""
    literature_text: builtins.bool
    """Rewrite text in literature style (default: false)."""
    phone_formatting_mode: global___TextNormalizationOptions.PhoneFormattingMode.ValueType
    """Define phone formatting mode"""
    def __init__(
        self,
        *,
        text_normalization: global___TextNormalizationOptions.TextNormalization.ValueType = ...,
        profanity_filter: builtins.bool = ...,
        literature_text: builtins.bool = ...,
        phone_formatting_mode: global___TextNormalizationOptions.PhoneFormattingMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["literature_text", b"literature_text", "phone_formatting_mode", b"phone_formatting_mode", "profanity_filter", b"profanity_filter", "text_normalization", b"text_normalization"]) -> None: ...

global___TextNormalizationOptions = TextNormalizationOptions

@typing.final
class DefaultEouClassifier(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EouSensitivity:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EouSensitivityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DefaultEouClassifier._EouSensitivity.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EOU_SENSITIVITY_UNSPECIFIED: DefaultEouClassifier._EouSensitivity.ValueType  # 0
        DEFAULT: DefaultEouClassifier._EouSensitivity.ValueType  # 1
        """Default and more conservative EOU detector."""
        HIGH: DefaultEouClassifier._EouSensitivity.ValueType  # 2
        """A high-sensitive and fast EOU detector, which may produce more false positives."""

    class EouSensitivity(_EouSensitivity, metaclass=_EouSensitivityEnumTypeWrapper): ...
    EOU_SENSITIVITY_UNSPECIFIED: DefaultEouClassifier.EouSensitivity.ValueType  # 0
    DEFAULT: DefaultEouClassifier.EouSensitivity.ValueType  # 1
    """Default and more conservative EOU detector."""
    HIGH: DefaultEouClassifier.EouSensitivity.ValueType  # 2
    """A high-sensitive and fast EOU detector, which may produce more false positives."""

    TYPE_FIELD_NUMBER: builtins.int
    MAX_PAUSE_BETWEEN_WORDS_HINT_MS_FIELD_NUMBER: builtins.int
    type: global___DefaultEouClassifier.EouSensitivity.ValueType
    """EOU sensitivity."""
    max_pause_between_words_hint_ms: builtins.int
    """Hint for max pause between words. SpeechKit EOU detector could use this information to adjust the speed of the EOU detection.
    For example, a long pause between words will help distinguish between the end of utterance from slow speech like `One <long pause> two <long pause> three`.
    A short pause can be helpful if the speaker is speaking quickly and does not emphasize pauses between sentences.
    """
    def __init__(
        self,
        *,
        type: global___DefaultEouClassifier.EouSensitivity.ValueType = ...,
        max_pause_between_words_hint_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_pause_between_words_hint_ms", b"max_pause_between_words_hint_ms", "type", b"type"]) -> None: ...

global___DefaultEouClassifier = DefaultEouClassifier

@typing.final
class ExternalEouClassifier(google.protobuf.message.Message):
    """Use EOU provided by user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ExternalEouClassifier = ExternalEouClassifier

@typing.final
class EouClassifierOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEFAULT_CLASSIFIER_FIELD_NUMBER: builtins.int
    EXTERNAL_CLASSIFIER_FIELD_NUMBER: builtins.int
    @property
    def default_classifier(self) -> global___DefaultEouClassifier:
        """Default EOU classifier provided by SpeechKit."""

    @property
    def external_classifier(self) -> global___ExternalEouClassifier:
        """EOU classifier enforced by external messages from user."""

    def __init__(
        self,
        *,
        default_classifier: global___DefaultEouClassifier | None = ...,
        external_classifier: global___ExternalEouClassifier | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Classifier", b"Classifier", "default_classifier", b"default_classifier", "external_classifier", b"external_classifier"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Classifier", b"Classifier", "default_classifier", b"default_classifier", "external_classifier", b"external_classifier"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Classifier", b"Classifier"]) -> typing.Literal["default_classifier", "external_classifier"] | None: ...

global___EouClassifierOptions = EouClassifierOptions

@typing.final
class RecognitionClassifier(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TriggerType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TriggerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RecognitionClassifier._TriggerType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRIGGER_TYPE_UNSPECIFIED: RecognitionClassifier._TriggerType.ValueType  # 0
        ON_UTTERANCE: RecognitionClassifier._TriggerType.ValueType  # 1
        """Apply classifier to utterance responses."""
        ON_FINAL: RecognitionClassifier._TriggerType.ValueType  # 2
        """Apply classifier to final responses."""
        ON_PARTIAL: RecognitionClassifier._TriggerType.ValueType  # 3
        """Apply classifier to partial responses."""

    class TriggerType(_TriggerType, metaclass=_TriggerTypeEnumTypeWrapper):
        """Type of recognition classifier trigger."""

    TRIGGER_TYPE_UNSPECIFIED: RecognitionClassifier.TriggerType.ValueType  # 0
    ON_UTTERANCE: RecognitionClassifier.TriggerType.ValueType  # 1
    """Apply classifier to utterance responses."""
    ON_FINAL: RecognitionClassifier.TriggerType.ValueType  # 2
    """Apply classifier to final responses."""
    ON_PARTIAL: RecognitionClassifier.TriggerType.ValueType  # 3
    """Apply classifier to partial responses."""

    CLASSIFIER_FIELD_NUMBER: builtins.int
    TRIGGERS_FIELD_NUMBER: builtins.int
    classifier: builtins.str
    """Classifier name"""
    @property
    def triggers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___RecognitionClassifier.TriggerType.ValueType]:
        """Describes the types of responses to which the classification results will come. Classification responses will follow the responses of the specified types."""

    def __init__(
        self,
        *,
        classifier: builtins.str = ...,
        triggers: collections.abc.Iterable[global___RecognitionClassifier.TriggerType.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["classifier", b"classifier", "triggers", b"triggers"]) -> None: ...

global___RecognitionClassifier = RecognitionClassifier

@typing.final
class RecognitionClassifierOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFIERS_FIELD_NUMBER: builtins.int
    @property
    def classifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecognitionClassifier]:
        """List of classifiers to use. For detailed information and usage example, see [documentation](/docs/speechkit/stt/analysis)."""

    def __init__(
        self,
        *,
        classifiers: collections.abc.Iterable[global___RecognitionClassifier] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["classifiers", b"classifiers"]) -> None: ...

global___RecognitionClassifierOptions = RecognitionClassifierOptions

@typing.final
class SpeechAnalysisOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_SPEAKER_ANALYSIS_FIELD_NUMBER: builtins.int
    ENABLE_CONVERSATION_ANALYSIS_FIELD_NUMBER: builtins.int
    DESCRIPTIVE_STATISTICS_QUANTILES_FIELD_NUMBER: builtins.int
    enable_speaker_analysis: builtins.bool
    """Analyse speech for every speaker"""
    enable_conversation_analysis: builtins.bool
    """Analyse conversation of two speakers"""
    @property
    def descriptive_statistics_quantiles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Quantile levels in range (0, 1) for descriptive statistics"""

    def __init__(
        self,
        *,
        enable_speaker_analysis: builtins.bool = ...,
        enable_conversation_analysis: builtins.bool = ...,
        descriptive_statistics_quantiles: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["descriptive_statistics_quantiles", b"descriptive_statistics_quantiles", "enable_conversation_analysis", b"enable_conversation_analysis", "enable_speaker_analysis", b"enable_speaker_analysis"]) -> None: ...

global___SpeechAnalysisOptions = SpeechAnalysisOptions

@typing.final
class RawAudio(google.protobuf.message.Message):
    """RAW Audio format spec (no container to infer type). Used in AudioFormat options."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AudioEncoding:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AudioEncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RawAudio._AudioEncoding.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUDIO_ENCODING_UNSPECIFIED: RawAudio._AudioEncoding.ValueType  # 0
        LINEAR16_PCM: RawAudio._AudioEncoding.ValueType  # 1
        """Audio bit depth 16-bit signed little-endian (Linear PCM)."""

    class AudioEncoding(_AudioEncoding, metaclass=_AudioEncodingEnumTypeWrapper): ...
    AUDIO_ENCODING_UNSPECIFIED: RawAudio.AudioEncoding.ValueType  # 0
    LINEAR16_PCM: RawAudio.AudioEncoding.ValueType  # 1
    """Audio bit depth 16-bit signed little-endian (Linear PCM)."""

    AUDIO_ENCODING_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_HERTZ_FIELD_NUMBER: builtins.int
    AUDIO_CHANNEL_COUNT_FIELD_NUMBER: builtins.int
    audio_encoding: global___RawAudio.AudioEncoding.ValueType
    """Type of audio encoding."""
    sample_rate_hertz: builtins.int
    """PCM sample rate."""
    audio_channel_count: builtins.int
    """PCM channel count. Currently only single channel audio is supported in real-time recognition."""
    def __init__(
        self,
        *,
        audio_encoding: global___RawAudio.AudioEncoding.ValueType = ...,
        sample_rate_hertz: builtins.int = ...,
        audio_channel_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["audio_channel_count", b"audio_channel_count", "audio_encoding", b"audio_encoding", "sample_rate_hertz", b"sample_rate_hertz"]) -> None: ...

global___RawAudio = RawAudio

@typing.final
class ContainerAudio(google.protobuf.message.Message):
    """Audio with fixed type in container. Used in AudioFormat options."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ContainerAudioType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ContainerAudioTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ContainerAudio._ContainerAudioType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONTAINER_AUDIO_TYPE_UNSPECIFIED: ContainerAudio._ContainerAudioType.ValueType  # 0
        WAV: ContainerAudio._ContainerAudioType.ValueType  # 1
        """Audio bit depth 16-bit signed little-endian (Linear PCM)."""
        OGG_OPUS: ContainerAudio._ContainerAudioType.ValueType  # 2
        """Data is encoded using the OPUS audio codec and compressed using the OGG container format."""
        MP3: ContainerAudio._ContainerAudioType.ValueType  # 3
        """Data is encoded using MPEG-1/2 Layer III and compressed using the MP3 container format."""

    class ContainerAudioType(_ContainerAudioType, metaclass=_ContainerAudioTypeEnumTypeWrapper): ...
    CONTAINER_AUDIO_TYPE_UNSPECIFIED: ContainerAudio.ContainerAudioType.ValueType  # 0
    WAV: ContainerAudio.ContainerAudioType.ValueType  # 1
    """Audio bit depth 16-bit signed little-endian (Linear PCM)."""
    OGG_OPUS: ContainerAudio.ContainerAudioType.ValueType  # 2
    """Data is encoded using the OPUS audio codec and compressed using the OGG container format."""
    MP3: ContainerAudio.ContainerAudioType.ValueType  # 3
    """Data is encoded using MPEG-1/2 Layer III and compressed using the MP3 container format."""

    CONTAINER_AUDIO_TYPE_FIELD_NUMBER: builtins.int
    container_audio_type: global___ContainerAudio.ContainerAudioType.ValueType
    """Type of audio container."""
    def __init__(
        self,
        *,
        container_audio_type: global___ContainerAudio.ContainerAudioType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_audio_type", b"container_audio_type"]) -> None: ...

global___ContainerAudio = ContainerAudio

@typing.final
class AudioFormatOptions(google.protobuf.message.Message):
    """Audio format options."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_AUDIO_FIELD_NUMBER: builtins.int
    CONTAINER_AUDIO_FIELD_NUMBER: builtins.int
    @property
    def raw_audio(self) -> global___RawAudio:
        """RAW audio without container."""

    @property
    def container_audio(self) -> global___ContainerAudio:
        """Audio is wrapped in container."""

    def __init__(
        self,
        *,
        raw_audio: global___RawAudio | None = ...,
        container_audio: global___ContainerAudio | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["AudioFormat", b"AudioFormat", "container_audio", b"container_audio", "raw_audio", b"raw_audio"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["AudioFormat", b"AudioFormat", "container_audio", b"container_audio", "raw_audio", b"raw_audio"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["AudioFormat", b"AudioFormat"]) -> typing.Literal["raw_audio", "container_audio"] | None: ...

global___AudioFormatOptions = AudioFormatOptions

@typing.final
class LanguageRestrictionOptions(google.protobuf.message.Message):
    """Type of restriction for the list of languages expected in the incoming audio."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _LanguageRestrictionType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LanguageRestrictionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LanguageRestrictionOptions._LanguageRestrictionType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LANGUAGE_RESTRICTION_TYPE_UNSPECIFIED: LanguageRestrictionOptions._LanguageRestrictionType.ValueType  # 0
        WHITELIST: LanguageRestrictionOptions._LanguageRestrictionType.ValueType  # 1
        """The list of most possible languages in the incoming audio."""
        BLACKLIST: LanguageRestrictionOptions._LanguageRestrictionType.ValueType  # 2
        """The list of languages that are likely not to be included in the incoming audio."""

    class LanguageRestrictionType(_LanguageRestrictionType, metaclass=_LanguageRestrictionTypeEnumTypeWrapper): ...
    LANGUAGE_RESTRICTION_TYPE_UNSPECIFIED: LanguageRestrictionOptions.LanguageRestrictionType.ValueType  # 0
    WHITELIST: LanguageRestrictionOptions.LanguageRestrictionType.ValueType  # 1
    """The list of most possible languages in the incoming audio."""
    BLACKLIST: LanguageRestrictionOptions.LanguageRestrictionType.ValueType  # 2
    """The list of languages that are likely not to be included in the incoming audio."""

    RESTRICTION_TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    restriction_type: global___LanguageRestrictionOptions.LanguageRestrictionType.ValueType
    """Language restriction type.
    All of these restrictions are used by the model as guidelines, not as strict rules.
    The language is recognized for each sentence. If a sentence has phrases in different languages, all of them will be transcribed in the most probable language.
    """
    @property
    def language_code(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of [language codes](/docs/speechkit/stt/models) to restrict recognition in the case of an auto model."""

    def __init__(
        self,
        *,
        restriction_type: global___LanguageRestrictionOptions.LanguageRestrictionType.ValueType = ...,
        language_code: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["language_code", b"language_code", "restriction_type", b"restriction_type"]) -> None: ...

global___LanguageRestrictionOptions = LanguageRestrictionOptions

@typing.final
class JsonSchema(google.protobuf.message.Message):
    """Represents the expected structure of the model's response using a JSON Schema."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMA_FIELD_NUMBER: builtins.int
    @property
    def schema(self) -> google.protobuf.struct_pb2.Struct:
        """The JSON Schema that the model's output must conform to."""

    def __init__(
        self,
        *,
        schema: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["schema", b"schema"]) -> None: ...

global___JsonSchema = JsonSchema

@typing.final
class SummarizationProperty(google.protobuf.message.Message):
    """Represents summarization entry for transcription."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTION_FIELD_NUMBER: builtins.int
    JSON_OBJECT_FIELD_NUMBER: builtins.int
    JSON_SCHEMA_FIELD_NUMBER: builtins.int
    instruction: builtins.str
    """Summarization instruction for model."""
    json_object: builtins.bool
    """When set to true, the model will return a valid JSON object.
    Be sure to ask the model explicitly for JSON.
    Otherwise, it may produce excessive whitespace and run indefinitely until it reaches the token limit.
    """
    @property
    def json_schema(self) -> global___JsonSchema:
        """Enforces a specific JSON structure for the model's response based on a provided schema."""

    def __init__(
        self,
        *,
        instruction: builtins.str = ...,
        json_object: builtins.bool = ...,
        json_schema: global___JsonSchema | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "json_object", b"json_object", "json_schema", b"json_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "instruction", b"instruction", "json_object", b"json_object", "json_schema", b"json_schema"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ResponseFormat", b"ResponseFormat"]) -> typing.Literal["json_object", "json_schema"] | None: ...

global___SummarizationProperty = SummarizationProperty

@typing.final
class SummarizationOptions(google.protobuf.message.Message):
    """Represents transcription summarization options."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_URI_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    model_uri: builtins.str
    """The [ID of the model](/docs/foundation-models/concepts/yandexgpt/models) to be used for completion generation."""
    @property
    def properties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SummarizationProperty]:
        """A list of suimmarizations to perform with transcription."""

    def __init__(
        self,
        *,
        model_uri: builtins.str = ...,
        properties: collections.abc.Iterable[global___SummarizationProperty] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["model_uri", b"model_uri", "properties", b"properties"]) -> None: ...

global___SummarizationOptions = SummarizationOptions

@typing.final
class SummarizationPropertyResult(google.protobuf.message.Message):
    """Represents summarization response entry for transcription."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_FIELD_NUMBER: builtins.int
    response: builtins.str
    """Summarization response text."""
    def __init__(
        self,
        *,
        response: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["response", b"response"]) -> None: ...

global___SummarizationPropertyResult = SummarizationPropertyResult

@typing.final
class RecognitionModelOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AudioProcessingType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AudioProcessingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RecognitionModelOptions._AudioProcessingType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUDIO_PROCESSING_TYPE_UNSPECIFIED: RecognitionModelOptions._AudioProcessingType.ValueType  # 0
        REAL_TIME: RecognitionModelOptions._AudioProcessingType.ValueType  # 1
        """Process audio in mode optimized for real-time recognition, i.e. send partials and final responses as soon as possible."""
        FULL_DATA: RecognitionModelOptions._AudioProcessingType.ValueType  # 2
        """Process audio after all data was received."""

    class AudioProcessingType(_AudioProcessingType, metaclass=_AudioProcessingTypeEnumTypeWrapper): ...
    AUDIO_PROCESSING_TYPE_UNSPECIFIED: RecognitionModelOptions.AudioProcessingType.ValueType  # 0
    REAL_TIME: RecognitionModelOptions.AudioProcessingType.ValueType  # 1
    """Process audio in mode optimized for real-time recognition, i.e. send partials and final responses as soon as possible."""
    FULL_DATA: RecognitionModelOptions.AudioProcessingType.ValueType  # 2
    """Process audio after all data was received."""

    MODEL_FIELD_NUMBER: builtins.int
    AUDIO_FORMAT_FIELD_NUMBER: builtins.int
    TEXT_NORMALIZATION_FIELD_NUMBER: builtins.int
    LANGUAGE_RESTRICTION_FIELD_NUMBER: builtins.int
    AUDIO_PROCESSING_TYPE_FIELD_NUMBER: builtins.int
    model: builtins.str
    """Sets the recognition model for the cloud version of SpeechKit. 
    For `Recognizer.RecognizeStreaming`, possible values are `general`, `general:rc`, `general:deprecated`.
    For `AsyncRecognizer.RecognizeFile`, possible values are `general`, `general:rc`, `general:deprecated`, `deferred-general`, `deferred-general:rc`, and `deferred-general:deprecated`. 
    The model is ignored for SpeechKit Hybrid.
    """
    audio_processing_type: global___RecognitionModelOptions.AudioProcessingType.ValueType
    """For `Recognizer.RecognizeStreaming`, defines the audio data processing mode. Default is `REAL_TIME`.
    For `AsyncRecognizer.RecognizeFile`, this field is ignored.
    """
    @property
    def audio_format(self) -> global___AudioFormatOptions:
        """Specified input audio."""

    @property
    def text_normalization(self) -> global___TextNormalizationOptions:
        """Text normalization options."""

    @property
    def language_restriction(self) -> global___LanguageRestrictionOptions:
        """Possible languages in audio."""

    def __init__(
        self,
        *,
        model: builtins.str = ...,
        audio_format: global___AudioFormatOptions | None = ...,
        text_normalization: global___TextNormalizationOptions | None = ...,
        language_restriction: global___LanguageRestrictionOptions | None = ...,
        audio_processing_type: global___RecognitionModelOptions.AudioProcessingType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio_format", b"audio_format", "language_restriction", b"language_restriction", "text_normalization", b"text_normalization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio_format", b"audio_format", "audio_processing_type", b"audio_processing_type", "language_restriction", b"language_restriction", "model", b"model", "text_normalization", b"text_normalization"]) -> None: ...

global___RecognitionModelOptions = RecognitionModelOptions

@typing.final
class SpeakerLabelingOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SpeakerLabeling:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SpeakerLabelingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SpeakerLabelingOptions._SpeakerLabeling.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SPEAKER_LABELING_UNSPECIFIED: SpeakerLabelingOptions._SpeakerLabeling.ValueType  # 0
        SPEAKER_LABELING_ENABLED: SpeakerLabelingOptions._SpeakerLabeling.ValueType  # 1
        """Enable speaker labeling."""
        SPEAKER_LABELING_DISABLED: SpeakerLabelingOptions._SpeakerLabeling.ValueType  # 2
        """Disable speaker labeling. Default value."""

    class SpeakerLabeling(_SpeakerLabeling, metaclass=_SpeakerLabelingEnumTypeWrapper): ...
    SPEAKER_LABELING_UNSPECIFIED: SpeakerLabelingOptions.SpeakerLabeling.ValueType  # 0
    SPEAKER_LABELING_ENABLED: SpeakerLabelingOptions.SpeakerLabeling.ValueType  # 1
    """Enable speaker labeling."""
    SPEAKER_LABELING_DISABLED: SpeakerLabelingOptions.SpeakerLabeling.ValueType  # 2
    """Disable speaker labeling. Default value."""

    SPEAKER_LABELING_FIELD_NUMBER: builtins.int
    speaker_labeling: global___SpeakerLabelingOptions.SpeakerLabeling.ValueType
    """Specifies the execution of speaker labeling."""
    def __init__(
        self,
        *,
        speaker_labeling: global___SpeakerLabelingOptions.SpeakerLabeling.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["speaker_labeling", b"speaker_labeling"]) -> None: ...

global___SpeakerLabelingOptions = SpeakerLabelingOptions

@typing.final
class StreamingOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECOGNITION_MODEL_FIELD_NUMBER: builtins.int
    EOU_CLASSIFIER_FIELD_NUMBER: builtins.int
    RECOGNITION_CLASSIFIER_FIELD_NUMBER: builtins.int
    SPEECH_ANALYSIS_FIELD_NUMBER: builtins.int
    SPEAKER_LABELING_FIELD_NUMBER: builtins.int
    SUMMARIZATION_FIELD_NUMBER: builtins.int
    @property
    def recognition_model(self) -> global___RecognitionModelOptions:
        """Configuration for speech recognition model."""

    @property
    def eou_classifier(self) -> global___EouClassifierOptions:
        """Configuration for an end of utterance detection model."""

    @property
    def recognition_classifier(self) -> global___RecognitionClassifierOptions:
        """Configuration for classifiers over speech recognition."""

    @property
    def speech_analysis(self) -> global___SpeechAnalysisOptions:
        """Configuration for speech analysis over speech recognition."""

    @property
    def speaker_labeling(self) -> global___SpeakerLabelingOptions:
        """Configuration for speaker labeling."""

    @property
    def summarization(self) -> global___SummarizationOptions:
        """Summarization options."""

    def __init__(
        self,
        *,
        recognition_model: global___RecognitionModelOptions | None = ...,
        eou_classifier: global___EouClassifierOptions | None = ...,
        recognition_classifier: global___RecognitionClassifierOptions | None = ...,
        speech_analysis: global___SpeechAnalysisOptions | None = ...,
        speaker_labeling: global___SpeakerLabelingOptions | None = ...,
        summarization: global___SummarizationOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["eou_classifier", b"eou_classifier", "recognition_classifier", b"recognition_classifier", "recognition_model", b"recognition_model", "speaker_labeling", b"speaker_labeling", "speech_analysis", b"speech_analysis", "summarization", b"summarization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["eou_classifier", b"eou_classifier", "recognition_classifier", b"recognition_classifier", "recognition_model", b"recognition_model", "speaker_labeling", b"speaker_labeling", "speech_analysis", b"speech_analysis", "summarization", b"summarization"]) -> None: ...

global___StreamingOptions = StreamingOptions

@typing.final
class AudioChunk(google.protobuf.message.Message):
    """Data chunk with audio."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """Bytes with audio data."""
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data"]) -> None: ...

global___AudioChunk = AudioChunk

@typing.final
class SilenceChunk(google.protobuf.message.Message):
    """Data chunk with silence."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DURATION_MS_FIELD_NUMBER: builtins.int
    duration_ms: builtins.int
    """Duration of silence chunk in ms."""
    def __init__(
        self,
        *,
        duration_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["duration_ms", b"duration_ms"]) -> None: ...

global___SilenceChunk = SilenceChunk

@typing.final
class Eou(google.protobuf.message.Message):
    """Force EOU."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Eou = Eou

@typing.final
class StreamingRequest(google.protobuf.message.Message):
    """Streaming audio request.
    Events are control messages from user. First message should be session options. The next messages are audio data chunks or control messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_OPTIONS_FIELD_NUMBER: builtins.int
    CHUNK_FIELD_NUMBER: builtins.int
    SILENCE_CHUNK_FIELD_NUMBER: builtins.int
    EOU_FIELD_NUMBER: builtins.int
    @property
    def session_options(self) -> global___StreamingOptions:
        """Session options. Should be the first message from user."""

    @property
    def chunk(self) -> global___AudioChunk:
        """Chunk with audio data."""

    @property
    def silence_chunk(self) -> global___SilenceChunk:
        """Chunk with silence."""

    @property
    def eou(self) -> global___Eou:
        """Request to end current utterance. Works only with external EOU detector."""

    def __init__(
        self,
        *,
        session_options: global___StreamingOptions | None = ...,
        chunk: global___AudioChunk | None = ...,
        silence_chunk: global___SilenceChunk | None = ...,
        eou: global___Eou | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Event", b"Event", "chunk", b"chunk", "eou", b"eou", "session_options", b"session_options", "silence_chunk", b"silence_chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Event", b"Event", "chunk", b"chunk", "eou", b"eou", "session_options", b"session_options", "silence_chunk", b"silence_chunk"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Event", b"Event"]) -> typing.Literal["session_options", "chunk", "silence_chunk", "eou"] | None: ...

global___StreamingRequest = StreamingRequest

@typing.final
class RecognizeFileRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    URI_FIELD_NUMBER: builtins.int
    RECOGNITION_MODEL_FIELD_NUMBER: builtins.int
    RECOGNITION_CLASSIFIER_FIELD_NUMBER: builtins.int
    SPEECH_ANALYSIS_FIELD_NUMBER: builtins.int
    SPEAKER_LABELING_FIELD_NUMBER: builtins.int
    SUMMARIZATION_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Bytes with data"""
    uri: builtins.str
    """S3 data URL"""
    @property
    def recognition_model(self) -> global___RecognitionModelOptions:
        """Configuration for speech recognition model."""

    @property
    def recognition_classifier(self) -> global___RecognitionClassifierOptions:
        """Configuration for classifiers over speech recognition."""

    @property
    def speech_analysis(self) -> global___SpeechAnalysisOptions:
        """Configuration for speech analysis over speech recognition."""

    @property
    def speaker_labeling(self) -> global___SpeakerLabelingOptions:
        """Configuration for speaker labeling"""

    @property
    def summarization(self) -> global___SummarizationOptions:
        """Summarization options"""

    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
        uri: builtins.str = ...,
        recognition_model: global___RecognitionModelOptions | None = ...,
        recognition_classifier: global___RecognitionClassifierOptions | None = ...,
        speech_analysis: global___SpeechAnalysisOptions | None = ...,
        speaker_labeling: global___SpeakerLabelingOptions | None = ...,
        summarization: global___SummarizationOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["AudioSource", b"AudioSource", "content", b"content", "recognition_classifier", b"recognition_classifier", "recognition_model", b"recognition_model", "speaker_labeling", b"speaker_labeling", "speech_analysis", b"speech_analysis", "summarization", b"summarization", "uri", b"uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["AudioSource", b"AudioSource", "content", b"content", "recognition_classifier", b"recognition_classifier", "recognition_model", b"recognition_model", "speaker_labeling", b"speaker_labeling", "speech_analysis", b"speech_analysis", "summarization", b"summarization", "uri", b"uri"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["AudioSource", b"AudioSource"]) -> typing.Literal["content", "uri"] | None: ...

global___RecognizeFileRequest = RecognizeFileRequest

@typing.final
class Word(google.protobuf.message.Message):
    """Now response

    Recognized word.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_MS_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Word text."""
    start_time_ms: builtins.int
    """Estimation of word start time in ms."""
    end_time_ms: builtins.int
    """Estimation of word end time in ms."""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        start_time_ms: builtins.int = ...,
        end_time_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["end_time_ms", b"end_time_ms", "start_time_ms", b"start_time_ms", "text", b"text"]) -> None: ...

global___Word = Word

@typing.final
class LanguageEstimation(google.protobuf.message.Message):
    """Estimation of language and its probability."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PROBABILITY_FIELD_NUMBER: builtins.int
    language_code: builtins.str
    """Language tag in IETF BCP 47 format, consisting of ISO 639-1 language code and ISO 3166-1 country code (e.g., en-US, ru-RU)."""
    probability: builtins.float
    """Estimation of language probability."""
    def __init__(
        self,
        *,
        language_code: builtins.str = ...,
        probability: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["language_code", b"language_code", "probability", b"probability"]) -> None: ...

global___LanguageEstimation = LanguageEstimation

@typing.final
class Alternative(google.protobuf.message.Message):
    """Recognition of specific time frame."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORDS_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_MS_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    LANGUAGES_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text in time frame."""
    start_time_ms: builtins.int
    """Start of time frame."""
    end_time_ms: builtins.int
    """End of time frame."""
    confidence: builtins.float
    """The hypothesis confidence. Currently is not used."""
    @property
    def words(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Word]:
        """Words in time frame."""

    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LanguageEstimation]:
        """Distribution over possible languages."""

    def __init__(
        self,
        *,
        words: collections.abc.Iterable[global___Word] | None = ...,
        text: builtins.str = ...,
        start_time_ms: builtins.int = ...,
        end_time_ms: builtins.int = ...,
        confidence: builtins.float = ...,
        languages: collections.abc.Iterable[global___LanguageEstimation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["confidence", b"confidence", "end_time_ms", b"end_time_ms", "languages", b"languages", "start_time_ms", b"start_time_ms", "text", b"text", "words", b"words"]) -> None: ...

global___Alternative = Alternative

@typing.final
class EouUpdate(google.protobuf.message.Message):
    """Update information for external End of Utterance."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_MS_FIELD_NUMBER: builtins.int
    time_ms: builtins.int
    """EOU estimated time."""
    def __init__(
        self,
        *,
        time_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["time_ms", b"time_ms"]) -> None: ...

global___EouUpdate = EouUpdate

@typing.final
class AlternativeUpdate(google.protobuf.message.Message):
    """Update of hypothesis."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALTERNATIVES_FIELD_NUMBER: builtins.int
    CHANNEL_TAG_FIELD_NUMBER: builtins.int
    channel_tag: builtins.str
    @property
    def alternatives(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Alternative]:
        """List of hypothesis for timeframes."""

    def __init__(
        self,
        *,
        alternatives: collections.abc.Iterable[global___Alternative] | None = ...,
        channel_tag: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alternatives", b"alternatives", "channel_tag", b"channel_tag"]) -> None: ...

global___AlternativeUpdate = AlternativeUpdate

@typing.final
class AudioCursors(google.protobuf.message.Message):
    """AudioCursors are state of ASR recognition stream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECEIVED_DATA_MS_FIELD_NUMBER: builtins.int
    RESET_TIME_MS_FIELD_NUMBER: builtins.int
    PARTIAL_TIME_MS_FIELD_NUMBER: builtins.int
    FINAL_TIME_MS_FIELD_NUMBER: builtins.int
    FINAL_INDEX_FIELD_NUMBER: builtins.int
    EOU_TIME_MS_FIELD_NUMBER: builtins.int
    received_data_ms: builtins.int
    """Amount of audio chunks server received. This cursor is moved after each audio chunk was received by server."""
    reset_time_ms: builtins.int
    """Input stream reset data."""
    partial_time_ms: builtins.int
    """How much audio was processed. This time includes trimming silences as well. 
    This cursor is moved after server received enough data to update recognition results (includes silence as well).
    """
    final_time_ms: builtins.int
    """Time of last final. This cursor is moved when server decides that recognition from start of audio until `final_time_ms` will not change anymore
    usually this event is followed by EOU detection. This behavior could change in future.
    """
    final_index: builtins.int
    """This is index of last final server send. Incremented after each new final."""
    eou_time_ms: builtins.int
    """Estimated time of EOU. Cursor is updated after each new EOU is sent.
    For external classifier this equals to [received_data_ms] at the moment EOU event arrives.
    For internal classifier this is estimation of time. The time is not exact and has the same guarantees as word timings.
    """
    def __init__(
        self,
        *,
        received_data_ms: builtins.int = ...,
        reset_time_ms: builtins.int = ...,
        partial_time_ms: builtins.int = ...,
        final_time_ms: builtins.int = ...,
        final_index: builtins.int = ...,
        eou_time_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["eou_time_ms", b"eou_time_ms", "final_index", b"final_index", "final_time_ms", b"final_time_ms", "partial_time_ms", b"partial_time_ms", "received_data_ms", b"received_data_ms", "reset_time_ms", b"reset_time_ms"]) -> None: ...

global___AudioCursors = AudioCursors

@typing.final
class FinalRefinement(google.protobuf.message.Message):
    """Refinement for final hypo. For example, text normalization is refinement."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FINAL_INDEX_FIELD_NUMBER: builtins.int
    NORMALIZED_TEXT_FIELD_NUMBER: builtins.int
    final_index: builtins.int
    """Index of final for which server sends additional information."""
    @property
    def normalized_text(self) -> global___AlternativeUpdate:
        """Normalized text instead of raw one."""

    def __init__(
        self,
        *,
        final_index: builtins.int = ...,
        normalized_text: global___AlternativeUpdate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Type", b"Type", "normalized_text", b"normalized_text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Type", b"Type", "final_index", b"final_index", "normalized_text", b"normalized_text"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Type", b"Type"]) -> typing.Literal["normalized_text"] | None: ...

global___FinalRefinement = FinalRefinement

@typing.final
class StatusCode(google.protobuf.message.Message):
    """Status message."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_TYPE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    code_type: global___CodeType.ValueType
    """Code type."""
    message: builtins.str
    """Human readable message."""
    def __init__(
        self,
        *,
        code_type: global___CodeType.ValueType = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["code_type", b"code_type", "message", b"message"]) -> None: ...

global___StatusCode = StatusCode

@typing.final
class SessionUuid(google.protobuf.message.Message):
    """Session identifier."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UUID_FIELD_NUMBER: builtins.int
    USER_REQUEST_ID_FIELD_NUMBER: builtins.int
    uuid: builtins.str
    """Internal session identifier."""
    user_request_id: builtins.str
    """User session identifier."""
    def __init__(
        self,
        *,
        uuid: builtins.str = ...,
        user_request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_request_id", b"user_request_id", "uuid", b"uuid"]) -> None: ...

global___SessionUuid = SessionUuid

@typing.final
class PhraseHighlight(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_MS_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text transcription of the highlighted audio segment."""
    start_time_ms: builtins.int
    """Start time of the highlighted audio segment."""
    end_time_ms: builtins.int
    """End time of the highlighted audio segment."""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        start_time_ms: builtins.int = ...,
        end_time_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["end_time_ms", b"end_time_ms", "start_time_ms", b"start_time_ms", "text", b"text"]) -> None: ...

global___PhraseHighlight = PhraseHighlight

@typing.final
class RecognitionClassifierLabel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LABEL_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    label: builtins.str
    """The label of the class predicted by the classifier."""
    confidence: builtins.float
    """The prediction confidence."""
    def __init__(
        self,
        *,
        label: builtins.str = ...,
        confidence: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["confidence", b"confidence", "label", b"label"]) -> None: ...

global___RecognitionClassifierLabel = RecognitionClassifierLabel

@typing.final
class RecognitionClassifierResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFIER_FIELD_NUMBER: builtins.int
    HIGHLIGHTS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    classifier: builtins.str
    """Name of the triggered classifier."""
    @property
    def highlights(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PhraseHighlight]:
        """List of highlights, i.e. parts of phrase that determine the result of the classification."""

    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecognitionClassifierLabel]:
        """Classifier predictions."""

    def __init__(
        self,
        *,
        classifier: builtins.str = ...,
        highlights: collections.abc.Iterable[global___PhraseHighlight] | None = ...,
        labels: collections.abc.Iterable[global___RecognitionClassifierLabel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["classifier", b"classifier", "highlights", b"highlights", "labels", b"labels"]) -> None: ...

global___RecognitionClassifierResult = RecognitionClassifierResult

@typing.final
class RecognitionClassifierUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WindowType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WindowTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RecognitionClassifierUpdate._WindowType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WINDOW_TYPE_UNSPECIFIED: RecognitionClassifierUpdate._WindowType.ValueType  # 0
        LAST_UTTERANCE: RecognitionClassifierUpdate._WindowType.ValueType  # 1
        """The result of applying the classifier to the last utterance response."""
        LAST_FINAL: RecognitionClassifierUpdate._WindowType.ValueType  # 2
        """The result of applying the classifier to the last final response."""
        LAST_PARTIAL: RecognitionClassifierUpdate._WindowType.ValueType  # 3
        """The result of applying the classifier to the last partial response."""

    class WindowType(_WindowType, metaclass=_WindowTypeEnumTypeWrapper): ...
    WINDOW_TYPE_UNSPECIFIED: RecognitionClassifierUpdate.WindowType.ValueType  # 0
    LAST_UTTERANCE: RecognitionClassifierUpdate.WindowType.ValueType  # 1
    """The result of applying the classifier to the last utterance response."""
    LAST_FINAL: RecognitionClassifierUpdate.WindowType.ValueType  # 2
    """The result of applying the classifier to the last final response."""
    LAST_PARTIAL: RecognitionClassifierUpdate.WindowType.ValueType  # 3
    """The result of applying the classifier to the last partial response."""

    WINDOW_TYPE_FIELD_NUMBER: builtins.int
    START_TIME_MS_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    CLASSIFIER_RESULT_FIELD_NUMBER: builtins.int
    window_type: global___RecognitionClassifierUpdate.WindowType.ValueType
    """Response window type."""
    start_time_ms: builtins.int
    """Start time of the audio segment used for classification."""
    end_time_ms: builtins.int
    """End time of the audio segment used for classification."""
    @property
    def classifier_result(self) -> global___RecognitionClassifierResult:
        """Result for dictionary-based classifier."""

    def __init__(
        self,
        *,
        window_type: global___RecognitionClassifierUpdate.WindowType.ValueType = ...,
        start_time_ms: builtins.int = ...,
        end_time_ms: builtins.int = ...,
        classifier_result: global___RecognitionClassifierResult | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["classifier_result", b"classifier_result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["classifier_result", b"classifier_result", "end_time_ms", b"end_time_ms", "start_time_ms", b"start_time_ms", "window_type", b"window_type"]) -> None: ...

global___RecognitionClassifierUpdate = RecognitionClassifierUpdate

@typing.final
class DescriptiveStatistics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Quantile(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LEVEL_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        level: builtins.float
        """Quantile level in range (0, 1)."""
        value: builtins.float
        """Quantile value."""
        def __init__(
            self,
            *,
            level: builtins.float = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["level", b"level", "value", b"value"]) -> None: ...

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    MEAN_FIELD_NUMBER: builtins.int
    STD_FIELD_NUMBER: builtins.int
    QUANTILES_FIELD_NUMBER: builtins.int
    min: builtins.float
    """Minimum observed value."""
    max: builtins.float
    """Maximum observed value."""
    mean: builtins.float
    """Estimated mean of distribution."""
    std: builtins.float
    """Estimated standard deviation of distribution."""
    @property
    def quantiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DescriptiveStatistics.Quantile]:
        """List of evaluated quantiles."""

    def __init__(
        self,
        *,
        min: builtins.float = ...,
        max: builtins.float = ...,
        mean: builtins.float = ...,
        std: builtins.float = ...,
        quantiles: collections.abc.Iterable[global___DescriptiveStatistics.Quantile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max", b"max", "mean", b"mean", "min", b"min", "quantiles", b"quantiles", "std", b"std"]) -> None: ...

global___DescriptiveStatistics = DescriptiveStatistics

@typing.final
class AudioSegmentBoundaries(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_MS_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    start_time_ms: builtins.int
    """Audio segment start time."""
    end_time_ms: builtins.int
    """Audio segment end time."""
    def __init__(
        self,
        *,
        start_time_ms: builtins.int = ...,
        end_time_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["end_time_ms", b"end_time_ms", "start_time_ms", b"start_time_ms"]) -> None: ...

global___AudioSegmentBoundaries = AudioSegmentBoundaries

@typing.final
class SpeakerAnalysis(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WindowType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WindowTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SpeakerAnalysis._WindowType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WINDOW_TYPE_UNSPECIFIED: SpeakerAnalysis._WindowType.ValueType  # 0
        TOTAL: SpeakerAnalysis._WindowType.ValueType  # 1
        """Stats for all received audio."""
        LAST_UTTERANCE: SpeakerAnalysis._WindowType.ValueType  # 2
        """Stats for last utterance."""

    class WindowType(_WindowType, metaclass=_WindowTypeEnumTypeWrapper): ...
    WINDOW_TYPE_UNSPECIFIED: SpeakerAnalysis.WindowType.ValueType  # 0
    TOTAL: SpeakerAnalysis.WindowType.ValueType  # 1
    """Stats for all received audio."""
    LAST_UTTERANCE: SpeakerAnalysis.WindowType.ValueType  # 2
    """Stats for last utterance."""

    SPEAKER_TAG_FIELD_NUMBER: builtins.int
    WINDOW_TYPE_FIELD_NUMBER: builtins.int
    SPEECH_BOUNDARIES_FIELD_NUMBER: builtins.int
    TOTAL_SPEECH_MS_FIELD_NUMBER: builtins.int
    SPEECH_RATIO_FIELD_NUMBER: builtins.int
    TOTAL_SILENCE_MS_FIELD_NUMBER: builtins.int
    SILENCE_RATIO_FIELD_NUMBER: builtins.int
    WORDS_COUNT_FIELD_NUMBER: builtins.int
    LETTERS_COUNT_FIELD_NUMBER: builtins.int
    WORDS_PER_SECOND_FIELD_NUMBER: builtins.int
    LETTERS_PER_SECOND_FIELD_NUMBER: builtins.int
    WORDS_PER_UTTERANCE_FIELD_NUMBER: builtins.int
    LETTERS_PER_UTTERANCE_FIELD_NUMBER: builtins.int
    UTTERANCE_COUNT_FIELD_NUMBER: builtins.int
    UTTERANCE_DURATION_ESTIMATION_FIELD_NUMBER: builtins.int
    speaker_tag: builtins.str
    """Speaker tag."""
    window_type: global___SpeakerAnalysis.WindowType.ValueType
    """Response window type."""
    total_speech_ms: builtins.int
    """Total speech duration."""
    speech_ratio: builtins.float
    """Speech ratio within audio segment."""
    total_silence_ms: builtins.int
    """Total duration of silence."""
    silence_ratio: builtins.float
    """Silence ratio within audio segment."""
    words_count: builtins.int
    """Number of words in recognized speech."""
    letters_count: builtins.int
    """Number of letters in recognized speech."""
    utterance_count: builtins.int
    """Number of utterances"""
    @property
    def speech_boundaries(self) -> global___AudioSegmentBoundaries:
        """Audio segment boundaries."""

    @property
    def words_per_second(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for words per second distribution."""

    @property
    def letters_per_second(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for letters per second distribution."""

    @property
    def words_per_utterance(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for words per utterance distribution."""

    @property
    def letters_per_utterance(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for letters per utterance distribution."""

    @property
    def utterance_duration_estimation(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for utterance duration distribution"""

    def __init__(
        self,
        *,
        speaker_tag: builtins.str = ...,
        window_type: global___SpeakerAnalysis.WindowType.ValueType = ...,
        speech_boundaries: global___AudioSegmentBoundaries | None = ...,
        total_speech_ms: builtins.int = ...,
        speech_ratio: builtins.float = ...,
        total_silence_ms: builtins.int = ...,
        silence_ratio: builtins.float = ...,
        words_count: builtins.int = ...,
        letters_count: builtins.int = ...,
        words_per_second: global___DescriptiveStatistics | None = ...,
        letters_per_second: global___DescriptiveStatistics | None = ...,
        words_per_utterance: global___DescriptiveStatistics | None = ...,
        letters_per_utterance: global___DescriptiveStatistics | None = ...,
        utterance_count: builtins.int = ...,
        utterance_duration_estimation: global___DescriptiveStatistics | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["letters_per_second", b"letters_per_second", "letters_per_utterance", b"letters_per_utterance", "speech_boundaries", b"speech_boundaries", "utterance_duration_estimation", b"utterance_duration_estimation", "words_per_second", b"words_per_second", "words_per_utterance", b"words_per_utterance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["letters_count", b"letters_count", "letters_per_second", b"letters_per_second", "letters_per_utterance", b"letters_per_utterance", "silence_ratio", b"silence_ratio", "speaker_tag", b"speaker_tag", "speech_boundaries", b"speech_boundaries", "speech_ratio", b"speech_ratio", "total_silence_ms", b"total_silence_ms", "total_speech_ms", b"total_speech_ms", "utterance_count", b"utterance_count", "utterance_duration_estimation", b"utterance_duration_estimation", "window_type", b"window_type", "words_count", b"words_count", "words_per_second", b"words_per_second", "words_per_utterance", b"words_per_utterance"]) -> None: ...

global___SpeakerAnalysis = SpeakerAnalysis

@typing.final
class ConversationAnalysis(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class InterruptsEvaluation(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SPEAKER_TAG_FIELD_NUMBER: builtins.int
        INTERRUPTS_COUNT_FIELD_NUMBER: builtins.int
        INTERRUPTS_DURATION_MS_FIELD_NUMBER: builtins.int
        INTERRUPTS_FIELD_NUMBER: builtins.int
        speaker_tag: builtins.str
        """Speaker tag."""
        interrupts_count: builtins.int
        """Number of interrupts made by the speaker."""
        interrupts_duration_ms: builtins.int
        """Total duration of all interrupts."""
        @property
        def interrupts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioSegmentBoundaries]:
            """Boundaries for every interrupt."""

        def __init__(
            self,
            *,
            speaker_tag: builtins.str = ...,
            interrupts_count: builtins.int = ...,
            interrupts_duration_ms: builtins.int = ...,
            interrupts: collections.abc.Iterable[global___AudioSegmentBoundaries] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["interrupts", b"interrupts", "interrupts_count", b"interrupts_count", "interrupts_duration_ms", b"interrupts_duration_ms", "speaker_tag", b"speaker_tag"]) -> None: ...

    CONVERSATION_BOUNDARIES_FIELD_NUMBER: builtins.int
    TOTAL_SIMULTANEOUS_SILENCE_DURATION_MS_FIELD_NUMBER: builtins.int
    TOTAL_SIMULTANEOUS_SILENCE_RATIO_FIELD_NUMBER: builtins.int
    SIMULTANEOUS_SILENCE_DURATION_ESTIMATION_FIELD_NUMBER: builtins.int
    TOTAL_SIMULTANEOUS_SPEECH_DURATION_MS_FIELD_NUMBER: builtins.int
    TOTAL_SIMULTANEOUS_SPEECH_RATIO_FIELD_NUMBER: builtins.int
    SIMULTANEOUS_SPEECH_DURATION_ESTIMATION_FIELD_NUMBER: builtins.int
    SPEAKER_INTERRUPTS_FIELD_NUMBER: builtins.int
    TOTAL_SPEECH_DURATION_MS_FIELD_NUMBER: builtins.int
    TOTAL_SPEECH_RATIO_FIELD_NUMBER: builtins.int
    total_simultaneous_silence_duration_ms: builtins.int
    """Total simultaneous silence duration."""
    total_simultaneous_silence_ratio: builtins.float
    """Simultaneous silence ratio within audio segment."""
    total_simultaneous_speech_duration_ms: builtins.int
    """Total simultaneous speech duration."""
    total_simultaneous_speech_ratio: builtins.float
    """Simultaneous speech ratio within audio segment."""
    total_speech_duration_ms: builtins.int
    """Total speech duration, including both simultaneous and separate speech."""
    total_speech_ratio: builtins.float
    """Total speech ratio within audio segment."""
    @property
    def conversation_boundaries(self) -> global___AudioSegmentBoundaries:
        """Audio segment boundaries."""

    @property
    def simultaneous_silence_duration_estimation(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for simultaneous silence duration distribution."""

    @property
    def simultaneous_speech_duration_estimation(self) -> global___DescriptiveStatistics:
        """Descriptive statistics for simultaneous speech duration distribution."""

    @property
    def speaker_interrupts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationAnalysis.InterruptsEvaluation]:
        """Interrupts description for every speaker."""

    def __init__(
        self,
        *,
        conversation_boundaries: global___AudioSegmentBoundaries | None = ...,
        total_simultaneous_silence_duration_ms: builtins.int = ...,
        total_simultaneous_silence_ratio: builtins.float = ...,
        simultaneous_silence_duration_estimation: global___DescriptiveStatistics | None = ...,
        total_simultaneous_speech_duration_ms: builtins.int = ...,
        total_simultaneous_speech_ratio: builtins.float = ...,
        simultaneous_speech_duration_estimation: global___DescriptiveStatistics | None = ...,
        speaker_interrupts: collections.abc.Iterable[global___ConversationAnalysis.InterruptsEvaluation] | None = ...,
        total_speech_duration_ms: builtins.int = ...,
        total_speech_ratio: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["conversation_boundaries", b"conversation_boundaries", "simultaneous_silence_duration_estimation", b"simultaneous_silence_duration_estimation", "simultaneous_speech_duration_estimation", b"simultaneous_speech_duration_estimation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["conversation_boundaries", b"conversation_boundaries", "simultaneous_silence_duration_estimation", b"simultaneous_silence_duration_estimation", "simultaneous_speech_duration_estimation", b"simultaneous_speech_duration_estimation", "speaker_interrupts", b"speaker_interrupts", "total_simultaneous_silence_duration_ms", b"total_simultaneous_silence_duration_ms", "total_simultaneous_silence_ratio", b"total_simultaneous_silence_ratio", "total_simultaneous_speech_duration_ms", b"total_simultaneous_speech_duration_ms", "total_simultaneous_speech_ratio", b"total_simultaneous_speech_ratio", "total_speech_duration_ms", b"total_speech_duration_ms", "total_speech_ratio", b"total_speech_ratio"]) -> None: ...

global___ConversationAnalysis = ConversationAnalysis

@typing.final
class ContentUsage(google.protobuf.message.Message):
    """An object representing the number of content [tokens](/docs/foundation-models/concepts/yandexgpt/tokens) used by the completion model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_TEXT_TOKENS_FIELD_NUMBER: builtins.int
    COMPLETION_TOKENS_FIELD_NUMBER: builtins.int
    TOTAL_TOKENS_FIELD_NUMBER: builtins.int
    input_text_tokens: builtins.int
    """The number of tokens in the textual part of the model input."""
    completion_tokens: builtins.int
    """The number of tokens in the generated completion."""
    total_tokens: builtins.int
    """The total number of tokens, including all input tokens and all generated tokens."""
    def __init__(
        self,
        *,
        input_text_tokens: builtins.int = ...,
        completion_tokens: builtins.int = ...,
        total_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["completion_tokens", b"completion_tokens", "input_text_tokens", b"input_text_tokens", "total_tokens", b"total_tokens"]) -> None: ...

global___ContentUsage = ContentUsage

@typing.final
class Summarization(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULTS_FIELD_NUMBER: builtins.int
    CONTENT_USAGE_FIELD_NUMBER: builtins.int
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SummarizationPropertyResult]:
        """A list of summarizations of transcription."""

    @property
    def content_usage(self) -> global___ContentUsage:
        """A set of statistics describing the number of content tokens used by the completion model."""

    def __init__(
        self,
        *,
        results: collections.abc.Iterable[global___SummarizationPropertyResult] | None = ...,
        content_usage: global___ContentUsage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["content_usage", b"content_usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["content_usage", b"content_usage", "results", b"results"]) -> None: ...

global___Summarization = Summarization

@typing.final
class StreamingResponse(google.protobuf.message.Message):
    """Responses from server.
    Each response contains session UUID, AudioCursors, and specific event.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_UUID_FIELD_NUMBER: builtins.int
    AUDIO_CURSORS_FIELD_NUMBER: builtins.int
    RESPONSE_WALL_TIME_MS_FIELD_NUMBER: builtins.int
    PARTIAL_FIELD_NUMBER: builtins.int
    FINAL_FIELD_NUMBER: builtins.int
    EOU_UPDATE_FIELD_NUMBER: builtins.int
    FINAL_REFINEMENT_FIELD_NUMBER: builtins.int
    STATUS_CODE_FIELD_NUMBER: builtins.int
    CLASSIFIER_UPDATE_FIELD_NUMBER: builtins.int
    SPEAKER_ANALYSIS_FIELD_NUMBER: builtins.int
    CONVERSATION_ANALYSIS_FIELD_NUMBER: builtins.int
    SUMMARIZATION_FIELD_NUMBER: builtins.int
    CHANNEL_TAG_FIELD_NUMBER: builtins.int
    response_wall_time_ms: builtins.int
    """Wall clock on server side. This is time when server wrote results to stream."""
    channel_tag: builtins.str
    """Tag for distinguish audio channels."""
    @property
    def session_uuid(self) -> global___SessionUuid:
        """Session identifier."""

    @property
    def audio_cursors(self) -> global___AudioCursors:
        """Progress bar for stream session recognition: how many data we obtained; final and partial times; etc."""

    @property
    def partial(self) -> global___AlternativeUpdate:
        """Partial results, server will send them regularly after enough audio data was received from user. 
        This is the current text estimation from `final_time_ms` to `partial_time_ms`. Could change after new data will arrive.
        """

    @property
    def final(self) -> global___AlternativeUpdate:
        """Final results, the recognition is now fixed until `final_time_ms`. For now, final is sent only if the EOU event was triggered. This behavior could be changed in future releases."""

    @property
    def eou_update(self) -> global___EouUpdate:
        """After EOU classifier, send the message with final, send the EouUpdate with time of EOU
        before eou_update we send final with the same time. there could be several finals before eou update.
        """

    @property
    def final_refinement(self) -> global___FinalRefinement:
        """For each final, if normalization is enabled, sent the normalized text (or some other advanced post-processing).
        Final normalization will introduce additional latency.
        """

    @property
    def status_code(self) -> global___StatusCode:
        """Status messages, send by server with fixed interval (keep-alive)."""

    @property
    def classifier_update(self) -> global___RecognitionClassifierUpdate:
        """Result of the triggered classifier."""

    @property
    def speaker_analysis(self) -> global___SpeakerAnalysis:
        """Speech statistics for every speaker."""

    @property
    def conversation_analysis(self) -> global___ConversationAnalysis:
        """Conversation statistics."""

    @property
    def summarization(self) -> global___Summarization:
        """Summary."""

    def __init__(
        self,
        *,
        session_uuid: global___SessionUuid | None = ...,
        audio_cursors: global___AudioCursors | None = ...,
        response_wall_time_ms: builtins.int = ...,
        partial: global___AlternativeUpdate | None = ...,
        final: global___AlternativeUpdate | None = ...,
        eou_update: global___EouUpdate | None = ...,
        final_refinement: global___FinalRefinement | None = ...,
        status_code: global___StatusCode | None = ...,
        classifier_update: global___RecognitionClassifierUpdate | None = ...,
        speaker_analysis: global___SpeakerAnalysis | None = ...,
        conversation_analysis: global___ConversationAnalysis | None = ...,
        summarization: global___Summarization | None = ...,
        channel_tag: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Event", b"Event", "audio_cursors", b"audio_cursors", "classifier_update", b"classifier_update", "conversation_analysis", b"conversation_analysis", "eou_update", b"eou_update", "final", b"final", "final_refinement", b"final_refinement", "partial", b"partial", "session_uuid", b"session_uuid", "speaker_analysis", b"speaker_analysis", "status_code", b"status_code", "summarization", b"summarization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Event", b"Event", "audio_cursors", b"audio_cursors", "channel_tag", b"channel_tag", "classifier_update", b"classifier_update", "conversation_analysis", b"conversation_analysis", "eou_update", b"eou_update", "final", b"final", "final_refinement", b"final_refinement", "partial", b"partial", "response_wall_time_ms", b"response_wall_time_ms", "session_uuid", b"session_uuid", "speaker_analysis", b"speaker_analysis", "status_code", b"status_code", "summarization", b"summarization"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Event", b"Event"]) -> typing.Literal["partial", "final", "eou_update", "final_refinement", "status_code", "classifier_update", "speaker_analysis", "conversation_analysis", "summarization"] | None: ...

global___StreamingResponse = StreamingResponse

@typing.final
class DeleteRecognitionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_ID_FIELD_NUMBER: builtins.int
    operation_id: builtins.str
    def __init__(
        self,
        *,
        operation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["operation_id", b"operation_id"]) -> None: ...

global___DeleteRecognitionRequest = DeleteRecognitionRequest

@typing.final
class StreamingResponseList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAMING_RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def streaming_responses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StreamingResponse]: ...
    def __init__(
        self,
        *,
        streaming_responses: collections.abc.Iterable[global___StreamingResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["streaming_responses", b"streaming_responses"]) -> None: ...

global___StreamingResponseList = StreamingResponseList
