"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.ai.vision.v1.primitives_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class TextAnnotation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGES_FIELD_NUMBER: builtins.int
    @property
    def pages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Page]:
        """Pages of the recognized file.

        For JPEG and PNG files contains only 1 page.
        """

    def __init__(
        self,
        *,
        pages: collections.abc.Iterable[global___Page] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pages", b"pages"]) -> None: ...

global___TextAnnotation = TextAnnotation

@typing.final
class Page(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    BLOCKS_FIELD_NUMBER: builtins.int
    ENTITIES_FIELD_NUMBER: builtins.int
    width: builtins.int
    """Page width in pixels."""
    height: builtins.int
    """Page height in pixels."""
    @property
    def blocks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Block]:
        """Recognized text blocks in this page."""

    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Entity]:
        """Recognized entities"""

    def __init__(
        self,
        *,
        width: builtins.int = ...,
        height: builtins.int = ...,
        blocks: collections.abc.Iterable[global___Block] | None = ...,
        entities: collections.abc.Iterable[global___Entity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["blocks", b"blocks", "entities", b"entities", "height", b"height", "width", b"width"]) -> None: ...

global___Page = Page

@typing.final
class Entity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Entity name"""
    text: builtins.str
    """Recognized entity text"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "text", b"text"]) -> None: ...

global___Entity = Entity

@typing.final
class Block(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOUNDING_BOX_FIELD_NUMBER: builtins.int
    LINES_FIELD_NUMBER: builtins.int
    @property
    def bounding_box(self) -> yandex.cloud.ai.vision.v1.primitives_pb2.Polygon:
        """Area on the page where the text block is located."""

    @property
    def lines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Line]:
        """Recognized lines in this block."""

    def __init__(
        self,
        *,
        bounding_box: yandex.cloud.ai.vision.v1.primitives_pb2.Polygon | None = ...,
        lines: collections.abc.Iterable[global___Line] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bounding_box", b"bounding_box"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bounding_box", b"bounding_box", "lines", b"lines"]) -> None: ...

global___Block = Block

@typing.final
class Line(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOUNDING_BOX_FIELD_NUMBER: builtins.int
    WORDS_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    confidence: builtins.float
    """Confidence of the OCR results for the line. Range [0, 1]."""
    @property
    def bounding_box(self) -> yandex.cloud.ai.vision.v1.primitives_pb2.Polygon:
        """Area on the page where the line is located."""

    @property
    def words(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Word]:
        """Recognized words in this line."""

    def __init__(
        self,
        *,
        bounding_box: yandex.cloud.ai.vision.v1.primitives_pb2.Polygon | None = ...,
        words: collections.abc.Iterable[global___Word] | None = ...,
        confidence: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bounding_box", b"bounding_box"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bounding_box", b"bounding_box", "confidence", b"confidence", "words", b"words"]) -> None: ...

global___Line = Line

@typing.final
class Word(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DetectedLanguage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LANGUAGE_CODE_FIELD_NUMBER: builtins.int
        CONFIDENCE_FIELD_NUMBER: builtins.int
        language_code: builtins.str
        """Detected language code."""
        confidence: builtins.float
        """Confidence of detected language. Range [0, 1]."""
        def __init__(
            self,
            *,
            language_code: builtins.str = ...,
            confidence: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["confidence", b"confidence", "language_code", b"language_code"]) -> None: ...

    BOUNDING_BOX_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    LANGUAGES_FIELD_NUMBER: builtins.int
    ENTITY_INDEX_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Recognized word value."""
    confidence: builtins.float
    """Confidence of the OCR results for the word. Range [0, 1]."""
    entity_index: builtins.int
    """Id of recognized word in entities array"""
    @property
    def bounding_box(self) -> yandex.cloud.ai.vision.v1.primitives_pb2.Polygon:
        """Area on the page where the word is located."""

    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Word.DetectedLanguage]:
        """A list of detected languages together with confidence."""

    def __init__(
        self,
        *,
        bounding_box: yandex.cloud.ai.vision.v1.primitives_pb2.Polygon | None = ...,
        text: builtins.str = ...,
        confidence: builtins.float = ...,
        languages: collections.abc.Iterable[global___Word.DetectedLanguage] | None = ...,
        entity_index: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bounding_box", b"bounding_box"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bounding_box", b"bounding_box", "confidence", b"confidence", "entity_index", b"entity_index", "languages", b"languages", "text", b"text"]) -> None: ...

global___Word = Word
