"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.airflow.v1.common_pb2
import yandex.cloud.airflow.v1.maintenance_pb2
import yandex.cloud.logging.v1.log_entry_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """Apache Airflow cluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        STOPPING: Cluster._Status.ValueType  # 4
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 5
        """Cluster is stopped."""
        STARTING: Cluster._Status.ValueType  # 6
        """Cluster is starting."""
        UPDATING: Cluster._Status.ValueType  # 7
        """Cluster is being updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    STOPPING: Cluster.Status.ValueType  # 4
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 5
    """Cluster is stopped."""
    STARTING: Cluster.Status.ValueType  # 6
    """Cluster is starting."""
    UPDATING: Cluster.Status.ValueType  # 7
    """Cluster is being updated."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    CODE_SYNC_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    WEBSERVER_URL_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID of the Apache Airflow cluster.
    This ID is assigned by Cloud during cluster creation.
    """
    folder_id: builtins.str
    """ID of the folder that the Apache Airflow cluster belongs to."""
    name: builtins.str
    """Name of the Apache Airflow cluster.
    The name is unique within the folder. 1-64 characters long.
    """
    description: builtins.str
    """Description of the Apache Airflow cluster. 0-256 characters long."""
    health: yandex.cloud.airflow.v1.common_pb2.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Cluster status."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster."""
    webserver_url: builtins.str
    """Address of Apache Airflow web UI."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources.
    For more information, see [documentation](/docs/managed-airflow/concepts/impersonation).
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Apache Airflow cluster was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Monitoring systems relevant to the Apache Airflow cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of Apache Airflow components."""

    @property
    def network(self) -> global___NetworkConfig:
        """Network related configuration options."""

    @property
    def code_sync(self) -> global___CodeSyncConfig:
        """Parameters of the location and access to the code that will be executed in the cluster."""

    @property
    def logging(self) -> global___LoggingConfig:
        """Cloud Logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def planned_operation(self) -> yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation planned at nearest maintenance_window."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        health: yandex.cloud.airflow.v1.common_pb2.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        network: global___NetworkConfig | None = ...,
        code_sync: global___CodeSyncConfig | None = ...,
        deletion_protection: builtins.bool = ...,
        webserver_url: builtins.str = ...,
        service_account_id: builtins.str = ...,
        logging: global___LoggingConfig | None = ...,
        maintenance_window: yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceOperation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code_sync", b"code_sync", "config", b"config", "created_at", b"created_at", "logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["code_sync", b"code_sync", "config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network", b"network", "planned_operation", b"planned_operation", "service_account_id", b"service_account_id", "status", b"status", "webserver_url", b"webserver_url"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_ID_FIELD_NUMBER: builtins.int
    AIRFLOW_FIELD_NUMBER: builtins.int
    WEBSERVER_FIELD_NUMBER: builtins.int
    SCHEDULER_FIELD_NUMBER: builtins.int
    TRIGGERER_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    LOCKBOX_FIELD_NUMBER: builtins.int
    AIRFLOW_VERSION_FIELD_NUMBER: builtins.int
    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    version_id: builtins.str
    """Version of Apache Airflow that runs on the cluster.
    Use `airflow_version` instead.
    """
    airflow_version: builtins.str
    """Apache Airflow version. Format: "Major.Minor" """
    python_version: builtins.str
    """Python version. Format: "Major.Minor" """
    @property
    def airflow(self) -> global___AirflowConfig:
        """Configuration of the Apache Airflow application itself."""

    @property
    def webserver(self) -> global___WebserverConfig:
        """Configuration of webserver instances."""

    @property
    def scheduler(self) -> global___SchedulerConfig:
        """Configuration of scheduler instances."""

    @property
    def triggerer(self) -> global___TriggererConfig:
        """Configuration of triggerer instances."""

    @property
    def worker(self) -> global___WorkerConfig:
        """Configuration of worker instances."""

    @property
    def dependencies(self) -> global___Dependencies:
        """The list of additional packages installed in the cluster."""

    @property
    def lockbox(self) -> global___LockboxConfig:
        """Configuration of Lockbox Secret Backend."""

    def __init__(
        self,
        *,
        version_id: builtins.str = ...,
        airflow: global___AirflowConfig | None = ...,
        webserver: global___WebserverConfig | None = ...,
        scheduler: global___SchedulerConfig | None = ...,
        triggerer: global___TriggererConfig | None = ...,
        worker: global___WorkerConfig | None = ...,
        dependencies: global___Dependencies | None = ...,
        lockbox: global___LockboxConfig | None = ...,
        airflow_version: builtins.str = ...,
        python_version: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["airflow", b"airflow", "dependencies", b"dependencies", "lockbox", b"lockbox", "scheduler", b"scheduler", "triggerer", b"triggerer", "webserver", b"webserver", "worker", b"worker"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["airflow", b"airflow", "airflow_version", b"airflow_version", "dependencies", b"dependencies", "lockbox", b"lockbox", "python_version", b"python_version", "scheduler", b"scheduler", "triggerer", b"triggerer", "version_id", b"version_id", "webserver", b"webserver", "worker", b"worker"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class AirflowConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Properties to be passed to Apache Airflow configuration file."""

    def __init__(
        self,
        *,
        config: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["config", b"config"]) -> None: ...

global___AirflowConfig = AirflowConfig

@typing.final
class WebserverConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    count: builtins.int
    """The number of webserver instances in the cluster."""
    @property
    def resources(self) -> yandex.cloud.airflow.v1.common_pb2.Resources:
        """Resources allocated to webserver instances."""

    def __init__(
        self,
        *,
        count: builtins.int = ...,
        resources: yandex.cloud.airflow.v1.common_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "resources", b"resources"]) -> None: ...

global___WebserverConfig = WebserverConfig

@typing.final
class SchedulerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    count: builtins.int
    """The number of scheduler instances in the cluster."""
    @property
    def resources(self) -> yandex.cloud.airflow.v1.common_pb2.Resources:
        """Resources allocated to scheduler instances."""

    def __init__(
        self,
        *,
        count: builtins.int = ...,
        resources: yandex.cloud.airflow.v1.common_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "resources", b"resources"]) -> None: ...

global___SchedulerConfig = SchedulerConfig

@typing.final
class TriggererConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    count: builtins.int
    """The number of triggerer instances in the cluster."""
    @property
    def resources(self) -> yandex.cloud.airflow.v1.common_pb2.Resources:
        """Resources allocated to triggerer instances."""

    def __init__(
        self,
        *,
        count: builtins.int = ...,
        resources: yandex.cloud.airflow.v1.common_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "resources", b"resources"]) -> None: ...

global___TriggererConfig = TriggererConfig

@typing.final
class WorkerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_COUNT_FIELD_NUMBER: builtins.int
    MAX_COUNT_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    min_count: builtins.int
    """The minimum number of worker instances in the cluster."""
    max_count: builtins.int
    """The maximum number of worker instances in the cluster."""
    @property
    def resources(self) -> yandex.cloud.airflow.v1.common_pb2.Resources:
        """Resources allocated to worker instances."""

    def __init__(
        self,
        *,
        min_count: builtins.int = ...,
        max_count: builtins.int = ...,
        resources: yandex.cloud.airflow.v1.common_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["max_count", b"max_count", "min_count", b"min_count", "resources", b"resources"]) -> None: ...

global___WorkerConfig = WorkerConfig

@typing.final
class Dependencies(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIP_PACKAGES_FIELD_NUMBER: builtins.int
    DEB_PACKAGES_FIELD_NUMBER: builtins.int
    @property
    def pip_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Python packages that are installed in the cluster."""

    @property
    def deb_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """System packages that are installed in the cluster."""

    def __init__(
        self,
        *,
        pip_packages: collections.abc.Iterable[builtins.str] | None = ...,
        deb_packages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deb_packages", b"deb_packages", "pip_packages", b"pip_packages"]) -> None: ...

global___Dependencies = Dependencies

@typing.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBNET_IDS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of VPC network subnets where instances of the cluster are attached."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkConfig = NetworkConfig

@typing.final
class S3Config(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_FIELD_NUMBER: builtins.int
    bucket: builtins.str
    """The name of the Object Storage bucket that stores DAG files used in the cluster."""
    def __init__(
        self,
        *,
        bucket: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket"]) -> None: ...

global___S3Config = S3Config

@typing.final
class GitSyncConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPO_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    SUB_PATH_FIELD_NUMBER: builtins.int
    SSH_KEY_FIELD_NUMBER: builtins.int
    repo: builtins.str
    """Git repository URL."""
    branch: builtins.str
    """Git branch name to sync from."""
    sub_path: builtins.str
    """Subdirectory path within the repository containing DAG files."""
    ssh_key: builtins.str
    """SSH private key for repository authentication."""
    def __init__(
        self,
        *,
        repo: builtins.str = ...,
        branch: builtins.str = ...,
        sub_path: builtins.str = ...,
        ssh_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["branch", b"branch", "repo", b"repo", "ssh_key", b"ssh_key", "sub_path", b"sub_path"]) -> None: ...

global___GitSyncConfig = GitSyncConfig

@typing.final
class CodeSyncConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    S3_FIELD_NUMBER: builtins.int
    GIT_SYNC_FIELD_NUMBER: builtins.int
    @property
    def s3(self) -> global___S3Config: ...
    @property
    def git_sync(self) -> global___GitSyncConfig: ...
    def __init__(
        self,
        *,
        s3: global___S3Config | None = ...,
        git_sync: global___GitSyncConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["git_sync", b"git_sync", "s3", b"s3", "source", b"source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["git_sync", b"git_sync", "s3", b"s3", "source", b"source"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["s3", "git_sync"] | None: ...

global___CodeSyncConfig = CodeSyncConfig

@typing.final
class LoggingConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Logs generated by the Airflow components are delivered to Cloud Logging."""
    folder_id: builtins.str
    """Logs should be written to default log group for specified folder."""
    log_group_id: builtins.str
    """Logs should be written to log group resolved by ID."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum log entry level.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        folder_id: builtins.str = ...,
        log_group_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "enabled", b"enabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["folder_id", "log_group_id"] | None: ...

global___LoggingConfig = LoggingConfig

@typing.final
class LockboxConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """The setting allows to enable Lockbox Secret Backend."""
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enabled", b"enabled"]) -> None: ...

global___LockboxConfig = LockboxConfig
