"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.apploadbalancer.v1.payload_pb2
import yandex.cloud.apploadbalancer.v1.tls_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LoadBalancingMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LoadBalancingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LoadBalancingMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ROUND_ROBIN: _LoadBalancingMode.ValueType  # 0
    """Round robin load balancing mode.

    All endpoints of the backend take their turns to receive requests attributed to the backend.
    """
    RANDOM: _LoadBalancingMode.ValueType  # 1
    """Random load balancing mode. Default value.

    For a request attributed to the backend, an endpoint that receives it is picked at random.
    """
    LEAST_REQUEST: _LoadBalancingMode.ValueType  # 2
    """Least request load balancing mode.

    To pick an endpoint that receives a request attributed to the backend, the power of two choices algorithm is used;
    that is, two endpoints are picked at random, and the request is sent to the one which has the fewest active
    requests.
    """
    MAGLEV_HASH: _LoadBalancingMode.ValueType  # 3
    """Maglev hashing load balancing mode.

    Each endpoint is hashed, and a hash table with 65537 rows is filled accordingly, so that every endpoint occupies
    the same amount of rows. An attribute of each request is also hashed by the same function (if session affinity is
    enabled for the backend group, the attribute to hash is specified in session affinity configuration). The row
    with the same number as the resulting value is looked up in the table to determine the endpoint that receives
    the request.

    If the backend group with session affinity enabled contains more than one backend with positive weight, endpoints
    for backends with `MAGLEV_HASH` load balancing mode are picked at `RANDOM` instead.
    """

class LoadBalancingMode(_LoadBalancingMode, metaclass=_LoadBalancingModeEnumTypeWrapper):
    """A load balancing mode resource.
    For details about the concept, see
    [documentation](/docs/application-load-balancer/concepts/backend-group#balancing-mode).
    """

ROUND_ROBIN: LoadBalancingMode.ValueType  # 0
"""Round robin load balancing mode.

All endpoints of the backend take their turns to receive requests attributed to the backend.
"""
RANDOM: LoadBalancingMode.ValueType  # 1
"""Random load balancing mode. Default value.

For a request attributed to the backend, an endpoint that receives it is picked at random.
"""
LEAST_REQUEST: LoadBalancingMode.ValueType  # 2
"""Least request load balancing mode.

To pick an endpoint that receives a request attributed to the backend, the power of two choices algorithm is used;
that is, two endpoints are picked at random, and the request is sent to the one which has the fewest active
requests.
"""
MAGLEV_HASH: LoadBalancingMode.ValueType  # 3
"""Maglev hashing load balancing mode.

Each endpoint is hashed, and a hash table with 65537 rows is filled accordingly, so that every endpoint occupies
the same amount of rows. An attribute of each request is also hashed by the same function (if session affinity is
enabled for the backend group, the attribute to hash is specified in session affinity configuration). The row
with the same number as the resulting value is looked up in the table to determine the endpoint that receives
the request.

If the backend group with session affinity enabled contains more than one backend with positive weight, endpoints
for backends with `MAGLEV_HASH` load balancing mode are picked at `RANDOM` instead.
"""
global___LoadBalancingMode = LoadBalancingMode

@typing.final
class BackendGroup(google.protobuf.message.Message):
    """A backend group resource.
    For details about the concept, see [documentation](/docs/application-load-balancer/concepts/backend-group).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    HTTP_FIELD_NUMBER: builtins.int
    GRPC_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the backend group. Generated at creation time."""
    name: builtins.str
    """Name of the backend group. The name is unique within the folder. The string length in characters is 3-63."""
    description: builtins.str
    """Description of the backend group. The string is 0-256 characters long."""
    folder_id: builtins.str
    """ID of the folder that the backend group belongs to."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Backend group labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
        The maximum number of labels is 64.
        """

    @property
    def http(self) -> global___HttpBackendGroup:
        """List of HTTP backends that the backend group consists of."""

    @property
    def grpc(self) -> global___GrpcBackendGroup:
        """List of gRPC backends that the backend group consists of."""

    @property
    def stream(self) -> global___StreamBackendGroup:
        """List of stream (TCP) backends that the backend group consists of."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        folder_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        http: global___HttpBackendGroup | None = ...,
        grpc: global___GrpcBackendGroup | None = ...,
        stream: global___StreamBackendGroup | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backend", b"backend", "created_at", b"created_at", "grpc", b"grpc", "http", b"http", "stream", b"stream"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backend", b"backend", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "grpc", b"grpc", "http", b"http", "id", b"id", "labels", b"labels", "name", b"name", "stream", b"stream"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["backend", b"backend"]) -> typing.Literal["http", "grpc", "stream"] | None: ...

global___BackendGroup = BackendGroup

@typing.final
class StreamBackendGroup(google.protobuf.message.Message):
    """A stream (TCP) backend group resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKENDS_FIELD_NUMBER: builtins.int
    CONNECTION_FIELD_NUMBER: builtins.int
    @property
    def backends(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StreamBackend]:
        """List of stream (TCP) backends."""

    @property
    def connection(self) -> global___ConnectionSessionAffinity:
        """Connection-based session affinity configuration.

        For now, a connection is defined only by an IP address of the client.
        """

    def __init__(
        self,
        *,
        backends: collections.abc.Iterable[global___StreamBackend] | None = ...,
        connection: global___ConnectionSessionAffinity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection", "session_affinity", b"session_affinity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backends", b"backends", "connection", b"connection", "session_affinity", b"session_affinity"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["session_affinity", b"session_affinity"]) -> typing.Literal["connection"] | None: ...

global___StreamBackendGroup = StreamBackendGroup

@typing.final
class HttpBackendGroup(google.protobuf.message.Message):
    """An HTTP backend group resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKENDS_FIELD_NUMBER: builtins.int
    CONNECTION_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    COOKIE_FIELD_NUMBER: builtins.int
    @property
    def backends(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HttpBackend]:
        """List of HTTP backends."""

    @property
    def connection(self) -> global___ConnectionSessionAffinity:
        """Connection-based session affinity configuration.

        For now, a connection is defined only by an IP address of the client.
        """

    @property
    def header(self) -> global___HeaderSessionAffinity:
        """HTTP-header-field-based session affinity configuration."""

    @property
    def cookie(self) -> global___CookieSessionAffinity:
        """Cookie-based session affinity configuration."""

    def __init__(
        self,
        *,
        backends: collections.abc.Iterable[global___HttpBackend] | None = ...,
        connection: global___ConnectionSessionAffinity | None = ...,
        header: global___HeaderSessionAffinity | None = ...,
        cookie: global___CookieSessionAffinity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection", "cookie", b"cookie", "header", b"header", "session_affinity", b"session_affinity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backends", b"backends", "connection", b"connection", "cookie", b"cookie", "header", b"header", "session_affinity", b"session_affinity"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["session_affinity", b"session_affinity"]) -> typing.Literal["connection", "header", "cookie"] | None: ...

global___HttpBackendGroup = HttpBackendGroup

@typing.final
class GrpcBackendGroup(google.protobuf.message.Message):
    """A gRPC backend group resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKENDS_FIELD_NUMBER: builtins.int
    CONNECTION_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    COOKIE_FIELD_NUMBER: builtins.int
    @property
    def backends(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GrpcBackend]:
        """List of gRPC backends."""

    @property
    def connection(self) -> global___ConnectionSessionAffinity:
        """Connection-based session affinity configuration.

        For now, a connection is defined only by an IP address of the client.
        """

    @property
    def header(self) -> global___HeaderSessionAffinity:
        """HTTP-header-field-based session affinity configuration."""

    @property
    def cookie(self) -> global___CookieSessionAffinity:
        """Cookie-based session affinity configuration."""

    def __init__(
        self,
        *,
        backends: collections.abc.Iterable[global___GrpcBackend] | None = ...,
        connection: global___ConnectionSessionAffinity | None = ...,
        header: global___HeaderSessionAffinity | None = ...,
        cookie: global___CookieSessionAffinity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection", "cookie", b"cookie", "header", b"header", "session_affinity", b"session_affinity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backends", b"backends", "connection", b"connection", "cookie", b"cookie", "header", b"header", "session_affinity", b"session_affinity"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["session_affinity", b"session_affinity"]) -> typing.Literal["connection", "header", "cookie"] | None: ...

global___GrpcBackendGroup = GrpcBackendGroup

@typing.final
class HeaderSessionAffinity(google.protobuf.message.Message):
    """A resource for HTTP-header-field-based session affinity configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEADER_NAME_FIELD_NUMBER: builtins.int
    header_name: builtins.str
    """Name of the HTTP header field that is used for session affinity."""
    def __init__(
        self,
        *,
        header_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["header_name", b"header_name"]) -> None: ...

global___HeaderSessionAffinity = HeaderSessionAffinity

@typing.final
class CookieSessionAffinity(google.protobuf.message.Message):
    """A resource for cookie-based session affinity configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the cookie that is used for session affinity."""
    @property
    def ttl(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum age of cookies that are generated for sessions.

        If set to `0`, session cookies are used, which are stored by clients in temporary memory and are deleted
        on client restarts.

        If not set, the balancer does not generate cookies and only uses incoming ones for establishing session affinity.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        ttl: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ttl", b"ttl"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "ttl", b"ttl"]) -> None: ...

global___CookieSessionAffinity = CookieSessionAffinity

@typing.final
class ConnectionSessionAffinity(google.protobuf.message.Message):
    """A resource for connection-based session affinity configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_IP_FIELD_NUMBER: builtins.int
    source_ip: builtins.bool
    """Specifies whether an IP address of the client is used to define a connection for session affinity."""
    def __init__(
        self,
        *,
        source_ip: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["source_ip", b"source_ip"]) -> None: ...

global___ConnectionSessionAffinity = ConnectionSessionAffinity

@typing.final
class LoadBalancingConfig(google.protobuf.message.Message):
    """A load balancing configuration resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PANIC_THRESHOLD_FIELD_NUMBER: builtins.int
    LOCALITY_AWARE_ROUTING_PERCENT_FIELD_NUMBER: builtins.int
    STRICT_LOCALITY_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    panic_threshold: builtins.int
    """Threshold for panic mode.

    If percentage of healthy backends in the group drops below threshold,
    panic mode will be activated and traffic will be routed to all backends, regardless of their health check status.
    This helps to avoid overloading healthy backends.
    For details about panic mode, see [documentation](/docs/application-load-balancer/concepts/backend-group#panic-mode).

    If the value is `0`, panic mode will never be activated and traffic is routed only to healthy backends at all times.

    Default value: `0`.
    """
    locality_aware_routing_percent: builtins.int
    """Percentage of traffic that a load balancer node sends to healthy backends in its availability zone.
    The rest is divided equally between other zones. For details about zone-aware routing, see
    [documentation](/docs/application-load-balancer/concepts/backend-group#locality).

    If there are no healthy backends in an availability zone, all the traffic is divided between other zones.

    If [strict_locality] is `true`, the specified value is ignored.
    A load balancer node sends all the traffic within its availability zone, regardless of backends' health.

    Default value: `0`.
    """
    strict_locality: builtins.bool
    """Specifies whether a load balancer node should only send traffic to backends in its availability zone,
    regardless of their health, and ignore backends in other zones.

    If set to `true` and there are no healthy backends in the zone, the node in this zone will respond
    to incoming traffic with errors.
    For details about strict locality, see [documentation](/docs/application-load-balancer/concepts/backend-group#locality).

    If `strict_locality` is `true`, the value specified in [locality_aware_routing_percent] is ignored.

    Default value: `false`.
    """
    mode: global___LoadBalancingMode.ValueType
    """Load balancing mode for the backend.

    For details about load balancing modes, see
    [documentation](/docs/application-load-balancer/concepts/backend-group#balancing-mode).
    """
    def __init__(
        self,
        *,
        panic_threshold: builtins.int = ...,
        locality_aware_routing_percent: builtins.int = ...,
        strict_locality: builtins.bool = ...,
        mode: global___LoadBalancingMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["locality_aware_routing_percent", b"locality_aware_routing_percent", "mode", b"mode", "panic_threshold", b"panic_threshold", "strict_locality", b"strict_locality"]) -> None: ...

global___LoadBalancingConfig = LoadBalancingConfig

@typing.final
class StreamBackend(google.protobuf.message.Message):
    """A stream (TCP) backend resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BACKEND_WEIGHT_FIELD_NUMBER: builtins.int
    LOAD_BALANCING_CONFIG_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    TARGET_GROUPS_FIELD_NUMBER: builtins.int
    HEALTHCHECKS_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    ENABLE_PROXY_PROTOCOL_FIELD_NUMBER: builtins.int
    KEEP_CONNECTIONS_ON_HOST_HEALTH_FAILURE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the backend."""
    port: builtins.int
    """Port used by all targets to receive traffic."""
    enable_proxy_protocol: builtins.bool
    """If set, proxy protocol will be enabled for this backend."""
    keep_connections_on_host_health_failure: builtins.bool
    """If a backend host becomes unhealthy (as determined by the configured health checks),
    keep connections to the failed host.
    """
    @property
    def backend_weight(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Backend weight. Traffic is distributed between backends of a backend group according to their weights.

        Weights must be set either for all backends in a group or for none of them.
        Setting no weights is the same as setting equal non-zero weights for all backends.

        If the weight is non-positive, traffic is not sent to the backend.
        """

    @property
    def load_balancing_config(self) -> global___LoadBalancingConfig:
        """Load balancing configuration for the backend."""

    @property
    def target_groups(self) -> global___TargetGroupsBackend:
        """Target groups that belong to the backend. For details about target groups, see
        [documentation](/docs/application-load-balancer/concepts/target-group).
        """

    @property
    def healthchecks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HealthCheck]:
        """Health checks to perform on targets from target groups.
        For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).

        If no health checks are specified, active health checking is not performed.
        """

    @property
    def tls(self) -> global___BackendTls:
        """Settings for TLS connections between load balancer nodes and backend targets.

        If specified, the load balancer establishes TLS-encrypted TCP connections with targets and compares received
        certificates with the one specified in [BackendTls.validation_context].
        If not specified, the load balancer establishes unencrypted TCP connections with targets.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        backend_weight: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        load_balancing_config: global___LoadBalancingConfig | None = ...,
        port: builtins.int = ...,
        target_groups: global___TargetGroupsBackend | None = ...,
        healthchecks: collections.abc.Iterable[global___HealthCheck] | None = ...,
        tls: global___BackendTls | None = ...,
        enable_proxy_protocol: builtins.bool = ...,
        keep_connections_on_host_health_failure: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "load_balancing_config", b"load_balancing_config", "target_groups", b"target_groups", "tls", b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "enable_proxy_protocol", b"enable_proxy_protocol", "healthchecks", b"healthchecks", "keep_connections_on_host_health_failure", b"keep_connections_on_host_health_failure", "load_balancing_config", b"load_balancing_config", "name", b"name", "port", b"port", "target_groups", b"target_groups", "tls", b"tls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["backend_type", b"backend_type"]) -> typing.Literal["target_groups"] | None: ...

global___StreamBackend = StreamBackend

@typing.final
class HttpBackend(google.protobuf.message.Message):
    """An HTTP backend resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BACKEND_WEIGHT_FIELD_NUMBER: builtins.int
    LOAD_BALANCING_CONFIG_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    TARGET_GROUPS_FIELD_NUMBER: builtins.int
    STORAGE_BUCKET_FIELD_NUMBER: builtins.int
    HEALTHCHECKS_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    USE_HTTP2_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the backend."""
    port: builtins.int
    """Port used by all targets to receive traffic."""
    use_http2: builtins.bool
    """Enables HTTP/2 usage in connections between load balancer nodes and backend targets.

    Default value: `false`, HTTP/1.1 is used.
    """
    @property
    def backend_weight(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Backend weight. Traffic is distributed between backends of a backend group according to their weights.

        Weights must be set either for all backends in a group or for none of them.
        Setting no weights is the same as setting equal non-zero weights for all backends.

        If the weight is non-positive, traffic is not sent to the backend.
        """

    @property
    def load_balancing_config(self) -> global___LoadBalancingConfig:
        """Load balancing configuration for the backend."""

    @property
    def target_groups(self) -> global___TargetGroupsBackend:
        """Target groups that belong to the backend. For details about target groups, see
        [documentation](/docs/application-load-balancer/concepts/target-group).
        """

    @property
    def storage_bucket(self) -> global___StorageBucketBackend:
        """Object Storage bucket to use as the backend. For details about buckets, see
        [documentation](/docs/storage/concepts/bucket).

        If a bucket is used as a backend, the list of bucket objects and the objects themselves must be publicly
        accessible. For instructions, see [documentation](/docs/storage/operations/buckets/bucket-availability).
        """

    @property
    def healthchecks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HealthCheck]:
        """Health checks to perform on targets from target groups.
        For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).

        If no health checks are specified, active health checking is not performed.
        """

    @property
    def tls(self) -> global___BackendTls:
        """Settings for TLS connections between load balancer nodes and backend targets.

        If specified, the load balancer establishes HTTPS (HTTP over TLS) connections with targets
        and compares received certificates with the one specified in [BackendTls.validation_context].
        If not specified, the load balancer establishes unencrypted HTTP connections with targets.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        backend_weight: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        load_balancing_config: global___LoadBalancingConfig | None = ...,
        port: builtins.int = ...,
        target_groups: global___TargetGroupsBackend | None = ...,
        storage_bucket: global___StorageBucketBackend | None = ...,
        healthchecks: collections.abc.Iterable[global___HealthCheck] | None = ...,
        tls: global___BackendTls | None = ...,
        use_http2: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "load_balancing_config", b"load_balancing_config", "storage_bucket", b"storage_bucket", "target_groups", b"target_groups", "tls", b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "healthchecks", b"healthchecks", "load_balancing_config", b"load_balancing_config", "name", b"name", "port", b"port", "storage_bucket", b"storage_bucket", "target_groups", b"target_groups", "tls", b"tls", "use_http2", b"use_http2"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["backend_type", b"backend_type"]) -> typing.Literal["target_groups", "storage_bucket"] | None: ...

global___HttpBackend = HttpBackend

@typing.final
class GrpcBackend(google.protobuf.message.Message):
    """A gRPC backend resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BACKEND_WEIGHT_FIELD_NUMBER: builtins.int
    LOAD_BALANCING_CONFIG_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    TARGET_GROUPS_FIELD_NUMBER: builtins.int
    HEALTHCHECKS_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the backend."""
    port: builtins.int
    """Port used by all targets to receive traffic."""
    @property
    def backend_weight(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Backend weight. Traffic is distributed between backends of a backend group according to their weights.

        Weights must be set either for all backends of a group or for none of them.
        Setting no weights is the same as setting equal non-zero weights for all backends.

        If the weight is non-positive, traffic is not sent to the backend.
        """

    @property
    def load_balancing_config(self) -> global___LoadBalancingConfig:
        """Load balancing configuration for the backend."""

    @property
    def target_groups(self) -> global___TargetGroupsBackend:
        """Target groups that belong to the backend."""

    @property
    def healthchecks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HealthCheck]:
        """Health checks to perform on targets from target groups.
        For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).

        If no health checks are specified, active health checking is not performed.
        """

    @property
    def tls(self) -> global___BackendTls:
        """Settings for TLS connections between load balancer nodes and backend targets.

        If specified, the load balancer establishes HTTPS (HTTP over TLS) connections with targets
        and compares received certificates with the one specified in [BackendTls.validation_context].
        If not specified, the load balancer establishes unencrypted HTTP connections with targets.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        backend_weight: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        load_balancing_config: global___LoadBalancingConfig | None = ...,
        port: builtins.int = ...,
        target_groups: global___TargetGroupsBackend | None = ...,
        healthchecks: collections.abc.Iterable[global___HealthCheck] | None = ...,
        tls: global___BackendTls | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "load_balancing_config", b"load_balancing_config", "target_groups", b"target_groups", "tls", b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backend_type", b"backend_type", "backend_weight", b"backend_weight", "healthchecks", b"healthchecks", "load_balancing_config", b"load_balancing_config", "name", b"name", "port", b"port", "target_groups", b"target_groups", "tls", b"tls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["backend_type", b"backend_type"]) -> typing.Literal["target_groups"] | None: ...

global___GrpcBackend = GrpcBackend

@typing.final
class TargetGroupsBackend(google.protobuf.message.Message):
    """A resource for target groups that belong to the backend."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def target_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of ID's of target groups that belong to the backend.

        To get the ID's of all available target groups, make a [TargetGroupService.List] request.
        """

    def __init__(
        self,
        *,
        target_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["target_group_ids", b"target_group_ids"]) -> None: ...

global___TargetGroupsBackend = TargetGroupsBackend

@typing.final
class PlaintextTransportSettings(google.protobuf.message.Message):
    """Transport settings to be used instead of the settings configured per-cluster"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PlaintextTransportSettings = PlaintextTransportSettings

@typing.final
class SecureTransportSettings(google.protobuf.message.Message):
    """Transport settings to be used instead of the settings configured per-cluster"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNI_FIELD_NUMBER: builtins.int
    VALIDATION_CONTEXT_FIELD_NUMBER: builtins.int
    sni: builtins.str
    """SNI string for TLS connections."""
    @property
    def validation_context(self) -> yandex.cloud.apploadbalancer.v1.tls_pb2.ValidationContext:
        """Validation context for backend TLS connections."""

    def __init__(
        self,
        *,
        sni: builtins.str = ...,
        validation_context: yandex.cloud.apploadbalancer.v1.tls_pb2.ValidationContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["validation_context", b"validation_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["sni", b"sni", "validation_context", b"validation_context"]) -> None: ...

global___SecureTransportSettings = SecureTransportSettings

@typing.final
class BackendTls(google.protobuf.message.Message):
    """A resource for backend TLS settings."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNI_FIELD_NUMBER: builtins.int
    VALIDATION_CONTEXT_FIELD_NUMBER: builtins.int
    sni: builtins.str
    """Server Name Indication (SNI) string for TLS connections."""
    @property
    def validation_context(self) -> yandex.cloud.apploadbalancer.v1.tls_pb2.ValidationContext:
        """Validation context for TLS connections."""

    def __init__(
        self,
        *,
        sni: builtins.str = ...,
        validation_context: yandex.cloud.apploadbalancer.v1.tls_pb2.ValidationContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["validation_context", b"validation_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["sni", b"sni", "validation_context", b"validation_context"]) -> None: ...

global___BackendTls = BackendTls

@typing.final
class StorageBucketBackend(google.protobuf.message.Message):
    """A resource for Object Storage bucket used as a backend. For details about the concept,
    see [documentation](/docs/storage/concepts/bucket).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_FIELD_NUMBER: builtins.int
    bucket: builtins.str
    """Name of the bucket."""
    def __init__(
        self,
        *,
        bucket: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket"]) -> None: ...

global___StorageBucketBackend = StorageBucketBackend

@typing.final
class HealthCheck(google.protobuf.message.Message):
    """A health check resource.
    For details about the concept, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class StreamHealthCheck(google.protobuf.message.Message):
        """A resource for TCP stream health check settings."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SEND_FIELD_NUMBER: builtins.int
        RECEIVE_FIELD_NUMBER: builtins.int
        @property
        def send(self) -> yandex.cloud.apploadbalancer.v1.payload_pb2.Payload:
            """Message sent to targets during TCP data transfer.

            If not specified, no data is sent to the target.
            """

        @property
        def receive(self) -> yandex.cloud.apploadbalancer.v1.payload_pb2.Payload:
            """Data that must be contained in the messages received from targets for a successful health check.

            If not specified, no messages are expected from targets, and those that are received are not checked.
            """

        def __init__(
            self,
            *,
            send: yandex.cloud.apploadbalancer.v1.payload_pb2.Payload | None = ...,
            receive: yandex.cloud.apploadbalancer.v1.payload_pb2.Payload | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["receive", b"receive", "send", b"send"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["receive", b"receive", "send", b"send"]) -> None: ...

    @typing.final
    class HttpHealthCheck(google.protobuf.message.Message):
        """A resource for HTTP health check settings."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOST_FIELD_NUMBER: builtins.int
        PATH_FIELD_NUMBER: builtins.int
        USE_HTTP2_FIELD_NUMBER: builtins.int
        EXPECTED_STATUSES_FIELD_NUMBER: builtins.int
        host: builtins.str
        """Value for the HTTP/1.1 `Host` header or the HTTP/2 `:authority` pseudo-header used in requests to targets."""
        path: builtins.str
        """HTTP path used in requests to targets: request URI for HTTP/1.1 request line
        or value for the HTTP/2 `:path` pseudo-header.
        """
        use_http2: builtins.bool
        """Enables HTTP/2 usage in health checks.

        Default value: `false`, HTTP/1.1 is used.
        """
        @property
        def expected_statuses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """A list of HTTP response statuses considered healthy.
            By default only 200 HTTP status code considered healthy.
            """

        def __init__(
            self,
            *,
            host: builtins.str = ...,
            path: builtins.str = ...,
            use_http2: builtins.bool = ...,
            expected_statuses: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["expected_statuses", b"expected_statuses", "host", b"host", "path", b"path", "use_http2", b"use_http2"]) -> None: ...

    @typing.final
    class GrpcHealthCheck(google.protobuf.message.Message):
        """A resource for gRPC health check settings."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SERVICE_NAME_FIELD_NUMBER: builtins.int
        service_name: builtins.str
        """Name of the gRPC service to be checked.

        If not specified, overall health is checked.

        For details about the concept, see [GRPC Health Checking Protocol](https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        """
        def __init__(
            self,
            *,
            service_name: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["service_name", b"service_name"]) -> None: ...

    TIMEOUT_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    INTERVAL_JITTER_PERCENT_FIELD_NUMBER: builtins.int
    HEALTHY_THRESHOLD_FIELD_NUMBER: builtins.int
    UNHEALTHY_THRESHOLD_FIELD_NUMBER: builtins.int
    HEALTHCHECK_PORT_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    HTTP_FIELD_NUMBER: builtins.int
    GRPC_FIELD_NUMBER: builtins.int
    PLAINTEXT_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    interval_jitter_percent: builtins.float
    healthy_threshold: builtins.int
    """Number of consecutive successful health checks required to mark an unhealthy target as healthy.

    Both `0` and `1` values amount to one successful check required.

    The value is ignored when a load balancer is initialized; a target is marked healthy after one successful check.

    Default value: `0`.
    """
    unhealthy_threshold: builtins.int
    """Number of consecutive failed health checks required to mark a healthy target as unhealthy.

    Both `0` and `1` values amount to one unsuccessful check required.

    The value is ignored if a health check is failed due to an HTTP `503 Service Unavailable` response from the target
    (not applicable to TCP stream health checks). The target is immediately marked unhealthy.

    Default value: `0`.
    """
    healthcheck_port: builtins.int
    """Port used for health checks.

    If not specified, the backend port ([HttpBackend.port] or [GrpcBackend.port]) is used for health checks.
    """
    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Health check timeout.

        The timeout is the time allowed for the target to respond to a check.
        If the target doesn't respond in time, the check is considered failed.
        """

    @property
    def interval(self) -> google.protobuf.duration_pb2.Duration:
        """Base interval between consecutive health checks."""

    @property
    def stream(self) -> global___HealthCheck.StreamHealthCheck:
        """TCP stream health check settings."""

    @property
    def http(self) -> global___HealthCheck.HttpHealthCheck:
        """HTTP health check settings."""

    @property
    def grpc(self) -> global___HealthCheck.GrpcHealthCheck:
        """gRPC health check settings."""

    @property
    def plaintext(self) -> global___PlaintextTransportSettings: ...
    @property
    def tls(self) -> global___SecureTransportSettings: ...
    def __init__(
        self,
        *,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
        interval: google.protobuf.duration_pb2.Duration | None = ...,
        interval_jitter_percent: builtins.float = ...,
        healthy_threshold: builtins.int = ...,
        unhealthy_threshold: builtins.int = ...,
        healthcheck_port: builtins.int = ...,
        stream: global___HealthCheck.StreamHealthCheck | None = ...,
        http: global___HealthCheck.HttpHealthCheck | None = ...,
        grpc: global___HealthCheck.GrpcHealthCheck | None = ...,
        plaintext: global___PlaintextTransportSettings | None = ...,
        tls: global___SecureTransportSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["grpc", b"grpc", "healthcheck", b"healthcheck", "http", b"http", "interval", b"interval", "plaintext", b"plaintext", "stream", b"stream", "timeout", b"timeout", "tls", b"tls", "transport_settings", b"transport_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["grpc", b"grpc", "healthcheck", b"healthcheck", "healthcheck_port", b"healthcheck_port", "healthy_threshold", b"healthy_threshold", "http", b"http", "interval", b"interval", "interval_jitter_percent", b"interval_jitter_percent", "plaintext", b"plaintext", "stream", b"stream", "timeout", b"timeout", "tls", b"tls", "transport_settings", b"transport_settings", "unhealthy_threshold", b"unhealthy_threshold"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["healthcheck", b"healthcheck"]) -> typing.Literal["stream", "http", "grpc"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["transport_settings", b"transport_settings"]) -> typing.Literal["plaintext", "tls"] | None: ...

global___HealthCheck = HealthCheck
