"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.apploadbalancer.v1.logging_pb2
import yandex.cloud.apploadbalancer.v1.target_group_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class LoadBalancer(google.protobuf.message.Message):
    """An application load balancer resource.
    For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LoadBalancer._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: LoadBalancer._Status.ValueType  # 0
        CREATING: LoadBalancer._Status.ValueType  # 1
        """The application load balancer is being created."""
        STARTING: LoadBalancer._Status.ValueType  # 2
        """The application load balancer is being started."""
        ACTIVE: LoadBalancer._Status.ValueType  # 3
        """The application load balancer is active and sends traffic to the targets."""
        STOPPING: LoadBalancer._Status.ValueType  # 4
        """The application load balancer is being stopped."""
        STOPPED: LoadBalancer._Status.ValueType  # 5
        """The application load balancer is stopped and doesn't send traffic to the targets."""
        DELETING: LoadBalancer._Status.ValueType  # 6
        """The application load balancer is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: LoadBalancer.Status.ValueType  # 0
    CREATING: LoadBalancer.Status.ValueType  # 1
    """The application load balancer is being created."""
    STARTING: LoadBalancer.Status.ValueType  # 2
    """The application load balancer is being started."""
    ACTIVE: LoadBalancer.Status.ValueType  # 3
    """The application load balancer is active and sends traffic to the targets."""
    STOPPING: LoadBalancer.Status.ValueType  # 4
    """The application load balancer is being stopped."""
    STOPPED: LoadBalancer.Status.ValueType  # 5
    """The application load balancer is stopped and doesn't send traffic to the targets."""
    DELETING: LoadBalancer.Status.ValueType  # 6
    """The application load balancer is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    REGION_ID_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    LISTENERS_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    AUTO_SCALE_POLICY_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    ALLOW_ZONAL_SHIFT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the application load balancer. Generated at creation time."""
    name: builtins.str
    """Name of the application load balancer. The name is unique within the folder."""
    description: builtins.str
    """Description of the application load balancer."""
    folder_id: builtins.str
    """ID of the folder that the application load balancer belongs to."""
    status: global___LoadBalancer.Status.ValueType
    """Status of the application load balancer."""
    region_id: builtins.str
    """ID of the region that the application load balancer is located at."""
    network_id: builtins.str
    """ID of the network that the application load balancer belongs to."""
    log_group_id: builtins.str
    """ID of the log group that stores access logs of the application load balancer.

    The logs can be accessed using a Cloud Functions [trigger for Cloud Logs](/docs/functions/operations/trigger/cloud-logging-trigger-create).
    """
    allow_zonal_shift: builtins.bool
    """Specifies whether application load balancer is available to zonal shift."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Application load balancer labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
        """

    @property
    def listeners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Listener]:
        """Listeners that belong to the application load balancer.

        For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
        """

    @property
    def allocation_policy(self) -> global___AllocationPolicy:
        """Locality settings of the application load balancer.

        For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
        """

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of the security groups attributed to the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#security-groups).
        """

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def auto_scale_policy(self) -> global___AutoScalePolicy:
        """Scaling settings of the application load balancer.

        The scaling settings relate to a special internal instance group which facilitates the balancer's work.
        Instances in this group are called _resource units_. The group is scaled automatically based on incoming load
        and within limitations specified in these settings.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lcu-scaling).
        """

    @property
    def log_options(self) -> yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions:
        """Cloud logging settings of the application load balancer."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        folder_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___LoadBalancer.Status.ValueType = ...,
        region_id: builtins.str = ...,
        network_id: builtins.str = ...,
        listeners: collections.abc.Iterable[global___Listener] | None = ...,
        allocation_policy: global___AllocationPolicy | None = ...,
        log_group_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        auto_scale_policy: global___AutoScalePolicy | None = ...,
        log_options: yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions | None = ...,
        allow_zonal_shift: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "auto_scale_policy", b"auto_scale_policy", "created_at", b"created_at", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "allow_zonal_shift", b"allow_zonal_shift", "auto_scale_policy", b"auto_scale_policy", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "listeners", b"listeners", "log_group_id", b"log_group_id", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "region_id", b"region_id", "security_group_ids", b"security_group_ids", "status", b"status"]) -> None: ...

global___LoadBalancer = LoadBalancer

@typing.final
class Address(google.protobuf.message.Message):
    """An endpoint address resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERNAL_IPV4_ADDRESS_FIELD_NUMBER: builtins.int
    INTERNAL_IPV4_ADDRESS_FIELD_NUMBER: builtins.int
    EXTERNAL_IPV6_ADDRESS_FIELD_NUMBER: builtins.int
    @property
    def external_ipv4_address(self) -> global___ExternalIpv4Address:
        """Public IPv4 endpoint address."""

    @property
    def internal_ipv4_address(self) -> global___InternalIpv4Address:
        """Internal IPv4 endpoint address.

        To enable the use of listeners with internal addresses, [contact support](/docs/support/overview#response-time).
        """

    @property
    def external_ipv6_address(self) -> global___ExternalIpv6Address:
        """Public IPv6 endpoint address."""

    def __init__(
        self,
        *,
        external_ipv4_address: global___ExternalIpv4Address | None = ...,
        internal_ipv4_address: global___InternalIpv4Address | None = ...,
        external_ipv6_address: global___ExternalIpv6Address | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["address", b"address", "external_ipv4_address", b"external_ipv4_address", "external_ipv6_address", b"external_ipv6_address", "internal_ipv4_address", b"internal_ipv4_address"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "external_ipv4_address", b"external_ipv4_address", "external_ipv6_address", b"external_ipv6_address", "internal_ipv4_address", b"internal_ipv4_address"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["address", b"address"]) -> typing.Literal["external_ipv4_address", "internal_ipv4_address", "external_ipv6_address"] | None: ...

global___Address = Address

@typing.final
class ExternalIpv4Address(google.protobuf.message.Message):
    """A public (external) IPv4 endpoint address resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv4 address."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address"]) -> None: ...

global___ExternalIpv4Address = ExternalIpv4Address

@typing.final
class InternalIpv4Address(google.protobuf.message.Message):
    """An internal IPv4 endpoint address resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv4 address."""
    subnet_id: builtins.str
    """ID of the subnet that the address belongs to."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
        subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "subnet_id", b"subnet_id"]) -> None: ...

global___InternalIpv4Address = InternalIpv4Address

@typing.final
class ExternalIpv6Address(google.protobuf.message.Message):
    """A public (external) IPv4 endpoint address resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv6 address."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address"]) -> None: ...

global___ExternalIpv6Address = ExternalIpv6Address

@typing.final
class Location(google.protobuf.message.Message):
    """An application load balancer location resource.

    For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_ID_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    DISABLE_TRAFFIC_FIELD_NUMBER: builtins.int
    ZONAL_SHIFT_ACTIVE_FIELD_NUMBER: builtins.int
    ZONAL_TRAFFIC_DISABLED_FIELD_NUMBER: builtins.int
    zone_id: builtins.str
    """ID of the availability zone where the application load balancer resides.

    Each availability zone can only be specified once.
    """
    subnet_id: builtins.str
    """ID of the subnet that the application load balancer belongs to."""
    disable_traffic: builtins.bool
    """Disables the load balancer node in the specified availability zone.

    Backends in the availability zone are not directly affected by this setting.
    They still may receive traffic from the load balancer nodes in other availability zones,
    subject to [LoadBalancingConfig.locality_aware_routing_percent] and [LoadBalancingConfig.strict_locality] settings.
    """
    zonal_shift_active: builtins.bool
    """Show zonal shift status for the location.
    Deprecated: use [zonal_traffic_disabled] below to track traffic status.
    """
    zonal_traffic_disabled: builtins.bool
    """Computed field: will be set to true if all traffic in zone is disabled
    either manually by user or automatically by Cloud infrastructure.
    """
    def __init__(
        self,
        *,
        zone_id: builtins.str = ...,
        subnet_id: builtins.str = ...,
        disable_traffic: builtins.bool = ...,
        zonal_shift_active: builtins.bool = ...,
        zonal_traffic_disabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disable_traffic", b"disable_traffic", "subnet_id", b"subnet_id", "zonal_shift_active", b"zonal_shift_active", "zonal_traffic_disabled", b"zonal_traffic_disabled", "zone_id", b"zone_id"]) -> None: ...

global___Location = Location

@typing.final
class AllocationPolicy(google.protobuf.message.Message):
    """A locality settings (allocation policy) resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOCATIONS_FIELD_NUMBER: builtins.int
    @property
    def locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Location]:
        """Availability zones and subnets that the application load balancer resides."""

    def __init__(
        self,
        *,
        locations: collections.abc.Iterable[global___Location] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["locations", b"locations"]) -> None: ...

global___AllocationPolicy = AllocationPolicy

@typing.final
class Listener(google.protobuf.message.Message):
    """A listener resource.

    For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    HTTP_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the listener. The name is unique within the application load balancer.
    The string length in characters is 3-63.
    """
    @property
    def endpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Endpoint]:
        """Endpoints of the listener.

        Endpoints are defined by their IP addresses and ports.
        """

    @property
    def http(self) -> global___HttpListener:
        """Unencrypted HTTP listener settings."""

    @property
    def tls(self) -> global___TlsListener:
        """TLS-encrypted HTTP or TCP stream listener settings.

        All handlers within a listener ([TlsListener.default_handler] and [TlsListener.sni_handlers]) must be of one
        type, [HttpHandler] or [StreamHandler]. Mixing HTTP and TCP stream traffic in a TLS-encrypted listener is not
        supported.
        """

    @property
    def stream(self) -> global___StreamListener:
        """Unencrypted stream (TCP) listener settings."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        endpoints: collections.abc.Iterable[global___Endpoint] | None = ...,
        http: global___HttpListener | None = ...,
        tls: global___TlsListener | None = ...,
        stream: global___StreamListener | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["http", b"http", "listener", b"listener", "stream", b"stream", "tls", b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["endpoints", b"endpoints", "http", b"http", "listener", b"listener", "name", b"name", "stream", b"stream", "tls", b"tls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["listener", b"listener"]) -> typing.Literal["http", "tls", "stream"] | None: ...

global___Listener = Listener

@typing.final
class Endpoint(google.protobuf.message.Message):
    """An endpoint resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESSES_FIELD_NUMBER: builtins.int
    PORTS_FIELD_NUMBER: builtins.int
    @property
    def addresses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Address]:
        """Endpoint public (external) and internal addresses."""

    @property
    def ports(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Endpoint ports."""

    def __init__(
        self,
        *,
        addresses: collections.abc.Iterable[global___Address] | None = ...,
        ports: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addresses", b"addresses", "ports", b"ports"]) -> None: ...

global___Endpoint = Endpoint

@typing.final
class HttpListener(google.protobuf.message.Message):
    """An HTTP listener resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HANDLER_FIELD_NUMBER: builtins.int
    REDIRECTS_FIELD_NUMBER: builtins.int
    @property
    def handler(self) -> global___HttpHandler:
        """Settings for handling HTTP requests.

        Only one of `handler` and [redirects] can be specified.
        """

    @property
    def redirects(self) -> global___Redirects:
        """Redirects settings.

        Only one of `redirects` and [handler] can be specified.
        """

    def __init__(
        self,
        *,
        handler: global___HttpHandler | None = ...,
        redirects: global___Redirects | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler", "redirects", b"redirects"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["handler", b"handler", "redirects", b"redirects"]) -> None: ...

global___HttpListener = HttpListener

@typing.final
class TlsListener(google.protobuf.message.Message):
    """TLS-encrypted (HTTP or TCP stream) listener resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEFAULT_HANDLER_FIELD_NUMBER: builtins.int
    SNI_HANDLERS_FIELD_NUMBER: builtins.int
    @property
    def default_handler(self) -> global___TlsHandler:
        """Settings for handling requests by default, with Server Name
        Indication (SNI) not matching any of the [sni_handlers].
        """

    @property
    def sni_handlers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SniMatch]:
        """Settings for handling requests with Server Name Indication (SNI)
        matching one of [SniMatch.server_names] values.
        """

    def __init__(
        self,
        *,
        default_handler: global___TlsHandler | None = ...,
        sni_handlers: collections.abc.Iterable[global___SniMatch] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_handler", b"default_handler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_handler", b"default_handler", "sni_handlers", b"sni_handlers"]) -> None: ...

global___TlsListener = TlsListener

@typing.final
class StreamListener(google.protobuf.message.Message):
    """A stream (TCP) listener resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HANDLER_FIELD_NUMBER: builtins.int
    @property
    def handler(self) -> global___StreamHandler:
        """Settings for handling stream (TCP) requests."""

    def __init__(
        self,
        *,
        handler: global___StreamHandler | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["handler", b"handler"]) -> None: ...

global___StreamListener = StreamListener

@typing.final
class Http2Options(google.protobuf.message.Message):
    """An HTTP/2 options resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_CONCURRENT_STREAMS_FIELD_NUMBER: builtins.int
    max_concurrent_streams: builtins.int
    """Maximum number of concurrent HTTP/2 streams in a connection."""
    def __init__(
        self,
        *,
        max_concurrent_streams: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_concurrent_streams", b"max_concurrent_streams"]) -> None: ...

global___Http2Options = Http2Options

@typing.final
class StreamHandler(google.protobuf.message.Message):
    """A stream (TCP) handler resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKEND_GROUP_ID_FIELD_NUMBER: builtins.int
    IDLE_TIMEOUT_FIELD_NUMBER: builtins.int
    backend_group_id: builtins.str
    """ID of the backend group processing requests. For details about the concept, see
    [documentation](/docs/application-load-balancer/concepts/backend-group).

    The backend group type, specified via [BackendGroup.backend], must be `stream`.

    To get the list of all available backend groups, make a [BackendGroupService.List] request.
    """
    @property
    def idle_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """The idle timeout is duration during which no data is transmitted or received on either the upstream or downstream connection. 
        If not configured, the default idle timeout is 1 hour. Setting it to 0 disables the timeout.
        """

    def __init__(
        self,
        *,
        backend_group_id: builtins.str = ...,
        idle_timeout: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["idle_timeout", b"idle_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backend_group_id", b"backend_group_id", "idle_timeout", b"idle_timeout"]) -> None: ...

global___StreamHandler = StreamHandler

@typing.final
class HttpHandler(google.protobuf.message.Message):
    """An HTTP handler resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    HTTP2_OPTIONS_FIELD_NUMBER: builtins.int
    ALLOW_HTTP10_FIELD_NUMBER: builtins.int
    REWRITE_REQUEST_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router processing requests. For details about the concept, see
    [documentation](/docs/application-load-balancer/concepts/http-router).

    To get the list of all available HTTP routers, make a [HttpRouterService.List] request.
    """
    allow_http10: builtins.bool
    """Enables support for incoming HTTP/1.0 and HTTP/1.1 requests and disables it for HTTP/2 requests."""
    rewrite_request_id: builtins.bool
    """When unset, will preserve the incoming x-request-id header, otherwise would rewrite it with a new value."""
    @property
    def http2_options(self) -> global___Http2Options:
        """HTTP/2 settings.

        If specified, incoming HTTP/2 requests are supported by the listener.
        """

    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
        http2_options: global___Http2Options | None = ...,
        allow_http10: builtins.bool = ...,
        rewrite_request_id: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allow_http10", b"allow_http10", "http2_options", b"http2_options", "protocol_settings", b"protocol_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow_http10", b"allow_http10", "http2_options", b"http2_options", "http_router_id", b"http_router_id", "protocol_settings", b"protocol_settings", "rewrite_request_id", b"rewrite_request_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["protocol_settings", b"protocol_settings"]) -> typing.Literal["http2_options", "allow_http10"] | None: ...

global___HttpHandler = HttpHandler

@typing.final
class Redirects(google.protobuf.message.Message):
    """A listener redirects resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_TO_HTTPS_FIELD_NUMBER: builtins.int
    http_to_https: builtins.bool
    """Redirects all unencrypted HTTP requests to the same URI with scheme changed to `https`.

    The setting has the same effect as a single, catch-all [HttpRoute]
    with [RedirectAction.replace_scheme] set to `https`.
    """
    def __init__(
        self,
        *,
        http_to_https: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_to_https", b"http_to_https"]) -> None: ...

global___Redirects = Redirects

@typing.final
class SniMatch(google.protobuf.message.Message):
    """A SNI handler resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SERVER_NAMES_FIELD_NUMBER: builtins.int
    HANDLER_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the SNI handler."""
    @property
    def server_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Server names that are matched by the SNI handler."""

    @property
    def handler(self) -> global___TlsHandler:
        """Settings for handling requests with Server Name Indication (SNI) matching one of [server_names] values."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        server_names: collections.abc.Iterable[builtins.str] | None = ...,
        handler: global___TlsHandler | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["handler", b"handler", "name", b"name", "server_names", b"server_names"]) -> None: ...

global___SniMatch = SniMatch

@typing.final
class TlsHandler(google.protobuf.message.Message):
    """A TLS-encrypted (HTTP or TCP stream) handler resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_HANDLER_FIELD_NUMBER: builtins.int
    STREAM_HANDLER_FIELD_NUMBER: builtins.int
    CERTIFICATE_IDS_FIELD_NUMBER: builtins.int
    @property
    def http_handler(self) -> global___HttpHandler:
        """HTTP handler."""

    @property
    def stream_handler(self) -> global___StreamHandler:
        """Stream (TCP) handler."""

    @property
    def certificate_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of the TLS server certificates from [Certificate Manager](/docs/certificate-manager/).

        RSA and ECDSA certificates are supported, and only the first certificate of each type is used.
        """

    def __init__(
        self,
        *,
        http_handler: global___HttpHandler | None = ...,
        stream_handler: global___StreamHandler | None = ...,
        certificate_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler", "http_handler", b"http_handler", "stream_handler", b"stream_handler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["certificate_ids", b"certificate_ids", "handler", b"handler", "http_handler", b"http_handler", "stream_handler", b"stream_handler"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["handler", b"handler"]) -> typing.Literal["http_handler", "stream_handler"] | None: ...

global___TlsHandler = TlsHandler

@typing.final
class TargetState(google.protobuf.message.Message):
    """A target state resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TargetState._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: TargetState._Status.ValueType  # 0
        HEALTHY: TargetState._Status.ValueType  # 1
        """All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] are passed
        (the number depends on the [HealthCheck.healthy_threshold] setting) and the target is ready to receive traffic.
        """
        PARTIALLY_HEALTHY: TargetState._Status.ValueType  # 2
        """Some of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
        (the number depends on the [HealthCheck.unhealthy_threshold] setting).
        The target is ready to receive traffic from the load balancer nodes which, based on their health checks,
        consider the target healthy.
        """
        UNHEALTHY: TargetState._Status.ValueType  # 3
        """All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
        (the number depends on the [HealthCheck.unhealthy_threshold] setting) and the target is not receiving traffic.
        """
        DRAINING: TargetState._Status.ValueType  # 4
        """Target is being deleted and the application load balancer is no longer sending traffic to this target."""
        TIMEOUT: TargetState._Status.ValueType  # 5

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Supported target statuses."""

    STATUS_UNSPECIFIED: TargetState.Status.ValueType  # 0
    HEALTHY: TargetState.Status.ValueType  # 1
    """All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] are passed
    (the number depends on the [HealthCheck.healthy_threshold] setting) and the target is ready to receive traffic.
    """
    PARTIALLY_HEALTHY: TargetState.Status.ValueType  # 2
    """Some of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
    (the number depends on the [HealthCheck.unhealthy_threshold] setting).
    The target is ready to receive traffic from the load balancer nodes which, based on their health checks,
    consider the target healthy.
    """
    UNHEALTHY: TargetState.Status.ValueType  # 3
    """All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
    (the number depends on the [HealthCheck.unhealthy_threshold] setting) and the target is not receiving traffic.
    """
    DRAINING: TargetState.Status.ValueType  # 4
    """Target is being deleted and the application load balancer is no longer sending traffic to this target."""
    TIMEOUT: TargetState.Status.ValueType  # 5

    @typing.final
    class HealthcheckStatus(google.protobuf.message.Message):
        """Health of the target."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ZONE_STATUSES_FIELD_NUMBER: builtins.int
        @property
        def zone_statuses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TargetState.ZoneHealthcheckStatus]:
            """Statuses of the target in its availability zones."""

        def __init__(
            self,
            *,
            zone_statuses: collections.abc.Iterable[global___TargetState.ZoneHealthcheckStatus] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["zone_statuses", b"zone_statuses"]) -> None: ...

    @typing.final
    class ZoneHealthcheckStatus(google.protobuf.message.Message):
        """Health of the target in the availability zone."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ZONE_ID_FIELD_NUMBER: builtins.int
        STATUS_FIELD_NUMBER: builtins.int
        FAILED_ACTIVE_HC_FIELD_NUMBER: builtins.int
        zone_id: builtins.str
        """ID of the availability zone."""
        status: global___TargetState.Status.ValueType
        """Status of the target in the availability zone."""
        failed_active_hc: builtins.bool
        """Indicates whether the target has been marked `UNHEALTHY` due to failing active health checks,
        which determine target statuses as configured in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks].

        Currently the only type of health checks is active, as described above.
        Passive health checks, which determine the health of a target based on its responses to production requests
        (HTTP 5xx status codes, connection errors etc.), are not implemented yet.
        """
        def __init__(
            self,
            *,
            zone_id: builtins.str = ...,
            status: global___TargetState.Status.ValueType = ...,
            failed_active_hc: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["failed_active_hc", b"failed_active_hc", "status", b"status", "zone_id", b"zone_id"]) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___TargetState.HealthcheckStatus:
        """Health of the target, i.e. its statuses in all availability zones."""

    @property
    def target(self) -> yandex.cloud.apploadbalancer.v1.target_group_pb2.Target:
        """Target."""

    def __init__(
        self,
        *,
        status: global___TargetState.HealthcheckStatus | None = ...,
        target: yandex.cloud.apploadbalancer.v1.target_group_pb2.Target | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["status", b"status", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["status", b"status", "target", b"target"]) -> None: ...

global___TargetState = TargetState

@typing.final
class AutoScalePolicy(google.protobuf.message.Message):
    """A resource for scaling settings of an application load balancer."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_ZONE_SIZE_FIELD_NUMBER: builtins.int
    MAX_SIZE_FIELD_NUMBER: builtins.int
    min_zone_size: builtins.int
    """Lower limit for the number of resource units in each availability zone.

    If not specified previously (using other instruments such as management console), the default value is 2.
    To revert to it, specify it explicitly.

    The minimum value is 2.
    """
    max_size: builtins.int
    """Upper limit for the total number of resource units across all availability zones.

    If a positive value is specified, it must be at least [min_zone_size] multiplied by the size of
    [AllocationPolicy.locations].

    If the value is 0, there is no upper limit.
    """
    def __init__(
        self,
        *,
        min_zone_size: builtins.int = ...,
        max_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_size", b"max_size", "min_zone_size", b"min_zone_size"]) -> None: ...

global___AutoScalePolicy = AutoScalePolicy
