"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Format:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Format.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FORMAT_UNSPECIFIED: _Format.ValueType  # 0
    VERSION_11: _Format.ValueType  # 1
    """A legacy backup format used in older versions. It's not recommended to use."""
    VERSION_12: _Format.ValueType  # 2
    """A new format recommended in most cases for fast backup and recovery."""
    AUTO: _Format.ValueType  # 3
    """Automatic version selection. Will be used version 12 unless the protection
    plan (policy) appends backups to the ones created by earlier product
    versions.
    """

class Format(_Format, metaclass=_FormatEnumTypeWrapper):
    """Format of the backup in policy. For backup locations that can be browsed
    with a file manager, the backup format determines the number of files and
    their extension.
    """

FORMAT_UNSPECIFIED: Format.ValueType  # 0
VERSION_11: Format.ValueType  # 1
"""A legacy backup format used in older versions. It's not recommended to use."""
VERSION_12: Format.ValueType  # 2
"""A new format recommended in most cases for fast backup and recovery."""
AUTO: Format.ValueType  # 3
"""Automatic version selection. Will be used version 12 unless the protection
plan (policy) appends backups to the ones created by earlier product
versions.
"""
global___Format = Format

@typing.final
class Policy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Policy ID."""
    name: builtins.str
    """Policy name."""
    enabled: builtins.bool
    """If this field is true, it means that the policy is enabled."""
    folder_id: builtins.str
    """ID of the folder that the policy belongs to."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def settings(self) -> global___PolicySettings:
        """Set of policy settings"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        enabled: builtins.bool = ...,
        settings: global___PolicySettings | None = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "settings", b"settings", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "enabled", b"enabled", "folder_id", b"folder_id", "id", b"id", "name", b"name", "settings", b"settings", "updated_at", b"updated_at"]) -> None: ...

global___Policy = Policy

@typing.final
class PolicySettings(google.protobuf.message.Message):
    """Set of policy settings"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Compression:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CompressionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings._Compression.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COMPRESSION_UNSPECIFIED: PolicySettings._Compression.ValueType  # 0
        NORMAL: PolicySettings._Compression.ValueType  # 1
        HIGH: PolicySettings._Compression.ValueType  # 2
        MAX: PolicySettings._Compression.ValueType  # 3
        OFF: PolicySettings._Compression.ValueType  # 4

    class Compression(_Compression, metaclass=_CompressionEnumTypeWrapper):
        """Compression rate of the backups."""

    COMPRESSION_UNSPECIFIED: PolicySettings.Compression.ValueType  # 0
    NORMAL: PolicySettings.Compression.ValueType  # 1
    HIGH: PolicySettings.Compression.ValueType  # 2
    MAX: PolicySettings.Compression.ValueType  # 3
    OFF: PolicySettings.Compression.ValueType  # 4

    class _RepeatePeriod:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RepeatePeriodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings._RepeatePeriod.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REPEATE_PERIOD_UNSPECIFIED: PolicySettings._RepeatePeriod.ValueType  # 0
        HOURLY: PolicySettings._RepeatePeriod.ValueType  # 1
        DAILY: PolicySettings._RepeatePeriod.ValueType  # 2
        WEEKLY: PolicySettings._RepeatePeriod.ValueType  # 3
        MONTHLY: PolicySettings._RepeatePeriod.ValueType  # 4

    class RepeatePeriod(_RepeatePeriod, metaclass=_RepeatePeriodEnumTypeWrapper): ...
    REPEATE_PERIOD_UNSPECIFIED: PolicySettings.RepeatePeriod.ValueType  # 0
    HOURLY: PolicySettings.RepeatePeriod.ValueType  # 1
    DAILY: PolicySettings.RepeatePeriod.ValueType  # 2
    WEEKLY: PolicySettings.RepeatePeriod.ValueType  # 3
    MONTHLY: PolicySettings.RepeatePeriod.ValueType  # 4

    class _Day:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DayEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings._Day.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DAY_UNSPECIFIED: PolicySettings._Day.ValueType  # 0
        MONDAY: PolicySettings._Day.ValueType  # 1
        TUESDAY: PolicySettings._Day.ValueType  # 2
        WEDNESDAY: PolicySettings._Day.ValueType  # 3
        THURSDAY: PolicySettings._Day.ValueType  # 4
        FRIDAY: PolicySettings._Day.ValueType  # 5
        SATURDAY: PolicySettings._Day.ValueType  # 6
        SUNDAY: PolicySettings._Day.ValueType  # 7

    class Day(_Day, metaclass=_DayEnumTypeWrapper): ...
    DAY_UNSPECIFIED: PolicySettings.Day.ValueType  # 0
    MONDAY: PolicySettings.Day.ValueType  # 1
    TUESDAY: PolicySettings.Day.ValueType  # 2
    WEDNESDAY: PolicySettings.Day.ValueType  # 3
    THURSDAY: PolicySettings.Day.ValueType  # 4
    FRIDAY: PolicySettings.Day.ValueType  # 5
    SATURDAY: PolicySettings.Day.ValueType  # 6
    SUNDAY: PolicySettings.Day.ValueType  # 7

    class _ChangedBlockTracking:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ChangedBlockTrackingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings._ChangedBlockTracking.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CHANGED_BLOCK_TRACKING_UNSPECIFIED: PolicySettings._ChangedBlockTracking.ValueType  # 0
        USE_IF_ENABLED: PolicySettings._ChangedBlockTracking.ValueType  # 1
        ENABLE_AND_USE: PolicySettings._ChangedBlockTracking.ValueType  # 2
        DO_NOT_USE: PolicySettings._ChangedBlockTracking.ValueType  # 3

    class ChangedBlockTracking(_ChangedBlockTracking, metaclass=_ChangedBlockTrackingEnumTypeWrapper): ...
    CHANGED_BLOCK_TRACKING_UNSPECIFIED: PolicySettings.ChangedBlockTracking.ValueType  # 0
    USE_IF_ENABLED: PolicySettings.ChangedBlockTracking.ValueType  # 1
    ENABLE_AND_USE: PolicySettings.ChangedBlockTracking.ValueType  # 2
    DO_NOT_USE: PolicySettings.ChangedBlockTracking.ValueType  # 3

    class _CommandType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CommandTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings._CommandType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COMMAND_TYPE_UNSPECIFIED: PolicySettings._CommandType.ValueType  # 0
        PRE_COMMAND: PolicySettings._CommandType.ValueType  # 1
        """Launch command before backup execution"""
        POST_COMMAND: PolicySettings._CommandType.ValueType  # 2
        """Launch command after backup execution"""

    class CommandType(_CommandType, metaclass=_CommandTypeEnumTypeWrapper): ...
    COMMAND_TYPE_UNSPECIFIED: PolicySettings.CommandType.ValueType  # 0
    PRE_COMMAND: PolicySettings.CommandType.ValueType  # 1
    """Launch command before backup execution"""
    POST_COMMAND: PolicySettings.CommandType.ValueType  # 2
    """Launch command after backup execution"""

    @typing.final
    class Interval(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Type:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings.Interval._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            TYPE_UNSPECIFIED: PolicySettings.Interval._Type.ValueType  # 0
            SECONDS: PolicySettings.Interval._Type.ValueType  # 1
            MINUTES: PolicySettings.Interval._Type.ValueType  # 2
            HOURS: PolicySettings.Interval._Type.ValueType  # 3
            DAYS: PolicySettings.Interval._Type.ValueType  # 4
            WEEKS: PolicySettings.Interval._Type.ValueType  # 5
            MONTHS: PolicySettings.Interval._Type.ValueType  # 6

        class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
        TYPE_UNSPECIFIED: PolicySettings.Interval.Type.ValueType  # 0
        SECONDS: PolicySettings.Interval.Type.ValueType  # 1
        MINUTES: PolicySettings.Interval.Type.ValueType  # 2
        HOURS: PolicySettings.Interval.Type.ValueType  # 3
        DAYS: PolicySettings.Interval.Type.ValueType  # 4
        WEEKS: PolicySettings.Interval.Type.ValueType  # 5
        MONTHS: PolicySettings.Interval.Type.ValueType  # 6

        TYPE_FIELD_NUMBER: builtins.int
        COUNT_FIELD_NUMBER: builtins.int
        type: global___PolicySettings.Interval.Type.ValueType
        """A type of the interval."""
        count: builtins.int
        """The amount of value specified in `Interval.Type`."""
        def __init__(
            self,
            *,
            type: global___PolicySettings.Interval.Type.ValueType = ...,
            count: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["count", b"count", "type", b"type"]) -> None: ...

    @typing.final
    class RetriesConfiguration(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        INTERVAL_FIELD_NUMBER: builtins.int
        MAX_ATTEMPTS_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """If true, enables retry on errors."""
        max_attempts: builtins.int
        """Max number of retry attempts. Operation will be considered as failed 
        when max number of retry attempts is reached.
        """
        @property
        def interval(self) -> global___PolicySettings.Interval:
            """An interval between retry attempts."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            interval: global___PolicySettings.Interval | None = ...,
            max_attempts: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["interval", b"interval"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "interval", b"interval", "max_attempts", b"max_attempts"]) -> None: ...

    @typing.final
    class Splitting(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_FIELD_NUMBER: builtins.int
        size: builtins.int
        """The size of split backup file in bytes."""
        def __init__(
            self,
            *,
            size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

    @typing.final
    class VolumeShadowCopyServiceSettings(google.protobuf.message.Message):
        """Settings for Volume Shadow Copy Services which allows to notify
        VSS-aware applications that backup is about to start. This will
        ensure the consistent state of all data used by the applications.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _VSSProvider:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _VSSProviderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings.VolumeShadowCopyServiceSettings._VSSProvider.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            VSS_PROVIDER_UNSPECIFIED: PolicySettings.VolumeShadowCopyServiceSettings._VSSProvider.ValueType  # 0
            NATIVE: PolicySettings.VolumeShadowCopyServiceSettings._VSSProvider.ValueType  # 1
            TARGET_SYSTEM_DEFINED: PolicySettings.VolumeShadowCopyServiceSettings._VSSProvider.ValueType  # 2

        class VSSProvider(_VSSProvider, metaclass=_VSSProviderEnumTypeWrapper): ...
        VSS_PROVIDER_UNSPECIFIED: PolicySettings.VolumeShadowCopyServiceSettings.VSSProvider.ValueType  # 0
        NATIVE: PolicySettings.VolumeShadowCopyServiceSettings.VSSProvider.ValueType  # 1
        TARGET_SYSTEM_DEFINED: PolicySettings.VolumeShadowCopyServiceSettings.VSSProvider.ValueType  # 2

        ENABLED_FIELD_NUMBER: builtins.int
        PROVIDER_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """If true, the VSS will be enabled."""
        provider: global___PolicySettings.VolumeShadowCopyServiceSettings.VSSProvider.ValueType
        """A type of VSS provider to use in backup."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            provider: global___PolicySettings.VolumeShadowCopyServiceSettings.VSSProvider.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "provider", b"provider"]) -> None: ...

    @typing.final
    class ArchiveProperties(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        name: builtins.str
        """The name of the generated archive. The name may use the following variables: `[Machine Name]`, `[Plan ID]`, `[Plan Name]`, `[Unique ID]`, `[Virtualization Server Type]`.
        Default value: `[Machine Name]-[Plan ID]-[Unique ID]A`.
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

    @typing.final
    class PerformanceWindow(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """If true, the time windows will be enabled."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled"]) -> None: ...

    @typing.final
    class TimeOfDay(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOUR_FIELD_NUMBER: builtins.int
        MINUTE_FIELD_NUMBER: builtins.int
        hour: builtins.int
        """Hours."""
        minute: builtins.int
        """Minutes."""
        def __init__(
            self,
            *,
            hour: builtins.int = ...,
            minute: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["hour", b"hour", "minute", b"minute"]) -> None: ...

    @typing.final
    class Retention(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class RetentionRule(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            BACKUP_SET_FIELD_NUMBER: builtins.int
            MAX_AGE_FIELD_NUMBER: builtins.int
            MAX_COUNT_FIELD_NUMBER: builtins.int
            max_count: builtins.int
            @property
            def backup_set(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___PolicySettings.RepeatePeriod.ValueType]:
                """A list of backup sets where rules are effective."""

            @property
            def max_age(self) -> global___PolicySettings.Interval: ...
            def __init__(
                self,
                *,
                backup_set: collections.abc.Iterable[global___PolicySettings.RepeatePeriod.ValueType] | None = ...,
                max_age: global___PolicySettings.Interval | None = ...,
                max_count: builtins.int = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["condition", b"condition", "max_age", b"max_age", "max_count", b"max_count"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["backup_set", b"backup_set", "condition", b"condition", "max_age", b"max_age", "max_count", b"max_count"]) -> None: ...
            def WhichOneof(self, oneof_group: typing.Literal["condition", b"condition"]) -> typing.Literal["max_age", "max_count"] | None: ...

        RULES_FIELD_NUMBER: builtins.int
        BEFORE_BACKUP_FIELD_NUMBER: builtins.int
        before_backup: builtins.bool
        """If true, retention rules will be applied before backup is finished."""
        @property
        def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolicySettings.Retention.RetentionRule]:
            """A list of retention rules."""

        def __init__(
            self,
            *,
            rules: collections.abc.Iterable[global___PolicySettings.Retention.RetentionRule] | None = ...,
            before_backup: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["before_backup", b"before_backup", "rules", b"rules"]) -> None: ...

    @typing.final
    class Scheduling(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Scheme:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _SchemeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings.Scheduling._Scheme.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            SCHEME_UNSPECIFIED: PolicySettings.Scheduling._Scheme.ValueType  # 0
            SIMPLE: PolicySettings.Scheduling._Scheme.ValueType  # 1
            ALWAYS_FULL: PolicySettings.Scheduling._Scheme.ValueType  # 2
            ALWAYS_INCREMENTAL: PolicySettings.Scheduling._Scheme.ValueType  # 3
            WEEKLY_INCREMENTAL: PolicySettings.Scheduling._Scheme.ValueType  # 4
            WEEKLY_FULL_DAILY_INCREMENTAL: PolicySettings.Scheduling._Scheme.ValueType  # 5
            CUSTOM: PolicySettings.Scheduling._Scheme.ValueType  # 6
            """Custom will require to specify schedules for full, differential
            and incremental backups additionally.
            """
            CDP: PolicySettings.Scheduling._Scheme.ValueType  # 7

        class Scheme(_Scheme, metaclass=_SchemeEnumTypeWrapper):
            """Scheme of backups."""

        SCHEME_UNSPECIFIED: PolicySettings.Scheduling.Scheme.ValueType  # 0
        SIMPLE: PolicySettings.Scheduling.Scheme.ValueType  # 1
        ALWAYS_FULL: PolicySettings.Scheduling.Scheme.ValueType  # 2
        ALWAYS_INCREMENTAL: PolicySettings.Scheduling.Scheme.ValueType  # 3
        WEEKLY_INCREMENTAL: PolicySettings.Scheduling.Scheme.ValueType  # 4
        WEEKLY_FULL_DAILY_INCREMENTAL: PolicySettings.Scheduling.Scheme.ValueType  # 5
        CUSTOM: PolicySettings.Scheduling.Scheme.ValueType  # 6
        """Custom will require to specify schedules for full, differential
        and incremental backups additionally.
        """
        CDP: PolicySettings.Scheduling.Scheme.ValueType  # 7

        @typing.final
        class BackupSet(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Type:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicySettings.Scheduling.BackupSet._Type.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                TYPE_UNSPECIFIED: PolicySettings.Scheduling.BackupSet._Type.ValueType  # 0
                TYPE_AUTO: PolicySettings.Scheduling.BackupSet._Type.ValueType  # 1
                TYPE_FULL: PolicySettings.Scheduling.BackupSet._Type.ValueType  # 2
                TYPE_INCREMENTAL: PolicySettings.Scheduling.BackupSet._Type.ValueType  # 3
                TYPE_DIFFERENTIAL: PolicySettings.Scheduling.BackupSet._Type.ValueType  # 4

            class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
            TYPE_UNSPECIFIED: PolicySettings.Scheduling.BackupSet.Type.ValueType  # 0
            TYPE_AUTO: PolicySettings.Scheduling.BackupSet.Type.ValueType  # 1
            TYPE_FULL: PolicySettings.Scheduling.BackupSet.Type.ValueType  # 2
            TYPE_INCREMENTAL: PolicySettings.Scheduling.BackupSet.Type.ValueType  # 3
            TYPE_DIFFERENTIAL: PolicySettings.Scheduling.BackupSet.Type.ValueType  # 4

            @typing.final
            class Time(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                WEEKDAYS_FIELD_NUMBER: builtins.int
                REPEAT_AT_FIELD_NUMBER: builtins.int
                REPEAT_EVERY_FIELD_NUMBER: builtins.int
                TIME_FROM_FIELD_NUMBER: builtins.int
                TIME_TO_FIELD_NUMBER: builtins.int
                MONTHDAYS_FIELD_NUMBER: builtins.int
                INCLUDE_LAST_DAY_OF_MONTH_FIELD_NUMBER: builtins.int
                MONTHS_FIELD_NUMBER: builtins.int
                TYPE_FIELD_NUMBER: builtins.int
                RUN_LATER_FIELD_NUMBER: builtins.int
                include_last_day_of_month: builtins.bool
                """If set to true, last day of month will activate
                the policy.
                """
                type: global___PolicySettings.RepeatePeriod.ValueType
                """Possible types: `REPEATE_PERIOD_UNSPECIFIED`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`."""
                run_later: builtins.bool
                """If the machine is off, launch missed tasks on boot up."""
                @property
                def weekdays(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___PolicySettings.Day.ValueType]:
                    """Days in a week to perform a backup."""

                @property
                def repeat_at(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolicySettings.TimeOfDay]:
                    """Time to repeat the backup."""

                @property
                def repeat_every(self) -> global___PolicySettings.Interval:
                    """Frequency of backup repetition."""

                @property
                def time_from(self) -> global___PolicySettings.TimeOfDay:
                    """The start time of the backup time interval."""

                @property
                def time_to(self) -> global___PolicySettings.TimeOfDay:
                    """The end time of the backup time interval."""

                @property
                def monthdays(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
                    """Days in a month to perform a backup.
                    Allowed values are from 1 to 31.
                    """

                @property
                def months(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
                    """Set of values. Allowed values form 1 to 12."""

                def __init__(
                    self,
                    *,
                    weekdays: collections.abc.Iterable[global___PolicySettings.Day.ValueType] | None = ...,
                    repeat_at: collections.abc.Iterable[global___PolicySettings.TimeOfDay] | None = ...,
                    repeat_every: global___PolicySettings.Interval | None = ...,
                    time_from: global___PolicySettings.TimeOfDay | None = ...,
                    time_to: global___PolicySettings.TimeOfDay | None = ...,
                    monthdays: collections.abc.Iterable[builtins.int] | None = ...,
                    include_last_day_of_month: builtins.bool = ...,
                    months: collections.abc.Iterable[builtins.int] | None = ...,
                    type: global___PolicySettings.RepeatePeriod.ValueType = ...,
                    run_later: builtins.bool = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["repeat_every", b"repeat_every", "time_from", b"time_from", "time_to", b"time_to"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["include_last_day_of_month", b"include_last_day_of_month", "monthdays", b"monthdays", "months", b"months", "repeat_at", b"repeat_at", "repeat_every", b"repeat_every", "run_later", b"run_later", "time_from", b"time_from", "time_to", b"time_to", "type", b"type", "weekdays", b"weekdays"]) -> None: ...

            @typing.final
            class SinceLastExecTime(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                DELAY_FIELD_NUMBER: builtins.int
                @property
                def delay(self) -> global___PolicySettings.Interval:
                    """The interval between backups."""

                def __init__(
                    self,
                    *,
                    delay: global___PolicySettings.Interval | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["delay", b"delay"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["delay", b"delay"]) -> None: ...

            TIME_FIELD_NUMBER: builtins.int
            SINCE_LAST_EXEC_TIME_FIELD_NUMBER: builtins.int
            TYPE_FIELD_NUMBER: builtins.int
            type: global___PolicySettings.Scheduling.BackupSet.Type.ValueType
            """BackupSet type -- one of incr, full, differential or auto.
            if custom scheme is used the BackupSet type should be specified
            """
            @property
            def time(self) -> global___PolicySettings.Scheduling.BackupSet.Time: ...
            @property
            def since_last_exec_time(self) -> global___PolicySettings.Scheduling.BackupSet.SinceLastExecTime: ...
            def __init__(
                self,
                *,
                time: global___PolicySettings.Scheduling.BackupSet.Time | None = ...,
                since_last_exec_time: global___PolicySettings.Scheduling.BackupSet.SinceLastExecTime | None = ...,
                type: global___PolicySettings.Scheduling.BackupSet.Type.ValueType = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["setting", b"setting", "since_last_exec_time", b"since_last_exec_time", "time", b"time"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["setting", b"setting", "since_last_exec_time", b"since_last_exec_time", "time", b"time", "type", b"type"]) -> None: ...
            def WhichOneof(self, oneof_group: typing.Literal["setting", b"setting"]) -> typing.Literal["time", "since_last_exec_time"] | None: ...

        BACKUP_SETS_FIELD_NUMBER: builtins.int
        ENABLED_FIELD_NUMBER: builtins.int
        MAX_PARALLEL_BACKUPS_FIELD_NUMBER: builtins.int
        RAND_MAX_DELAY_FIELD_NUMBER: builtins.int
        SCHEME_FIELD_NUMBER: builtins.int
        WEEKLY_BACKUP_DAY_FIELD_NUMBER: builtins.int
        TASK_FAILURE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """If true, the backup schedule will be enabled."""
        max_parallel_backups: builtins.int
        """Max number of backup processes allowed to run in parallel. Unlimited if not set."""
        scheme: global___PolicySettings.Scheduling.Scheme.ValueType
        """A backup scheme. Available values: `simple`, `always_full`, `always_incremental`, `weekly_incremental`, `weekly_full_daily_incremental`, `custom`, `cdp`."""
        weekly_backup_day: global___PolicySettings.Day.ValueType
        """A day of week to start weekly backups."""
        @property
        def backup_sets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolicySettings.Scheduling.BackupSet]:
            """A list of schedules with backup sets that compose the whole scheme."""

        @property
        def rand_max_delay(self) -> global___PolicySettings.Interval:
            """Configuration of the random delay between the execution of parallel tasks."""

        @property
        def task_failure(self) -> global___PolicySettings.RetriesConfiguration:
            """Task failure settings in case of failure of scheduled task, not applicable to  manually launched tasks"""

        def __init__(
            self,
            *,
            backup_sets: collections.abc.Iterable[global___PolicySettings.Scheduling.BackupSet] | None = ...,
            enabled: builtins.bool = ...,
            max_parallel_backups: builtins.int = ...,
            rand_max_delay: global___PolicySettings.Interval | None = ...,
            scheme: global___PolicySettings.Scheduling.Scheme.ValueType = ...,
            weekly_backup_day: global___PolicySettings.Day.ValueType = ...,
            task_failure: global___PolicySettings.RetriesConfiguration | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["rand_max_delay", b"rand_max_delay", "task_failure", b"task_failure"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["backup_sets", b"backup_sets", "enabled", b"enabled", "max_parallel_backups", b"max_parallel_backups", "rand_max_delay", b"rand_max_delay", "scheme", b"scheme", "task_failure", b"task_failure", "weekly_backup_day", b"weekly_backup_day"]) -> None: ...

    @typing.final
    class FileFilters(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXCLUSION_MASKS_FIELD_NUMBER: builtins.int
        INCLUSION_MASKS_FIELD_NUMBER: builtins.int
        @property
        def exclusion_masks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Do not backup files that match the following criteria"""

        @property
        def inclusion_masks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Backup only files that match the following criteria"""

        def __init__(
            self,
            *,
            exclusion_masks: collections.abc.Iterable[builtins.str] | None = ...,
            inclusion_masks: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["exclusion_masks", b"exclusion_masks", "inclusion_masks", b"inclusion_masks"]) -> None: ...

    @typing.final
    class PrePostCommand(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CMD_FIELD_NUMBER: builtins.int
        ARGS_FIELD_NUMBER: builtins.int
        ENABLED_FIELD_NUMBER: builtins.int
        STOP_ON_ERROR_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        WAIT_FIELD_NUMBER: builtins.int
        WORKDIR_FIELD_NUMBER: builtins.int
        cmd: builtins.str
        """Command to execute"""
        args: builtins.str
        """Command args"""
        enabled: builtins.bool
        """Is command enabled"""
        stop_on_error: builtins.bool
        """Stop backup execution on error"""
        type: global___PolicySettings.CommandType.ValueType
        """Type of command: pre or post"""
        wait: builtins.bool
        """Wait command finish before launching backup"""
        workdir: builtins.str
        """Workdir for command execution"""
        def __init__(
            self,
            *,
            cmd: builtins.str = ...,
            args: builtins.str = ...,
            enabled: builtins.bool = ...,
            stop_on_error: builtins.bool = ...,
            type: global___PolicySettings.CommandType.ValueType = ...,
            wait: builtins.bool = ...,
            workdir: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["args", b"args", "cmd", b"cmd", "enabled", b"enabled", "stop_on_error", b"stop_on_error", "type", b"type", "wait", b"wait", "workdir", b"workdir"]) -> None: ...

    COMPRESSION_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    MULTI_VOLUME_SNAPSHOTTING_ENABLED_FIELD_NUMBER: builtins.int
    PRESERVE_FILE_SECURITY_SETTINGS_FIELD_NUMBER: builtins.int
    REATTEMPTS_FIELD_NUMBER: builtins.int
    SILENT_MODE_ENABLED_FIELD_NUMBER: builtins.int
    SPLITTING_FIELD_NUMBER: builtins.int
    VM_SNAPSHOT_REATTEMPTS_FIELD_NUMBER: builtins.int
    VSS_FIELD_NUMBER: builtins.int
    ARCHIVE_FIELD_NUMBER: builtins.int
    PERFORMANCE_WINDOW_FIELD_NUMBER: builtins.int
    RETENTION_FIELD_NUMBER: builtins.int
    SCHEDULING_FIELD_NUMBER: builtins.int
    CBT_FIELD_NUMBER: builtins.int
    FAST_BACKUP_ENABLED_FIELD_NUMBER: builtins.int
    QUIESCE_SNAPSHOTTING_ENABLED_FIELD_NUMBER: builtins.int
    FILE_FILTERS_FIELD_NUMBER: builtins.int
    SECTOR_BY_SECTOR_FIELD_NUMBER: builtins.int
    VALIDATION_ENABLED_FIELD_NUMBER: builtins.int
    LVM_SNAPSHOTTING_ENABLED_FIELD_NUMBER: builtins.int
    PRE_POST_COMMANDS_FIELD_NUMBER: builtins.int
    compression: global___PolicySettings.Compression.ValueType
    """Archive compression level."""
    format: global___Format.ValueType
    """Format of the Acronis backup archive."""
    multi_volume_snapshotting_enabled: builtins.bool
    """If true, snapshots of multiple volumes will be taken simultaneously."""
    preserve_file_security_settings: builtins.bool
    """If true, the file security settings will be preserved.
    Deprecated.
    """
    silent_mode_enabled: builtins.bool
    """If true, a user interaction will be avoided when possible. Equals to false if value is not specified."""
    cbt: global___PolicySettings.ChangedBlockTracking.ValueType
    """A configuration of Changed Block Tracking (CBT)."""
    fast_backup_enabled: builtins.bool
    """If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup."""
    quiesce_snapshotting_enabled: builtins.bool
    """If true, a quiesced snapshot of the virtual machine will be taken.
    Deprecated.
    """
    sector_by_sector: builtins.bool
    """A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, 
    including those that do not contain data.
    Therefore, the size of such a backup copy will be equal to the size of the original disk or volume. 
    This method can be used to back up a disk or volume with an unsupported file system.
    """
    validation_enabled: builtins.bool
    """Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. 
    This is because not only the data physically contained in the backup copy is verified,
    but all data restored when it is selected. 
    This option requires access to previously created backup copies.
    """
    lvm_snapshotting_enabled: builtins.bool
    """LVM will be used to create the volume snapshot.
    If LVM fails to create a snapshot (for example, because there is not enough free space),
    the software will create the snapshot itself.
    """
    @property
    def reattempts(self) -> global___PolicySettings.RetriesConfiguration:
        """Configuration of retries on recoverable errors during the backup operations like reconnection to destination. No attempts to fix recoverable errors will be made if retry configuration is not set."""

    @property
    def splitting(self) -> global___PolicySettings.Splitting:
        """Determines the size to split backups on. Splitting is not performed if value is not specified."""

    @property
    def vm_snapshot_reattempts(self) -> global___PolicySettings.RetriesConfiguration:
        """Configuration of retries on errors during the creation of the virtual machine snapshot. No attempts to fix recoverable errors will be made if retry configuration is not set."""

    @property
    def vss(self) -> global___PolicySettings.VolumeShadowCopyServiceSettings:
        """Settings for the Volume Shadow Copy Service (VSS) provider. If not set, no VSS provider is used."""

    @property
    def archive(self) -> global___PolicySettings.ArchiveProperties:
        """The archive properties."""

    @property
    def performance_window(self) -> global___PolicySettings.PerformanceWindow:
        """Time windows for performance limitations of backup and storage maintenance operations."""

    @property
    def retention(self) -> global___PolicySettings.Retention:
        """Configuration of backup retention rules."""

    @property
    def scheduling(self) -> global___PolicySettings.Scheduling:
        """Configuration of the backup schedule."""

    @property
    def file_filters(self) -> global___PolicySettings.FileFilters:
        """File filters to specify masks of files to backup or to exclude of backuping"""

    @property
    def pre_post_commands(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PolicySettings.PrePostCommand]:
        """Commands to launch before or after backup execution"""

    def __init__(
        self,
        *,
        compression: global___PolicySettings.Compression.ValueType = ...,
        format: global___Format.ValueType = ...,
        multi_volume_snapshotting_enabled: builtins.bool = ...,
        preserve_file_security_settings: builtins.bool = ...,
        reattempts: global___PolicySettings.RetriesConfiguration | None = ...,
        silent_mode_enabled: builtins.bool = ...,
        splitting: global___PolicySettings.Splitting | None = ...,
        vm_snapshot_reattempts: global___PolicySettings.RetriesConfiguration | None = ...,
        vss: global___PolicySettings.VolumeShadowCopyServiceSettings | None = ...,
        archive: global___PolicySettings.ArchiveProperties | None = ...,
        performance_window: global___PolicySettings.PerformanceWindow | None = ...,
        retention: global___PolicySettings.Retention | None = ...,
        scheduling: global___PolicySettings.Scheduling | None = ...,
        cbt: global___PolicySettings.ChangedBlockTracking.ValueType = ...,
        fast_backup_enabled: builtins.bool = ...,
        quiesce_snapshotting_enabled: builtins.bool = ...,
        file_filters: global___PolicySettings.FileFilters | None = ...,
        sector_by_sector: builtins.bool = ...,
        validation_enabled: builtins.bool = ...,
        lvm_snapshotting_enabled: builtins.bool = ...,
        pre_post_commands: collections.abc.Iterable[global___PolicySettings.PrePostCommand] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["archive", b"archive", "file_filters", b"file_filters", "performance_window", b"performance_window", "reattempts", b"reattempts", "retention", b"retention", "scheduling", b"scheduling", "splitting", b"splitting", "vm_snapshot_reattempts", b"vm_snapshot_reattempts", "vss", b"vss"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["archive", b"archive", "cbt", b"cbt", "compression", b"compression", "fast_backup_enabled", b"fast_backup_enabled", "file_filters", b"file_filters", "format", b"format", "lvm_snapshotting_enabled", b"lvm_snapshotting_enabled", "multi_volume_snapshotting_enabled", b"multi_volume_snapshotting_enabled", "performance_window", b"performance_window", "pre_post_commands", b"pre_post_commands", "preserve_file_security_settings", b"preserve_file_security_settings", "quiesce_snapshotting_enabled", b"quiesce_snapshotting_enabled", "reattempts", b"reattempts", "retention", b"retention", "scheduling", b"scheduling", "sector_by_sector", b"sector_by_sector", "silent_mode_enabled", b"silent_mode_enabled", "splitting", b"splitting", "validation_enabled", b"validation_enabled", "vm_snapshot_reattempts", b"vm_snapshot_reattempts", "vss", b"vss"]) -> None: ...

global___PolicySettings = PolicySettings

@typing.final
class PolicyApplication(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PolicyApplication._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: PolicyApplication._Status.ValueType  # 0
        OK: PolicyApplication._Status.ValueType  # 1
        """Application is applied and everything is OK."""
        RUNNING: PolicyApplication._Status.ValueType  # 2
        """Application is currently running."""
        DISABLED: PolicyApplication._Status.ValueType  # 3
        """Application is disabled."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: PolicyApplication.Status.ValueType  # 0
    OK: PolicyApplication.Status.ValueType  # 1
    """Application is applied and everything is OK."""
    RUNNING: PolicyApplication.Status.ValueType  # 2
    """Application is currently running."""
    DISABLED: PolicyApplication.Status.ValueType  # 3
    """Application is disabled."""

    POLICY_ID_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    IS_PROCESSING_FIELD_NUMBER: builtins.int
    policy_id: builtins.str
    """Policy ID."""
    compute_instance_id: builtins.str
    """Compute Cloud instance ID."""
    enabled: builtins.bool
    status: global___PolicyApplication.Status.ValueType
    is_processing: builtins.bool
    """If true, then the policy is in in the process of binding to the instance."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        policy_id: builtins.str = ...,
        compute_instance_id: builtins.str = ...,
        enabled: builtins.bool = ...,
        status: global___PolicyApplication.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_processing: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["compute_instance_id", b"compute_instance_id", "created_at", b"created_at", "enabled", b"enabled", "is_processing", b"is_processing", "policy_id", b"policy_id", "status", b"status"]) -> None: ...

global___PolicyApplication = PolicyApplication
