"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Image(google.protobuf.message.Message):
    """An Image resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Image._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Image._Status.ValueType  # 0
        """Unspecified image status."""
        CREATING: Image._Status.ValueType  # 1
        """Image is being created."""
        READY: Image._Status.ValueType  # 2
        """Image is ready to use."""
        ERROR: Image._Status.ValueType  # 3
        """Image encountered an error."""
        DELETING: Image._Status.ValueType  # 4
        """Image is being deleted."""
        UPDATING: Image._Status.ValueType  # 5
        """Image is being updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Image status."""

    STATUS_UNSPECIFIED: Image.Status.ValueType  # 0
    """Unspecified image status."""
    CREATING: Image.Status.ValueType  # 1
    """Image is being created."""
    READY: Image.Status.ValueType  # 2
    """Image is ready to use."""
    ERROR: Image.Status.ValueType  # 3
    """Image encountered an error."""
    DELETING: Image.Status.ValueType  # 4
    """Image is being deleted."""
    UPDATING: Image.Status.ValueType  # 5
    """Image is being updated."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CHECKSUM_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the image."""
    folder_id: builtins.str
    """ID of the folder that the image belongs to."""
    name: builtins.str
    """Name of the image.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the image."""
    checksum: builtins.str
    """MD5 checksum of the image."""
    status: global___Image.Status.ValueType
    """Status of the image."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        checksum: builtins.str = ...,
        status: global___Image.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["checksum", b"checksum", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "status", b"status"]) -> None: ...

global___Image = Image
