"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.baremetal.v1alpha.dhcp_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PublicSubnetType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PublicSubnetTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PublicSubnetType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PUBLIC_SUBNET_TYPE_UNSPECIFIED: _PublicSubnetType.ValueType  # 0
    """Unspecified public subnet type."""
    DEDICATED: _PublicSubnetType.ValueType  # 1
    """Dedicated public subnet."""
    EPHEMERAL: _PublicSubnetType.ValueType  # 2
    """Ephemeral public subnet."""

class PublicSubnetType(_PublicSubnetType, metaclass=_PublicSubnetTypeEnumTypeWrapper):
    """Type of the public subnet."""

PUBLIC_SUBNET_TYPE_UNSPECIFIED: PublicSubnetType.ValueType  # 0
"""Unspecified public subnet type."""
DEDICATED: PublicSubnetType.ValueType  # 1
"""Dedicated public subnet."""
EPHEMERAL: PublicSubnetType.ValueType  # 2
"""Ephemeral public subnet."""
global___PublicSubnetType = PublicSubnetType

@typing.final
class PublicSubnet(google.protobuf.message.Message):
    """A PublicSubnet resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_IDS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PREFIX_LENGTH_FIELD_NUMBER: builtins.int
    CIDR_FIELD_NUMBER: builtins.int
    DHCP_OPTIONS_FIELD_NUMBER: builtins.int
    GATEWAY_IP_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the public subnet."""
    cloud_id: builtins.str
    """ID of the cloud that the public subnet belongs to."""
    folder_id: builtins.str
    """ID of the folder that the public subnet belongs to."""
    name: builtins.str
    """Name of the public subnet.
    The name is unique within the folder.
    """
    description: builtins.str
    """Optional description of the public subnet."""
    zone_id: builtins.str
    """ID of the availability zone where the server resides."""
    type: global___PublicSubnetType.ValueType
    """Type of the public subnet (static or ephemeral)."""
    prefix_length: builtins.int
    """Prefix length of the public subnet CIDR block."""
    cidr: builtins.str
    """CIDR block for the public subnet."""
    gateway_ip: builtins.str
    """Gateway IP address for the public subnet."""
    @property
    def hardware_pool_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the hardware pool that the public subnet belongs to."""

    @property
    def dhcp_options(self) -> yandex.cloud.baremetal.v1alpha.dhcp_pb2.DhcpOptions:
        """DHCP options for the public subnet."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        zone_id: builtins.str = ...,
        hardware_pool_ids: collections.abc.Iterable[builtins.str] | None = ...,
        type: global___PublicSubnetType.ValueType = ...,
        prefix_length: builtins.int = ...,
        cidr: builtins.str = ...,
        dhcp_options: yandex.cloud.baremetal.v1alpha.dhcp_pb2.DhcpOptions | None = ...,
        gateway_ip: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "dhcp_options", b"dhcp_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cidr", b"cidr", "cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "dhcp_options", b"dhcp_options", "folder_id", b"folder_id", "gateway_ip", b"gateway_ip", "hardware_pool_ids", b"hardware_pool_ids", "id", b"id", "labels", b"labels", "name", b"name", "prefix_length", b"prefix_length", "type", b"type", "zone_id", b"zone_id"]) -> None: ...

global___PublicSubnet = PublicSubnet
