"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.baremetal.v1alpha.public_subnet_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetPublicSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the PublicSubnet resource to return.

    To get the public subnet ID use a [PublicSubnetService.List] request.
    """
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___GetPublicSubnetRequest = GetPublicSubnetRequest

@typing.final
class ListPublicSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list public subnets in.

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListPublicSubnetResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListPublicSubnetResponse.next_page_token] returned by a previous list request.
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    Supported fields: ["id", "name", "createdAt"].
    Both snake_case and camelCase are supported for fields.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=` (equal), `:` (substring), `@>` (contains).
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    Example: "key1='value' AND key2='value'"
    Supported operators: ["AND"].
    Supported fields: ["id", "name", "zoneId", "hardwarePoolIds"].
    Deprecated fields: ["hardwarePoolId"].
    Both snake_case and camelCase are supported for fields.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListPublicSubnetRequest = ListPublicSubnetRequest

@typing.final
class ListPublicSubnetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListPublicSubnetRequest.page_size], use `next_page_token` as the value
    for the [ListPublicSubnetRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def public_subnets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.public_subnet_pb2.PublicSubnet]:
        """List of PublicSubnet resources."""

    def __init__(
        self,
        *,
        public_subnets: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.public_subnet_pb2.PublicSubnet] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "public_subnets", b"public_subnets"]) -> None: ...

global___ListPublicSubnetResponse = ListPublicSubnetResponse

@typing.final
class CreatePublicSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_IDS_FIELD_NUMBER: builtins.int
    PREFIX_LENGTH_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a public subnet in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the public subnet.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the public subnet."""
    prefix_length: builtins.int
    """Prefix length of the public subnet CIDR block."""
    @property
    def hardware_pool_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the hardware pool that the public subnet belongs to.

        To get a list of available hardware pools, use the [HardwarePoolService.List] request.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        hardware_pool_ids: collections.abc.Iterable[builtins.str] | None = ...,
        prefix_length: builtins.int = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "hardware_pool_ids", b"hardware_pool_ids", "labels", b"labels", "name", b"name", "prefix_length", b"prefix_length"]) -> None: ...

global___CreatePublicSubnetRequest = CreatePublicSubnetRequest

@typing.final
class CreatePublicSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the public subnet that is being created."""
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___CreatePublicSubnetMetadata = CreatePublicSubnetMetadata

@typing.final
class UpdatePublicSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_IDS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the PublicSubnet resource to update.

    To get the public subnet ID, use a [PublicSubnetService.List] request.
    """
    name: builtins.str
    """Name of the public subnet.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the public subnet."""
    type: yandex.cloud.baremetal.v1alpha.public_subnet_pb2.PublicSubnetType.ValueType
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the PublicSubnet resource are going to be updated."""

    @property
    def hardware_pool_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the hardware pool that the public subnet belongs to.

        To get a list of available hardware pools, use the [HardwarePoolService.List] request.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        Existing set of `labels` is completely replaced by the provided set.
        """

    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        hardware_pool_ids: collections.abc.Iterable[builtins.str] | None = ...,
        type: yandex.cloud.baremetal.v1alpha.public_subnet_pb2.PublicSubnetType.ValueType = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "hardware_pool_ids", b"hardware_pool_ids", "labels", b"labels", "name", b"name", "public_subnet_id", b"public_subnet_id", "type", b"type", "update_mask", b"update_mask"]) -> None: ...

global___UpdatePublicSubnetRequest = UpdatePublicSubnetRequest

@typing.final
class UpdatePublicSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the PublicSubnet resource that is being updated."""
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___UpdatePublicSubnetMetadata = UpdatePublicSubnetMetadata

@typing.final
class DeletePublicSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the public subnet to delete.

    To get the public subnet ID, use a [PublicSubnetService.List] request.
    """
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___DeletePublicSubnetRequest = DeletePublicSubnetRequest

@typing.final
class DeletePublicSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the PublicSubnet resource that is being deleted."""
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___DeletePublicSubnetMetadata = DeletePublicSubnetMetadata

@typing.final
class ListPublicSubnetOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the PublicSubnet resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListPublicSubnetResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListPublicSubnetOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "public_subnet_id", b"public_subnet_id"]) -> None: ...

global___ListPublicSubnetOperationsRequest = ListPublicSubnetOperationsRequest

@typing.final
class ListPublicSubnetOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListPublicSubnetOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListPublicSubnetOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified PublicSubnet resource."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListPublicSubnetOperationsResponse = ListPublicSubnetOperationsResponse
