"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing
import yandex.cloud.cdn.v1.origin_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetOriginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    ORIGIN_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the origin belongs to."""
    origin_id: builtins.int
    """[origin_id] group ID to request origin from."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        origin_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "origin_id", b"origin_id"]) -> None: ...

global___GetOriginRequest = GetOriginRequest

@typing.final
class ListOriginsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the origin belongs to."""
    origin_group_id: builtins.int
    """ID of the group to request origins from."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        origin_group_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "origin_group_id", b"origin_group_id"]) -> None: ...

global___ListOriginsRequest = ListOriginsRequest

@typing.final
class ListOriginsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGINS_FIELD_NUMBER: builtins.int
    @property
    def origins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.cdn.v1.origin_pb2.Origin]:
        """Origin from response."""

    def __init__(
        self,
        *,
        origins: collections.abc.Iterable[yandex.cloud.cdn.v1.origin_pb2.Origin] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["origins", b"origins"]) -> None: ...

global___ListOriginsResponse = ListOriginsResponse

@typing.final
class CreateOriginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    BACKUP_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    PROVIDER_TYPE_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the origin belongs to."""
    origin_group_id: builtins.int
    """[origin_group_id] group ID to request origins from."""
    source: builtins.str
    """IP address or Domain name of your origin and the port (if custom).
    Used if [meta] variant is `common`.
    """
    provider_type: builtins.str
    """Set up origin provider

    It has two possible values:

    ourcdn - Based on Yandex technologies
    gcore - Based on an external partner infrastructure

    Default value: ourcdn
    """
    @property
    def enabled(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """The setting allows to enable or disable an Origin source in the Origins group.

        It has two possible values:

        True - The origin is enabled and used as a source for the CDN. An origins
        group must contain at least one enabled origin. Default value.
        False - The origin is disabled and the CDN is not using it to pull content.
        """

    @property
    def backup(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether the origin is used in its origin group as backup.
        A backup origin is used when one of active origins becomes unavailable.

        Default value: False.
        """

    @property
    def meta(self) -> yandex.cloud.cdn.v1.origin_pb2.OriginMeta:
        """Set up origin of the content."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        origin_group_id: builtins.int = ...,
        source: builtins.str = ...,
        enabled: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        backup: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        meta: yandex.cloud.cdn.v1.origin_pb2.OriginMeta | None = ...,
        provider_type: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backup", b"backup", "enabled", b"enabled", "meta", b"meta"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup", b"backup", "enabled", b"enabled", "folder_id", b"folder_id", "meta", b"meta", "origin_group_id", b"origin_group_id", "provider_type", b"provider_type", "source", b"source"]) -> None: ...

global___CreateOriginRequest = CreateOriginRequest

@typing.final
class CreateOriginMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_ID_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_ID_FIELD_NUMBER: builtins.int
    origin_id: builtins.int
    """ID of the origin."""
    origin_group_id: builtins.int
    """ID pf the parent origins group."""
    def __init__(
        self,
        *,
        origin_id: builtins.int = ...,
        origin_group_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["origin_group_id", b"origin_group_id", "origin_id", b"origin_id"]) -> None: ...

global___CreateOriginMetadata = CreateOriginMetadata

@typing.final
class UpdateOriginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    ORIGIN_ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    BACKUP_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the origin belongs to."""
    origin_id: builtins.int
    """ID of the origin."""
    source: builtins.str
    """PUT behavior, parameter below will be fully rewritten

    IP address or Domain name of your origin and the port (if custom).
    Used if [meta] variant is `common`.
    Required.
    """
    enabled: builtins.bool
    """The setting allows to enable or disable an Origin source in the Origins group.

    It has two possible values:

    True - The origin is enabled and used as a source for the CDN. An origins
    group must contain at least one enabled origin. Default value.
    False - The origin is disabled and the CDN is not using it to pull content.

    Required.
    """
    backup: builtins.bool
    """Specifies whether the origin is used in its origin group as backup.
    A backup origin is used when one of active origins becomes unavailable.

    Required.
    """
    @property
    def meta(self) -> yandex.cloud.cdn.v1.origin_pb2.OriginMeta:
        """Set up type of the origin."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        origin_id: builtins.int = ...,
        source: builtins.str = ...,
        enabled: builtins.bool = ...,
        backup: builtins.bool = ...,
        meta: yandex.cloud.cdn.v1.origin_pb2.OriginMeta | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["meta", b"meta"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup", b"backup", "enabled", b"enabled", "folder_id", b"folder_id", "meta", b"meta", "origin_id", b"origin_id", "source", b"source"]) -> None: ...

global___UpdateOriginRequest = UpdateOriginRequest

@typing.final
class UpdateOriginMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_ID_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_ID_FIELD_NUMBER: builtins.int
    origin_id: builtins.int
    """ID of the origin."""
    origin_group_id: builtins.int
    """Parent origins group ID."""
    def __init__(
        self,
        *,
        origin_id: builtins.int = ...,
        origin_group_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["origin_group_id", b"origin_group_id", "origin_id", b"origin_id"]) -> None: ...

global___UpdateOriginMetadata = UpdateOriginMetadata

@typing.final
class DeleteOriginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    ORIGIN_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the origin belongs to."""
    origin_id: builtins.int
    """ID of the origin."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        origin_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "origin_id", b"origin_id"]) -> None: ...

global___DeleteOriginRequest = DeleteOriginRequest

@typing.final
class DeleteOriginMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_ID_FIELD_NUMBER: builtins.int
    origin_id: builtins.int
    """ID of the origin."""
    def __init__(
        self,
        *,
        origin_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["origin_id", b"origin_id"]) -> None: ...

global___DeleteOriginMetadata = DeleteOriginMetadata
