"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.cdn.v1.shielding_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetShieldingDetailsRequest(google.protobuf.message.Message):
    """Request to retrieve shielding details for a specific resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource for which to get shielding details."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_id", b"resource_id"]) -> None: ...

global___GetShieldingDetailsRequest = GetShieldingDetailsRequest

@typing.final
class ActivateShieldingRequest(google.protobuf.message.Message):
    """Request to activate shielding for a specific resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCATION_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource to activate shielding for."""
    location_id: builtins.int
    """ID of the location to activate shielding in, allowing selection of a suitable geographical location."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
        location_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["location_id", b"location_id", "resource_id", b"resource_id"]) -> None: ...

global___ActivateShieldingRequest = ActivateShieldingRequest

@typing.final
class ActivateShieldingMetadata(google.protobuf.message.Message):
    """Metadata for shielding activation, detailing the operations performed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource for which shielding is being activated."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_id", b"resource_id"]) -> None: ...

global___ActivateShieldingMetadata = ActivateShieldingMetadata

@typing.final
class DeactivateShieldingRequest(google.protobuf.message.Message):
    """Request to deactivate shielding for a specific resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource to deactivate shielding for."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_id", b"resource_id"]) -> None: ...

global___DeactivateShieldingRequest = DeactivateShieldingRequest

@typing.final
class DeactivateShieldingMetadata(google.protobuf.message.Message):
    """Metadata for shielding deactivation, detailing the operations performed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource for which shielding is being deactivated."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_id", b"resource_id"]) -> None: ...

global___DeactivateShieldingMetadata = DeactivateShieldingMetadata

@typing.final
class UpdateShieldingRequest(google.protobuf.message.Message):
    """Request to update shielding parameters, including location adjustments."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCATION_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource for which shielding parameters are being updated."""
    location_id: builtins.int
    """ID of the location for updating shielding parameters, allowing for geographical adjustments."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
        location_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["location_id", b"location_id", "resource_id", b"resource_id"]) -> None: ...

global___UpdateShieldingRequest = UpdateShieldingRequest

@typing.final
class UpdateShieldingMetadata(google.protobuf.message.Message):
    """Metadata for shielding updates, detailing the operations performed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_ID_FIELD_NUMBER: builtins.int
    resource_id: builtins.str
    """ID of the resource for which shielding parameters are being updated."""
    def __init__(
        self,
        *,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_id", b"resource_id"]) -> None: ...

global___UpdateShieldingMetadata = UpdateShieldingMetadata

@typing.final
class ListShieldingLocationsRequest(google.protobuf.message.Message):
    """Request to list available geographical locations for shielding."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder for which to request a list of locations where shielding can be activated."""
    page_size: builtins.int
    """Maximum number of results per page."""
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListShieldingLocationsResponse.next_page_token]
    returned by a previous list response.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListShieldingLocationsRequest = ListShieldingLocationsRequest

@typing.final
class ListShieldingLocationsResponse(google.protobuf.message.Message):
    """Response for the list of available shielding locations."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHIELDING_LOCATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of results."""
    @property
    def shielding_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.cdn.v1.shielding_pb2.ShieldingDetails]:
        """List of available shielding locations, each representing a potential geographical location for the shielding server."""

    def __init__(
        self,
        *,
        shielding_locations: collections.abc.Iterable[yandex.cloud.cdn.v1.shielding_pb2.ShieldingDetails] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "shielding_locations", b"shielding_locations"]) -> None: ...

global___ListShieldingLocationsResponse = ListShieldingLocationsResponse
