"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.access.access_pb2
import yandex.cloud.clouddesktop.v1.disk_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DesktopGroup(google.protobuf.message.Message):
    """A desktop group resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DesktopGroup._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: DesktopGroup._Status.ValueType  # 0
        CREATING: DesktopGroup._Status.ValueType  # 1
        """Desktop group is being created."""
        ACTIVE: DesktopGroup._Status.ValueType  # 2
        """Desktop group is ready to use."""
        DELETING: DesktopGroup._Status.ValueType  # 3
        """Desktop group is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: DesktopGroup.Status.ValueType  # 0
    CREATING: DesktopGroup.Status.ValueType  # 1
    """Desktop group is being created."""
    ACTIVE: DesktopGroup.Status.ValueType  # 2
    """Desktop group is ready to use."""
    DELETING: DesktopGroup.Status.ValueType  # 3
    """Desktop group is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_SPEC_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    BOOT_DISK_SPEC_FIELD_NUMBER: builtins.int
    DATA_DISK_SPEC_FIELD_NUMBER: builtins.int
    GROUP_CONFIG_FIELD_NUMBER: builtins.int
    AUTO_UPDATE_POLICY_FIELD_NUMBER: builtins.int
    MANUAL_UPDATE_POLICY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Desktop group ID."""
    folder_id: builtins.str
    """ID of the folder that the desktop group belongs to."""
    status: global___DesktopGroup.Status.ValueType
    """Status of the desktop group."""
    name: builtins.str
    """Name of the desktop group."""
    description: builtins.str
    """Description of the desktop group."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def resources_spec(self) -> global___ResourcesSpec:
        """Resource specification of the desktop group."""

    @property
    def network_interface_spec(self) -> global___NetworkInterfaceSpec:
        """Network interface specification of the desktop group."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the desktop group."""

    @property
    def boot_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Boot disk specification of the desktop group."""

    @property
    def data_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Data disk specification of the desktop group."""

    @property
    def group_config(self) -> global___DesktopGroupConfiguration:
        """Desktop group configuration."""

    @property
    def auto_update_policy(self) -> global___AutoUpdatePolicy: ...
    @property
    def manual_update_policy(self) -> global___ManualUpdatePolicy: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___DesktopGroup.Status.ValueType = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        resources_spec: global___ResourcesSpec | None = ...,
        network_interface_spec: global___NetworkInterfaceSpec | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        boot_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        data_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        group_config: global___DesktopGroupConfiguration | None = ...,
        auto_update_policy: global___AutoUpdatePolicy | None = ...,
        manual_update_policy: global___ManualUpdatePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_update_policy", b"auto_update_policy", "boot_disk_spec", b"boot_disk_spec", "created_at", b"created_at", "data_disk_spec", b"data_disk_spec", "group_config", b"group_config", "manual_update_policy", b"manual_update_policy", "network_interface_spec", b"network_interface_spec", "resources_spec", b"resources_spec", "update_policy", b"update_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_update_policy", b"auto_update_policy", "boot_disk_spec", b"boot_disk_spec", "created_at", b"created_at", "data_disk_spec", b"data_disk_spec", "description", b"description", "folder_id", b"folder_id", "group_config", b"group_config", "id", b"id", "labels", b"labels", "manual_update_policy", b"manual_update_policy", "name", b"name", "network_interface_spec", b"network_interface_spec", "resources_spec", b"resources_spec", "status", b"status", "update_policy", b"update_policy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["update_policy", b"update_policy"]) -> typing.Literal["auto_update_policy", "manual_update_policy"] | None: ...

global___DesktopGroup = DesktopGroup

@typing.final
class DesktopGroupConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DesktopType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DesktopTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DesktopGroupConfiguration._DesktopType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DESKTOP_TYPE_UNSPECIFIED: DesktopGroupConfiguration._DesktopType.ValueType  # 0
        PERSISTENT: DesktopGroupConfiguration._DesktopType.ValueType  # 1
        NON_PERSISTENT: DesktopGroupConfiguration._DesktopType.ValueType  # 2

    class DesktopType(_DesktopType, metaclass=_DesktopTypeEnumTypeWrapper): ...
    DESKTOP_TYPE_UNSPECIFIED: DesktopGroupConfiguration.DesktopType.ValueType  # 0
    PERSISTENT: DesktopGroupConfiguration.DesktopType.ValueType  # 1
    NON_PERSISTENT: DesktopGroupConfiguration.DesktopType.ValueType  # 2

    MIN_READY_DESKTOPS_FIELD_NUMBER: builtins.int
    MAX_DESKTOPS_AMOUNT_FIELD_NUMBER: builtins.int
    DESKTOP_TYPE_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    min_ready_desktops: builtins.int
    """Minimum number of ready desktops."""
    max_desktops_amount: builtins.int
    """Maximum number of desktops."""
    desktop_type: global___DesktopGroupConfiguration.DesktopType.ValueType
    """Type of the desktop."""
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.access.access_pb2.Subject]:
        """List of members of the desktop group."""

    def __init__(
        self,
        *,
        min_ready_desktops: builtins.int = ...,
        max_desktops_amount: builtins.int = ...,
        desktop_type: global___DesktopGroupConfiguration.DesktopType.ValueType = ...,
        members: collections.abc.Iterable[yandex.cloud.access.access_pb2.Subject] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_type", b"desktop_type", "max_desktops_amount", b"max_desktops_amount", "members", b"members", "min_ready_desktops", b"min_ready_desktops"]) -> None: ...

global___DesktopGroupConfiguration = DesktopGroupConfiguration

@typing.final
class ResourcesSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMORY_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    CORE_FRACTION_FIELD_NUMBER: builtins.int
    memory: builtins.int
    """RAM volume, in bytes."""
    cores: builtins.int
    """Number of CPU cores."""
    core_fraction: builtins.int
    """Baseline level of CPU performance with the ability to burst performance above that baseline level.
    This field sets baseline performance for each core.
    """
    def __init__(
        self,
        *,
        memory: builtins.int = ...,
        cores: builtins.int = ...,
        core_fraction: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["core_fraction", b"core_fraction", "cores", b"cores", "memory", b"memory"]) -> None: ...

global___ResourcesSpec = ResourcesSpec

@typing.final
class NetworkInterfaceSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    SUBNET_IDS_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """ID of the network interface specification."""
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of subnet IDs."""

    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkInterfaceSpec = NetworkInterfaceSpec

@typing.final
class ManualUpdatePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ManualUpdatePolicy = ManualUpdatePolicy

@typing.final
class AutoUpdatePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AutoUpdatePolicy = AutoUpdatePolicy
