"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.clouddesktop.v1.desktop_image_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ListDesktopImagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list desktop images in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDesktopImagesRequest.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDesktopImagesRequest.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [DesktopImage.name] field.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. Value or a list of values to compare against the values of the field.
    """
    order_by: builtins.str
    """Sorting the list by [DesktopImage.name], [DesktopImage.created_at] and [DesktopImage.status] fields.
    The default sorting order is ascending.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDesktopImagesRequest = ListDesktopImagesRequest

@typing.final
class ListDesktopImagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_IMAGES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDesktopImagesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListDesktopImagesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def desktop_images(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.clouddesktop.v1.desktop_image_pb2.DesktopImage]:
        """List of desktop images."""

    def __init__(
        self,
        *,
        desktop_images: collections.abc.Iterable[yandex.cloud.clouddesktop.v1.desktop_image_pb2.DesktopImage] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_images", b"desktop_images", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDesktopImagesResponse = ListDesktopImagesResponse

@typing.final
class CopyDesktopImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    IMAGE_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to copy the image to."""
    name: builtins.str
    """Name of the image."""
    image_id: builtins.str
    """ID of the compute image to copy the image from."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "image_id", b"image_id", "name", b"name"]) -> None: ...

global___CopyDesktopImageRequest = CopyDesktopImageRequest

@typing.final
class UpdateDesktopImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    IMAGE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """Id of image to update."""
    name: builtins.str
    """New desktop image name."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Mask of fields that need to be update."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New desktop image labels."""

    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDesktopImageRequest = UpdateDesktopImageRequest

@typing.final
class CopyFromDesktopRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESKTOP_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to copy the image to."""
    name: builtins.str
    """Name of the image."""
    desktop_id: builtins.str
    """ID of the desktop to copy the image from."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        desktop_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_id", b"desktop_id", "folder_id", b"folder_id", "name", b"name"]) -> None: ...

global___CopyFromDesktopRequest = CopyFromDesktopRequest

@typing.final
class CopyDesktopImageMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the new image."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___CopyDesktopImageMetadata = CopyDesktopImageMetadata

@typing.final
class CopyFromDesktopMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the new image."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___CopyFromDesktopMetadata = CopyFromDesktopMetadata

@typing.final
class DeleteDesktopImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the image to delete."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___DeleteDesktopImageRequest = DeleteDesktopImageRequest

@typing.final
class DeleteDesktopImageMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the image to delete."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___DeleteDesktopImageMetadata = DeleteDesktopImageMetadata

@typing.final
class GetDesktopImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the image to get."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___GetDesktopImageRequest = GetDesktopImageRequest

@typing.final
class UpdateDesktopImageMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___UpdateDesktopImageMetadata = UpdateDesktopImageMetadata
