"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.compute.v1.hardware_generation_pb2
import yandex.cloud.compute.v1.kek_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Disk(google.protobuf.message.Message):
    """A Disk resource. For more information, see [Disks](/docs/compute/concepts/disk)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Disk._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Disk._Status.ValueType  # 0
        CREATING: Disk._Status.ValueType  # 1
        """Disk is being created."""
        READY: Disk._Status.ValueType  # 2
        """Disk is ready to use."""
        ERROR: Disk._Status.ValueType  # 3
        """Disk encountered a problem and cannot operate."""
        DELETING: Disk._Status.ValueType  # 4
        """Disk is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Disk.Status.ValueType  # 0
    CREATING: Disk.Status.ValueType  # 1
    """Disk is being created."""
    READY: Disk.Status.ValueType  # 2
    """Disk is ready to use."""
    ERROR: Disk.Status.ValueType  # 3
    """Disk encountered a problem and cannot operate."""
    DELETING: Disk.Status.ValueType  # 4
    """Disk is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TYPE_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    BLOCK_SIZE_FIELD_NUMBER: builtins.int
    PRODUCT_IDS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SOURCE_IMAGE_ID_FIELD_NUMBER: builtins.int
    SOURCE_SNAPSHOT_ID_FIELD_NUMBER: builtins.int
    INSTANCE_IDS_FIELD_NUMBER: builtins.int
    DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    HARDWARE_GENERATION_FIELD_NUMBER: builtins.int
    KMS_KEY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the disk."""
    folder_id: builtins.str
    """ID of the folder that the disk belongs to."""
    name: builtins.str
    """Name of the disk. 1-63 characters long."""
    description: builtins.str
    """Description of the disk. 0-256 characters long."""
    type_id: builtins.str
    """ID of the disk type."""
    zone_id: builtins.str
    """ID of the availability zone where the disk resides."""
    size: builtins.int
    """Size of the disk, specified in bytes."""
    block_size: builtins.int
    """Block size of the disk, specified in bytes."""
    status: global___Disk.Status.ValueType
    """Current status of the disk."""
    source_image_id: builtins.str
    """ID of the image that was used for disk creation."""
    source_snapshot_id: builtins.str
    """ID of the snapshot that was used for disk creation."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def product_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """License IDs that indicate which licenses are attached to this resource.
        License IDs are used to calculate additional charges for the use of the virtual machine.

        The correct license ID is generated by the platform. IDs are inherited by new resources created from this resource.

        If you know the license IDs, specify them when you create the image.
        For example, if you create a disk image using a third-party utility and load it into Object Storage, the license IDs will be lost.
        You can specify them in the [yandex.cloud.compute.v1.ImageService.Create] request.
        """

    @property
    def instance_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Array of instances to which the disk is attached."""

    @property
    def disk_placement_policy(self) -> global___DiskPlacementPolicy:
        """Placement policy configuration."""

    @property
    def hardware_generation(self) -> yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration:
        """If specified, forces the same HardwareGeneration features to be applied to the instance
        created using this disk as a boot one. Otherwise the current default will be used.
        """

    @property
    def kms_key(self) -> yandex.cloud.compute.v1.kek_pb2.KMSKey:
        """Key encryption key info."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        type_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        size: builtins.int = ...,
        block_size: builtins.int = ...,
        product_ids: collections.abc.Iterable[builtins.str] | None = ...,
        status: global___Disk.Status.ValueType = ...,
        source_image_id: builtins.str = ...,
        source_snapshot_id: builtins.str = ...,
        instance_ids: collections.abc.Iterable[builtins.str] | None = ...,
        disk_placement_policy: global___DiskPlacementPolicy | None = ...,
        hardware_generation: yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration | None = ...,
        kms_key: yandex.cloud.compute.v1.kek_pb2.KMSKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "disk_placement_policy", b"disk_placement_policy", "hardware_generation", b"hardware_generation", "kms_key", b"kms_key", "source", b"source", "source_image_id", b"source_image_id", "source_snapshot_id", b"source_snapshot_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["block_size", b"block_size", "created_at", b"created_at", "description", b"description", "disk_placement_policy", b"disk_placement_policy", "folder_id", b"folder_id", "hardware_generation", b"hardware_generation", "id", b"id", "instance_ids", b"instance_ids", "kms_key", b"kms_key", "labels", b"labels", "name", b"name", "product_ids", b"product_ids", "size", b"size", "source", b"source", "source_image_id", b"source_image_id", "source_snapshot_id", b"source_snapshot_id", "status", b"status", "type_id", b"type_id", "zone_id", b"zone_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["source_image_id", "source_snapshot_id"] | None: ...

global___Disk = Disk

@typing.final
class DiskPlacementPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_PARTITION_FIELD_NUMBER: builtins.int
    placement_group_id: builtins.str
    """Placement group ID."""
    placement_group_partition: builtins.int
    def __init__(
        self,
        *,
        placement_group_id: builtins.str = ...,
        placement_group_partition: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["placement_group_id", b"placement_group_id", "placement_group_partition", b"placement_group_partition"]) -> None: ...

global___DiskPlacementPolicy = DiskPlacementPolicy

@typing.final
class DiskPlacementPolicyChange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """Disk ID."""
    @property
    def disk_placement_policy(self) -> global___DiskPlacementPolicy:
        """Placement policy configuration for given disk."""

    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        disk_placement_policy: global___DiskPlacementPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_placement_policy", b"disk_placement_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id", "disk_placement_policy", b"disk_placement_policy"]) -> None: ...

global___DiskPlacementPolicyChange = DiskPlacementPolicyChange
