"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.compute.v1.disk_pb2
import yandex.cloud.compute.v1.hardware_generation_pb2
import yandex.cloud.compute.v1.snapshot_schedule_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the Disk resource to return.
    To get the disk ID use a [DiskService.List] request.
    """
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id"]) -> None: ...

global___GetDiskRequest = GetDiskRequest

@typing.final
class ListDisksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list disks in.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDisksResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDisksResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    The default sorting order is ascending
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDisksRequest = ListDisksRequest

@typing.final
class ListDisksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISKS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDisksRequest.page_size], use
    the [next_page_token] as the value
    for the [ListDisksRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.disk_pb2.Disk]:
        """List of Disk resources."""

    def __init__(
        self,
        *,
        disks: collections.abc.Iterable[yandex.cloud.compute.v1.disk_pb2.Disk] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disks", b"disks", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDisksResponse = ListDisksResponse

@typing.final
class CreateDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TYPE_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    IMAGE_ID_FIELD_NUMBER: builtins.int
    SNAPSHOT_ID_FIELD_NUMBER: builtins.int
    BLOCK_SIZE_FIELD_NUMBER: builtins.int
    DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    SNAPSHOT_SCHEDULE_IDS_FIELD_NUMBER: builtins.int
    HARDWARE_GENERATION_FIELD_NUMBER: builtins.int
    KMS_KEY_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a disk in.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the disk."""
    description: builtins.str
    """Description of the disk."""
    type_id: builtins.str
    """ID of the disk type.
    To get a list of available disk types use the [yandex.cloud.compute.v1.DiskTypeService.List] request.
    """
    zone_id: builtins.str
    """ID of the availability zone where the disk resides.
    To get a list of available zones use the [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    size: builtins.int
    """Size of the disk, specified in bytes.
    If the disk was created from a image, this value should be more than the
    [yandex.cloud.compute.v1.Image.min_disk_size] value.
    """
    image_id: builtins.str
    """ID of the image to create the disk from."""
    snapshot_id: builtins.str
    """ID of the snapshot to restore the disk from."""
    block_size: builtins.int
    """Block size used for disk, specified in bytes. The default is 4096."""
    kms_key_id: builtins.str
    """ID of KMS key for disk encryption."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def disk_placement_policy(self) -> yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy:
        """Placement policy configuration."""

    @property
    def snapshot_schedule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of IDs of the snapshot schedules to attach the disk to."""

    @property
    def hardware_generation(self) -> yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration:
        """Specify the overrides to hardware_generation of a source disk, image or snapshot,
        or to the default values if the source does not define it.
        """

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        type_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        size: builtins.int = ...,
        image_id: builtins.str = ...,
        snapshot_id: builtins.str = ...,
        block_size: builtins.int = ...,
        disk_placement_policy: yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy | None = ...,
        snapshot_schedule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        hardware_generation: yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration | None = ...,
        kms_key_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_placement_policy", b"disk_placement_policy", "hardware_generation", b"hardware_generation", "image_id", b"image_id", "snapshot_id", b"snapshot_id", "source", b"source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["block_size", b"block_size", "description", b"description", "disk_placement_policy", b"disk_placement_policy", "folder_id", b"folder_id", "hardware_generation", b"hardware_generation", "image_id", b"image_id", "kms_key_id", b"kms_key_id", "labels", b"labels", "name", b"name", "size", b"size", "snapshot_id", b"snapshot_id", "snapshot_schedule_ids", b"snapshot_schedule_ids", "source", b"source", "type_id", b"type_id", "zone_id", b"zone_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["image_id", "snapshot_id"] | None: ...

global___CreateDiskRequest = CreateDiskRequest

@typing.final
class CreateDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk that is being created."""
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id"]) -> None: ...

global___CreateDiskMetadata = CreateDiskMetadata

@typing.final
class UpdateDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DISK_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the Disk resource to update.
    To get the disk ID use a [DiskService.List] request.
    """
    name: builtins.str
    """Name of the disk."""
    description: builtins.str
    """Description of the disk."""
    size: builtins.int
    """Size of the disk, specified in bytes."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Disk resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        Existing set of `labels` is completely replaced by the provided set.
        """

    @property
    def disk_placement_policy(self) -> yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy:
        """Placement policy configuration."""

    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        size: builtins.int = ...,
        disk_placement_policy: yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_placement_policy", b"disk_placement_policy", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "disk_id", b"disk_id", "disk_placement_policy", b"disk_placement_policy", "labels", b"labels", "name", b"name", "size", b"size", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDiskRequest = UpdateDiskRequest

@typing.final
class UpdateDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the Disk resource that is being updated."""
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id"]) -> None: ...

global___UpdateDiskMetadata = UpdateDiskMetadata

@typing.final
class DeleteDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk to delete.
    To get the disk ID use a [DiskService.List] request.
    """
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id"]) -> None: ...

global___DeleteDiskRequest = DeleteDiskRequest

@typing.final
class DeleteDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk that is being deleted."""
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id"]) -> None: ...

global___DeleteDiskMetadata = DeleteDiskMetadata

@typing.final
class ListDiskOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the Disk resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListDiskOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDiskOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDiskOperationsRequest = ListDiskOperationsRequest

@typing.final
class ListDiskOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDiskOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListDiskOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified disk."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListDiskOperationsResponse = ListDiskOperationsResponse

@typing.final
class MoveDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk to move.

    To get the disk ID, make a [DiskService.List] request.
    """
    destination_folder_id: builtins.str
    """ID of the folder to move the disk to.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "disk_id", b"disk_id"]) -> None: ...

global___MoveDiskRequest = MoveDiskRequest

@typing.final
class MoveDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk that is being moved."""
    source_folder_id: builtins.str
    """ID of the folder that the disk is being moved from."""
    destination_folder_id: builtins.str
    """ID of the folder that the disk is being moved to."""
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "disk_id", b"disk_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveDiskMetadata = MoveDiskMetadata

@typing.final
class RelocateDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    DESTINATION_ZONE_ID_FIELD_NUMBER: builtins.int
    DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk to move.

    To get the disk ID, make a [DiskService.List] request.
    """
    destination_zone_id: builtins.str
    """ID of the availability zone to move the disk to.

    To get the zone ID, make a [ZoneService.List] request.
    """
    @property
    def disk_placement_policy(self) -> yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy:
        """Placement policy configuration in target zone. Must be specified if disk has placement policy."""

    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        destination_zone_id: builtins.str = ...,
        disk_placement_policy: yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_placement_policy", b"disk_placement_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination_zone_id", b"destination_zone_id", "disk_id", b"disk_id", "disk_placement_policy", b"disk_placement_policy"]) -> None: ...

global___RelocateDiskRequest = RelocateDiskRequest

@typing.final
class RelocateDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    SOURCE_ZONE_ID_FIELD_NUMBER: builtins.int
    DESTINATION_ZONE_ID_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk that is being moved."""
    source_zone_id: builtins.str
    """ID of the availability zone that the disk is being moved from."""
    destination_zone_id: builtins.str
    """ID of the availability zone that the disk is being moved to."""
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        source_zone_id: builtins.str = ...,
        destination_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_zone_id", b"destination_zone_id", "disk_id", b"disk_id", "source_zone_id", b"source_zone_id"]) -> None: ...

global___RelocateDiskMetadata = RelocateDiskMetadata

@typing.final
class ListDiskSnapshotSchedulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    disk_id: builtins.str
    """ID of the disk to list snapshot schedules for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListDiskSnapshotSchedulesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListDiskSnapshotSchedulesResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        disk_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDiskSnapshotSchedulesRequest = ListDiskSnapshotSchedulesRequest

@typing.final
class ListDiskSnapshotSchedulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListDiskSnapshotSchedulesRequest.page_size], use `next_page_token` as the value
    for the [ListDiskSnapshotSchedulesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def snapshot_schedules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule]:
        """List of snapshot schedules the specified disk is attached to."""

    def __init__(
        self,
        *,
        snapshot_schedules: collections.abc.Iterable[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "snapshot_schedules", b"snapshot_schedules"]) -> None: ...

global___ListDiskSnapshotSchedulesResponse = ListDiskSnapshotSchedulesResponse
