"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.compute.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class HostGroup(google.protobuf.message.Message):
    """Represents group of dedicated hosts"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HostGroup._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: HostGroup._Status.ValueType  # 0
        CREATING: HostGroup._Status.ValueType  # 1
        READY: HostGroup._Status.ValueType  # 2
        UPDATING: HostGroup._Status.ValueType  # 3
        DELETING: HostGroup._Status.ValueType  # 4

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: HostGroup.Status.ValueType  # 0
    CREATING: HostGroup.Status.ValueType  # 1
    READY: HostGroup.Status.ValueType  # 2
    UPDATING: HostGroup.Status.ValueType  # 3
    DELETING: HostGroup.Status.ValueType  # 4

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TYPE_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_POLICY_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the group."""
    folder_id: builtins.str
    """ID of the folder that the group belongs to."""
    name: builtins.str
    """Name of the group. The name is unique within the folder."""
    description: builtins.str
    """Description of the group."""
    zone_id: builtins.str
    """Availability zone where all dedicated hosts are allocated."""
    status: global___HostGroup.Status.ValueType
    """Status of the group."""
    type_id: builtins.str
    """ID of host type. Resources provided by each host of the group."""
    maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType
    """Behaviour on maintenance events."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def scale_policy(self) -> global___ScalePolicy:
        """Scale policy. Only fixed number of hosts are supported at this moment."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
        status: global___HostGroup.Status.ValueType = ...,
        type_id: builtins.str = ...,
        maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType = ...,
        scale_policy: global___ScalePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "maintenance_policy", b"maintenance_policy", "name", b"name", "scale_policy", b"scale_policy", "status", b"status", "type_id", b"type_id", "zone_id", b"zone_id"]) -> None: ...

global___HostGroup = HostGroup

@typing.final
class Host(google.protobuf.message.Message):
    """Represents a dedicated host"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Host._Status.ValueType  # 0
        UP: Host._Status.ValueType  # 1
        DOWN: Host._Status.ValueType  # 2

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Host.Status.ValueType  # 0
    UP: Host.Status.ValueType  # 1
    DOWN: Host.Status.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SERVER_ID_FIELD_NUMBER: builtins.int
    REPLACEMENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the host."""
    status: global___Host.Status.ValueType
    """Current status of the host. New instances are unable to start on host in DOWN status."""
    server_id: builtins.str
    """ID of the physical server that the host belongs to."""
    @property
    def replacement(self) -> global___Replacement:
        """Set temporarily if maintenance is planned for this host, and a new host was provided as a replacement."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: global___Host.Status.ValueType = ...,
        server_id: builtins.str = ...,
        replacement: global___Replacement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["replacement", b"replacement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "replacement", b"replacement", "server_id", b"server_id", "status", b"status"]) -> None: ...

global___Host = Host

@typing.final
class ScalePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FixedScale(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_FIELD_NUMBER: builtins.int
        size: builtins.int
        def __init__(
            self,
            *,
            size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

    FIXED_SCALE_FIELD_NUMBER: builtins.int
    @property
    def fixed_scale(self) -> global___ScalePolicy.FixedScale: ...
    def __init__(
        self,
        *,
        fixed_scale: global___ScalePolicy.FixedScale | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["scale_type", b"scale_type"]) -> typing.Literal["fixed_scale"] | None: ...

global___ScalePolicy = ScalePolicy

@typing.final
class Replacement(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_ID_FIELD_NUMBER: builtins.int
    DEADLINE_AT_FIELD_NUMBER: builtins.int
    host_id: builtins.str
    """ID of the host which replaces this one."""
    @property
    def deadline_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date and time when this host will be automatically freed of instances."""

    def __init__(
        self,
        *,
        host_id: builtins.str = ...,
        deadline_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deadline_at", b"deadline_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deadline_at", b"deadline_at", "host_id", b"host_id"]) -> None: ...

global___Replacement = Replacement
