"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.compute.v1.hardware_generation_pb2
import yandex.cloud.compute.v1.kek_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Image(google.protobuf.message.Message):
    """An Image resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Image._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Image._Status.ValueType  # 0
        CREATING: Image._Status.ValueType  # 1
        """Image is being created."""
        READY: Image._Status.ValueType  # 2
        """Image is ready to use."""
        ERROR: Image._Status.ValueType  # 3
        """Image encountered a problem and cannot operate."""
        DELETING: Image._Status.ValueType  # 4
        """Image is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Image.Status.ValueType  # 0
    CREATING: Image.Status.ValueType  # 1
    """Image is being created."""
    READY: Image.Status.ValueType  # 2
    """Image is ready to use."""
    ERROR: Image.Status.ValueType  # 3
    """Image encountered a problem and cannot operate."""
    DELETING: Image.Status.ValueType  # 4
    """Image is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    FAMILY_FIELD_NUMBER: builtins.int
    STORAGE_SIZE_FIELD_NUMBER: builtins.int
    MIN_DISK_SIZE_FIELD_NUMBER: builtins.int
    PRODUCT_IDS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    OS_FIELD_NUMBER: builtins.int
    POOLED_FIELD_NUMBER: builtins.int
    HARDWARE_GENERATION_FIELD_NUMBER: builtins.int
    KMS_KEY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the image."""
    folder_id: builtins.str
    """ID of the folder that the image belongs to."""
    name: builtins.str
    """Name of the image. 1-63 characters long."""
    description: builtins.str
    """Description of the image. 0-256 characters long."""
    family: builtins.str
    """The name of the image family to which this image belongs.

    You can get the most recent image from a family by using
    the [yandex.cloud.compute.v1.ImageService.GetLatestByFamily] request
    and create the disk from this image.
    """
    storage_size: builtins.int
    """The size of the image, specified in bytes."""
    min_disk_size: builtins.int
    """Minimum size of the disk which will be created from this image."""
    status: global___Image.Status.ValueType
    """Current status of the image."""
    pooled: builtins.bool
    """When true, indicates there is an image pool for fast creation disks from the image."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def product_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """License IDs that indicate which licenses are attached to this resource.
        License IDs are used to calculate additional charges for the use of the virtual machine.

        The correct license ID is generated by the platform. IDs are inherited by new resources created from this resource.

        If you know the license IDs, specify them when you create the image.
        For example, if you create a disk image using a third-party utility and load it into Object Storage, the license IDs will be lost.
        You can specify them in the [yandex.cloud.compute.v1.ImageService.Create] request.
        """

    @property
    def os(self) -> global___Os:
        """Operating system that is contained in the image."""

    @property
    def hardware_generation(self) -> yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration:
        """If specified, forces the same HardwareGeneration features to be applied to the instance
        created using this image as a source for the boot disk. Otherwise the current default will be used.
        """

    @property
    def kms_key(self) -> yandex.cloud.compute.v1.kek_pb2.KMSKey:
        """Key encryption key info."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        family: builtins.str = ...,
        storage_size: builtins.int = ...,
        min_disk_size: builtins.int = ...,
        product_ids: collections.abc.Iterable[builtins.str] | None = ...,
        status: global___Image.Status.ValueType = ...,
        os: global___Os | None = ...,
        pooled: builtins.bool = ...,
        hardware_generation: yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration | None = ...,
        kms_key: yandex.cloud.compute.v1.kek_pb2.KMSKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "hardware_generation", b"hardware_generation", "kms_key", b"kms_key", "os", b"os"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "family", b"family", "folder_id", b"folder_id", "hardware_generation", b"hardware_generation", "id", b"id", "kms_key", b"kms_key", "labels", b"labels", "min_disk_size", b"min_disk_size", "name", b"name", "os", b"os", "pooled", b"pooled", "product_ids", b"product_ids", "status", b"status", "storage_size", b"storage_size"]) -> None: ...

global___Image = Image

@typing.final
class Os(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Os._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Os._Type.ValueType  # 0
        LINUX: Os._Type.ValueType  # 1
        """Linux operating system."""
        WINDOWS: Os._Type.ValueType  # 2
        """Windows operating system."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Os.Type.ValueType  # 0
    LINUX: Os.Type.ValueType  # 1
    """Linux operating system."""
    WINDOWS: Os.Type.ValueType  # 2
    """Windows operating system."""

    TYPE_FIELD_NUMBER: builtins.int
    type: global___Os.Type.ValueType
    """Operating system type. The default is `LINUX`.

    This field is used to correctly emulate a vCPU and calculate the cost of using an instance.
    """
    def __init__(
        self,
        *,
        type: global___Os.Type.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["type", b"type"]) -> None: ...

global___Os = Os
