"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.compute.v1.hardware_generation_pb2
import yandex.cloud.compute.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _IpVersion:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IpVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IpVersion.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IP_VERSION_UNSPECIFIED: _IpVersion.ValueType  # 0
    IPV4: _IpVersion.ValueType  # 1
    """IPv4 address, for example 192.0.2.235."""
    IPV6: _IpVersion.ValueType  # 2
    """IPv6 address. Not available yet."""

class IpVersion(_IpVersion, metaclass=_IpVersionEnumTypeWrapper): ...

IP_VERSION_UNSPECIFIED: IpVersion.ValueType  # 0
IPV4: IpVersion.ValueType  # 1
"""IPv4 address, for example 192.0.2.235."""
IPV6: IpVersion.ValueType  # 2
"""IPv6 address. Not available yet."""
global___IpVersion = IpVersion

class _MetadataOption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetadataOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetadataOption.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METADATA_OPTION_UNSPECIFIED: _MetadataOption.ValueType  # 0
    ENABLED: _MetadataOption.ValueType  # 1
    """Option is enabled"""
    DISABLED: _MetadataOption.ValueType  # 2
    """Option is disabled"""

class MetadataOption(_MetadataOption, metaclass=_MetadataOptionEnumTypeWrapper): ...

METADATA_OPTION_UNSPECIFIED: MetadataOption.ValueType  # 0
ENABLED: MetadataOption.ValueType  # 1
"""Option is enabled"""
DISABLED: MetadataOption.ValueType  # 2
"""Option is disabled"""
global___MetadataOption = MetadataOption

@typing.final
class Instance(google.protobuf.message.Message):
    """An Instance resource. For more information, see [Instances](/docs/compute/concepts/vm)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Instance._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Instance._Status.ValueType  # 0
        PROVISIONING: Instance._Status.ValueType  # 1
        """Instance is waiting for resources to be allocated."""
        RUNNING: Instance._Status.ValueType  # 2
        """Instance is running normally."""
        STOPPING: Instance._Status.ValueType  # 3
        """Instance is being stopped."""
        STOPPED: Instance._Status.ValueType  # 4
        """Instance stopped."""
        STARTING: Instance._Status.ValueType  # 5
        """Instance is being started."""
        RESTARTING: Instance._Status.ValueType  # 6
        """Instance is being restarted."""
        UPDATING: Instance._Status.ValueType  # 7
        """Instance is being updated."""
        ERROR: Instance._Status.ValueType  # 8
        """Instance encountered a problem and cannot operate."""
        CRASHED: Instance._Status.ValueType  # 9
        """Instance crashed and will be restarted automatically."""
        DELETING: Instance._Status.ValueType  # 10
        """Instance is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Instance.Status.ValueType  # 0
    PROVISIONING: Instance.Status.ValueType  # 1
    """Instance is waiting for resources to be allocated."""
    RUNNING: Instance.Status.ValueType  # 2
    """Instance is running normally."""
    STOPPING: Instance.Status.ValueType  # 3
    """Instance is being stopped."""
    STOPPED: Instance.Status.ValueType  # 4
    """Instance stopped."""
    STARTING: Instance.Status.ValueType  # 5
    """Instance is being started."""
    RESTARTING: Instance.Status.ValueType  # 6
    """Instance is being restarted."""
    UPDATING: Instance.Status.ValueType  # 7
    """Instance is being updated."""
    ERROR: Instance.Status.ValueType  # 8
    """Instance encountered a problem and cannot operate."""
    CRASHED: Instance.Status.ValueType  # 9
    """Instance crashed and will be restarted automatically."""
    DELETING: Instance.Status.ValueType  # 10
    """Instance is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    PLATFORM_ID_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    METADATA_OPTIONS_FIELD_NUMBER: builtins.int
    BOOT_DISK_FIELD_NUMBER: builtins.int
    SECONDARY_DISKS_FIELD_NUMBER: builtins.int
    LOCAL_DISKS_FIELD_NUMBER: builtins.int
    FILESYSTEMS_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACES_FIELD_NUMBER: builtins.int
    SERIAL_PORT_SETTINGS_FIELD_NUMBER: builtins.int
    GPU_SETTINGS_FIELD_NUMBER: builtins.int
    FQDN_FIELD_NUMBER: builtins.int
    SCHEDULING_POLICY_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    NETWORK_SETTINGS_FIELD_NUMBER: builtins.int
    PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    HOST_GROUP_ID_FIELD_NUMBER: builtins.int
    HOST_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_POLICY_FIELD_NUMBER: builtins.int
    MAINTENANCE_GRACE_PERIOD_FIELD_NUMBER: builtins.int
    HARDWARE_GENERATION_FIELD_NUMBER: builtins.int
    RESERVED_INSTANCE_POOL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the instance."""
    folder_id: builtins.str
    """ID of the folder that the instance belongs to."""
    name: builtins.str
    """Name of the instance. 1-63 characters long."""
    description: builtins.str
    """Description of the instance. 0-256 characters long."""
    zone_id: builtins.str
    """ID of the availability zone where the instance resides."""
    platform_id: builtins.str
    """ID of the hardware platform configuration for the instance."""
    status: global___Instance.Status.ValueType
    """Status of the instance."""
    fqdn: builtins.str
    """A domain name of the instance. FQDN is defined by the server
    in the format `<hostname>.<region_id>.internal` when the instance is created.
    If the hostname were not specified when the instance was created, FQDN would be `<id>.auto.internal`.
    output only
    """
    service_account_id: builtins.str
    """ID of the service account to use for [authentication inside the instance](/docs/compute/operations/vm-connect/auth-inside-vm).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    host_group_id: builtins.str
    """ID of the dedicated host group that the instance belongs to."""
    host_id: builtins.str
    """ID of the dedicated host that the instance belongs to."""
    maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType
    """Behaviour on maintenance events"""
    reserved_instance_pool_id: builtins.str
    """ID of the reserved instance pool that the instance belongs to."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def resources(self) -> global___Resources:
        """Computing resources of the instance such as the amount of memory and number of cores."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata `key:value` pairs assigned to this instance. This includes custom metadata and predefined keys.

        For example, you may use the metadata in order to provide your public SSH key to the instance.
        For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
        """

    @property
    def metadata_options(self) -> global___MetadataOptions:
        """Options allow user to configure access to instance's metadata"""

    @property
    def boot_disk(self) -> global___AttachedDisk:
        """Boot disk that is attached to the instance."""

    @property
    def secondary_disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedDisk]:
        """Array of secondary disks that are attached to the instance."""

    @property
    def local_disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedLocalDisk]:
        """Array of local disks that are attached to the instance."""

    @property
    def filesystems(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedFilesystem]:
        """Array of filesystems that are attached to the instance."""

    @property
    def network_interfaces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterface]:
        """Array of network interfaces that are attached to the instance."""

    @property
    def serial_port_settings(self) -> global___SerialPortSettings:
        """Serial port settings"""

    @property
    def gpu_settings(self) -> global___GpuSettings:
        """GPU settings"""

    @property
    def scheduling_policy(self) -> global___SchedulingPolicy:
        """Scheduling policy configuration."""

    @property
    def network_settings(self) -> global___NetworkSettings:
        """Network Settings"""

    @property
    def placement_policy(self) -> global___PlacementPolicy:
        """Placement policy configuration."""

    @property
    def maintenance_grace_period(self) -> google.protobuf.duration_pb2.Duration:
        """Time between notification via metadata service and maintenance"""

    @property
    def hardware_generation(self) -> yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration:
        """This feature set is inherited from the image/disk used as a boot one at the creation of the instance."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
        platform_id: builtins.str = ...,
        resources: global___Resources | None = ...,
        status: global___Instance.Status.ValueType = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        metadata_options: global___MetadataOptions | None = ...,
        boot_disk: global___AttachedDisk | None = ...,
        secondary_disks: collections.abc.Iterable[global___AttachedDisk] | None = ...,
        local_disks: collections.abc.Iterable[global___AttachedLocalDisk] | None = ...,
        filesystems: collections.abc.Iterable[global___AttachedFilesystem] | None = ...,
        network_interfaces: collections.abc.Iterable[global___NetworkInterface] | None = ...,
        serial_port_settings: global___SerialPortSettings | None = ...,
        gpu_settings: global___GpuSettings | None = ...,
        fqdn: builtins.str = ...,
        scheduling_policy: global___SchedulingPolicy | None = ...,
        service_account_id: builtins.str = ...,
        network_settings: global___NetworkSettings | None = ...,
        placement_policy: global___PlacementPolicy | None = ...,
        host_group_id: builtins.str = ...,
        host_id: builtins.str = ...,
        maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType = ...,
        maintenance_grace_period: google.protobuf.duration_pb2.Duration | None = ...,
        hardware_generation: yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration | None = ...,
        reserved_instance_pool_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boot_disk", b"boot_disk", "created_at", b"created_at", "gpu_settings", b"gpu_settings", "hardware_generation", b"hardware_generation", "maintenance_grace_period", b"maintenance_grace_period", "metadata_options", b"metadata_options", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "resources", b"resources", "scheduling_policy", b"scheduling_policy", "serial_port_settings", b"serial_port_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boot_disk", b"boot_disk", "created_at", b"created_at", "description", b"description", "filesystems", b"filesystems", "folder_id", b"folder_id", "fqdn", b"fqdn", "gpu_settings", b"gpu_settings", "hardware_generation", b"hardware_generation", "host_group_id", b"host_group_id", "host_id", b"host_id", "id", b"id", "labels", b"labels", "local_disks", b"local_disks", "maintenance_grace_period", b"maintenance_grace_period", "maintenance_policy", b"maintenance_policy", "metadata", b"metadata", "metadata_options", b"metadata_options", "name", b"name", "network_interfaces", b"network_interfaces", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "platform_id", b"platform_id", "reserved_instance_pool_id", b"reserved_instance_pool_id", "resources", b"resources", "scheduling_policy", b"scheduling_policy", "secondary_disks", b"secondary_disks", "serial_port_settings", b"serial_port_settings", "service_account_id", b"service_account_id", "status", b"status", "zone_id", b"zone_id"]) -> None: ...

global___Instance = Instance

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMORY_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    CORE_FRACTION_FIELD_NUMBER: builtins.int
    GPUS_FIELD_NUMBER: builtins.int
    memory: builtins.int
    """The amount of memory available to the instance, specified in bytes."""
    cores: builtins.int
    """The number of cores available to the instance."""
    core_fraction: builtins.int
    """Baseline level of CPU performance with the ability to burst performance above that baseline level.
    This field sets baseline performance for each core.
    """
    gpus: builtins.int
    """The number of GPUs available to the instance."""
    def __init__(
        self,
        *,
        memory: builtins.int = ...,
        cores: builtins.int = ...,
        core_fraction: builtins.int = ...,
        gpus: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["core_fraction", b"core_fraction", "cores", b"cores", "gpus", b"gpus", "memory", b"memory"]) -> None: ...

global___Resources = Resources

@typing.final
class AttachedDisk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedDisk._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedDisk._Mode.ValueType  # 0
        READ_ONLY: AttachedDisk._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedDisk._Mode.ValueType  # 2
        """Read/Write access."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedDisk.Mode.ValueType  # 0
    READ_ONLY: AttachedDisk.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedDisk.Mode.ValueType  # 2
    """Read/Write access."""

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    AUTO_DELETE_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    mode: global___AttachedDisk.Mode.ValueType
    """Access mode to the Disk resource."""
    device_name: builtins.str
    """Serial number that is reflected into the /dev/disk/by-id/ tree
    of a Linux operating system running within the instance.

    This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
    """
    auto_delete: builtins.bool
    """Specifies whether the disk will be auto-deleted when the instance is deleted."""
    disk_id: builtins.str
    """ID of the disk that is attached to the instance."""
    def __init__(
        self,
        *,
        mode: global___AttachedDisk.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        auto_delete: builtins.bool = ...,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["auto_delete", b"auto_delete", "device_name", b"device_name", "disk_id", b"disk_id", "mode", b"mode"]) -> None: ...

global___AttachedDisk = AttachedDisk

@typing.final
class AttachedLocalDisk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Size of the disk, specified in bytes."""
    device_name: builtins.str
    """Serial number that is reflected into the /dev/disk/by-id/ tree
    of a Linux operating system running within the instance.

    This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
    """
    def __init__(
        self,
        *,
        size: builtins.int = ...,
        device_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "size", b"size"]) -> None: ...

global___AttachedLocalDisk = AttachedLocalDisk

@typing.final
class AttachedFilesystem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedFilesystem._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedFilesystem._Mode.ValueType  # 0
        READ_ONLY: AttachedFilesystem._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedFilesystem._Mode.ValueType  # 2
        """Read/Write access."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedFilesystem.Mode.ValueType  # 0
    READ_ONLY: AttachedFilesystem.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedFilesystem.Mode.ValueType  # 2
    """Read/Write access."""

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    mode: global___AttachedFilesystem.Mode.ValueType
    """Access mode to the filesystem."""
    device_name: builtins.str
    """Name of the device representing the filesystem on the instance.

    The name should be used for referencing the filesystem from within the instance
    when it's being mounted, resized etc.
    """
    filesystem_id: builtins.str
    """ID of the filesystem that is attached to the instance."""
    def __init__(
        self,
        *,
        mode: global___AttachedFilesystem.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "filesystem_id", b"filesystem_id", "mode", b"mode"]) -> None: ...

global___AttachedFilesystem = AttachedFilesystem

@typing.final
class NetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INDEX_FIELD_NUMBER: builtins.int
    MAC_ADDRESS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_FIELD_NUMBER: builtins.int
    PRIMARY_V6_ADDRESS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    index: builtins.str
    """The index of the network interface, will be generated by the server, 0,1,2... etc if not specified."""
    mac_address: builtins.str
    """MAC address that is assigned to the network interface."""
    subnet_id: builtins.str
    """ID of the subnet."""
    @property
    def primary_v4_address(self) -> global___PrimaryAddress:
        """Primary IPv4 address that is assigned to the instance for this network interface."""

    @property
    def primary_v6_address(self) -> global___PrimaryAddress:
        """Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of security groups attached to the interface"""

    def __init__(
        self,
        *,
        index: builtins.str = ...,
        mac_address: builtins.str = ...,
        subnet_id: builtins.str = ...,
        primary_v4_address: global___PrimaryAddress | None = ...,
        primary_v6_address: global___PrimaryAddress | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address", b"primary_v4_address", "primary_v6_address", b"primary_v6_address"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["index", b"index", "mac_address", b"mac_address", "primary_v4_address", b"primary_v4_address", "primary_v6_address", b"primary_v6_address", "security_group_ids", b"security_group_ids", "subnet_id", b"subnet_id"]) -> None: ...

global___NetworkInterface = NetworkInterface

@typing.final
class PrimaryAddress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    ONE_TO_ONE_NAT_FIELD_NUMBER: builtins.int
    DNS_RECORDS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """An IPv4 internal network address that is assigned to the instance for this network interface."""
    @property
    def one_to_one_nat(self) -> global___OneToOneNat:
        """One-to-one NAT configuration. If missing, NAT has not been set up."""

    @property
    def dns_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecord]:
        """Internal DNS configuration"""

    def __init__(
        self,
        *,
        address: builtins.str = ...,
        one_to_one_nat: global___OneToOneNat | None = ...,
        dns_records: collections.abc.Iterable[global___DnsRecord] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_to_one_nat", b"one_to_one_nat"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_records", b"dns_records", "one_to_one_nat", b"one_to_one_nat"]) -> None: ...

global___PrimaryAddress = PrimaryAddress

@typing.final
class OneToOneNat(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    IP_VERSION_FIELD_NUMBER: builtins.int
    DNS_RECORDS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """An external IP address associated with this instance."""
    ip_version: global___IpVersion.ValueType
    """IP version for the external IP address."""
    @property
    def dns_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecord]:
        """External DNS configuration"""

    def __init__(
        self,
        *,
        address: builtins.str = ...,
        ip_version: global___IpVersion.ValueType = ...,
        dns_records: collections.abc.Iterable[global___DnsRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_records", b"dns_records", "ip_version", b"ip_version"]) -> None: ...

global___OneToOneNat = OneToOneNat

@typing.final
class DnsRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FQDN_FIELD_NUMBER: builtins.int
    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    PTR_FIELD_NUMBER: builtins.int
    fqdn: builtins.str
    """Name of the A/AAAA record as specified when creating the instance.
    Note that if `fqdn' has no trailing '.', it is specified relative to the zone (@see dns_zone_id).
    """
    dns_zone_id: builtins.str
    """DNS zone id for the record (optional, if not set, some private zone is used)."""
    ttl: builtins.int
    """DNS record ttl (optional, if not set, a reasonable default is used.)"""
    ptr: builtins.bool
    """When true, indicates there is a corresponding auto-created PTR DNS record."""
    def __init__(
        self,
        *,
        fqdn: builtins.str = ...,
        dns_zone_id: builtins.str = ...,
        ttl: builtins.int = ...,
        ptr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "fqdn", b"fqdn", "ptr", b"ptr", "ttl", b"ttl"]) -> None: ...

global___DnsRecord = DnsRecord

@typing.final
class SchedulingPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREEMPTIBLE_FIELD_NUMBER: builtins.int
    preemptible: builtins.bool
    """True for short-lived compute instances. For more information, see [Preemptible VMs](/docs/compute/concepts/preemptible-vm)."""
    def __init__(
        self,
        *,
        preemptible: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["preemptible", b"preemptible"]) -> None: ...

global___SchedulingPolicy = SchedulingPolicy

@typing.final
class NetworkSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NetworkSettings._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: NetworkSettings._Type.ValueType  # 0
        STANDARD: NetworkSettings._Type.ValueType  # 1
        """Standard network."""
        SOFTWARE_ACCELERATED: NetworkSettings._Type.ValueType  # 2
        """Software accelerated network."""
        HARDWARE_ACCELERATED: NetworkSettings._Type.ValueType  # 3
        """Hardware accelerated network (not available yet, reserved for future use)."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: NetworkSettings.Type.ValueType  # 0
    STANDARD: NetworkSettings.Type.ValueType  # 1
    """Standard network."""
    SOFTWARE_ACCELERATED: NetworkSettings.Type.ValueType  # 2
    """Software accelerated network."""
    HARDWARE_ACCELERATED: NetworkSettings.Type.ValueType  # 3
    """Hardware accelerated network (not available yet, reserved for future use)."""

    TYPE_FIELD_NUMBER: builtins.int
    type: global___NetworkSettings.Type.ValueType
    """Network Type"""
    def __init__(
        self,
        *,
        type: global___NetworkSettings.Type.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["type", b"type"]) -> None: ...

global___NetworkSettings = NetworkSettings

@typing.final
class GpuSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """Attach instance to specified GPU cluster."""
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___GpuSettings = GpuSettings

@typing.final
class PlacementPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HostAffinityRule(google.protobuf.message.Message):
        """Affinity definition"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Operator:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _OperatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PlacementPolicy.HostAffinityRule._Operator.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            OPERATOR_UNSPECIFIED: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 0
            IN: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 1
            NOT_IN: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 2

        class Operator(_Operator, metaclass=_OperatorEnumTypeWrapper): ...
        OPERATOR_UNSPECIFIED: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 0
        IN: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 1
        NOT_IN: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 2

        KEY_FIELD_NUMBER: builtins.int
        OP_FIELD_NUMBER: builtins.int
        VALUES_FIELD_NUMBER: builtins.int
        key: builtins.str
        """Affinity label or one of reserved values - 'yc.hostId', 'yc.hostGroupId'"""
        op: global___PlacementPolicy.HostAffinityRule.Operator.ValueType
        """Include or exclude action"""
        @property
        def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Affinity value or host ID or host group ID"""

        def __init__(
            self,
            *,
            key: builtins.str = ...,
            op: global___PlacementPolicy.HostAffinityRule.Operator.ValueType = ...,
            values: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "op", b"op", "values", b"values"]) -> None: ...

    PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    HOST_AFFINITY_RULES_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_PARTITION_FIELD_NUMBER: builtins.int
    placement_group_id: builtins.str
    """Placement group ID."""
    placement_group_partition: builtins.int
    """Placement group partition"""
    @property
    def host_affinity_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PlacementPolicy.HostAffinityRule]:
        """List of affinity rules. Scheduler will attempt to allocate instances according to order of rules."""

    def __init__(
        self,
        *,
        placement_group_id: builtins.str = ...,
        host_affinity_rules: collections.abc.Iterable[global___PlacementPolicy.HostAffinityRule] | None = ...,
        placement_group_partition: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["host_affinity_rules", b"host_affinity_rules", "placement_group_id", b"placement_group_id", "placement_group_partition", b"placement_group_partition"]) -> None: ...

global___PlacementPolicy = PlacementPolicy

@typing.final
class MetadataOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GCE_HTTP_ENDPOINT_FIELD_NUMBER: builtins.int
    AWS_V1_HTTP_ENDPOINT_FIELD_NUMBER: builtins.int
    GCE_HTTP_TOKEN_FIELD_NUMBER: builtins.int
    AWS_V1_HTTP_TOKEN_FIELD_NUMBER: builtins.int
    gce_http_endpoint: global___MetadataOption.ValueType
    """Enabled access to GCE flavored metadata"""
    aws_v1_http_endpoint: global___MetadataOption.ValueType
    """Enabled access to AWS flavored metadata (IMDSv1)"""
    gce_http_token: global___MetadataOption.ValueType
    """Enabled access to IAM credentials with GCE flavored metadata"""
    aws_v1_http_token: global___MetadataOption.ValueType
    """Enabled access to IAM credentials with AWS flavored metadata (IMDSv1)"""
    def __init__(
        self,
        *,
        gce_http_endpoint: global___MetadataOption.ValueType = ...,
        aws_v1_http_endpoint: global___MetadataOption.ValueType = ...,
        gce_http_token: global___MetadataOption.ValueType = ...,
        aws_v1_http_token: global___MetadataOption.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aws_v1_http_endpoint", b"aws_v1_http_endpoint", "aws_v1_http_token", b"aws_v1_http_token", "gce_http_endpoint", b"gce_http_endpoint", "gce_http_token", b"gce_http_token"]) -> None: ...

global___MetadataOptions = MetadataOptions

@typing.final
class SerialPortSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SSHAuthorization:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SSHAuthorizationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SerialPortSettings._SSHAuthorization.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SSH_AUTHORIZATION_UNSPECIFIED: SerialPortSettings._SSHAuthorization.ValueType  # 0
        INSTANCE_METADATA: SerialPortSettings._SSHAuthorization.ValueType  # 1
        """Authentication and authorization using SSH keys in instance metadata"""
        OS_LOGIN: SerialPortSettings._SSHAuthorization.ValueType  # 2
        """Authentication and authorization using Oslogin service"""

    class SSHAuthorization(_SSHAuthorization, metaclass=_SSHAuthorizationEnumTypeWrapper): ...
    SSH_AUTHORIZATION_UNSPECIFIED: SerialPortSettings.SSHAuthorization.ValueType  # 0
    INSTANCE_METADATA: SerialPortSettings.SSHAuthorization.ValueType  # 1
    """Authentication and authorization using SSH keys in instance metadata"""
    OS_LOGIN: SerialPortSettings.SSHAuthorization.ValueType  # 2
    """Authentication and authorization using Oslogin service"""

    SSH_AUTHORIZATION_FIELD_NUMBER: builtins.int
    ssh_authorization: global___SerialPortSettings.SSHAuthorization.ValueType
    """Authentication and authorization in serial console when using SSH protocol"""
    def __init__(
        self,
        *,
        ssh_authorization: global___SerialPortSettings.SSHAuthorization.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ssh_authorization", b"ssh_authorization"]) -> None: ...

global___SerialPortSettings = SerialPortSettings
