"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.compute.v1.disk_pb2
import yandex.cloud.compute.v1.instance_pb2
import yandex.cloud.compute.v1.maintenance_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _InstanceView:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstanceViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstanceView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BASIC: _InstanceView.ValueType  # 0
    """Doesn't include the metadata of the instance in the server response."""
    FULL: _InstanceView.ValueType  # 1
    """Returns the metadata of the instance in the server response."""

class InstanceView(_InstanceView, metaclass=_InstanceViewEnumTypeWrapper): ...

BASIC: InstanceView.ValueType  # 0
"""Doesn't include the metadata of the instance in the server response."""
FULL: InstanceView.ValueType  # 1
"""Returns the metadata of the instance in the server response."""
global___InstanceView = InstanceView

@typing.final
class GetInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the Instance resource to return.
    To get the instance ID, use a [InstanceService.List] request.
    """
    view: global___InstanceView.ValueType
    """Defines which information about the Instance resource should be returned in the server response."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        view: global___InstanceView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "view", b"view"]) -> None: ...

global___GetInstanceRequest = GetInstanceRequest

@typing.final
class ListInstancesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the Folder to list instances in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListInstancesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListInstancesResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    The default sorting order is ascending
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstancesRequest = ListInstancesRequest

@typing.final
class ListInstancesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListInstancesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListInstancesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instance_pb2.Instance]:
        """List of Instance resources."""

    def __init__(
        self,
        *,
        instances: collections.abc.Iterable[yandex.cloud.compute.v1.instance_pb2.Instance] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instances", b"instances", "next_page_token", b"next_page_token"]) -> None: ...

global___ListInstancesResponse = ListInstancesResponse

@typing.final
class CreateInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    PLATFORM_ID_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    METADATA_OPTIONS_FIELD_NUMBER: builtins.int
    BOOT_DISK_SPEC_FIELD_NUMBER: builtins.int
    SECONDARY_DISK_SPECS_FIELD_NUMBER: builtins.int
    LOCAL_DISK_SPECS_FIELD_NUMBER: builtins.int
    FILESYSTEM_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_SPECS_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    SCHEDULING_POLICY_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    NETWORK_SETTINGS_FIELD_NUMBER: builtins.int
    PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    GPU_SETTINGS_FIELD_NUMBER: builtins.int
    MAINTENANCE_POLICY_FIELD_NUMBER: builtins.int
    MAINTENANCE_GRACE_PERIOD_FIELD_NUMBER: builtins.int
    SERIAL_PORT_SETTINGS_FIELD_NUMBER: builtins.int
    RESERVED_INSTANCE_POOL_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an instance in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the instance."""
    description: builtins.str
    """Description of the instance."""
    zone_id: builtins.str
    """ID of the availability zone where the instance resides.
    To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request
    """
    platform_id: builtins.str
    """ID of the hardware platform configuration for the instance.
    This field affects the available values in [resources_spec] field.

    Platforms allows you to create various types of instances: with a large amount of memory,
    with a large number of cores, with a burstable performance.
    For more information, see [Platforms](/docs/compute/concepts/vm-platforms).
    """
    hostname: builtins.str
    """Host name for the instance.
    This field is used to generate the [yandex.cloud.compute.v1.Instance.fqdn] value.
    The host name must be unique within the network and region.
    If not specified, the host name will be equal to [yandex.cloud.compute.v1.Instance.id] of the instance
    and FQDN will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
    """
    service_account_id: builtins.str
    """ID of the service account to use for [authentication inside the instance](/docs/compute/operations/vm-connect/auth-inside-vm).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType
    """Behaviour on maintenance events"""
    reserved_instance_pool_id: builtins.str
    """ID of the reserved instance pool that the instance should belong to.
    Instance will be created using resources from the reserved instance pool.
    Reserved instance pool resource configuration must match the resource configuration of the instance.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def resources_spec(self) -> global___ResourcesSpec:
        """Computing resources of the instance, such as the amount of memory and number of cores.
        To get a list of available values, see [Levels of core performance](/docs/compute/concepts/performance-levels).
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata `key:value` pairs that will be assigned to this instance. This includes custom metadata and predefined keys.
        The total size of all keys and values must be less than 512 KB.

        Values are free-form strings, and only have meaning as interpreted by the programs which configure the instance.
        The values must be 256 KB or less.

        For example, you may use the metadata in order to provide your public SSH key to the instance.
        For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
        """

    @property
    def metadata_options(self) -> yandex.cloud.compute.v1.instance_pb2.MetadataOptions:
        """Options allow user to configure access to instance's metadata"""

    @property
    def boot_disk_spec(self) -> global___AttachedDiskSpec:
        """Boot disk to attach to the instance."""

    @property
    def secondary_disk_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedDiskSpec]:
        """Array of secondary disks to attach to the instance."""

    @property
    def local_disk_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedLocalDiskSpec]:
        """Array of local disks to attach to the instance."""

    @property
    def filesystem_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedFilesystemSpec]:
        """Array of filesystems to attach to the instance.

        The filesystems must reside in the same availability zone as the instance.

        To use the instance with an attached filesystem, the latter must be mounted.
        For details, see [documentation](/docs/compute/operations/filesystem/attach-to-vm).
        """

    @property
    def network_interface_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterfaceSpec]:
        """Network configuration for the instance. Specifies how the network interface is configured
        to interact with other services on the internal network and on the internet.
        """

    @property
    def scheduling_policy(self) -> yandex.cloud.compute.v1.instance_pb2.SchedulingPolicy:
        """Scheduling policy configuration."""

    @property
    def network_settings(self) -> yandex.cloud.compute.v1.instance_pb2.NetworkSettings:
        """Network settings."""

    @property
    def placement_policy(self) -> yandex.cloud.compute.v1.instance_pb2.PlacementPolicy:
        """Placement policy configuration."""

    @property
    def gpu_settings(self) -> yandex.cloud.compute.v1.instance_pb2.GpuSettings:
        """GPU settings."""

    @property
    def maintenance_grace_period(self) -> google.protobuf.duration_pb2.Duration:
        """Time between notification via metadata service and maintenance"""

    @property
    def serial_port_settings(self) -> yandex.cloud.compute.v1.instance_pb2.SerialPortSettings:
        """Serial port settings"""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
        platform_id: builtins.str = ...,
        resources_spec: global___ResourcesSpec | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        metadata_options: yandex.cloud.compute.v1.instance_pb2.MetadataOptions | None = ...,
        boot_disk_spec: global___AttachedDiskSpec | None = ...,
        secondary_disk_specs: collections.abc.Iterable[global___AttachedDiskSpec] | None = ...,
        local_disk_specs: collections.abc.Iterable[global___AttachedLocalDiskSpec] | None = ...,
        filesystem_specs: collections.abc.Iterable[global___AttachedFilesystemSpec] | None = ...,
        network_interface_specs: collections.abc.Iterable[global___NetworkInterfaceSpec] | None = ...,
        hostname: builtins.str = ...,
        scheduling_policy: yandex.cloud.compute.v1.instance_pb2.SchedulingPolicy | None = ...,
        service_account_id: builtins.str = ...,
        network_settings: yandex.cloud.compute.v1.instance_pb2.NetworkSettings | None = ...,
        placement_policy: yandex.cloud.compute.v1.instance_pb2.PlacementPolicy | None = ...,
        gpu_settings: yandex.cloud.compute.v1.instance_pb2.GpuSettings | None = ...,
        maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType = ...,
        maintenance_grace_period: google.protobuf.duration_pb2.Duration | None = ...,
        serial_port_settings: yandex.cloud.compute.v1.instance_pb2.SerialPortSettings | None = ...,
        reserved_instance_pool_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "gpu_settings", b"gpu_settings", "maintenance_grace_period", b"maintenance_grace_period", "metadata_options", b"metadata_options", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy", "serial_port_settings", b"serial_port_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "description", b"description", "filesystem_specs", b"filesystem_specs", "folder_id", b"folder_id", "gpu_settings", b"gpu_settings", "hostname", b"hostname", "labels", b"labels", "local_disk_specs", b"local_disk_specs", "maintenance_grace_period", b"maintenance_grace_period", "maintenance_policy", b"maintenance_policy", "metadata", b"metadata", "metadata_options", b"metadata_options", "name", b"name", "network_interface_specs", b"network_interface_specs", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "platform_id", b"platform_id", "reserved_instance_pool_id", b"reserved_instance_pool_id", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy", "secondary_disk_specs", b"secondary_disk_specs", "serial_port_settings", b"serial_port_settings", "service_account_id", b"service_account_id", "zone_id", b"zone_id"]) -> None: ...

global___CreateInstanceRequest = CreateInstanceRequest

@typing.final
class CreateInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being created."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___CreateInstanceMetadata = CreateInstanceMetadata

@typing.final
class UpdateInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PLATFORM_ID_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    METADATA_OPTIONS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    NETWORK_SETTINGS_FIELD_NUMBER: builtins.int
    PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    SCHEDULING_POLICY_FIELD_NUMBER: builtins.int
    MAINTENANCE_POLICY_FIELD_NUMBER: builtins.int
    MAINTENANCE_GRACE_PERIOD_FIELD_NUMBER: builtins.int
    SERIAL_PORT_SETTINGS_FIELD_NUMBER: builtins.int
    RESERVED_INSTANCE_POOL_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the Instance resource to update.
    To get the instance ID, use a [InstanceService.List] request.
    """
    name: builtins.str
    """Name of the instance."""
    description: builtins.str
    """Description of the instance."""
    platform_id: builtins.str
    """ID of the hardware platform configuration for the instance.
    This field affects the available values in [resources_spec] field.

    Platforms allows you to create various types of instances: with a large amount of memory,
    with a large number of cores, with a burstable performance.
    For more information, see [Platforms](/docs/compute/concepts/vm-platforms).
    """
    service_account_id: builtins.str
    """ID of the service account to use for [authentication inside the instance](/docs/compute/operations/vm-connect/auth-inside-vm).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType
    """Behaviour on maintenance events"""
    reserved_instance_pool_id: builtins.str
    """ID of the reserved instance pool that the instance should belong to.
    Attaching/detaching running instance will increase/decrease the size of the reserved instance pool.
    Attaching/detaching stopped instance will leave the size of the reserved instance pool unchanged. Starting such attached instance will use resources from the reserved instance pool.
    Reserved instance pool resource configuration must match the resource configuration of the instance.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Instance resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        Existing set of `labels` is completely replaced by the provided set.
        """

    @property
    def resources_spec(self) -> global___ResourcesSpec:
        """Computing resources of the instance, such as the amount of memory and number of cores.
        To get a list of available values, see [Levels of core performance](/docs/compute/concepts/performance-levels).
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata `key:value` pairs that will be assigned to this instance. This includes custom metadata and predefined keys.
        The total size of all keys and values must be less than 512 KB.

        Existing set of `metadata` is completely replaced by the provided set.

        Values are free-form strings, and only have meaning as interpreted by the programs which configure the instance.
        The values must be 256 KB or less.

        For example, you may use the metadata in order to provide your public SSH key to the instance.
        For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
        """

    @property
    def metadata_options(self) -> yandex.cloud.compute.v1.instance_pb2.MetadataOptions:
        """Options allow user to configure access to instance's metadata"""

    @property
    def network_settings(self) -> yandex.cloud.compute.v1.instance_pb2.NetworkSettings:
        """Network settings."""

    @property
    def placement_policy(self) -> yandex.cloud.compute.v1.instance_pb2.PlacementPolicy:
        """Placement policy configuration."""

    @property
    def scheduling_policy(self) -> yandex.cloud.compute.v1.instance_pb2.SchedulingPolicy:
        """Scheduling policy configuration."""

    @property
    def maintenance_grace_period(self) -> google.protobuf.duration_pb2.Duration:
        """Time between notification via metadata service and maintenance"""

    @property
    def serial_port_settings(self) -> yandex.cloud.compute.v1.instance_pb2.SerialPortSettings:
        """Serial port settings"""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        platform_id: builtins.str = ...,
        resources_spec: global___ResourcesSpec | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        metadata_options: yandex.cloud.compute.v1.instance_pb2.MetadataOptions | None = ...,
        service_account_id: builtins.str = ...,
        network_settings: yandex.cloud.compute.v1.instance_pb2.NetworkSettings | None = ...,
        placement_policy: yandex.cloud.compute.v1.instance_pb2.PlacementPolicy | None = ...,
        scheduling_policy: yandex.cloud.compute.v1.instance_pb2.SchedulingPolicy | None = ...,
        maintenance_policy: yandex.cloud.compute.v1.maintenance_pb2.MaintenancePolicy.ValueType = ...,
        maintenance_grace_period: google.protobuf.duration_pb2.Duration | None = ...,
        serial_port_settings: yandex.cloud.compute.v1.instance_pb2.SerialPortSettings | None = ...,
        reserved_instance_pool_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["maintenance_grace_period", b"maintenance_grace_period", "metadata_options", b"metadata_options", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy", "serial_port_settings", b"serial_port_settings", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "instance_id", b"instance_id", "labels", b"labels", "maintenance_grace_period", b"maintenance_grace_period", "maintenance_policy", b"maintenance_policy", "metadata", b"metadata", "metadata_options", b"metadata_options", "name", b"name", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "platform_id", b"platform_id", "reserved_instance_pool_id", b"reserved_instance_pool_id", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy", "serial_port_settings", b"serial_port_settings", "service_account_id", b"service_account_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateInstanceRequest = UpdateInstanceRequest

@typing.final
class UpdateInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the Instance resource that is being updated."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___UpdateInstanceMetadata = UpdateInstanceMetadata

@typing.final
class DeleteInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to delete.
    To get the instance ID, use a [InstanceService.List] request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___DeleteInstanceRequest = DeleteInstanceRequest

@typing.final
class DeleteInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being deleted."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___DeleteInstanceMetadata = DeleteInstanceMetadata

@typing.final
class UpdateInstanceMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class UpsertEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    UPSERT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being updated."""
    @property
    def delete(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of keys to be deleted."""

    @property
    def upsert(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata `key:value` pairs that will be added or updated to this instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        delete: collections.abc.Iterable[builtins.str] | None = ...,
        upsert: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["delete", b"delete", "instance_id", b"instance_id", "upsert", b"upsert"]) -> None: ...

global___UpdateInstanceMetadataRequest = UpdateInstanceMetadataRequest

@typing.final
class UpdateInstanceMetadataMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being updated."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___UpdateInstanceMetadataMetadata = UpdateInstanceMetadataMetadata

@typing.final
class GetInstanceSerialPortOutputRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to return the serial port output for."""
    port: builtins.int
    """Serial port to retrieve data from. The default is 1."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        port: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "port", b"port"]) -> None: ...

global___GetInstanceSerialPortOutputRequest = GetInstanceSerialPortOutputRequest

@typing.final
class GetInstanceSerialPortOutputResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENTS_FIELD_NUMBER: builtins.int
    contents: builtins.str
    """The contents of the serial port output, starting from the time when the instance
    started to boot.
    """
    def __init__(
        self,
        *,
        contents: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["contents", b"contents"]) -> None: ...

global___GetInstanceSerialPortOutputResponse = GetInstanceSerialPortOutputResponse

@typing.final
class StopInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to stop.
    To get the instance ID, use a [InstanceService.List] request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StopInstanceRequest = StopInstanceRequest

@typing.final
class StopInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being deleted."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StopInstanceMetadata = StopInstanceMetadata

@typing.final
class StartInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to start.
    To get the instance ID, use a [InstanceService.List] request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StartInstanceRequest = StartInstanceRequest

@typing.final
class StartInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StartInstanceMetadata = StartInstanceMetadata

@typing.final
class RestartInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to restart.
    To get the instance ID, use a [InstanceService.List] request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___RestartInstanceRequest = RestartInstanceRequest

@typing.final
class RestartInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___RestartInstanceMetadata = RestartInstanceMetadata

@typing.final
class AttachInstanceDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    ATTACHED_DISK_SPEC_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to attach the disk to.
    To get the instance ID, use a [InstanceService.List] request.
    """
    @property
    def attached_disk_spec(self) -> global___AttachedDiskSpec:
        """Disk that should be attached."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        attached_disk_spec: global___AttachedDiskSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attached_disk_spec", b"attached_disk_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attached_disk_spec", b"attached_disk_spec", "instance_id", b"instance_id"]) -> None: ...

global___AttachInstanceDiskRequest = AttachInstanceDiskRequest

@typing.final
class AttachInstanceDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    disk_id: builtins.str
    """ID of the disk."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id", "instance_id", b"instance_id"]) -> None: ...

global___AttachInstanceDiskMetadata = AttachInstanceDiskMetadata

@typing.final
class DetachInstanceDiskRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to detach the disk from.
    To get the instance ID, use a [InstanceService.List] request.
    """
    disk_id: builtins.str
    """ID of the disk that should be detached."""
    device_name: builtins.str
    """Serial number of the disk that should be detached. This value is reflected into the /dev/disk/by-id/ tree
    of a Linux operating system running within the instance.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        disk_id: builtins.str = ...,
        device_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["device_name", b"device_name", "disk", b"disk", "disk_id", b"disk_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "disk", b"disk", "disk_id", b"disk_id", "instance_id", b"instance_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["disk", b"disk"]) -> typing.Literal["disk_id", "device_name"] | None: ...

global___DetachInstanceDiskRequest = DetachInstanceDiskRequest

@typing.final
class DetachInstanceDiskMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    disk_id: builtins.str
    """ID of the disk."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_id", b"disk_id", "instance_id", b"instance_id"]) -> None: ...

global___DetachInstanceDiskMetadata = DetachInstanceDiskMetadata

@typing.final
class AttachInstanceFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    ATTACHED_FILESYSTEM_SPEC_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to attach the filesystem to.

    To get the instance ID, make a [InstanceService.List] request.
    """
    @property
    def attached_filesystem_spec(self) -> global___AttachedFilesystemSpec:
        """Filesystem to attach to the instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        attached_filesystem_spec: global___AttachedFilesystemSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attached_filesystem_spec", b"attached_filesystem_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attached_filesystem_spec", b"attached_filesystem_spec", "instance_id", b"instance_id"]) -> None: ...

global___AttachInstanceFilesystemRequest = AttachInstanceFilesystemRequest

@typing.final
class AttachInstanceFilesystemMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that the filesystem is being attached to."""
    filesystem_id: builtins.str
    """ID of the filesystem that is being attached to the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id", "instance_id", b"instance_id"]) -> None: ...

global___AttachInstanceFilesystemMetadata = AttachInstanceFilesystemMetadata

@typing.final
class DetachInstanceFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to detach the filesystem from.

    To get the instance ID, make a [InstanceService.List] request.
    """
    filesystem_id: builtins.str
    """ID of the filesystem that should be detached."""
    device_name: builtins.str
    """Name of the device used for mounting the filesystem that should be detached."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        filesystem_id: builtins.str = ...,
        device_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["device_name", b"device_name", "filesystem", b"filesystem", "filesystem_id", b"filesystem_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "filesystem", b"filesystem", "filesystem_id", b"filesystem_id", "instance_id", b"instance_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["filesystem", b"filesystem"]) -> typing.Literal["filesystem_id", "device_name"] | None: ...

global___DetachInstanceFilesystemRequest = DetachInstanceFilesystemRequest

@typing.final
class DetachInstanceFilesystemMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that the filesystem is being detached from."""
    filesystem_id: builtins.str
    """ID of the filesystem that is being detached from the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id", "instance_id", b"instance_id"]) -> None: ...

global___DetachInstanceFilesystemMetadata = DetachInstanceFilesystemMetadata

@typing.final
class AttachInstanceNetworkInterfaceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that in which network interface is being attached to."""
    network_interface_index: builtins.str
    """The index of the network interface"""
    subnet_id: builtins.str
    """ID of the subnet."""
    @property
    def primary_v4_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv4 address that will be assigned to the instance for this network interface."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of security groups attached to the interface."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
        subnet_id: builtins.str = ...,
        primary_v4_address_spec: global___PrimaryAddressSpec | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address_spec", b"primary_v4_address_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index", "primary_v4_address_spec", b"primary_v4_address_spec", "security_group_ids", b"security_group_ids", "subnet_id", b"subnet_id"]) -> None: ...

global___AttachInstanceNetworkInterfaceRequest = AttachInstanceNetworkInterfaceRequest

@typing.final
class AttachInstanceNetworkInterfaceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instant network interface that is being updated."""
    network_interface_index: builtins.str
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index"]) -> None: ...

global___AttachInstanceNetworkInterfaceMetadata = AttachInstanceNetworkInterfaceMetadata

@typing.final
class DetachInstanceNetworkInterfaceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that in which network interface is being attached to."""
    network_interface_index: builtins.str
    """The index of the network interface."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index"]) -> None: ...

global___DetachInstanceNetworkInterfaceRequest = DetachInstanceNetworkInterfaceRequest

@typing.final
class DetachInstanceNetworkInterfaceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instant network interface that is being updated."""
    network_interface_index: builtins.str
    """The index of the network interface."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index"]) -> None: ...

global___DetachInstanceNetworkInterfaceMetadata = DetachInstanceNetworkInterfaceMetadata

@typing.final
class AddInstanceOneToOneNatRequest(google.protobuf.message.Message):
    """Enables One-to-one NAT on the network interface."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    INTERNAL_ADDRESS_FIELD_NUMBER: builtins.int
    ONE_TO_ONE_NAT_SPEC_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to enable One-to-One NAT on."""
    network_interface_index: builtins.str
    """The index of the network interface to enable One-to-One NAT on."""
    internal_address: builtins.str
    """The network address that is assigned to the instance for this network interface.
    optional
    """
    @property
    def one_to_one_nat_spec(self) -> global___OneToOneNatSpec:
        """An external IP address configuration.
        If not specified, then this instance will have no external internet access.
        """

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
        internal_address: builtins.str = ...,
        one_to_one_nat_spec: global___OneToOneNatSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "internal_address", b"internal_address", "network_interface_index", b"network_interface_index", "one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> None: ...

global___AddInstanceOneToOneNatRequest = AddInstanceOneToOneNatRequest

@typing.final
class AddInstanceOneToOneNatMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___AddInstanceOneToOneNatMetadata = AddInstanceOneToOneNatMetadata

@typing.final
class RemoveInstanceOneToOneNatRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    INTERNAL_ADDRESS_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to remove One-to-one NAT."""
    network_interface_index: builtins.str
    """The index of the network interface to remove One-to-One NAT from."""
    internal_address: builtins.str
    """The network address that is assigned to the instance for this network interface.
    optional
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
        internal_address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "internal_address", b"internal_address", "network_interface_index", b"network_interface_index"]) -> None: ...

global___RemoveInstanceOneToOneNatRequest = RemoveInstanceOneToOneNatRequest

@typing.final
class RemoveInstanceOneToOneNatMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___RemoveInstanceOneToOneNatMetadata = RemoveInstanceOneToOneNatMetadata

@typing.final
class UpdateInstanceNetworkInterfaceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    PRIMARY_V6_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being updated."""
    network_interface_index: builtins.str
    """The index of the network interface to be updated."""
    subnet_id: builtins.str
    """ID of the subnet."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the instance should be updated."""

    @property
    def primary_v4_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv4 address that will be assigned to the instance for this network interface."""

    @property
    def primary_v6_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv6 address that will be assigned to the instance for this network interface. IPv6 not available yet."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of security groups attached to the interface."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        subnet_id: builtins.str = ...,
        primary_v4_address_spec: global___PrimaryAddressSpec | None = ...,
        primary_v6_address_spec: global___PrimaryAddressSpec | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index", "primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec", "security_group_ids", b"security_group_ids", "subnet_id", b"subnet_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateInstanceNetworkInterfaceRequest = UpdateInstanceNetworkInterfaceRequest

@typing.final
class UpdateInstanceNetworkInterfaceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_INDEX_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instant network interface that is being updated."""
    network_interface_index: builtins.str
    """The index of the network interface."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        network_interface_index: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "network_interface_index", b"network_interface_index"]) -> None: ...

global___UpdateInstanceNetworkInterfaceMetadata = UpdateInstanceNetworkInterfaceMetadata

@typing.final
class SimulateInstanceMaintenanceEventRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___SimulateInstanceMaintenanceEventRequest = SimulateInstanceMaintenanceEventRequest

@typing.final
class SimulateInstanceMaintenanceEventMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___SimulateInstanceMaintenanceEventMetadata = SimulateInstanceMaintenanceEventMetadata

@typing.final
class ListInstanceOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the Instance resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListInstanceOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListInstanceOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstanceOperationsRequest = ListInstanceOperationsRequest

@typing.final
class ListInstanceOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListInstanceOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListInstanceOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified instance."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListInstanceOperationsResponse = ListInstanceOperationsResponse

@typing.final
class ResourcesSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMORY_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    CORE_FRACTION_FIELD_NUMBER: builtins.int
    GPUS_FIELD_NUMBER: builtins.int
    memory: builtins.int
    """The amount of memory available to the instance, specified in bytes."""
    cores: builtins.int
    """The number of cores available to the instance."""
    core_fraction: builtins.int
    """Baseline level of CPU performance with the ability to burst performance above that baseline level.
    This field sets baseline performance for each core.

    For example, if you need only 5% of the CPU performance, you can set core_fraction=5.
    For more information, see [Levels of core performance](/docs/compute/concepts/performance-levels).
    """
    gpus: builtins.int
    """The number of GPUs available to the instance."""
    def __init__(
        self,
        *,
        memory: builtins.int = ...,
        cores: builtins.int = ...,
        core_fraction: builtins.int = ...,
        gpus: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["core_fraction", b"core_fraction", "cores", b"cores", "gpus", b"gpus", "memory", b"memory"]) -> None: ...

global___ResourcesSpec = ResourcesSpec

@typing.final
class AttachedDiskSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedDiskSpec._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedDiskSpec._Mode.ValueType  # 0
        READ_ONLY: AttachedDiskSpec._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedDiskSpec._Mode.ValueType  # 2
        """Read/Write access. Default value."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedDiskSpec.Mode.ValueType  # 0
    READ_ONLY: AttachedDiskSpec.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedDiskSpec.Mode.ValueType  # 2
    """Read/Write access. Default value."""

    @typing.final
    class DiskSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        TYPE_ID_FIELD_NUMBER: builtins.int
        SIZE_FIELD_NUMBER: builtins.int
        IMAGE_ID_FIELD_NUMBER: builtins.int
        SNAPSHOT_ID_FIELD_NUMBER: builtins.int
        DISK_PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
        BLOCK_SIZE_FIELD_NUMBER: builtins.int
        KMS_KEY_ID_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the disk."""
        description: builtins.str
        """Description of the disk."""
        type_id: builtins.str
        """ID of the disk type.
        To get a list of available disk types, use the [yandex.cloud.compute.v1.DiskTypeService.List] request.
        """
        size: builtins.int
        """Size of the disk, specified in bytes."""
        image_id: builtins.str
        """ID of the image to create the disk from."""
        snapshot_id: builtins.str
        """ID of the snapshot to restore the disk from."""
        block_size: builtins.int
        """Block size of the disk, specified in bytes. The default is 4096."""
        kms_key_id: builtins.str
        """ID of KMS key for disk encryption"""
        @property
        def disk_placement_policy(self) -> yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy:
            """Placement policy configuration."""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            description: builtins.str = ...,
            type_id: builtins.str = ...,
            size: builtins.int = ...,
            image_id: builtins.str = ...,
            snapshot_id: builtins.str = ...,
            disk_placement_policy: yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy | None = ...,
            block_size: builtins.int = ...,
            kms_key_id: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_placement_policy", b"disk_placement_policy", "image_id", b"image_id", "snapshot_id", b"snapshot_id", "source", b"source"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["block_size", b"block_size", "description", b"description", "disk_placement_policy", b"disk_placement_policy", "image_id", b"image_id", "kms_key_id", b"kms_key_id", "name", b"name", "size", b"size", "snapshot_id", b"snapshot_id", "source", b"source", "type_id", b"type_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["image_id", "snapshot_id"] | None: ...

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    AUTO_DELETE_FIELD_NUMBER: builtins.int
    DISK_SPEC_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    mode: global___AttachedDiskSpec.Mode.ValueType
    """The mode in which to attach this disk."""
    device_name: builtins.str
    """Specifies a unique serial number of your choice that is reflected into the /dev/disk/by-id/ tree
    of a Linux operating system running within the instance.

    This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
    If not specified, a random value will be generated.
    """
    auto_delete: builtins.bool
    """Specifies whether the disk will be auto-deleted when the instance is deleted."""
    disk_id: builtins.str
    """ID of the disk that should be attached."""
    @property
    def disk_spec(self) -> global___AttachedDiskSpec.DiskSpec:
        """Disk specification."""

    def __init__(
        self,
        *,
        mode: global___AttachedDiskSpec.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        auto_delete: builtins.bool = ...,
        disk_spec: global___AttachedDiskSpec.DiskSpec | None = ...,
        disk_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk", b"disk", "disk_id", b"disk_id", "disk_spec", b"disk_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_delete", b"auto_delete", "device_name", b"device_name", "disk", b"disk", "disk_id", b"disk_id", "disk_spec", b"disk_spec", "mode", b"mode"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["disk", b"disk"]) -> typing.Literal["disk_spec", "disk_id"] | None: ...

global___AttachedDiskSpec = AttachedDiskSpec

@typing.final
class AttachedLocalDiskSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Size of the disk, specified in bytes."""
    def __init__(
        self,
        *,
        size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

global___AttachedLocalDiskSpec = AttachedLocalDiskSpec

@typing.final
class AttachedFilesystemSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedFilesystemSpec._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedFilesystemSpec._Mode.ValueType  # 0
        READ_ONLY: AttachedFilesystemSpec._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedFilesystemSpec._Mode.ValueType  # 2
        """Read/Write access. Default value."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedFilesystemSpec.Mode.ValueType  # 0
    READ_ONLY: AttachedFilesystemSpec.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedFilesystemSpec.Mode.ValueType  # 2
    """Read/Write access. Default value."""

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    mode: global___AttachedFilesystemSpec.Mode.ValueType
    """Mode of access to the filesystem that should be attached."""
    device_name: builtins.str
    """Name of the device representing the filesystem on the instance.

    The name should be used for referencing the filesystem from within the instance
    when it's being mounted, resized etc.

    If not specified, a random value will be generated.
    """
    filesystem_id: builtins.str
    """ID of the filesystem that should be attached."""
    def __init__(
        self,
        *,
        mode: global___AttachedFilesystemSpec.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "filesystem_id", b"filesystem_id", "mode", b"mode"]) -> None: ...

global___AttachedFilesystemSpec = AttachedFilesystemSpec

@typing.final
class NetworkInterfaceSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBNET_ID_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    PRIMARY_V6_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    subnet_id: builtins.str
    """ID of the subnet."""
    index: builtins.str
    """The index of the network interface, will be generated by the server, 0,1,2... etc if not specified."""
    @property
    def primary_v4_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv4 address that will be assigned to the instance for this network interface."""

    @property
    def primary_v6_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv6 address that will be assigned to the instance for this network interface. IPv6 not available yet."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of security groups attached to the interface"""

    def __init__(
        self,
        *,
        subnet_id: builtins.str = ...,
        primary_v4_address_spec: global___PrimaryAddressSpec | None = ...,
        primary_v6_address_spec: global___PrimaryAddressSpec | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        index: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["index", b"index", "primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec", "security_group_ids", b"security_group_ids", "subnet_id", b"subnet_id"]) -> None: ...

global___NetworkInterfaceSpec = NetworkInterfaceSpec

@typing.final
class PrimaryAddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    ONE_TO_ONE_NAT_SPEC_FIELD_NUMBER: builtins.int
    DNS_RECORD_SPECS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """An IPv4 internal network address that is assigned to the instance for this network interface.
    If not specified by the user, an unused internal IP is assigned by the system.
    optional, manual set static internal IP
    """
    @property
    def one_to_one_nat_spec(self) -> global___OneToOneNatSpec:
        """An external IP address configuration.
        If not specified, then this instance will have no external internet access.
        """

    @property
    def dns_record_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecordSpec]:
        """Internal DNS configuration"""

    def __init__(
        self,
        *,
        address: builtins.str = ...,
        one_to_one_nat_spec: global___OneToOneNatSpec | None = ...,
        dns_record_specs: collections.abc.Iterable[global___DnsRecordSpec] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_record_specs", b"dns_record_specs", "one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> None: ...

global___PrimaryAddressSpec = PrimaryAddressSpec

@typing.final
class OneToOneNatSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_VERSION_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    DNS_RECORD_SPECS_FIELD_NUMBER: builtins.int
    ip_version: yandex.cloud.compute.v1.instance_pb2.IpVersion.ValueType
    """External IP address version.
    only if address unspecified
    """
    address: builtins.str
    """set static IP by value"""
    @property
    def dns_record_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecordSpec]:
        """External DNS configuration"""

    def __init__(
        self,
        *,
        ip_version: yandex.cloud.compute.v1.instance_pb2.IpVersion.ValueType = ...,
        address: builtins.str = ...,
        dns_record_specs: collections.abc.Iterable[global___DnsRecordSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_record_specs", b"dns_record_specs", "ip_version", b"ip_version"]) -> None: ...

global___OneToOneNatSpec = OneToOneNatSpec

@typing.final
class DnsRecordSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FQDN_FIELD_NUMBER: builtins.int
    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    PTR_FIELD_NUMBER: builtins.int
    fqdn: builtins.str
    """FQDN (required)"""
    dns_zone_id: builtins.str
    """DNS zone id (optional, if not set, private zone used)"""
    ttl: builtins.int
    """DNS record ttl, values in 0-86400 (optional)"""
    ptr: builtins.bool
    """When set to true, also create PTR DNS record (optional)"""
    def __init__(
        self,
        *,
        fqdn: builtins.str = ...,
        dns_zone_id: builtins.str = ...,
        ttl: builtins.int = ...,
        ptr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "fqdn", b"fqdn", "ptr", b"ptr", "ttl", b"ttl"]) -> None: ...

global___DnsRecordSpec = DnsRecordSpec

@typing.final
class MoveInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to move.

    To get the instance ID, make a [InstanceService.List] request.
    """
    destination_folder_id: builtins.str
    """ID of the folder to move the instance to.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "instance_id", b"instance_id"]) -> None: ...

global___MoveInstanceRequest = MoveInstanceRequest

@typing.final
class MoveInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being moved."""
    source_folder_id: builtins.str
    """ID of the folder that the instance is being moved from."""
    destination_folder_id: builtins.str
    """ID of the folder that the instance is being moved to."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "instance_id", b"instance_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveInstanceMetadata = MoveInstanceMetadata

@typing.final
class RelocateInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    DESTINATION_ZONE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_SPECS_FIELD_NUMBER: builtins.int
    BOOT_DISK_PLACEMENT_FIELD_NUMBER: builtins.int
    SECONDARY_DISK_PLACEMENTS_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance to move.

    To get the instance ID, make a [InstanceService.List] request.
    """
    destination_zone_id: builtins.str
    """ID of the availability zone to move the instance to.

    To get the zone ID, make a [ZoneService.List] request.
    """
    @property
    def network_interface_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterfaceSpec]:
        """Network configuration for the instance. Specifies how the network interface is configured
        to interact with other services on the internal network and on the internet.
        Currently only one network interface is supported per instance.
        """

    @property
    def boot_disk_placement(self) -> yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy:
        """Boot disk placement policy configuration in target zone. Must be specified if disk has placement policy."""

    @property
    def secondary_disk_placements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicyChange]:
        """Secondary disk placement policy configurations in target zone. Must be specified for each disk that has placement policy."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        destination_zone_id: builtins.str = ...,
        network_interface_specs: collections.abc.Iterable[global___NetworkInterfaceSpec] | None = ...,
        boot_disk_placement: yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicy | None = ...,
        secondary_disk_placements: collections.abc.Iterable[yandex.cloud.compute.v1.disk_pb2.DiskPlacementPolicyChange] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boot_disk_placement", b"boot_disk_placement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boot_disk_placement", b"boot_disk_placement", "destination_zone_id", b"destination_zone_id", "instance_id", b"instance_id", "network_interface_specs", b"network_interface_specs", "secondary_disk_placements", b"secondary_disk_placements"]) -> None: ...

global___RelocateInstanceRequest = RelocateInstanceRequest

@typing.final
class RelocateInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    SOURCE_ZONE_ID_FIELD_NUMBER: builtins.int
    DESTINATION_ZONE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being moved."""
    source_zone_id: builtins.str
    """ID of the availability zone that the instance is being moved from."""
    destination_zone_id: builtins.str
    """ID of the availability zone that the instance is being moved to."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        source_zone_id: builtins.str = ...,
        destination_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_zone_id", b"destination_zone_id", "instance_id", b"instance_id", "source_zone_id", b"source_zone_id"]) -> None: ...

global___RelocateInstanceMetadata = RelocateInstanceMetadata

@typing.final
class GuestStopInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that was stopped from guest OS."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___GuestStopInstanceMetadata = GuestStopInstanceMetadata

@typing.final
class PreemptInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that is being preempted."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___PreemptInstanceMetadata = PreemptInstanceMetadata

@typing.final
class CrashInstanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the instance that was crashed."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___CrashInstanceMetadata = CrashInstanceMetadata
