"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.access.access_pb2
import yandex.cloud.compute.v1.instance_pb2
import yandex.cloud.compute.v1.instance_service_pb2
import yandex.cloud.operation.operation_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class InstanceServiceStub:
    """A set of methods for managing Instance resources."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceRequest,
        yandex.cloud.compute.v1.instance_pb2.Instance,
    ]
    """Returns the specified Instance resource.

    To get the list of available Instance resources, make a [List] request.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.ListInstancesRequest,
        yandex.cloud.compute.v1.instance_service_pb2.ListInstancesResponse,
    ]
    """Retrieves the list of Instance resources in the specified folder."""

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.CreateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an instance in the specified folder.
    Method starts an asynchronous operation that can be cancelled while it is in progress.
    """

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified instance."""

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DeleteInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified instance."""

    UpdateMetadata: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceMetadataRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the metadata of the specified instance. For more information on metadata, see [VM metadata](/docs/compute/concepts/vm-metadata)."""

    GetSerialPortOutput: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputRequest,
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputResponse,
    ]
    """Returns the serial port output of the specified Instance resource."""

    Stop: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.StopInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the running instance.

    You can start the instance later using the [InstanceService.Start] method.
    """

    Start: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.StartInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the stopped instance."""

    Restart: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RestartInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Restarts the running instance."""

    AttachDisk: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceDiskRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the disk to the instance."""

    DetachDisk: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceDiskRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the disk from the instance."""

    AttachFilesystem: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceFilesystemRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the filesystem to the instance.

    The instance and the filesystem must reside in the same availability zone.

    To use the instance with an attached filesystem, the latter must be mounted.
    For details, see [documentation](/docs/compute/operations/filesystem/attach-to-vm).
    """

    DetachFilesystem: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceFilesystemRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the filesystem from the instance."""

    AttachNetworkInterface: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the network-interface to the instance.

    To attach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
    To check the instance status, make a [InstanceService.Get] request.
    To stop the running instance, make a [InstanceService.Stop] request.
    """

    DetachNetworkInterface: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the network-interface to the instance.

    To Detach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
    To check the instance status, make a [InstanceService.Get] request.
    To stop the running instance, make a [InstanceService.Stop] request.
    """

    AddOneToOneNat: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AddInstanceOneToOneNatRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Enables One-to-one NAT on the network interface."""

    RemoveOneToOneNat: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RemoveInstanceOneToOneNatRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Removes One-to-one NAT from the network interface."""

    UpdateNetworkInterface: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified instance network interface."""

    ListOperations: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsRequest,
        yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsResponse,
    ]
    """Lists operations for the specified instance."""

    Move: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.MoveInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified instance to another folder of the same cloud.

    The instance must be stopped before moving. To stop the instance, make a [Stop] request.

    After moving, the instance will start recording its Monitoring default metrics to its new folder. Metrics
    that have been recorded to the source folder prior to moving will be retained.
    """

    Relocate: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RelocateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified instance to another availability zone

    Running instance will be restarted during this operation.
    """

    SimulateMaintenanceEvent: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.SimulateInstanceMaintenanceEventRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """maintenance"""

    ListAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """access

    Lists access bindings for the instance.
    """

    SetAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the instance."""

    UpdateAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the instance."""

class InstanceServiceAsyncStub:
    """A set of methods for managing Instance resources."""

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceRequest,
        yandex.cloud.compute.v1.instance_pb2.Instance,
    ]
    """Returns the specified Instance resource.

    To get the list of available Instance resources, make a [List] request.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.ListInstancesRequest,
        yandex.cloud.compute.v1.instance_service_pb2.ListInstancesResponse,
    ]
    """Retrieves the list of Instance resources in the specified folder."""

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.CreateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an instance in the specified folder.
    Method starts an asynchronous operation that can be cancelled while it is in progress.
    """

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified instance."""

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DeleteInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified instance."""

    UpdateMetadata: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceMetadataRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the metadata of the specified instance. For more information on metadata, see [VM metadata](/docs/compute/concepts/vm-metadata)."""

    GetSerialPortOutput: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputRequest,
        yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputResponse,
    ]
    """Returns the serial port output of the specified Instance resource."""

    Stop: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.StopInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the running instance.

    You can start the instance later using the [InstanceService.Start] method.
    """

    Start: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.StartInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the stopped instance."""

    Restart: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RestartInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Restarts the running instance."""

    AttachDisk: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceDiskRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the disk to the instance."""

    DetachDisk: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceDiskRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the disk from the instance."""

    AttachFilesystem: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceFilesystemRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the filesystem to the instance.

    The instance and the filesystem must reside in the same availability zone.

    To use the instance with an attached filesystem, the latter must be mounted.
    For details, see [documentation](/docs/compute/operations/filesystem/attach-to-vm).
    """

    DetachFilesystem: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceFilesystemRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the filesystem from the instance."""

    AttachNetworkInterface: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Attaches the network-interface to the instance.

    To attach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
    To check the instance status, make a [InstanceService.Get] request.
    To stop the running instance, make a [InstanceService.Stop] request.
    """

    DetachNetworkInterface: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Detaches the network-interface to the instance.

    To Detach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
    To check the instance status, make a [InstanceService.Get] request.
    To stop the running instance, make a [InstanceService.Stop] request.
    """

    AddOneToOneNat: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.AddInstanceOneToOneNatRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Enables One-to-one NAT on the network interface."""

    RemoveOneToOneNat: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RemoveInstanceOneToOneNatRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Removes One-to-one NAT from the network interface."""

    UpdateNetworkInterface: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceNetworkInterfaceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified instance network interface."""

    ListOperations: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsRequest,
        yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsResponse,
    ]
    """Lists operations for the specified instance."""

    Move: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.MoveInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified instance to another folder of the same cloud.

    The instance must be stopped before moving. To stop the instance, make a [Stop] request.

    After moving, the instance will start recording its Monitoring default metrics to its new folder. Metrics
    that have been recorded to the source folder prior to moving will be retained.
    """

    Relocate: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.RelocateInstanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified instance to another availability zone

    Running instance will be restarted during this operation.
    """

    SimulateMaintenanceEvent: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.instance_service_pb2.SimulateInstanceMaintenanceEventRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """maintenance"""

    ListAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """access

    Lists access bindings for the instance.
    """

    SetAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the instance."""

    UpdateAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the instance."""

class InstanceServiceServicer(metaclass=abc.ABCMeta):
    """A set of methods for managing Instance resources."""

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.GetInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.instance_pb2.Instance, collections.abc.Awaitable[yandex.cloud.compute.v1.instance_pb2.Instance]]:
        """Returns the specified Instance resource.

        To get the list of available Instance resources, make a [List] request.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.ListInstancesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.instance_service_pb2.ListInstancesResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.instance_service_pb2.ListInstancesResponse]]:
        """Retrieves the list of Instance resources in the specified folder."""

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.CreateInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates an instance in the specified folder.
        Method starts an asynchronous operation that can be cancelled while it is in progress.
        """

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified instance."""

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.DeleteInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified instance."""

    @abc.abstractmethod
    def UpdateMetadata(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceMetadataRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the metadata of the specified instance. For more information on metadata, see [VM metadata](/docs/compute/concepts/vm-metadata)."""

    @abc.abstractmethod
    def GetSerialPortOutput(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.instance_service_pb2.GetInstanceSerialPortOutputResponse]]:
        """Returns the serial port output of the specified Instance resource."""

    @abc.abstractmethod
    def Stop(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.StopInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Stops the running instance.

        You can start the instance later using the [InstanceService.Start] method.
        """

    @abc.abstractmethod
    def Start(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.StartInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Starts the stopped instance."""

    @abc.abstractmethod
    def Restart(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.RestartInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Restarts the running instance."""

    @abc.abstractmethod
    def AttachDisk(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceDiskRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Attaches the disk to the instance."""

    @abc.abstractmethod
    def DetachDisk(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceDiskRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Detaches the disk from the instance."""

    @abc.abstractmethod
    def AttachFilesystem(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceFilesystemRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Attaches the filesystem to the instance.

        The instance and the filesystem must reside in the same availability zone.

        To use the instance with an attached filesystem, the latter must be mounted.
        For details, see [documentation](/docs/compute/operations/filesystem/attach-to-vm).
        """

    @abc.abstractmethod
    def DetachFilesystem(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceFilesystemRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Detaches the filesystem from the instance."""

    @abc.abstractmethod
    def AttachNetworkInterface(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.AttachInstanceNetworkInterfaceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Attaches the network-interface to the instance.

        To attach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
        To check the instance status, make a [InstanceService.Get] request.
        To stop the running instance, make a [InstanceService.Stop] request.
        """

    @abc.abstractmethod
    def DetachNetworkInterface(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.DetachInstanceNetworkInterfaceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Detaches the network-interface to the instance.

        To Detach a network-interface, the instance must have a `STOPPED` status ([Instance.status]).
        To check the instance status, make a [InstanceService.Get] request.
        To stop the running instance, make a [InstanceService.Stop] request.
        """

    @abc.abstractmethod
    def AddOneToOneNat(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.AddInstanceOneToOneNatRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Enables One-to-one NAT on the network interface."""

    @abc.abstractmethod
    def RemoveOneToOneNat(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.RemoveInstanceOneToOneNatRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Removes One-to-one NAT from the network interface."""

    @abc.abstractmethod
    def UpdateNetworkInterface(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.UpdateInstanceNetworkInterfaceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified instance network interface."""

    @abc.abstractmethod
    def ListOperations(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.instance_service_pb2.ListInstanceOperationsResponse]]:
        """Lists operations for the specified instance."""

    @abc.abstractmethod
    def Move(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.MoveInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Moves the specified instance to another folder of the same cloud.

        The instance must be stopped before moving. To stop the instance, make a [Stop] request.

        After moving, the instance will start recording its Monitoring default metrics to its new folder. Metrics
        that have been recorded to the source folder prior to moving will be retained.
        """

    @abc.abstractmethod
    def Relocate(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.RelocateInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Moves the specified instance to another availability zone

        Running instance will be restarted during this operation.
        """

    @abc.abstractmethod
    def SimulateMaintenanceEvent(
        self,
        request: yandex.cloud.compute.v1.instance_service_pb2.SimulateInstanceMaintenanceEventRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """maintenance"""

    @abc.abstractmethod
    def ListAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.access.access_pb2.ListAccessBindingsResponse, collections.abc.Awaitable[yandex.cloud.access.access_pb2.ListAccessBindingsResponse]]:
        """access

        Lists access bindings for the instance.
        """

    @abc.abstractmethod
    def SetAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Sets access bindings for the instance."""

    @abc.abstractmethod
    def UpdateAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates access bindings for the instance."""

def add_InstanceServiceServicer_to_server(servicer: InstanceServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
