"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.compute.v1.disk_pb2
import yandex.cloud.compute.v1.snapshot_pb2
import yandex.cloud.compute.v1.snapshot_schedule_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to return.

    To get a schedule ID, make a [SnapshotScheduleService.List] request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___GetSnapshotScheduleRequest = GetSnapshotScheduleRequest

@typing.final
class ListSnapshotSchedulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list snapshot schedules in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListSnapshotSchedulesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListSnapshotSchedulesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters snapshot schedules listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [SnapshotSchedule.name] field.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-schedule`.
    """
    order_by: builtins.str
    """A sorting expression that sorts snapshot schedules listed in the response.

    The expression must specify the field name from [SnapshotSchedule] and `asc`ending or `desc`ending order,
    e.g. `createdAt desc`.

    Default value: `id asc`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListSnapshotSchedulesRequest = ListSnapshotSchedulesRequest

@typing.final
class ListSnapshotSchedulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSnapshotSchedulesRequest.page_size], use `next_page_token` as the value
    for the [ListSnapshotSchedulesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def snapshot_schedules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule]:
        """List of snapshot schedules in the specified folder."""

    def __init__(
        self,
        *,
        snapshot_schedules: collections.abc.Iterable[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "snapshot_schedules", b"snapshot_schedules"]) -> None: ...

global___ListSnapshotSchedulesResponse = ListSnapshotSchedulesResponse

@typing.final
class CreateSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SCHEDULE_POLICY_FIELD_NUMBER: builtins.int
    RETENTION_PERIOD_FIELD_NUMBER: builtins.int
    SNAPSHOT_COUNT_FIELD_NUMBER: builtins.int
    SNAPSHOT_SPEC_FIELD_NUMBER: builtins.int
    DISK_IDS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a snapshot schedule in.

    Snapshots are created in the same folder as the schedule, even if disks from other folders are attached
    to the schedule.

    To get a folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the snapshot schedule.

    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the snapshot schedule."""
    snapshot_count: builtins.int
    """Retention count of the snapshot schedule. Once the number of snapshots created by the schedule exceeds this
    number, the oldest ones are automatically deleted. E.g. if the number is 5, the first snapshot is deleted
    after the sixth one is created, the second is deleted after the seventh one is created, and so on.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Snapshot schedule labels as `key:value` pairs."""

    @property
    def schedule_policy(self) -> yandex.cloud.compute.v1.snapshot_schedule_pb2.SchedulePolicy:
        """Frequency settings of the snapshot schedule."""

    @property
    def retention_period(self) -> google.protobuf.duration_pb2.Duration:
        """Retention period of the snapshot schedule. Once a snapshot created by the schedule reaches this age, it is
        automatically deleted.
        """

    @property
    def snapshot_spec(self) -> yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSpec:
        """Attributes of snapshots created by the snapshot schedule."""

    @property
    def disk_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of IDs of the disks attached to the snapshot schedule.

        To get a disk ID, make a [yandex.cloud.compute.v1.DiskService.List] request.
        """

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        schedule_policy: yandex.cloud.compute.v1.snapshot_schedule_pb2.SchedulePolicy | None = ...,
        retention_period: google.protobuf.duration_pb2.Duration | None = ...,
        snapshot_count: builtins.int = ...,
        snapshot_spec: yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSpec | None = ...,
        disk_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["retention_period", b"retention_period", "retention_policy", b"retention_policy", "schedule_policy", b"schedule_policy", "snapshot_count", b"snapshot_count", "snapshot_spec", b"snapshot_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "disk_ids", b"disk_ids", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "retention_period", b"retention_period", "retention_policy", b"retention_policy", "schedule_policy", b"schedule_policy", "snapshot_count", b"snapshot_count", "snapshot_spec", b"snapshot_spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["retention_policy", b"retention_policy"]) -> typing.Literal["retention_period", "snapshot_count"] | None: ...

global___CreateSnapshotScheduleRequest = CreateSnapshotScheduleRequest

@typing.final
class CreateSnapshotScheduleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being created."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___CreateSnapshotScheduleMetadata = CreateSnapshotScheduleMetadata

@typing.final
class UpdateSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SCHEDULE_POLICY_FIELD_NUMBER: builtins.int
    RETENTION_PERIOD_FIELD_NUMBER: builtins.int
    SNAPSHOT_COUNT_FIELD_NUMBER: builtins.int
    SNAPSHOT_SPEC_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to update.

    To get the snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    name: builtins.str
    """New name for the snapshot schedule.

    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the snapshot schedule."""
    snapshot_count: builtins.int
    """Retention count of the snapshot schedule. Once the number of snapshots created by the schedule exceeds this
    number, the oldest ones are automatically deleted. E.g. if the number is 5, the first snapshot is deleted
    after the sixth one is created, the second is deleted after the seventh one is created, and so on.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the snapshot schedule should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Snapshot schedule labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [SnapshotScheduleService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    @property
    def schedule_policy(self) -> yandex.cloud.compute.v1.snapshot_schedule_pb2.SchedulePolicy:
        """New frequency settings of the snapshot schedule."""

    @property
    def retention_period(self) -> google.protobuf.duration_pb2.Duration:
        """Retention period of the snapshot schedule. Once a snapshot created by the schedule reaches this age, it is
        automatically deleted.
        """

    @property
    def snapshot_spec(self) -> yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSpec:
        """New attributes of snapshots created by the snapshot schedule."""

    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        schedule_policy: yandex.cloud.compute.v1.snapshot_schedule_pb2.SchedulePolicy | None = ...,
        retention_period: google.protobuf.duration_pb2.Duration | None = ...,
        snapshot_count: builtins.int = ...,
        snapshot_spec: yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["retention_period", b"retention_period", "retention_policy", b"retention_policy", "schedule_policy", b"schedule_policy", "snapshot_count", b"snapshot_count", "snapshot_spec", b"snapshot_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "retention_period", b"retention_period", "retention_policy", b"retention_policy", "schedule_policy", b"schedule_policy", "snapshot_count", b"snapshot_count", "snapshot_schedule_id", b"snapshot_schedule_id", "snapshot_spec", b"snapshot_spec", "update_mask", b"update_mask"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["retention_policy", b"retention_policy"]) -> typing.Literal["retention_period", "snapshot_count"] | None: ...

global___UpdateSnapshotScheduleRequest = UpdateSnapshotScheduleRequest

@typing.final
class UpdateSnapshotScheduleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being updated."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___UpdateSnapshotScheduleMetadata = UpdateSnapshotScheduleMetadata

@typing.final
class DeleteSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to delete.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___DeleteSnapshotScheduleRequest = DeleteSnapshotScheduleRequest

@typing.final
class DeleteSnapshotScheduleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being deleted."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___DeleteSnapshotScheduleMetadata = DeleteSnapshotScheduleMetadata

@typing.final
class DisableSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to disable.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___DisableSnapshotScheduleRequest = DisableSnapshotScheduleRequest

@typing.final
class DisableSnapshotScheduleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being disabled."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___DisableSnapshotScheduleMetadata = DisableSnapshotScheduleMetadata

@typing.final
class EnableSnapshotScheduleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to enable.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___EnableSnapshotScheduleRequest = EnableSnapshotScheduleRequest

@typing.final
class EnableSnapshotScheduleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being enabled."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___EnableSnapshotScheduleMetadata = EnableSnapshotScheduleMetadata

@typing.final
class ListSnapshotScheduleOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to list operations for.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListSnapshotScheduleOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListSnapshotScheduleOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___ListSnapshotScheduleOperationsRequest = ListSnapshotScheduleOperationsRequest

@typing.final
class ListSnapshotScheduleOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSnapshotScheduleOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListSnapshotScheduleOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified snapshot schedule."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListSnapshotScheduleOperationsResponse = ListSnapshotScheduleOperationsResponse

@typing.final
class ListSnapshotScheduleSnapshotsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to list created snapshots for.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListSnapshotScheduleOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListSnapshotScheduleOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___ListSnapshotScheduleSnapshotsRequest = ListSnapshotScheduleSnapshotsRequest

@typing.final
class ListSnapshotScheduleSnapshotsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSnapshotScheduleSnapshotsRequest.page_size], use `next_page_token` as the value
    for the [ListSnapshotScheduleSnapshotsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def snapshots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.snapshot_pb2.Snapshot]:
        """List of snapshots created by the specified snapshot schedule."""

    def __init__(
        self,
        *,
        snapshots: collections.abc.Iterable[yandex.cloud.compute.v1.snapshot_pb2.Snapshot] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "snapshots", b"snapshots"]) -> None: ...

global___ListSnapshotScheduleSnapshotsResponse = ListSnapshotScheduleSnapshotsResponse

@typing.final
class ListSnapshotScheduleDisksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to list attached disks for.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListSnapshotScheduleDisksResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListSnapshotScheduleDisksResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___ListSnapshotScheduleDisksRequest = ListSnapshotScheduleDisksRequest

@typing.final
class ListSnapshotScheduleDisksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISKS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSnapshotScheduleDisksRequest.page_size], use `next_page_token` as the value
    for the [ListSnapshotScheduleDisksRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.disk_pb2.Disk]:
        """List of disks attached to the specified snapshot schedule."""

    def __init__(
        self,
        *,
        disks: collections.abc.Iterable[yandex.cloud.compute.v1.disk_pb2.Disk] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disks", b"disks", "next_page_token", b"next_page_token"]) -> None: ...

global___ListSnapshotScheduleDisksResponse = ListSnapshotScheduleDisksResponse

@typing.final
class UpdateSnapshotScheduleDisksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    REMOVE_FIELD_NUMBER: builtins.int
    ADD_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule to update.

    To get a snapshot schedule ID, make a [SnapshotScheduleService.List] request.
    """
    @property
    def remove(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of IDs of the disks to detach from the specified schedule.

        To get an ID of a disk attached to the schedule, make a [SnapshotScheduleService.ListDisks] request.
        """

    @property
    def add(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of IDs of the disks to attach to the specified schedule.

        To get a disk ID, make a [yandex.cloud.compute.v1.DiskService.List] request.
        """

    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
        remove: collections.abc.Iterable[builtins.str] | None = ...,
        add: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add", b"add", "remove", b"remove", "snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___UpdateSnapshotScheduleDisksRequest = UpdateSnapshotScheduleDisksRequest

@typing.final
class UpdateSnapshotScheduleDisksMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_ID_FIELD_NUMBER: builtins.int
    snapshot_schedule_id: builtins.str
    """ID of the snapshot schedule that is being updated."""
    def __init__(
        self,
        *,
        snapshot_schedule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["snapshot_schedule_id", b"snapshot_schedule_id"]) -> None: ...

global___UpdateSnapshotScheduleDisksMetadata = UpdateSnapshotScheduleDisksMetadata
