"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.containerregistry.v1.repository_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetRepositoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_ID_FIELD_NUMBER: builtins.int
    repository_id: builtins.str
    """ID of the Repository resource to return.

    To get the repository ID use a [RepositoryService.List] request.
    """
    def __init__(
        self,
        *,
        repository_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["repository_id", b"repository_id"]) -> None: ...

global___GetRepositoryRequest = GetRepositoryRequest

@typing.final
class GetRepositoryByNameRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_NAME_FIELD_NUMBER: builtins.int
    repository_name: builtins.str
    """Name of the Repository resource to return.

    To get the repository name use a [RepositoryService.List] request.
    """
    def __init__(
        self,
        *,
        repository_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["repository_name", b"repository_name"]) -> None: ...

global___GetRepositoryByNameRequest = GetRepositoryByNameRequest

@typing.final
class ListRepositoriesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTRY_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    registry_id: builtins.str
    """ID of the registry to list repositories in.

    To get the registry ID use a [RegistryService.List] request.
    """
    folder_id: builtins.str
    """ID of the folder to list registries in.

    [folder_id] is ignored if a [ListImagesRequest.registry_id] is specified in the request.

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListRepositoriesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListRepositoriesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [Repository.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    """
    order_by: builtins.str
    def __init__(
        self,
        *,
        registry_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "registry_id", b"registry_id"]) -> None: ...

global___ListRepositoriesRequest = ListRepositoriesRequest

@typing.final
class ListRepositoriesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListRepositoriesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListRepositoriesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def repositories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.containerregistry.v1.repository_pb2.Repository]:
        """List of Repository resources."""

    def __init__(
        self,
        *,
        repositories: collections.abc.Iterable[yandex.cloud.containerregistry.v1.repository_pb2.Repository] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "repositories", b"repositories"]) -> None: ...

global___ListRepositoriesResponse = ListRepositoriesResponse

@typing.final
class UpsertRepositoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the repository.

    The name of the repository should match the name of the images that will be pushed in the repository.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___UpsertRepositoryRequest = UpsertRepositoryRequest

@typing.final
class UpsertRepositoryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_ID_FIELD_NUMBER: builtins.int
    repository_id: builtins.str
    """ID of the repository that is being upserted."""
    def __init__(
        self,
        *,
        repository_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["repository_id", b"repository_id"]) -> None: ...

global___UpsertRepositoryMetadata = UpsertRepositoryMetadata

@typing.final
class DeleteRepositoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_ID_FIELD_NUMBER: builtins.int
    repository_id: builtins.str
    """ID of the repository to delete."""
    def __init__(
        self,
        *,
        repository_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["repository_id", b"repository_id"]) -> None: ...

global___DeleteRepositoryRequest = DeleteRepositoryRequest

@typing.final
class DeleteRepositoryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_ID_FIELD_NUMBER: builtins.int
    repository_id: builtins.str
    """ID of the repository that is being deleted."""
    def __init__(
        self,
        *,
        repository_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["repository_id", b"repository_id"]) -> None: ...

global___DeleteRepositoryMetadata = DeleteRepositoryMetadata
