"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.dataproc.v1.common_pb2
import yandex.cloud.dataproc.v1.subcluster_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSubclusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster that the subcluster belongs to."""
    subcluster_id: builtins.str
    """ID of the subcluster to return.

    To get a subcluster ID make a [SubclusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "subcluster_id", b"subcluster_id"]) -> None: ...

global___GetSubclusterRequest = GetSubclusterRequest

@typing.final
class ListSubclustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster to list subclusters in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListSubclustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListSubclustersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters subclusters listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [Subcluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=dataproc123_subcluster456`.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListSubclustersRequest = ListSubclustersRequest

@typing.final
class ListSubclustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBCLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSubclustersRequest.page_size], use `next_page_token` as the value
    for the [ListSubclustersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def subclusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dataproc.v1.subcluster_pb2.Subcluster]:
        """List of subclusters in the specified cluster."""

    def __init__(
        self,
        *,
        subclusters: collections.abc.Iterable[yandex.cloud.dataproc.v1.subcluster_pb2.Subcluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "subclusters", b"subclusters"]) -> None: ...

global___ListSubclustersResponse = ListSubclustersResponse

@typing.final
class CreateSubclusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    AUTOSCALING_CONFIG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster to create a subcluster in.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    name: builtins.str
    """Name of the subcluster. The name must be unique within the cluster. The name can't be
    changed when the subcluster is created.
    """
    role: yandex.cloud.dataproc.v1.subcluster_pb2.Role.ValueType
    """Role that is fulfilled by hosts of the subcluster."""
    subnet_id: builtins.str
    """ID of the VPC subnet used for hosts in the subcluster."""
    hosts_count: builtins.int
    """Number of hosts in the subcluster."""
    @property
    def resources(self) -> yandex.cloud.dataproc.v1.common_pb2.Resources:
        """Resources allocated for each host in the subcluster."""

    @property
    def autoscaling_config(self) -> yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig:
        """Configuration for instance group based subclusters"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
        role: yandex.cloud.dataproc.v1.subcluster_pb2.Role.ValueType = ...,
        resources: yandex.cloud.dataproc.v1.common_pb2.Resources | None = ...,
        subnet_id: builtins.str = ...,
        hosts_count: builtins.int = ...,
        autoscaling_config: yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "cluster_id", b"cluster_id", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "role", b"role", "subnet_id", b"subnet_id"]) -> None: ...

global___CreateSubclusterRequest = CreateSubclusterRequest

@typing.final
class CreateSubclusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the subcluster is being added to."""
    subcluster_id: builtins.str
    """ID of the subcluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "subcluster_id", b"subcluster_id"]) -> None: ...

global___CreateSubclusterMetadata = CreateSubclusterMetadata

@typing.final
class UpdateSubclusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    DECOMMISSION_TIMEOUT_FIELD_NUMBER: builtins.int
    AUTOSCALING_CONFIG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to update a subcluster in.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    subcluster_id: builtins.str
    """ID of the subcluster to update.

    To get a subcluster ID, make a [SubclusterService.List] request.
    """
    name: builtins.str
    """New name for the subcluster. The name must be unique within the cluster."""
    hosts_count: builtins.int
    """New number of hosts in the subcluster."""
    decommission_timeout: builtins.int
    """Timeout to gracefully decommission nodes. In seconds. Default value: 0"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the subcluster should be updated."""

    @property
    def resources(self) -> yandex.cloud.dataproc.v1.common_pb2.Resources:
        """New configuration of resources that should be allocated for each host in the subcluster."""

    @property
    def autoscaling_config(self) -> yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig:
        """Configuration for instance group based subclusters"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        resources: yandex.cloud.dataproc.v1.common_pb2.Resources | None = ...,
        name: builtins.str = ...,
        hosts_count: builtins.int = ...,
        decommission_timeout: builtins.int = ...,
        autoscaling_config: yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "resources", b"resources", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "cluster_id", b"cluster_id", "decommission_timeout", b"decommission_timeout", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "subcluster_id", b"subcluster_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateSubclusterRequest = UpdateSubclusterRequest

@typing.final
class UpdateSubclusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster whose subcluster is being updated."""
    subcluster_id: builtins.str
    """ID of the subcluster that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "subcluster_id", b"subcluster_id"]) -> None: ...

global___UpdateSubclusterMetadata = UpdateSubclusterMetadata

@typing.final
class DeleteSubclusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    DECOMMISSION_TIMEOUT_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to remove a subcluster from.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    subcluster_id: builtins.str
    """ID of the subcluster to delete."""
    decommission_timeout: builtins.int
    """Timeout to gracefully decommission nodes. In seconds. Default value: 0"""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
        decommission_timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "decommission_timeout", b"decommission_timeout", "subcluster_id", b"subcluster_id"]) -> None: ...

global___DeleteSubclusterRequest = DeleteSubclusterRequest

@typing.final
class DeleteSubclusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SUBCLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster whose subcluster is being deleted."""
    subcluster_id: builtins.str
    """ID of the subcluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        subcluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "subcluster_id", b"subcluster_id"]) -> None: ...

global___DeleteSubclusterMetadata = DeleteSubclusterMetadata
