"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.wrappers_pb2
import typing
import yandex.cloud.datasphere.v1.project_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    LIMITS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a project in.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the project."""
    description: builtins.str
    """Description of the project."""
    @property
    def settings(self) -> yandex.cloud.datasphere.v1.project_pb2.Project.Settings:
        """Settings of the project."""

    @property
    def limits(self) -> yandex.cloud.datasphere.v1.project_pb2.Project.Limits:
        """Limits of the project."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        settings: yandex.cloud.datasphere.v1.project_pb2.Project.Settings | None = ...,
        limits: yandex.cloud.datasphere.v1.project_pb2.Project.Limits | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limits", b"limits", "settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "limits", b"limits", "name", b"name", "settings", b"settings"]) -> None: ...

global___CreateProjectRequest = CreateProjectRequest

@typing.final
class CreateProjectMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project that is being created."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___CreateProjectMetadata = CreateProjectMetadata

@typing.final
class UpdateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    LIMITS_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the Project resource to update.
    To get the project ID use a [ProjectService.List] request.
    """
    name: builtins.str
    """Name of the project."""
    description: builtins.str
    """Description of the project."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Project resource are going to be updated."""

    @property
    def settings(self) -> yandex.cloud.datasphere.v1.project_pb2.Project.Settings:
        """Settings of the project."""

    @property
    def limits(self) -> yandex.cloud.datasphere.v1.project_pb2.Project.Limits:
        """Limits of the project."""

    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        settings: yandex.cloud.datasphere.v1.project_pb2.Project.Settings | None = ...,
        limits: yandex.cloud.datasphere.v1.project_pb2.Project.Limits | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limits", b"limits", "settings", b"settings", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "limits", b"limits", "name", b"name", "project_id", b"project_id", "settings", b"settings", "update_mask", b"update_mask"]) -> None: ...

global___UpdateProjectRequest = UpdateProjectRequest

@typing.final
class UpdateProjectMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project that is being updated."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___UpdateProjectMetadata = UpdateProjectMetadata

@typing.final
class DeleteProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the Project resource to delete.
    To get the project ID use a [ProjectService.List] request.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___DeleteProjectRequest = DeleteProjectRequest

@typing.final
class DeleteProjectMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project that is being deleted."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___DeleteProjectMetadata = DeleteProjectMetadata

@typing.final
class OpenProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the Project resource to open.
    To get the project ID use a [ProjectService.List] request.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___OpenProjectRequest = OpenProjectRequest

@typing.final
class OpenProjectMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project that is being opened."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___OpenProjectMetadata = OpenProjectMetadata

@typing.final
class OpenProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_URL_FIELD_NUMBER: builtins.int
    SESSION_TOKEN_FIELD_NUMBER: builtins.int
    project_url: builtins.str
    """URL of the project that is being opened.
    Make GET request to [project_url] with sessionToken query parameter equals to [session_token]
    or POST request to [project_url] with sessionToken body parameter equals to [session_token]
    to fetch Datasphere web interface.
    """
    session_token: builtins.str
    """Session token of the project that is being opened."""
    def __init__(
        self,
        *,
        project_url: builtins.str = ...,
        session_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_url", b"project_url", "session_token", b"session_token"]) -> None: ...

global___OpenProjectResponse = OpenProjectResponse

@typing.final
class GetProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the Project resource to return.
    To get the project ID use a [ProjectService.List] request.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___GetProjectRequest = GetProjectRequest

@typing.final
class ListProjectsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list projects in.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListProjectsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListProjectsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListProjectsRequest = ListProjectsRequest

@typing.final
class ListProjectsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListProjectsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListProjectsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def projects(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.datasphere.v1.project_pb2.Project]:
        """List of Project resources."""

    def __init__(
        self,
        *,
        projects: collections.abc.Iterable[yandex.cloud.datasphere.v1.project_pb2.Project] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "projects", b"projects"]) -> None: ...

global___ListProjectsResponse = ListProjectsResponse

@typing.final
class GetUnitBalanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project to return the unit balance for."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id"]) -> None: ...

global___GetUnitBalanceRequest = GetUnitBalanceRequest

@typing.final
class GetUnitBalanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNIT_BALANCE_FIELD_NUMBER: builtins.int
    @property
    def unit_balance(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of units available to the project."""

    def __init__(
        self,
        *,
        unit_balance: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["unit_balance", b"unit_balance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["unit_balance", b"unit_balance"]) -> None: ...

global___GetUnitBalanceResponse = GetUnitBalanceResponse

@typing.final
class SetUnitBalanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    UNIT_BALANCE_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project to set the unit balance for."""
    @property
    def unit_balance(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of units available to the project."""

    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        unit_balance: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["unit_balance", b"unit_balance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["project_id", b"project_id", "unit_balance", b"unit_balance"]) -> None: ...

global___SetUnitBalanceRequest = SetUnitBalanceRequest

@typing.final
class ProjectExecutionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NOTEBOOK_ID_FIELD_NUMBER: builtins.int
    CELL_ID_FIELD_NUMBER: builtins.int
    INPUT_VARIABLES_FIELD_NUMBER: builtins.int
    OUTPUT_VARIABLE_NAMES_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project to execute notebook/cell in."""
    notebook_id: builtins.str
    """ID of the notebook to execute."""
    cell_id: builtins.str
    """ID of the cell to execute."""
    @property
    def input_variables(self) -> google.protobuf.struct_pb2.Struct:
        """Values of input variables."""

    @property
    def output_variable_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of output variables."""

    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        notebook_id: builtins.str = ...,
        cell_id: builtins.str = ...,
        input_variables: google.protobuf.struct_pb2.Struct | None = ...,
        output_variable_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cell_id", b"cell_id", "input_variables", b"input_variables", "notebook_id", b"notebook_id", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cell_id", b"cell_id", "input_variables", b"input_variables", "notebook_id", b"notebook_id", "output_variable_names", b"output_variable_names", "project_id", b"project_id", "target", b"target"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["target", b"target"]) -> typing.Literal["notebook_id", "cell_id"] | None: ...

global___ProjectExecutionRequest = ProjectExecutionRequest

@typing.final
class ProjectExecutionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NOTEBOOK_ID_FIELD_NUMBER: builtins.int
    CELL_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """ID of the project in which notebook is being executed."""
    notebook_id: builtins.str
    """ID of the notebook that is being executed"""
    cell_id: builtins.str
    """ID of the cell that is being executed"""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        notebook_id: builtins.str = ...,
        cell_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cell_id", b"cell_id", "notebook_id", b"notebook_id", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cell_id", b"cell_id", "notebook_id", b"notebook_id", "project_id", b"project_id", "target", b"target"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["target", b"target"]) -> typing.Literal["notebook_id", "cell_id"] | None: ...

global___ProjectExecutionMetadata = ProjectExecutionMetadata

@typing.final
class ProjectExecutionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ProjectExecutionResponse = ProjectExecutionResponse
