"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.datasphere.v2.community_pb2
import yandex.cloud.datasphere.v2.resource_types_pb2
import yandex.cloud.datasphere.v2.restrictions_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateCommunityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    BILLING_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the community."""
    description: builtins.str
    """Description of the community."""
    organization_id: builtins.str
    """ID of the organization where community should be created."""
    billing_account_id: builtins.str
    """ID of the billing account for the created community. Optional, billing account could be bound to community later."""
    zone_id: builtins.str
    """ID of the zone where community will be created (all projects and other resources will be in this zone)"""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the community."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        organization_id: builtins.str = ...,
        billing_account_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["billing_account_id", b"billing_account_id", "description", b"description", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "zone_id", b"zone_id"]) -> None: ...

global___CreateCommunityRequest = CreateCommunityRequest

@typing.final
class CreateCommunityMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community that is being created."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___CreateCommunityMetadata = CreateCommunityMetadata

@typing.final
class GetCommunityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___GetCommunityRequest = GetCommunityRequest

@typing.final
class UpdateCommunityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community."""
    name: builtins.str
    """Name of the community."""
    description: builtins.str
    """Description of the community."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Community resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the community."""

    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id", "description", b"description", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateCommunityRequest = UpdateCommunityRequest

@typing.final
class UpdateCommunityMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community that is being updated."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___UpdateCommunityMetadata = UpdateCommunityMetadata

@typing.final
class DeleteCommunityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___DeleteCommunityRequest = DeleteCommunityRequest

@typing.final
class DeleteCommunityMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community that is being deleted."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___DeleteCommunityMetadata = DeleteCommunityMetadata

@typing.final
class ListCommunitiesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    NAME_OR_DESCRIPTION_PATTERN_FIELD_NUMBER: builtins.int
    OWNED_BY_ID_FIELD_NUMBER: builtins.int
    LIST_PUBLIC_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListCommunitiesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListCommunitiesResponse.next_page_token] returned by a previous list request.
    """
    name_or_description_pattern: builtins.str
    """Community name or description pattern.
    Only communities with names or descriptions matching specified pattern will be returned.
    """
    owned_by_id: builtins.str
    """ID of the user. Only communities owned by specified user will be returned."""
    list_public: builtins.bool
    """If set to true, only public communities will be returned."""
    organization_id: builtins.str
    """ID of the organization to list communities in."""
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        name_or_description_pattern: builtins.str = ...,
        owned_by_id: builtins.str = ...,
        list_public: builtins.bool = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_public", b"list_public", "name_or_description_pattern", b"name_or_description_pattern", "organization_id", b"organization_id", "owned_by_id", b"owned_by_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCommunitiesRequest = ListCommunitiesRequest

@typing.final
class ListCommunitiesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListCommunitiesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListCommunitiesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def communities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.datasphere.v2.community_pb2.Community]:
        """List of communities matching filters in list communities request."""

    def __init__(
        self,
        *,
        communities: collections.abc.Iterable[yandex.cloud.datasphere.v2.community_pb2.Community] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["communities", b"communities", "next_page_token", b"next_page_token"]) -> None: ...

global___ListCommunitiesResponse = ListCommunitiesResponse

@typing.final
class SetCommunityAccessBindingsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community which access bindings are set."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___SetCommunityAccessBindingsMetadata = SetCommunityAccessBindingsMetadata

@typing.final
class UpdateCommunityAccessBindingsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community which access bindings are updated."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___UpdateCommunityAccessBindingsMetadata = UpdateCommunityAccessBindingsMetadata

@typing.final
class AddCommunityResourceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    resource_type: yandex.cloud.datasphere.v2.resource_types_pb2.ResourceType.ValueType
    resource_id: builtins.str
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
        resource_type: yandex.cloud.datasphere.v2.resource_types_pb2.ResourceType.ValueType = ...,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id", "resource_id", b"resource_id", "resource_type", b"resource_type"]) -> None: ...

global___AddCommunityResourceRequest = AddCommunityResourceRequest

@typing.final
class RemoveCommunityResourceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    resource_type: yandex.cloud.datasphere.v2.resource_types_pb2.ResourceType.ValueType
    resource_id: builtins.str
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
        resource_type: yandex.cloud.datasphere.v2.resource_types_pb2.ResourceType.ValueType = ...,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id", "resource_id", b"resource_id", "resource_type", b"resource_type"]) -> None: ...

global___RemoveCommunityResourceRequest = RemoveCommunityResourceRequest

@typing.final
class GetCommunityRestrictionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community."""
    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id"]) -> None: ...

global___GetCommunityRestrictionsRequest = GetCommunityRestrictionsRequest

@typing.final
class SetCommunityRestrictionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMUNITY_ID_FIELD_NUMBER: builtins.int
    RESTRICTIONS_FIELD_NUMBER: builtins.int
    community_id: builtins.str
    """ID of the community."""
    @property
    def restrictions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.datasphere.v2.restrictions_pb2.Restriction]:
        """List of restrictions to set."""

    def __init__(
        self,
        *,
        community_id: builtins.str = ...,
        restrictions: collections.abc.Iterable[yandex.cloud.datasphere.v2.restrictions_pb2.Restriction] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["community_id", b"community_id", "restrictions", b"restrictions"]) -> None: ...

global___SetCommunityRestrictionsRequest = SetCommunityRestrictionsRequest
