"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.datatransfer.v1.endpoint.common_pb2
import yandex.cloud.datatransfer.v1.endpoint.parsers_pb2
import yandex.cloud.datatransfer.v1.endpoint.serializers_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _KafkaMechanism:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _KafkaMechanismEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KafkaMechanism.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    KAFKA_MECHANISM_UNSPECIFIED: _KafkaMechanism.ValueType  # 0
    KAFKA_MECHANISM_SHA256: _KafkaMechanism.ValueType  # 1
    KAFKA_MECHANISM_SHA512: _KafkaMechanism.ValueType  # 2

class KafkaMechanism(_KafkaMechanism, metaclass=_KafkaMechanismEnumTypeWrapper): ...

KAFKA_MECHANISM_UNSPECIFIED: KafkaMechanism.ValueType  # 0
KAFKA_MECHANISM_SHA256: KafkaMechanism.ValueType  # 1
KAFKA_MECHANISM_SHA512: KafkaMechanism.ValueType  # 2
global___KafkaMechanism = KafkaMechanism

@typing.final
class KafkaConnectionOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ON_PREMISE_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Managed Service for Kafka cluster ID"""
    @property
    def on_premise(self) -> global___OnPremiseKafka:
        """Connection options for on-premise Kafka"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        on_premise: global___OnPremiseKafka | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "connection", b"connection", "on_premise", b"on_premise"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "connection", b"connection", "on_premise", b"on_premise"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["connection", b"connection"]) -> typing.Literal["cluster_id", "on_premise"] | None: ...

global___KafkaConnectionOptions = KafkaConnectionOptions

@typing.final
class OnPremiseKafka(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BROKER_URLS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    TLS_MODE_FIELD_NUMBER: builtins.int
    subnet_id: builtins.str
    """Network interface for endpoint. If none will assume public ipv4"""
    @property
    def broker_urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Kafka broker URLs"""

    @property
    def tls_mode(self) -> yandex.cloud.datatransfer.v1.endpoint.common_pb2.TLSMode:
        """TLS settings for broker connection. Disabled by default."""

    def __init__(
        self,
        *,
        broker_urls: collections.abc.Iterable[builtins.str] | None = ...,
        subnet_id: builtins.str = ...,
        tls_mode: yandex.cloud.datatransfer.v1.endpoint.common_pb2.TLSMode | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["tls_mode", b"tls_mode"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["broker_urls", b"broker_urls", "subnet_id", b"subnet_id", "tls_mode", b"tls_mode"]) -> None: ...

global___OnPremiseKafka = OnPremiseKafka

@typing.final
class KafkaAuth(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SASL_FIELD_NUMBER: builtins.int
    NO_AUTH_FIELD_NUMBER: builtins.int
    @property
    def sasl(self) -> global___KafkaSaslSecurity:
        """Authentication with SASL"""

    @property
    def no_auth(self) -> yandex.cloud.datatransfer.v1.endpoint.common_pb2.NoAuth:
        """No authentication"""

    def __init__(
        self,
        *,
        sasl: global___KafkaSaslSecurity | None = ...,
        no_auth: yandex.cloud.datatransfer.v1.endpoint.common_pb2.NoAuth | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["no_auth", b"no_auth", "sasl", b"sasl", "security", b"security"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["no_auth", b"no_auth", "sasl", b"sasl", "security", b"security"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["security", b"security"]) -> typing.Literal["sasl", "no_auth"] | None: ...

global___KafkaAuth = KafkaAuth

@typing.final
class KafkaSaslSecurity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MECHANISM_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    user: builtins.str
    """User name"""
    mechanism: global___KafkaMechanism.ValueType
    """SASL mechanism for authentication"""
    @property
    def password(self) -> yandex.cloud.datatransfer.v1.endpoint.common_pb2.Secret:
        """Password for user"""

    def __init__(
        self,
        *,
        user: builtins.str = ...,
        mechanism: global___KafkaMechanism.ValueType = ...,
        password: yandex.cloud.datatransfer.v1.endpoint.common_pb2.Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["password", b"password"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mechanism", b"mechanism", "password", b"password", "user", b"user"]) -> None: ...

global___KafkaSaslSecurity = KafkaSaslSecurity

@typing.final
class KafkaSource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTION_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SECURITY_GROUPS_FIELD_NUMBER: builtins.int
    TOPIC_NAME_FIELD_NUMBER: builtins.int
    TRANSFORMER_FIELD_NUMBER: builtins.int
    PARSER_FIELD_NUMBER: builtins.int
    TOPIC_NAMES_FIELD_NUMBER: builtins.int
    topic_name: builtins.str
    """Full source topic name
    Deprecated in favor of topic names
    """
    @property
    def connection(self) -> global___KafkaConnectionOptions:
        """Connection settings"""

    @property
    def auth(self) -> global___KafkaAuth:
        """Authentication settings"""

    @property
    def security_groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Security groups"""

    @property
    def transformer(self) -> yandex.cloud.datatransfer.v1.endpoint.common_pb2.DataTransformationOptions:
        """Data transformation rules"""

    @property
    def parser(self) -> yandex.cloud.datatransfer.v1.endpoint.parsers_pb2.Parser:
        """Data parsing rules"""

    @property
    def topic_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of topic names to read"""

    def __init__(
        self,
        *,
        connection: global___KafkaConnectionOptions | None = ...,
        auth: global___KafkaAuth | None = ...,
        security_groups: collections.abc.Iterable[builtins.str] | None = ...,
        topic_name: builtins.str = ...,
        transformer: yandex.cloud.datatransfer.v1.endpoint.common_pb2.DataTransformationOptions | None = ...,
        parser: yandex.cloud.datatransfer.v1.endpoint.parsers_pb2.Parser | None = ...,
        topic_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auth", b"auth", "connection", b"connection", "parser", b"parser", "transformer", b"transformer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auth", b"auth", "connection", b"connection", "parser", b"parser", "security_groups", b"security_groups", "topic_name", b"topic_name", "topic_names", b"topic_names", "transformer", b"transformer"]) -> None: ...

global___KafkaSource = KafkaSource

@typing.final
class KafkaTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTION_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SECURITY_GROUPS_FIELD_NUMBER: builtins.int
    TOPIC_SETTINGS_FIELD_NUMBER: builtins.int
    SERIALIZER_FIELD_NUMBER: builtins.int
    @property
    def connection(self) -> global___KafkaConnectionOptions:
        """Connection settings"""

    @property
    def auth(self) -> global___KafkaAuth:
        """Authentication settings"""

    @property
    def security_groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Security groups"""

    @property
    def topic_settings(self) -> global___KafkaTargetTopicSettings:
        """Target topic settings"""

    @property
    def serializer(self) -> yandex.cloud.datatransfer.v1.endpoint.serializers_pb2.Serializer:
        """Data serialization format settings"""

    def __init__(
        self,
        *,
        connection: global___KafkaConnectionOptions | None = ...,
        auth: global___KafkaAuth | None = ...,
        security_groups: collections.abc.Iterable[builtins.str] | None = ...,
        topic_settings: global___KafkaTargetTopicSettings | None = ...,
        serializer: yandex.cloud.datatransfer.v1.endpoint.serializers_pb2.Serializer | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auth", b"auth", "connection", b"connection", "serializer", b"serializer", "topic_settings", b"topic_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auth", b"auth", "connection", b"connection", "security_groups", b"security_groups", "serializer", b"serializer", "topic_settings", b"topic_settings"]) -> None: ...

global___KafkaTarget = KafkaTarget

@typing.final
class KafkaTargetTopicSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_FIELD_NUMBER: builtins.int
    TOPIC_PREFIX_FIELD_NUMBER: builtins.int
    topic_prefix: builtins.str
    """Topic prefix

    Analogue of the Debezium setting database.server.name.
    Messages will be sent to topic with name <topic_prefix>.<schema>.<table_name>.
    """
    @property
    def topic(self) -> global___KafkaTargetTopic:
        """Full topic name"""

    def __init__(
        self,
        *,
        topic: global___KafkaTargetTopic | None = ...,
        topic_prefix: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["topic", b"topic", "topic_prefix", b"topic_prefix", "topic_settings", b"topic_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["topic", b"topic", "topic_prefix", b"topic_prefix", "topic_settings", b"topic_settings"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["topic_settings", b"topic_settings"]) -> typing.Literal["topic", "topic_prefix"] | None: ...

global___KafkaTargetTopicSettings = KafkaTargetTopicSettings

@typing.final
class KafkaTargetTopic(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_NAME_FIELD_NUMBER: builtins.int
    SAVE_TX_ORDER_FIELD_NUMBER: builtins.int
    topic_name: builtins.str
    """Topic name"""
    save_tx_order: builtins.bool
    """Save transactions order
    Not to split events queue into separate per-table queues.
    """
    def __init__(
        self,
        *,
        topic_name: builtins.str = ...,
        save_tx_order: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["save_tx_order", b"save_tx_order", "topic_name", b"topic_name"]) -> None: ...

global___KafkaTargetTopic = KafkaTargetTopic
