"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.datatransfer.v1.transfer_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SOURCE_ID_FIELD_NUMBER: builtins.int
    TARGET_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    RUNTIME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TRANSFORMATION_FIELD_NUMBER: builtins.int
    DATA_OBJECTS_FIELD_NUMBER: builtins.int
    REPLICATION_RUNTIME_FIELD_NUMBER: builtins.int
    source_id: builtins.str
    """Identifier of the source endpoint."""
    target_id: builtins.str
    """Identifier of the target endpoint."""
    description: builtins.str
    """Description of the transfer."""
    folder_id: builtins.str
    """ID of the folder to create the transfer in.

    To get the folder ID, make a
    [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    type: yandex.cloud.datatransfer.v1.transfer_pb2.TransferType.ValueType
    name: builtins.str
    """The transfer name. Must be unique within the folder."""
    @property
    def runtime(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Runtime: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Transfer labels as `key:value` pairs.

        For details about the concept, see [documentation]({{ api-url-prefix
        }}/resource-manager/concepts/labels).
        """

    @property
    def transformation(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Transformation: ...
    @property
    def data_objects(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.DataObjects: ...
    @property
    def replication_runtime(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Runtime: ...
    def __init__(
        self,
        *,
        source_id: builtins.str = ...,
        target_id: builtins.str = ...,
        description: builtins.str = ...,
        folder_id: builtins.str = ...,
        runtime: yandex.cloud.datatransfer.v1.transfer_pb2.Runtime | None = ...,
        type: yandex.cloud.datatransfer.v1.transfer_pb2.TransferType.ValueType = ...,
        name: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        transformation: yandex.cloud.datatransfer.v1.transfer_pb2.Transformation | None = ...,
        data_objects: yandex.cloud.datatransfer.v1.transfer_pb2.DataObjects | None = ...,
        replication_runtime: yandex.cloud.datatransfer.v1.transfer_pb2.Runtime | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_objects", b"data_objects", "replication_runtime", b"replication_runtime", "runtime", b"runtime", "transformation", b"transformation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_objects", b"data_objects", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "replication_runtime", b"replication_runtime", "runtime", b"runtime", "source_id", b"source_id", "target_id", b"target_id", "transformation", b"transformation", "type", b"type"]) -> None: ...

global___CreateTransferRequest = CreateTransferRequest

@typing.final
class CreateTransferMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___CreateTransferMetadata = CreateTransferMetadata

@typing.final
class UpdateTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RUNTIME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TRANSFORMATION_FIELD_NUMBER: builtins.int
    DATA_OBJECTS_FIELD_NUMBER: builtins.int
    REPLICATION_RUNTIME_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    """Identifier of the transfer to be updated."""
    description: builtins.str
    """The new description for the transfer."""
    name: builtins.str
    """The new transfer name. Must be unique within the folder."""
    @property
    def runtime(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Runtime: ...
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying transfer fields to be updated. Semantics for this field is
        described here:
        <https://pkg.go.dev/google.golang.org/protobuf/types/known/fieldmaskpb#FieldMask>
        The only exception: if the repeated field is specified in the mask, then
        the new value replaces the old one instead of being appended to the old one.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Transfer labels as `key:value` pairs.

        For details about the concept, see [documentation]({{ api-url-prefix
        }}/resource-manager/concepts/labels).
        """

    @property
    def transformation(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Transformation: ...
    @property
    def data_objects(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.DataObjects: ...
    @property
    def replication_runtime(self) -> yandex.cloud.datatransfer.v1.transfer_pb2.Runtime: ...
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
        description: builtins.str = ...,
        runtime: yandex.cloud.datatransfer.v1.transfer_pb2.Runtime | None = ...,
        name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        transformation: yandex.cloud.datatransfer.v1.transfer_pb2.Transformation | None = ...,
        data_objects: yandex.cloud.datatransfer.v1.transfer_pb2.DataObjects | None = ...,
        replication_runtime: yandex.cloud.datatransfer.v1.transfer_pb2.Runtime | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_objects", b"data_objects", "replication_runtime", b"replication_runtime", "runtime", b"runtime", "transformation", b"transformation", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_objects", b"data_objects", "description", b"description", "labels", b"labels", "name", b"name", "replication_runtime", b"replication_runtime", "runtime", b"runtime", "transfer_id", b"transfer_id", "transformation", b"transformation", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTransferRequest = UpdateTransferRequest

@typing.final
class UpdateTransferMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___UpdateTransferMetadata = UpdateTransferMetadata

@typing.final
class DeleteTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    """Identifier of the transfer to be deleted."""
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___DeleteTransferRequest = DeleteTransferRequest

@typing.final
class DeleteTransferMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___DeleteTransferMetadata = DeleteTransferMetadata

@typing.final
class ListTransfersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Identifier of the folder containing the transfers to be listed.

    To get the folder ID, make a
    [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of transfers to be sent in the response message. If the
    folder contains more transfers than `page_size`, `next_page_token` will be
    included
    in the response message. Include it into the subsequent `ListTransfersRequest`
    to
    fetch the next page. Defaults to `100` if not specified. The maximum allowed
    value
    for this field is `1000`.
    """
    page_token: builtins.str
    """Opaque value identifying the transfers page to be fetched. Should be empty in
    the first `ListTransfersRequest`. Subsequent requests should have this field
    filled
    with the `next_page_token` from the previous `ListTransfersResponse`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTransfersRequest = ListTransfersRequest

@typing.final
class ListTransfersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Opaque value identifying the next transfers page. This field is empty if there
    are no more transfers in the folder. Otherwise it is non-empty and should be
    included in the subsequent `ListTransfersRequest` to fetch the next transfers
    page.
    """
    @property
    def transfers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.datatransfer.v1.transfer_pb2.Transfer]:
        """The list of transfers. If there are more transfers in the folder, then
        `next_page_token` is a non-empty string to be included into the subsequent
        `ListTransfersRequest` to fetch the next transfers page.
        """

    def __init__(
        self,
        *,
        transfers: collections.abc.Iterable[yandex.cloud.datatransfer.v1.transfer_pb2.Transfer] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "transfers", b"transfers"]) -> None: ...

global___ListTransfersResponse = ListTransfersResponse

@typing.final
class GetTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    """Identifier of the transfer to be returned.

    To get the list of all available transfers, make a [List] request.
    """
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___GetTransferRequest = GetTransferRequest

@typing.final
class DeactivateTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    """Identifier of the transfer to be deactivated.

    To get the list of all available transfers, make a [List] request.
    """
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___DeactivateTransferRequest = DeactivateTransferRequest

@typing.final
class DeactivateTransferMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___DeactivateTransferMetadata = DeactivateTransferMetadata

@typing.final
class ActivateTransferRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    """Identifier of the transfer to be activated.

    To get the list of all available transfers, make a [List] request.
    """
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___ActivateTransferRequest = ActivateTransferRequest

@typing.final
class ActivateTransferMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSFER_ID_FIELD_NUMBER: builtins.int
    transfer_id: builtins.str
    def __init__(
        self,
        *,
        transfer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["transfer_id", b"transfer_id"]) -> None: ...

global___ActivateTransferMetadata = ActivateTransferMetadata
