"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.dns.v1.dns_zone_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class UpdateDnsZonePrivateNetworksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    PRIVATE_NETWORK_ID_ADDITIONS_FIELD_NUMBER: builtins.int
    PRIVATE_NETWORK_ID_DELETIONS_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone which private networks will be updated"""
    @property
    def private_network_id_additions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Network IDs to remove"""

    @property
    def private_network_id_deletions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Network IDs to add"""

    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        private_network_id_additions: collections.abc.Iterable[builtins.str] | None = ...,
        private_network_id_deletions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "private_network_id_additions", b"private_network_id_additions", "private_network_id_deletions", b"private_network_id_deletions"]) -> None: ...

global___UpdateDnsZonePrivateNetworksRequest = UpdateDnsZonePrivateNetworksRequest

@typing.final
class UpdateDnsZonePrivateNetworksMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone which private networks was updated"""
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___UpdateDnsZonePrivateNetworksMetadata = UpdateDnsZonePrivateNetworksMetadata

@typing.final
class GetDnsZoneRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to return.

    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___GetDnsZoneRequest = GetDnsZoneRequest

@typing.final
class ListDnsZonesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list DNS zones in. 

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListDnsZonesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the 
    [ListDnsZonesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters DNS zones listed in the response.

    The expression must specify: 
    1. The field name. Currently you can use filtering only on the [DnsZone.name] field. 
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-dns-zone`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDnsZonesRequest = ListDnsZonesRequest

@typing.final
class ListDnsZonesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListDnsZonesRequest.page_size], use `next_page_token` as the value
    for the [ListDnsZonesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def dns_zones(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.DnsZone]:
        """List of DNS zones in the specified folder."""

    def __init__(
        self,
        *,
        dns_zones: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.DnsZone] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zones", b"dns_zones", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDnsZonesResponse = ListDnsZonesResponse

@typing.final
class CreateDnsZoneRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_FIELD_NUMBER: builtins.int
    PRIVATE_VISIBILITY_FIELD_NUMBER: builtins.int
    PUBLIC_VISIBILITY_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create DNS zones in.

    To get a folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the DNS zone. 
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the DNS zone."""
    zone: builtins.str
    """DNS zone suffix."""
    deletion_protection: builtins.bool
    """Prevents accidental zone removal."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """DNS zone labels as `key:value` pairs."""

    @property
    def private_visibility(self) -> yandex.cloud.dns.v1.dns_zone_pb2.PrivateVisibility:
        """Privately visible zone settings. 
        At least one of two visibility fields must be set.
        """

    @property
    def public_visibility(self) -> yandex.cloud.dns.v1.dns_zone_pb2.PublicVisibility:
        """Publicly visible zone settings.
        At least one of two visibility fields must be set.
        """

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone: builtins.str = ...,
        private_visibility: yandex.cloud.dns.v1.dns_zone_pb2.PrivateVisibility | None = ...,
        public_visibility: yandex.cloud.dns.v1.dns_zone_pb2.PublicVisibility | None = ...,
        deletion_protection: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["private_visibility", b"private_visibility", "public_visibility", b"public_visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "private_visibility", b"private_visibility", "public_visibility", b"public_visibility", "zone", b"zone"]) -> None: ...

global___CreateDnsZoneRequest = CreateDnsZoneRequest

@typing.final
class CreateDnsZoneMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone that is being created."""
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___CreateDnsZoneMetadata = CreateDnsZoneMetadata

@typing.final
class UpdateDnsZoneRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PRIVATE_VISIBILITY_FIELD_NUMBER: builtins.int
    PUBLIC_VISIBILITY_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to update.
     
    To get the DNS zone ID, make a [DnsZoneService.List] request.
    """
    name: builtins.str
    """New name for the DNS zone. 
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the DNS zone."""
    deletion_protection: builtins.bool
    """Prevents accidental zone removal."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the DNS zone resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """DNS zone labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [DnsZoneService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    @property
    def private_visibility(self) -> yandex.cloud.dns.v1.dns_zone_pb2.PrivateVisibility:
        """Change network IDs for private visibility."""

    @property
    def public_visibility(self) -> yandex.cloud.dns.v1.dns_zone_pb2.PublicVisibility:
        """Public visibility configuration."""

    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        private_visibility: yandex.cloud.dns.v1.dns_zone_pb2.PrivateVisibility | None = ...,
        public_visibility: yandex.cloud.dns.v1.dns_zone_pb2.PublicVisibility | None = ...,
        deletion_protection: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["private_visibility", b"private_visibility", "public_visibility", b"public_visibility", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection", "description", b"description", "dns_zone_id", b"dns_zone_id", "labels", b"labels", "name", b"name", "private_visibility", b"private_visibility", "public_visibility", b"public_visibility", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDnsZoneRequest = UpdateDnsZoneRequest

@typing.final
class UpdateDnsZoneMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone that is being updated."""
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___UpdateDnsZoneMetadata = UpdateDnsZoneMetadata

@typing.final
class DeleteDnsZoneRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to delete.

    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___DeleteDnsZoneRequest = DeleteDnsZoneRequest

@typing.final
class DeleteDnsZoneMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone that is being deleted."""
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id"]) -> None: ...

global___DeleteDnsZoneMetadata = DeleteDnsZoneMetadata

@typing.final
class GetDnsZoneRecordSetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to get record set from.

    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    name: builtins.str
    """Name of the record set."""
    type: builtins.str
    """Type of the record set."""
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "name", b"name", "type", b"type"]) -> None: ...

global___GetDnsZoneRecordSetRequest = GetDnsZoneRecordSetRequest

@typing.final
class ListDnsZoneRecordSetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to list record sets in. 

    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListDnsZoneRecordSetsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the 
    [ListDnsZoneRecordSetsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters record sets listed in the response. The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where: 
    1. `<field>` is the field name. Currently you can use filtering only on the [RecordSet.name] and [RecordSet.type] fields.
    2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
    3. `<value>` represents a value.
    3.1. In case of single value condition (`=` or `!=`), the value is a string in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    3.2. In case of a list of values condition (`IN` or `NOT IN`), the value is `(<string1>, <string2>, .., <stringN>)`, where `<string>` is a string in double (`"`) or single (`'`) quotes.

    Examples of a filter: `name="my-record-set"`, `type IN ("MX","A") AND name="works.on.my.machine."`.
    """
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDnsZoneRecordSetsRequest = ListDnsZoneRecordSetsRequest

@typing.final
class ListDnsZoneRecordSetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_SETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListDnsZoneRecordSetsRequest.page_size], use `next_page_token` as the value
    for the [ListDnsZoneRecordSetsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def record_sets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """List of record sets in the specified DNS zone."""

    def __init__(
        self,
        *,
        record_sets: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "record_sets", b"record_sets"]) -> None: ...

global___ListDnsZoneRecordSetsResponse = ListDnsZoneRecordSetsResponse

@typing.final
class UpdateRecordSetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    DELETIONS_FIELD_NUMBER: builtins.int
    ADDITIONS_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to update record sets in.
     
    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    @property
    def deletions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """List of record sets to delete."""

    @property
    def additions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """List of record sets to add."""

    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        deletions: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
        additions: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["additions", b"additions", "deletions", b"deletions", "dns_zone_id", b"dns_zone_id"]) -> None: ...

global___UpdateRecordSetsRequest = UpdateRecordSetsRequest

@typing.final
class UpdateRecordSetsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateRecordSetsMetadata = UpdateRecordSetsMetadata

@typing.final
class UpsertRecordSetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    DELETIONS_FIELD_NUMBER: builtins.int
    REPLACEMENTS_FIELD_NUMBER: builtins.int
    MERGES_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to upsert record sets to.
     
    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    @property
    def deletions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """Delete only specified records from corresponding record sets."""

    @property
    def replacements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """Entirely replace specified record sets."""

    @property
    def merges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """Replace specified records or add new ones if no such record sets exists."""

    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        deletions: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
        replacements: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
        merges: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deletions", b"deletions", "dns_zone_id", b"dns_zone_id", "merges", b"merges", "replacements", b"replacements"]) -> None: ...

global___UpsertRecordSetsRequest = UpsertRecordSetsRequest

@typing.final
class UpsertRecordSetsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpsertRecordSetsMetadata = UpsertRecordSetsMetadata

@typing.final
class RecordSetDiff(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDITIONS_FIELD_NUMBER: builtins.int
    DELETIONS_FIELD_NUMBER: builtins.int
    @property
    def additions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """List of record sets that were added"""

    @property
    def deletions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet]:
        """List of record sets that were deleted"""

    def __init__(
        self,
        *,
        additions: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
        deletions: collections.abc.Iterable[yandex.cloud.dns.v1.dns_zone_pb2.RecordSet] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["additions", b"additions", "deletions", b"deletions"]) -> None: ...

global___RecordSetDiff = RecordSetDiff

@typing.final
class ListDnsZoneOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    dns_zone_id: builtins.str
    """ID of the DNS zone to list operations for.

    To get a DNS zone ID, make a [DnsZoneService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListDnsZoneOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the 
    [ListDnsZoneOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters DNS zones listed in the response.

    The expression must specify: 
    1. The field name. Currently you can use filtering only on the [DnsZone.name] field. 
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-dns-zone`.
    """
    def __init__(
        self,
        *,
        dns_zone_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDnsZoneOperationsRequest = ListDnsZoneOperationsRequest

@typing.final
class ListDnsZoneOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListDnsZoneOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListDnsZoneOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified DNS zone."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListDnsZoneOperationsResponse = ListDnsZoneOperationsResponse
