"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.gitlab.v1.instance_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Get"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance to return"""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___GetInstanceRequest = GetInstanceRequest

@typing.final
class ListInstancesRequest(google.protobuf.message.Message):
    """Request message for InstanceService.List."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list instances in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListInstancesRequest.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListInstancesRequest.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstancesRequest = ListInstancesRequest

@typing.final
class ListInstancesResponse(google.protobuf.message.Message):
    """Response message for InstanceService.List."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListInstancesRequest.page_size], use the [next_page_token] as the value
    for the [ListInstancesRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.gitlab.v1.instance_pb2.Instance]:
        """List of GitLab instances."""

    def __init__(
        self,
        *,
        instances: collections.abc.Iterable[yandex.cloud.gitlab.v1.instance_pb2.Instance] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instances", b"instances", "next_page_token", b"next_page_token"]) -> None: ...

global___ListInstancesResponse = ListInstancesResponse

@typing.final
class CreateInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Create."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    ADMIN_LOGIN_FIELD_NUMBER: builtins.int
    ADMIN_EMAIL_FIELD_NUMBER: builtins.int
    DOMAIN_PREFIX_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    MAINTENANCE_DELETE_UNTAGGED_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    APPROVAL_RULES_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create instance in."""
    name: builtins.str
    """Name of the instance (must be unique within the folder)."""
    description: builtins.str
    """Description of the instance."""
    resource_preset_id: builtins.str
    """ID of the resource preset for computational resources."""
    disk_size: builtins.int
    """Disk size in bytes."""
    admin_login: builtins.str
    """Admin user login."""
    admin_email: builtins.str
    """Admin user email."""
    domain_prefix: builtins.str
    """Domain prefix for the GitLab instance."""
    subnet_id: builtins.str
    """ID of the subnet where instance will be created."""
    backup_retain_period_days: builtins.int
    """Number of days to retain backups."""
    maintenance_delete_untagged: builtins.bool
    """Whether to delete untagged resources during maintenance."""
    deletion_protection: builtins.bool
    """Whether deletion protection is enabled."""
    approval_rules_id: builtins.str
    """ID of approval rules for the instance."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the instance as `` key:value `` pairs. For example, "env": "prod"."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        admin_login: builtins.str = ...,
        admin_email: builtins.str = ...,
        domain_prefix: builtins.str = ...,
        subnet_id: builtins.str = ...,
        backup_retain_period_days: builtins.int = ...,
        maintenance_delete_untagged: builtins.bool = ...,
        deletion_protection: builtins.bool = ...,
        approval_rules_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["admin_email", b"admin_email", "admin_login", b"admin_login", "approval_rules_id", b"approval_rules_id", "backup_retain_period_days", b"backup_retain_period_days", "deletion_protection", b"deletion_protection", "description", b"description", "disk_size", b"disk_size", "domain_prefix", b"domain_prefix", "folder_id", b"folder_id", "labels", b"labels", "maintenance_delete_untagged", b"maintenance_delete_untagged", "name", b"name", "resource_preset_id", b"resource_preset_id", "subnet_id", b"subnet_id"]) -> None: ...

global___CreateInstanceRequest = CreateInstanceRequest

@typing.final
class CreateInstanceMetadata(google.protobuf.message.Message):
    """Metadata message for InstanceService.Create."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance being created."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___CreateInstanceMetadata = CreateInstanceMetadata

@typing.final
class UpdateInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Update."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_DELETE_UNTAGGED_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    APPROVAL_RULES_ID_FIELD_NUMBER: builtins.int
    APPROVAL_RULES_TOKEN_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance to update."""
    name: builtins.str
    """Name of the instance (must be unique within the folder)."""
    description: builtins.str
    """Description of the instance."""
    backup_retain_period_days: builtins.int
    """Number of days to retain backups."""
    resource_preset_id: builtins.str
    """ID of the resource preset for computational resources."""
    maintenance_delete_untagged: builtins.bool
    """Whether to delete untagged resources during maintenance."""
    deletion_protection: builtins.bool
    """Whether deletion protection is enabled."""
    approval_rules_id: builtins.str
    """ID of approval rules for the instance."""
    approval_rules_token: builtins.str
    """Token of approval rules for the instance."""
    disk_size: builtins.int
    """Disk size in bytes."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the instance as `` key:value `` pairs. For example, "env": "prod" """

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the trail are going to be updated."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        backup_retain_period_days: builtins.int = ...,
        resource_preset_id: builtins.str = ...,
        maintenance_delete_untagged: builtins.bool = ...,
        deletion_protection: builtins.bool = ...,
        approval_rules_id: builtins.str = ...,
        approval_rules_token: builtins.str = ...,
        disk_size: builtins.int = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["approval_rules_id", b"approval_rules_id", "approval_rules_token", b"approval_rules_token", "backup_retain_period_days", b"backup_retain_period_days", "deletion_protection", b"deletion_protection", "description", b"description", "disk_size", b"disk_size", "instance_id", b"instance_id", "labels", b"labels", "maintenance_delete_untagged", b"maintenance_delete_untagged", "name", b"name", "resource_preset_id", b"resource_preset_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateInstanceRequest = UpdateInstanceRequest

@typing.final
class UpdateInstanceMetadata(google.protobuf.message.Message):
    """Metadata message for InstanceService.Update."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance to update."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___UpdateInstanceMetadata = UpdateInstanceMetadata

@typing.final
class DeleteInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Delete."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance to delete."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___DeleteInstanceRequest = DeleteInstanceRequest

@typing.final
class DeleteInstanceMetadata(google.protobuf.message.Message):
    """Metadata message for InstanceService.Delete."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance being deleted."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___DeleteInstanceMetadata = DeleteInstanceMetadata

@typing.final
class StartInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Start."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance to start."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StartInstanceRequest = StartInstanceRequest

@typing.final
class StartInstanceMetadata(google.protobuf.message.Message):
    """Metadata message for InstanceService.Start."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance being started."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StartInstanceMetadata = StartInstanceMetadata

@typing.final
class StopInstanceRequest(google.protobuf.message.Message):
    """Request message for InstanceService.Stop."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StopInstanceRequest = StopInstanceRequest

@typing.final
class StopInstanceMetadata(google.protobuf.message.Message):
    """Metadata message for InstanceService.Stop."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the GitLab instance being stoped."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StopInstanceMetadata = StopInstanceMetadata
