"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import yandex.cloud.iam.v1.api_key_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetApiKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the API key to return.
    To get the API key ID, use a [ApiKeyService.List] request.
    """
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id"]) -> None: ...

global___GetApiKeyRequest = GetApiKeyRequest

@typing.final
class ListApiKeysRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    service_account_id: builtins.str
    """ID of the service account to list API keys for.
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    If not specified, it defaults to the subject that made the request.
    use current subject identity if this not set
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListApiKeysResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token]
    to the [ListApiKeysResponse.next_page_token]
    returned by a previous list request.
    """
    def __init__(
        self,
        *,
        service_account_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "service_account_id", b"service_account_id"]) -> None: ...

global___ListApiKeysRequest = ListApiKeysRequest

@typing.final
class ListApiKeysResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEYS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListApiKeysRequest.page_size], use
    the [next_page_token] as the value
    for the [ListApiKeysRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def api_keys(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.iam.v1.api_key_pb2.ApiKey]:
        """List of API keys."""

    def __init__(
        self,
        *,
        api_keys: collections.abc.Iterable[yandex.cloud.iam.v1.api_key_pb2.ApiKey] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_keys", b"api_keys", "next_page_token", b"next_page_token"]) -> None: ...

global___ListApiKeysResponse = ListApiKeysResponse

@typing.final
class CreateApiKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    service_account_id: builtins.str
    """ID of the service account to create an API key for.
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    If not specified, it defaults to the subject that made the request.
    use current subject identity if this not set
    """
    description: builtins.str
    """Description of the API key."""
    scope: builtins.str
    """Draft
    Scope of the API key.
    """
    @property
    def scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Scopes of the API key."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """API key expiration timestamp, if not specified, then the API key doesn't expire"""

    def __init__(
        self,
        *,
        service_account_id: builtins.str = ...,
        description: builtins.str = ...,
        scope: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expires_at", b"expires_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "expires_at", b"expires_at", "scope", b"scope", "scopes", b"scopes", "service_account_id", b"service_account_id"]) -> None: ...

global___CreateApiKeyRequest = CreateApiKeyRequest

@typing.final
class CreateApiKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    SECRET_FIELD_NUMBER: builtins.int
    secret: builtins.str
    """Secret part of the API key. This secret key you may use in the requests for authentication."""
    @property
    def api_key(self) -> yandex.cloud.iam.v1.api_key_pb2.ApiKey:
        """ApiKey resource."""

    def __init__(
        self,
        *,
        api_key: yandex.cloud.iam.v1.api_key_pb2.ApiKey | None = ...,
        secret: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["api_key", b"api_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_key", b"api_key", "secret", b"secret"]) -> None: ...

global___CreateApiKeyResponse = CreateApiKeyResponse

@typing.final
class UpdateApiKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the ApiKey resource to update.
    To get the API key ID, use a [ApiKeyService.List] request.
    """
    description: builtins.str
    """Description of the API key."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the ApiKey resource are going to be updated."""

    @property
    def scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Scopes of the API key."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """API key expiration timestamp, if not specified, then the API key doesn't expire"""

    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expires_at", b"expires_at", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id", "description", b"description", "expires_at", b"expires_at", "scopes", b"scopes", "update_mask", b"update_mask"]) -> None: ...

global___UpdateApiKeyRequest = UpdateApiKeyRequest

@typing.final
class UpdateApiKeyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the ApiKey resource that is being updated."""
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id"]) -> None: ...

global___UpdateApiKeyMetadata = UpdateApiKeyMetadata

@typing.final
class DeleteApiKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the API key to delete.
    To get the API key ID, use a [ApiKeyService.List] request.
    """
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id"]) -> None: ...

global___DeleteApiKeyRequest = DeleteApiKeyRequest

@typing.final
class DeleteApiKeyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the API key that is being deleted."""
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id"]) -> None: ...

global___DeleteApiKeyMetadata = DeleteApiKeyMetadata

@typing.final
class ListApiKeyOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    api_key_id: builtins.str
    """ID of the key to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListApiKeyOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListApiKeyOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        api_key_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_key_id", b"api_key_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApiKeyOperationsRequest = ListApiKeyOperationsRequest

@typing.final
class ListApiKeyOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListApiKeyOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListApiKeyOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified API key."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListApiKeyOperationsResponse = ListApiKeyOperationsResponse

@typing.final
class ListApiKeyScopesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListApiKeyScopesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListApiKeyScopesResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApiKeyScopesRequest = ListApiKeyScopesRequest

@typing.final
class ListApiKeyScopesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCOPES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListApiKeyScopesRequest.page_size], use the [next_page_token] as the value
    for the [ListApiKeyScopesRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of scopes"""

    def __init__(
        self,
        *,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "scopes", b"scopes"]) -> None: ...

global___ListApiKeyScopesResponse = ListApiKeyScopesResponse
