"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Key(google.protobuf.message.Message):
    """A Key resource. For more information, see [Authorized keys](/docs/iam/concepts/authorization/key)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Algorithm:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Key._Algorithm.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALGORITHM_UNSPECIFIED: Key._Algorithm.ValueType  # 0
        RSA_2048: Key._Algorithm.ValueType  # 1
        """RSA with a 2048-bit key size. Default value."""
        RSA_4096: Key._Algorithm.ValueType  # 2
        """RSA with a 4096-bit key size."""

    class Algorithm(_Algorithm, metaclass=_AlgorithmEnumTypeWrapper): ...
    ALGORITHM_UNSPECIFIED: Key.Algorithm.ValueType  # 0
    RSA_2048: Key.Algorithm.ValueType  # 1
    """RSA with a 2048-bit key size. Default value."""
    RSA_4096: Key.Algorithm.ValueType  # 2
    """RSA with a 4096-bit key size."""

    ID_FIELD_NUMBER: builtins.int
    USER_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    KEY_ALGORITHM_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    LAST_USED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the Key resource."""
    user_account_id: builtins.str
    """ID of the user account that the Key resource belongs to."""
    service_account_id: builtins.str
    """ID of the service account that the Key resource belongs to."""
    description: builtins.str
    """Description of the Key resource. 0-256 characters long."""
    key_algorithm: global___Key.Algorithm.ValueType
    """An algorithm used to generate a key pair of the Key resource."""
    public_key: builtins.str
    """A public key of the Key resource."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def last_used_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp for the last use of this key."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_account_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        description: builtins.str = ...,
        key_algorithm: global___Key.Algorithm.ValueType = ...,
        public_key: builtins.str = ...,
        last_used_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "last_used_at", b"last_used_at", "service_account_id", b"service_account_id", "subject", b"subject", "user_account_id", b"user_account_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "id", b"id", "key_algorithm", b"key_algorithm", "last_used_at", b"last_used_at", "public_key", b"public_key", "service_account_id", b"service_account_id", "subject", b"subject", "user_account_id", b"user_account_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["subject", b"subject"]) -> typing.Literal["user_account_id", "service_account_id"] | None: ...

global___Key = Key
