"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.iam.v1.oauth_client_secret_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetOAuthClientSecretRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRET_ID_FIELD_NUMBER: builtins.int
    oauth_client_secret_id: builtins.str
    """ID of the OAuthClientSecret resource to return.
    To get the OAuthClientSecret ID, use a [OAuthClientSecretService.List] request.
    """
    def __init__(
        self,
        *,
        oauth_client_secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_secret_id", b"oauth_client_secret_id"]) -> None: ...

global___GetOAuthClientSecretRequest = GetOAuthClientSecretRequest

@typing.final
class ListOAuthClientSecretsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListOAuthClientSecretsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListOAuthClientSecretsResponse.next_page_token] returned by a previous list request.
    """
    oauth_client_id: builtins.str
    """ID of the OAuthClient resource to list OAuthClientSecret resources for.
    To get the oauth client ID, use a [yandex.cloud.iam.v1.OAuthClientService.List] request.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListOAuthClientSecretsRequest = ListOAuthClientSecretsRequest

@typing.final
class ListOAuthClientSecretsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListOAuthClientSecretsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListOAuthClientSecretsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def oauth_client_secrets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.iam.v1.oauth_client_secret_pb2.OAuthClientSecret]:
        """List of OAuthClientSecret resources of the specified OAuthClient resource"""

    def __init__(
        self,
        *,
        oauth_client_secrets: collections.abc.Iterable[yandex.cloud.iam.v1.oauth_client_secret_pb2.OAuthClientSecret] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "oauth_client_secrets", b"oauth_client_secrets"]) -> None: ...

global___ListOAuthClientSecretsResponse = ListOAuthClientSecretsResponse

@typing.final
class CreateOAuthClientSecretRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the OAuthClient resource to create OAuthClientSecret resource for.  
    To get the oauth client ID, use a [yandex.cloud.iam.v1.OAuthClientService.List] request.
    """
    description: builtins.str
    """Description of the OAuthClientResource."""
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "oauth_client_id", b"oauth_client_id"]) -> None: ...

global___CreateOAuthClientSecretRequest = CreateOAuthClientSecretRequest

@typing.final
class CreateOAuthClientSecretMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRET_ID_FIELD_NUMBER: builtins.int
    oauth_client_secret_id: builtins.str
    """ID of the OAuthClientSecretResource that is being created."""
    def __init__(
        self,
        *,
        oauth_client_secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_secret_id", b"oauth_client_secret_id"]) -> None: ...

global___CreateOAuthClientSecretMetadata = CreateOAuthClientSecretMetadata

@typing.final
class CreateOAuthClientSecretResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRET_FIELD_NUMBER: builtins.int
    SECRET_VALUE_FIELD_NUMBER: builtins.int
    secret_value: builtins.str
    """The secret value of OAuthClientSecret resource.
    This value can be used for lient secret based authentication.
    This value must be stored securely.
    """
    @property
    def oauth_client_secret(self) -> yandex.cloud.iam.v1.oauth_client_secret_pb2.OAuthClientSecret:
        """OAuthClientSecret resource."""

    def __init__(
        self,
        *,
        oauth_client_secret: yandex.cloud.iam.v1.oauth_client_secret_pb2.OAuthClientSecret | None = ...,
        secret_value: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["oauth_client_secret", b"oauth_client_secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_secret", b"oauth_client_secret", "secret_value", b"secret_value"]) -> None: ...

global___CreateOAuthClientSecretResponse = CreateOAuthClientSecretResponse

@typing.final
class DeleteOAuthClientSecretRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRET_ID_FIELD_NUMBER: builtins.int
    oauth_client_secret_id: builtins.str
    """ID of the OAuthClientSecret resource to delete."""
    def __init__(
        self,
        *,
        oauth_client_secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_secret_id", b"oauth_client_secret_id"]) -> None: ...

global___DeleteOAuthClientSecretRequest = DeleteOAuthClientSecretRequest

@typing.final
class DeleteOAuthClientSecretMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_SECRET_ID_FIELD_NUMBER: builtins.int
    oauth_client_secret_id: builtins.str
    """ID of the OAuthClientSecretResource that is being deleted."""
    def __init__(
        self,
        *,
        oauth_client_secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_secret_id", b"oauth_client_secret_id"]) -> None: ...

global___DeleteOAuthClientSecretMetadata = DeleteOAuthClientSecretMetadata
