"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetOAuthClientRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the OAuthClient resource to return.
    To get the oauth client ID, use a [OAuthClientService.List] request.
    """
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id"]) -> None: ...

global___GetOAuthClientRequest = GetOAuthClientRequest

@typing.final
class ListOAuthClientsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListOAuthClientsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListOAuthClientsResponse.next_page_token] returned by a previous list request.
    """
    folder_id: builtins.str
    """ID of the folder to list oauth clients for
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListOAuthClientsRequest = ListOAuthClientsRequest

@typing.final
class ListOAuthClientsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListOAuthClientsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListOAuthClientsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def oauth_clients(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OAuthClientListView]:
        """List of OAuthClient resource views"""

    def __init__(
        self,
        *,
        oauth_clients: collections.abc.Iterable[global___OAuthClientListView] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "oauth_clients", b"oauth_clients"]) -> None: ...

global___ListOAuthClientsResponse = ListOAuthClientsResponse

@typing.final
class OAuthClientListView(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the OAuthClient resource."""
    name: builtins.str
    """Name of the OAuthClient resource."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "name", b"name"]) -> None: ...

global___OAuthClientListView = OAuthClientListView

@typing.final
class UpdateOAuthClientMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the oauth client that is being updated"""
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id"]) -> None: ...

global___UpdateOAuthClientMetadata = UpdateOAuthClientMetadata

@typing.final
class DeleteOAuthClientMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the oauth client that is being deleted"""
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id"]) -> None: ...

global___DeleteOAuthClientMetadata = DeleteOAuthClientMetadata

@typing.final
class CreateOAuthClientRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    REDIRECT_URIS_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the oauth client.
    The name must be unique within folder.
    """
    folder_id: builtins.str
    """ID of the folder to create an oauth client in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    @property
    def redirect_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of redirect uries allowed for the oauth client."""

    @property
    def scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of oauth scopes requested by the oauth client."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        redirect_uris: collections.abc.Iterable[builtins.str] | None = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "name", b"name", "redirect_uris", b"redirect_uris", "scopes", b"scopes"]) -> None: ...

global___CreateOAuthClientRequest = CreateOAuthClientRequest

@typing.final
class CreateOAuthClientMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the oauth client that is being created"""
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id"]) -> None: ...

global___CreateOAuthClientMetadata = CreateOAuthClientMetadata

@typing.final
class UpdateOAuthClientRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    REDIRECT_URIS_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the OAuthClient resource to update.
    To get the oauth client ID, use a [OAuthClientService.List] request.
    """
    name: builtins.str
    """Name of the oauth client.
    The name must be unique within folder.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the OAuthClient resource are going to be updated."""

    @property
    def redirect_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of redirect uries allowed for the oauth client."""

    @property
    def scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of oauth scopes requested by the oauth client."""

    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        redirect_uris: collections.abc.Iterable[builtins.str] | None = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "oauth_client_id", b"oauth_client_id", "redirect_uris", b"redirect_uris", "scopes", b"scopes", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOAuthClientRequest = UpdateOAuthClientRequest

@typing.final
class DeleteOAuthClientRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OAUTH_CLIENT_ID_FIELD_NUMBER: builtins.int
    oauth_client_id: builtins.str
    """ID of the oauth client to delete.
    To get the oauth client ID, use [OAuthClientService.list] request.
    """
    def __init__(
        self,
        *,
        oauth_client_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["oauth_client_id", b"oauth_client_id"]) -> None: ...

global___DeleteOAuthClientRequest = DeleteOAuthClientRequest
