"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class RefreshToken(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProtectionLevel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProtectionLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RefreshToken._ProtectionLevel.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROTECTION_LEVEL_UNSPECIFIED: RefreshToken._ProtectionLevel.ValueType  # 0
        NO_PROTECTION: RefreshToken._ProtectionLevel.ValueType  # 1
        """Refresh token without DPOP"""
        INSECURE_KEY_DPOP: RefreshToken._ProtectionLevel.ValueType  # 2
        """Refresh token with dpop. The dpop key is not a YubiKey PIV key with required pin/touch policy and attestation."""
        SECURE_KEY_DPOP: RefreshToken._ProtectionLevel.ValueType  # 3
        """Refresh token with dpop. The dpop key is a YubiKey PIV key with required pin/touch policy and attestation."""

    class ProtectionLevel(_ProtectionLevel, metaclass=_ProtectionLevelEnumTypeWrapper):
        """Protection level of the refresh token."""

    PROTECTION_LEVEL_UNSPECIFIED: RefreshToken.ProtectionLevel.ValueType  # 0
    NO_PROTECTION: RefreshToken.ProtectionLevel.ValueType  # 1
    """Refresh token without DPOP"""
    INSECURE_KEY_DPOP: RefreshToken.ProtectionLevel.ValueType  # 2
    """Refresh token with dpop. The dpop key is not a YubiKey PIV key with required pin/touch policy and attestation."""
    SECURE_KEY_DPOP: RefreshToken.ProtectionLevel.ValueType  # 3
    """Refresh token with dpop. The dpop key is a YubiKey PIV key with required pin/touch policy and attestation."""

    ID_FIELD_NUMBER: builtins.int
    CLIENT_INSTANCE_INFO_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    SUBJECT_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    LAST_USED_AT_FIELD_NUMBER: builtins.int
    PROTECTION_LEVEL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Refresh Token id."""
    client_instance_info: builtins.str
    """Information about the app for which the Refresh Token was issued."""
    client_id: builtins.str
    """The OAuth client identifier for which the Refresh Token was issued."""
    subject_id: builtins.str
    """The subject identifier for whom the Refresh Token was issued."""
    protection_level: global___RefreshToken.ProtectionLevel.ValueType
    """Protection level of the refresh token.

    It shows whether DPOP was used to protect the Refresh Token and and the level of security of the storage used for the DPOP key.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Refresh token creation time."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Refresh token expiration time."""

    @property
    def last_used_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp for the last authentication using this Refresh Token."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        client_instance_info: builtins.str = ...,
        client_id: builtins.str = ...,
        subject_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_used_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        protection_level: global___RefreshToken.ProtectionLevel.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "expires_at", b"expires_at", "last_used_at", b"last_used_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_id", b"client_id", "client_instance_info", b"client_instance_info", "created_at", b"created_at", "expires_at", b"expires_at", "id", b"id", "last_used_at", b"last_used_at", "protection_level", b"protection_level", "subject_id", b"subject_id"]) -> None: ...

global___RefreshToken = RefreshToken
