"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.k8s.marketplace.v1.helm_release_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ListHelmReleasesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """The ID of the Kubernetes cluster to list Helm releases from."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned."""
    page_token: builtins.str
    """Token for pagination to retrieve the next page of results."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListHelmReleasesRequest = ListHelmReleasesRequest

@typing.final
class ListHelmReleasesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HELM_RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of Helm releases."""
    @property
    def helm_releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.k8s.marketplace.v1.helm_release_pb2.HelmRelease]:
        """List of Helm releases in the Kubernetes cluster."""

    def __init__(
        self,
        *,
        helm_releases: collections.abc.Iterable[yandex.cloud.k8s.marketplace.v1.helm_release_pb2.HelmRelease] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["helm_releases", b"helm_releases", "next_page_token", b"next_page_token"]) -> None: ...

global___ListHelmReleasesResponse = ListHelmReleasesResponse

@typing.final
class GetHelmReleaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the Helm release to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___GetHelmReleaseRequest = GetHelmReleaseRequest

@typing.final
class InstallHelmReleaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_ID_FIELD_NUMBER: builtins.int
    USER_VALUES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """The ID of the Kubernetes cluster where the Helm release is to be installed."""
    product_version_id: builtins.str
    """The product version ID to install."""
    @property
    def user_values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ValueWithKey]:
        """User-defined values for the Helm chart during installation."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        product_version_id: builtins.str = ...,
        user_values: collections.abc.Iterable[global___ValueWithKey] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "product_version_id", b"product_version_id", "user_values", b"user_values"]) -> None: ...

global___InstallHelmReleaseRequest = InstallHelmReleaseRequest

@typing.final
class InstallHelmReleaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HELM_RELEASE_ID_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """The ID of the Kubernetes cluster where the Helm release is being installed."""
    helm_release_id: builtins.str
    """The ID of the Helm release being installed."""
    product_version_id: builtins.str
    """The ID of the product version being deployed."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        helm_release_id: builtins.str = ...,
        product_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "helm_release_id", b"helm_release_id", "product_version_id", b"product_version_id"]) -> None: ...

global___InstallHelmReleaseMetadata = InstallHelmReleaseMetadata

@typing.final
class UpdateHelmReleaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_ID_FIELD_NUMBER: builtins.int
    USER_VALUES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the Helm release to update."""
    product_version_id: builtins.str
    """The ID of the new product version for the release."""
    @property
    def user_values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ValueWithKey]:
        """Custom user values to apply during the update."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        product_version_id: builtins.str = ...,
        user_values: collections.abc.Iterable[global___ValueWithKey] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "product_version_id", b"product_version_id", "user_values", b"user_values"]) -> None: ...

global___UpdateHelmReleaseRequest = UpdateHelmReleaseRequest

@typing.final
class UpdateHelmReleaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HELM_RELEASE_ID_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """The ID of the Kubernetes cluster where the Helm release is being updated."""
    helm_release_id: builtins.str
    """The ID of the Helm release being updated."""
    product_version_id: builtins.str
    """The ID of the new product version to update the Helm release to."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        helm_release_id: builtins.str = ...,
        product_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "helm_release_id", b"helm_release_id", "product_version_id", b"product_version_id"]) -> None: ...

global___UpdateHelmReleaseMetadata = UpdateHelmReleaseMetadata

@typing.final
class UninstallHelmReleaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the Helm release to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___UninstallHelmReleaseRequest = UninstallHelmReleaseRequest

@typing.final
class UninstallHelmReleaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HELM_RELEASE_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """The ID of the Kubernetes cluster where the release is being uninstalled."""
    helm_release_id: builtins.str
    """The ID of the Helm release being uninstalled."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        helm_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "helm_release_id", b"helm_release_id"]) -> None: ...

global___UninstallHelmReleaseMetadata = UninstallHelmReleaseMetadata

@typing.final
class ValueWithKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The key associated with the value."""
    @property
    def value(self) -> global___Value:
        """The value associated with the key."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: global___Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

global___ValueWithKey = ValueWithKey

@typing.final
class Value(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPED_VALUE_FIELD_NUMBER: builtins.int
    typed_value: builtins.str
    """The typed string value."""
    def __init__(
        self,
        *,
        typed_value: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["typed_value", b"typed_value", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["typed_value", b"typed_value", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["value", b"value"]) -> typing.Literal["typed_value"] | None: ...

global___Value = Value
