"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.message
import typing
import yandex.cloud.kms.v1.symmetric_key_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SymmetricEncryptRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    AAD_CONTEXT_FIELD_NUMBER: builtins.int
    PLAINTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key to use for encryption."""
    version_id: builtins.str
    """ID of the key version to encrypt plaintext with.
    Defaults to the primary version if not specified.
    """
    aad_context: builtins.bytes
    """Additional authenticated data (AAD context), optional.
    If specified, this data will be required for decryption with the [SymmetricDecryptRequest].
    Should be encoded with base64.
    """
    plaintext: builtins.bytes
    """Plaintext to be encrypted.
    Should be encoded with base64.
    """
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        aad_context: builtins.bytes = ...,
        plaintext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aad_context", b"aad_context", "key_id", b"key_id", "plaintext", b"plaintext", "version_id", b"version_id"]) -> None: ...

global___SymmetricEncryptRequest = SymmetricEncryptRequest

@typing.final
class SymmetricEncryptResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key that was used for encryption."""
    version_id: builtins.str
    """ID of the key version that was used for encryption."""
    ciphertext: builtins.bytes
    """Resulting ciphertext."""
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        ciphertext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ciphertext", b"ciphertext", "key_id", b"key_id", "version_id", b"version_id"]) -> None: ...

global___SymmetricEncryptResponse = SymmetricEncryptResponse

@typing.final
class SymmetricDecryptRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    AAD_CONTEXT_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key to use for decryption."""
    aad_context: builtins.bytes
    """Additional authenticated data, must be the same as was provided
    in the corresponding [SymmetricEncryptRequest].
    Should be encoded with base64.
    """
    ciphertext: builtins.bytes
    """Ciphertext to be decrypted.
    Should be encoded with base64.
    """
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        aad_context: builtins.bytes = ...,
        ciphertext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aad_context", b"aad_context", "ciphertext", b"ciphertext", "key_id", b"key_id"]) -> None: ...

global___SymmetricDecryptRequest = SymmetricDecryptRequest

@typing.final
class SymmetricDecryptResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    PLAINTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key that was used for decryption."""
    version_id: builtins.str
    """ID of the key version that was used for decryption."""
    plaintext: builtins.bytes
    """Decrypted plaintext."""
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        plaintext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key_id", b"key_id", "plaintext", b"plaintext", "version_id", b"version_id"]) -> None: ...

global___SymmetricDecryptResponse = SymmetricDecryptResponse

@typing.final
class GenerateDataKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    AAD_CONTEXT_FIELD_NUMBER: builtins.int
    DATA_KEY_SPEC_FIELD_NUMBER: builtins.int
    SKIP_PLAINTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key that the generated data key should be encrypted with."""
    version_id: builtins.str
    """ID of the key version to encrypt the generated data key with.
    Defaults to the primary version if not specified.
    """
    aad_context: builtins.bytes
    """Additional authenticated data (AAD context), optional.
    If specified, this data will be required for decryption with the [SymmetricDecryptRequest].
    Should be encoded with base64.
    """
    data_key_spec: yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricAlgorithm.ValueType
    """Encryption algorithm and key length for the generated data key."""
    skip_plaintext: builtins.bool
    """If `true`, the method won't return the data key as plaintext.
    Default value is `false`.
    """
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        aad_context: builtins.bytes = ...,
        data_key_spec: yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricAlgorithm.ValueType = ...,
        skip_plaintext: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aad_context", b"aad_context", "data_key_spec", b"data_key_spec", "key_id", b"key_id", "skip_plaintext", b"skip_plaintext", "version_id", b"version_id"]) -> None: ...

global___GenerateDataKeyRequest = GenerateDataKeyRequest

@typing.final
class GenerateDataKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    DATA_KEY_PLAINTEXT_FIELD_NUMBER: builtins.int
    DATA_KEY_CIPHERTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the symmetric KMS key that was used to encrypt the generated data key."""
    version_id: builtins.str
    """ID of the key version that was used for encryption."""
    data_key_plaintext: builtins.bytes
    """Generated data key as plaintext.
    The field is empty, if the [GenerateDataKeyRequest.skip_plaintext] parameter
    was set to `true`.
    """
    data_key_ciphertext: builtins.bytes
    """The encrypted data key."""
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        data_key_plaintext: builtins.bytes = ...,
        data_key_ciphertext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_key_ciphertext", b"data_key_ciphertext", "data_key_plaintext", b"data_key_plaintext", "key_id", b"key_id", "version_id", b"version_id"]) -> None: ...

global___GenerateDataKeyResponse = GenerateDataKeyResponse

@typing.final
class SymmetricReEncryptRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    AAD_CONTEXT_FIELD_NUMBER: builtins.int
    SOURCE_KEY_ID_FIELD_NUMBER: builtins.int
    SOURCE_AAD_CONTEXT_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the new key to be used for encryption."""
    version_id: builtins.str
    """ID of the version of the new key to be used for encryption.
    Defaults to the primary version if not specified.
    """
    aad_context: builtins.bytes
    """Additional authenticated data to be required for decryption.
    Should be encoded with base64.
    """
    source_key_id: builtins.str
    """ID of the key that the ciphertext is currently encrypted with. May be the same as for the new key."""
    source_aad_context: builtins.bytes
    """Additional authenticated data provided with the initial encryption request.
    Should be encoded with base64.
    """
    ciphertext: builtins.bytes
    """Ciphertext to re-encrypt.
    Should be encoded with base64.
    """
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        aad_context: builtins.bytes = ...,
        source_key_id: builtins.str = ...,
        source_aad_context: builtins.bytes = ...,
        ciphertext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aad_context", b"aad_context", "ciphertext", b"ciphertext", "key_id", b"key_id", "source_aad_context", b"source_aad_context", "source_key_id", b"source_key_id", "version_id", b"version_id"]) -> None: ...

global___SymmetricReEncryptRequest = SymmetricReEncryptRequest

@typing.final
class SymmetricReEncryptResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    SOURCE_KEY_ID_FIELD_NUMBER: builtins.int
    SOURCE_VERSION_ID_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    """ID of the key that the ciphertext is encrypted with now."""
    version_id: builtins.str
    """ID of key version that was used for encryption."""
    source_key_id: builtins.str
    """ID of the key that the ciphertext was encrypted with previously."""
    source_version_id: builtins.str
    """ID of the key version that was used to decrypt the re-encrypted ciphertext."""
    ciphertext: builtins.bytes
    """Resulting re-encrypted ciphertext."""
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        version_id: builtins.str = ...,
        source_key_id: builtins.str = ...,
        source_version_id: builtins.str = ...,
        ciphertext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ciphertext", b"ciphertext", "key_id", b"key_id", "source_key_id", b"source_key_id", "source_version_id", b"source_version_id", "version_id", b"version_id"]) -> None: ...

global___SymmetricReEncryptResponse = SymmetricReEncryptResponse
