"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.loadbalancer.v1.health_check_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _IpVersion:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IpVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IpVersion.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IP_VERSION_UNSPECIFIED: _IpVersion.ValueType  # 0
    IPV4: _IpVersion.ValueType  # 1
    """IPv4"""
    IPV6: _IpVersion.ValueType  # 2
    """IPv6"""

class IpVersion(_IpVersion, metaclass=_IpVersionEnumTypeWrapper):
    """IP version of the addresses that the load balancer works with.
    Only IPv4 is currently available.
    """

IP_VERSION_UNSPECIFIED: IpVersion.ValueType  # 0
IPV4: IpVersion.ValueType  # 1
"""IPv4"""
IPV6: IpVersion.ValueType  # 2
"""IPv6"""
global___IpVersion = IpVersion

@typing.final
class NetworkLoadBalancer(google.protobuf.message.Message):
    """A NetworkLoadBalancer resource. For more information, see [Network Load Balancer](/docs/network-load-balancer/concepts)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NetworkLoadBalancer._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: NetworkLoadBalancer._Status.ValueType  # 0
        CREATING: NetworkLoadBalancer._Status.ValueType  # 1
        """Network load balancer is being created."""
        STARTING: NetworkLoadBalancer._Status.ValueType  # 2
        """Network load balancer is being started."""
        ACTIVE: NetworkLoadBalancer._Status.ValueType  # 3
        """Network load balancer is active and sends traffic to the targets."""
        STOPPING: NetworkLoadBalancer._Status.ValueType  # 4
        """Network load balancer is being stopped."""
        STOPPED: NetworkLoadBalancer._Status.ValueType  # 5
        """Network load balancer is stopped and doesn't send traffic to the targets."""
        DELETING: NetworkLoadBalancer._Status.ValueType  # 6
        """Network load balancer is being deleted."""
        INACTIVE: NetworkLoadBalancer._Status.ValueType  # 7
        """The load balancer doesn't have any listeners or target groups, or
        attached target groups are empty. The load balancer doesn't perform any health checks or
        send traffic in this state.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: NetworkLoadBalancer.Status.ValueType  # 0
    CREATING: NetworkLoadBalancer.Status.ValueType  # 1
    """Network load balancer is being created."""
    STARTING: NetworkLoadBalancer.Status.ValueType  # 2
    """Network load balancer is being started."""
    ACTIVE: NetworkLoadBalancer.Status.ValueType  # 3
    """Network load balancer is active and sends traffic to the targets."""
    STOPPING: NetworkLoadBalancer.Status.ValueType  # 4
    """Network load balancer is being stopped."""
    STOPPED: NetworkLoadBalancer.Status.ValueType  # 5
    """Network load balancer is stopped and doesn't send traffic to the targets."""
    DELETING: NetworkLoadBalancer.Status.ValueType  # 6
    """Network load balancer is being deleted."""
    INACTIVE: NetworkLoadBalancer.Status.ValueType  # 7
    """The load balancer doesn't have any listeners or target groups, or
    attached target groups are empty. The load balancer doesn't perform any health checks or
    send traffic in this state.
    """

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NetworkLoadBalancer._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: NetworkLoadBalancer._Type.ValueType  # 0
        EXTERNAL: NetworkLoadBalancer._Type.ValueType  # 1
        """External network load balancer."""
        INTERNAL: NetworkLoadBalancer._Type.ValueType  # 2
        """Internal network load balancer."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: NetworkLoadBalancer.Type.ValueType  # 0
    EXTERNAL: NetworkLoadBalancer.Type.ValueType  # 1
    """External network load balancer."""
    INTERNAL: NetworkLoadBalancer.Type.ValueType  # 2
    """Internal network load balancer."""

    class _SessionAffinity:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SessionAffinityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NetworkLoadBalancer._SessionAffinity.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SESSION_AFFINITY_UNSPECIFIED: NetworkLoadBalancer._SessionAffinity.ValueType  # 0
        CLIENT_IP_PORT_PROTO: NetworkLoadBalancer._SessionAffinity.ValueType  # 1
        """5-tuple affinity."""

    class SessionAffinity(_SessionAffinity, metaclass=_SessionAffinityEnumTypeWrapper):
        """Type of session affinity. Only 5-tuple affinity is currently available.
        For more information, see [Load Balancer concepts](/docs/network-load-balancer/concepts/).
        """

    SESSION_AFFINITY_UNSPECIFIED: NetworkLoadBalancer.SessionAffinity.ValueType  # 0
    CLIENT_IP_PORT_PROTO: NetworkLoadBalancer.SessionAffinity.ValueType  # 1
    """5-tuple affinity."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    REGION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    SESSION_AFFINITY_FIELD_NUMBER: builtins.int
    LISTENERS_FIELD_NUMBER: builtins.int
    ATTACHED_TARGET_GROUPS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    ALLOW_ZONAL_SHIFT_FIELD_NUMBER: builtins.int
    DISABLE_ZONE_STATUSES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the network load balancer."""
    folder_id: builtins.str
    """ID of the folder that the network load balancer belongs to."""
    name: builtins.str
    """Name of the network load balancer. The name is unique within the folder. 3-63 characters long."""
    description: builtins.str
    """Optional description of the network load balancer. 0-256 characters long."""
    region_id: builtins.str
    """ID of the region that the network load balancer belongs to."""
    status: global___NetworkLoadBalancer.Status.ValueType
    """Status of the network load balancer."""
    type: global___NetworkLoadBalancer.Type.ValueType
    """Type of the network load balancer. Only external network load balancers are available now."""
    session_affinity: global___NetworkLoadBalancer.SessionAffinity.ValueType
    """Type of the session affinity. Only 5-tuple affinity is available now."""
    deletion_protection: builtins.bool
    """Specifies if network load balancer protected from deletion."""
    allow_zonal_shift: builtins.bool
    """Specifies if network load balancer available to zonal shift."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def listeners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Listener]:
        """List of listeners for the network load balancer."""

    @property
    def attached_target_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedTargetGroup]:
        """List of target groups attached to the network load balancer."""

    @property
    def disable_zone_statuses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DisableZoneStatus]:
        """List of disabled zones for the network load balancer."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        region_id: builtins.str = ...,
        status: global___NetworkLoadBalancer.Status.ValueType = ...,
        type: global___NetworkLoadBalancer.Type.ValueType = ...,
        session_affinity: global___NetworkLoadBalancer.SessionAffinity.ValueType = ...,
        listeners: collections.abc.Iterable[global___Listener] | None = ...,
        attached_target_groups: collections.abc.Iterable[global___AttachedTargetGroup] | None = ...,
        deletion_protection: builtins.bool = ...,
        allow_zonal_shift: builtins.bool = ...,
        disable_zone_statuses: collections.abc.Iterable[global___DisableZoneStatus] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow_zonal_shift", b"allow_zonal_shift", "attached_target_groups", b"attached_target_groups", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "disable_zone_statuses", b"disable_zone_statuses", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "listeners", b"listeners", "name", b"name", "region_id", b"region_id", "session_affinity", b"session_affinity", "status", b"status", "type", b"type"]) -> None: ...

global___NetworkLoadBalancer = NetworkLoadBalancer

@typing.final
class AttachedTargetGroup(google.protobuf.message.Message):
    """An AttachedTargetGroup resource. For more information, see [Targets and groups](/docs/network-load-balancer/concepts/target-resources)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_ID_FIELD_NUMBER: builtins.int
    HEALTH_CHECKS_FIELD_NUMBER: builtins.int
    target_group_id: builtins.str
    """ID of the target group."""
    @property
    def health_checks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.loadbalancer.v1.health_check_pb2.HealthCheck]:
        """A health check to perform on the target group.
        For now we accept only one health check per AttachedTargetGroup.
        """

    def __init__(
        self,
        *,
        target_group_id: builtins.str = ...,
        health_checks: collections.abc.Iterable[yandex.cloud.loadbalancer.v1.health_check_pb2.HealthCheck] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health_checks", b"health_checks", "target_group_id", b"target_group_id"]) -> None: ...

global___AttachedTargetGroup = AttachedTargetGroup

@typing.final
class Listener(google.protobuf.message.Message):
    """A Listener resource. For more information, see [Listener](/docs/network-load-balancer/concepts/listener)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Protocol:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Listener._Protocol.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROTOCOL_UNSPECIFIED: Listener._Protocol.ValueType  # 0
        TCP: Listener._Protocol.ValueType  # 1
        UDP: Listener._Protocol.ValueType  # 2

    class Protocol(_Protocol, metaclass=_ProtocolEnumTypeWrapper):
        """Network protocol to use."""

    PROTOCOL_UNSPECIFIED: Listener.Protocol.ValueType  # 0
    TCP: Listener.Protocol.ValueType  # 1
    UDP: Listener.Protocol.ValueType  # 2

    NAME_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    TARGET_PORT_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    IP_VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the listener. The name must be unique for each listener on a single load balancer. 3-63 characters long."""
    address: builtins.str
    """IP address for the listener."""
    port: builtins.int
    """Port."""
    protocol: global___Listener.Protocol.ValueType
    """Network protocol for incoming traffic."""
    target_port: builtins.int
    """Port of a target."""
    subnet_id: builtins.str
    """ID of the subnet."""
    ip_version: global___IpVersion.ValueType
    """IP version of the external address."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        address: builtins.str = ...,
        port: builtins.int = ...,
        protocol: global___Listener.Protocol.ValueType = ...,
        target_port: builtins.int = ...,
        subnet_id: builtins.str = ...,
        ip_version: global___IpVersion.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "ip_version", b"ip_version", "name", b"name", "port", b"port", "protocol", b"protocol", "subnet_id", b"subnet_id", "target_port", b"target_port"]) -> None: ...

global___Listener = Listener

@typing.final
class TargetState(google.protobuf.message.Message):
    """State of the target that was returned after the last health check."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TargetState._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: TargetState._Status.ValueType  # 0
        INITIAL: TargetState._Status.ValueType  # 1
        """The network load balancer is setting up health checks for this target."""
        HEALTHY: TargetState._Status.ValueType  # 2
        """Health check passed and the target is ready to receive traffic."""
        UNHEALTHY: TargetState._Status.ValueType  # 3
        """Health check failed and the target is not receiving traffic."""
        DRAINING: TargetState._Status.ValueType  # 4
        """Target is being deleted and the network load balancer is no longer sending traffic to this target."""
        INACTIVE: TargetState._Status.ValueType  # 5
        """The network load balancer is stopped and not performing health checks on this target."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the target."""

    STATUS_UNSPECIFIED: TargetState.Status.ValueType  # 0
    INITIAL: TargetState.Status.ValueType  # 1
    """The network load balancer is setting up health checks for this target."""
    HEALTHY: TargetState.Status.ValueType  # 2
    """Health check passed and the target is ready to receive traffic."""
    UNHEALTHY: TargetState.Status.ValueType  # 3
    """Health check failed and the target is not receiving traffic."""
    DRAINING: TargetState.Status.ValueType  # 4
    """Target is being deleted and the network load balancer is no longer sending traffic to this target."""
    INACTIVE: TargetState.Status.ValueType  # 5
    """The network load balancer is stopped and not performing health checks on this target."""

    SUBNET_ID_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ZONE_SHIFTED_FIELD_NUMBER: builtins.int
    subnet_id: builtins.str
    """ID of the subnet that the target is connected to."""
    address: builtins.str
    """IP address of the target."""
    status: global___TargetState.Status.ValueType
    """Status of the target."""
    zone_shifted: builtins.bool
    """Zone shifted status."""
    def __init__(
        self,
        *,
        subnet_id: builtins.str = ...,
        address: builtins.str = ...,
        status: global___TargetState.Status.ValueType = ...,
        zone_shifted: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "status", b"status", "subnet_id", b"subnet_id", "zone_shifted", b"zone_shifted"]) -> None: ...

global___TargetState = TargetState

@typing.final
class DisableZoneStatus(google.protobuf.message.Message):
    """Status of the disabled zone."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_ID_FIELD_NUMBER: builtins.int
    DISABLED_UNTIL_FIELD_NUMBER: builtins.int
    zone_id: builtins.str
    """ID of zone."""
    @property
    def disabled_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp until which the zone will be disabled.
        If not present then zone will be disabled until it is removed through a separate call.
        """

    def __init__(
        self,
        *,
        zone_id: builtins.str = ...,
        disabled_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disabled_until", b"disabled_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disabled_until", b"disabled_until", "zone_id", b"zone_id"]) -> None: ...

global___DisableZoneStatus = DisableZoneStatus
