"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2
import yandex.cloud.loadtesting.api.v1.agent.status_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Agent(google.protobuf.message.Message):
    """Load testing agent on which tests are executed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    CURRENT_JOB_ID_FIELD_NUMBER: builtins.int
    AGENT_VERSION_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    LOG_SETTINGS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the agent. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the agent belongs to."""
    name: builtins.str
    """Name of the agent."""
    description: builtins.str
    """Description of the agent."""
    compute_instance_id: builtins.str
    """ID of the compute instance managed by the agent.

    Empty if there is no such instance (i.e. the case of external agent).
    """
    status: yandex.cloud.loadtesting.api.v1.agent.status_pb2.Status.ValueType
    """Status of the agent."""
    current_job_id: builtins.str
    """ID of the test that is currently being executed by the agent."""
    agent_version_id: builtins.str
    """Version of the agent."""
    @property
    def errors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of errors reported by the agent."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Agent labels as `key:value` pairs."""

    @property
    def log_settings(self) -> yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2.LogSettings:
        """Agent log settings"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        compute_instance_id: builtins.str = ...,
        status: yandex.cloud.loadtesting.api.v1.agent.status_pb2.Status.ValueType = ...,
        errors: collections.abc.Iterable[builtins.str] | None = ...,
        current_job_id: builtins.str = ...,
        agent_version_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        log_settings: yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2.LogSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["log_settings", b"log_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agent_version_id", b"agent_version_id", "compute_instance_id", b"compute_instance_id", "current_job_id", b"current_job_id", "description", b"description", "errors", b"errors", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "log_settings", b"log_settings", "name", b"name", "status", b"status"]) -> None: ...

global___Agent = Agent
