"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Maintenance(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Maintenance._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Maintenance._Status.ValueType  # 0
        """Not set."""
        SCHEDULED: Maintenance._Status.ValueType  # 1
        """Maintenance is scheduled for a future time."""
        RUNNING: Maintenance._Status.ValueType  # 2
        """Maintenance is currently running."""
        SUCCEEDED: Maintenance._Status.ValueType  # 3
        """Maintenance completed successfully."""
        CANCELLED: Maintenance._Status.ValueType  # 4
        """Maintenance is cancelled and will not run."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Maintenance.Status.ValueType  # 0
    """Not set."""
    SCHEDULED: Maintenance.Status.ValueType  # 1
    """Maintenance is scheduled for a future time."""
    RUNNING: Maintenance.Status.ValueType  # 2
    """Maintenance is currently running."""
    SUCCEEDED: Maintenance.Status.ValueType  # 3
    """Maintenance completed successfully."""
    CANCELLED: Maintenance.Status.ValueType  # 4
    """Maintenance is cancelled and will not run."""

    @typing.final
    class Resource(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        id: builtins.str
        """ID of the resource"""
        type: builtins.str
        """The type of the resource, e.g. resource-manager.cloud, resource-manager.folder, compute.instance, etc."""
        def __init__(
            self,
            *,
            id: builtins.str = ...,
            type: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["id", b"id", "type", b"type"]) -> None: ...

    @typing.final
    class Detail(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        """Unique key (service-specific)."""
        value: builtins.str
        """Description (service-specific)."""
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    RESOURCE_PATH_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    START_SCHEDULED_AT_FIELD_NUMBER: builtins.int
    COMPLETION_SCHEDULED_AT_FIELD_NUMBER: builtins.int
    MAX_START_SCHEDULED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    SUCCEEDED_AT_FIELD_NUMBER: builtins.int
    CANCELLED_AT_FIELD_NUMBER: builtins.int
    USER_CONTROLLABLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the maintenance."""
    description: builtins.str
    """Describes action to be performed."""
    status: global___Maintenance.Status.ValueType
    """Status of the maintenance."""
    user_controllable: builtins.bool
    """Indicates whether the user can control (reschedule) the maintenance."""
    @property
    def resource_path(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Maintenance.Resource]:
        """Full path to the resource affected by maintenance,
        represented as a hierarchy from specific resource to top-level container.
        Example for a Compute instance with ID "I" in folder "F" and cloud "C":
        resource_path = [
           { "compute.instance", "I" },
           { "resource-manager.folder", "F" },
           { "resource-manager.cloud", "C" }
        ]
        """

    @property
    def details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Maintenance.Detail]:
        """Service-specific details."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The creation time of the maintenance."""

    @property
    def start_scheduled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the maintenance was scheduled to start."""

    @property
    def completion_scheduled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the maintenance is estimated to complete. Optional."""

    @property
    def max_start_scheduled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Latest time the maintenance can be postponed to."""

    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time time when the maintenance has actually started."""

    @property
    def succeeded_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time time when the maintenance has actually completed successfully."""

    @property
    def cancelled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time time when the maintenance has actually been cancelled."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        resource_path: collections.abc.Iterable[global___Maintenance.Resource] | None = ...,
        description: builtins.str = ...,
        details: collections.abc.Iterable[global___Maintenance.Detail] | None = ...,
        status: global___Maintenance.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        start_scheduled_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        completion_scheduled_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        max_start_scheduled_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        succeeded_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cancelled_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_controllable: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cancelled_at", b"cancelled_at", "completion_scheduled_at", b"completion_scheduled_at", "created_at", b"created_at", "max_start_scheduled_at", b"max_start_scheduled_at", "start_scheduled_at", b"start_scheduled_at", "started_at", b"started_at", "succeeded_at", b"succeeded_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cancelled_at", b"cancelled_at", "completion_scheduled_at", b"completion_scheduled_at", "created_at", b"created_at", "description", b"description", "details", b"details", "id", b"id", "max_start_scheduled_at", b"max_start_scheduled_at", "resource_path", b"resource_path", "start_scheduled_at", b"start_scheduled_at", "started_at", b"started_at", "status", b"status", "succeeded_at", b"succeeded_at", "user_controllable", b"user_controllable"]) -> None: ...

global___Maintenance = Maintenance

@typing.final
class ListMaintenancesRequest(google.protobuf.message.Message):
    """ListMaintenancesRequest allows listing maintenances by cloud ID, folder ID, resource type or resource ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cloud_id: builtins.str
    """Cloud ID for the resources."""
    folder_id: builtins.str
    """Folder ID for the resources."""
    resource_id: builtins.str
    """Resource ID of the target resource."""
    page_size: builtins.int
    """The maximum number of maintenances to return per response."""
    page_token: builtins.str
    """Token to retrieve the next page of results. Omitted on the first request."""
    order_by: builtins.str
    """By which field the listing should be ordered and in which direction,
    format is "created_at desc". The default sorting order is ascending.
    Supported fields: ["created_at", "start_scheduled_at", "started_at"].
    """
    filter: builtins.str
    """Filter list by various fields.
    Supported fields: ["status", "resource_type", "resource_id"]
    """
    def __init__(
        self,
        *,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        resource_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "container", b"container", "folder_id", b"folder_id", "resource_id", b"resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "container", b"container", "filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "resource_id", b"resource_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["container", b"container"]) -> typing.Literal["cloud_id", "folder_id", "resource_id"] | None: ...

global___ListMaintenancesRequest = ListMaintenancesRequest

@typing.final
class ListMaintenancesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAINTENANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token to retrieve the next page of results."""
    @property
    def maintenances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Maintenance]:
        """List of maintenances."""

    def __init__(
        self,
        *,
        maintenances: collections.abc.Iterable[global___Maintenance] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["maintenances", b"maintenances", "next_page_token", b"next_page_token"]) -> None: ...

global___ListMaintenancesResponse = ListMaintenancesResponse

@typing.final
class GetMaintenanceRequest(google.protobuf.message.Message):
    """GetMaintenanceRequest allows getting Maintenance by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAINTENANCE_ID_FIELD_NUMBER: builtins.int
    maintenance_id: builtins.str
    def __init__(
        self,
        *,
        maintenance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["maintenance_id", b"maintenance_id"]) -> None: ...

global___GetMaintenanceRequest = GetMaintenanceRequest

@typing.final
class RescheduleMaintenanceRequest(google.protobuf.message.Message):
    """RescheduleMaintenanceRequest allows to reschedule maintenance to another date and time."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RescheduleMaintenanceRequest._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: RescheduleMaintenanceRequest._Type.ValueType  # 0
        """Not set."""
        IMMEDIATE: RescheduleMaintenanceRequest._Type.ValueType  # 1
        """If the user wants to reschedule the maintenance to happen now."""
        NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest._Type.ValueType  # 2
        """If the user wants to reschedule the maintenance for the next maintenance window."""
        SPECIFIC_TIME: RescheduleMaintenanceRequest._Type.ValueType  # 3
        """If the user wants to reschedule the maintenance to a specific time."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: RescheduleMaintenanceRequest.Type.ValueType  # 0
    """Not set."""
    IMMEDIATE: RescheduleMaintenanceRequest.Type.ValueType  # 1
    """If the user wants to reschedule the maintenance to happen now."""
    NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest.Type.ValueType  # 2
    """If the user wants to reschedule the maintenance for the next maintenance window."""
    SPECIFIC_TIME: RescheduleMaintenanceRequest.Type.ValueType  # 3
    """If the user wants to reschedule the maintenance to a specific time."""

    MAINTENANCE_ID_FIELD_NUMBER: builtins.int
    RESCHEDULE_TYPE_FIELD_NUMBER: builtins.int
    SCHEDULED_AT_FIELD_NUMBER: builtins.int
    maintenance_id: builtins.str
    """Required. ID of the maintenance."""
    reschedule_type: global___RescheduleMaintenanceRequest.Type.ValueType
    """Required. If `reschedule_type` is "SPECIFIC_TIME",
    must set up `schedule_time` as well.
    """
    @property
    def scheduled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Optional. Timestamp the maintenance shall be rescheduled to,
        if `reschedule_type` = "SPECIFIC_TIME".
        Must be in RFC 3339 format (e.g. "2025-11-15T16:19:00.094Z").
        """

    def __init__(
        self,
        *,
        maintenance_id: builtins.str = ...,
        reschedule_type: global___RescheduleMaintenanceRequest.Type.ValueType = ...,
        scheduled_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["scheduled_at", b"scheduled_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["maintenance_id", b"maintenance_id", "reschedule_type", b"reschedule_type", "scheduled_at", b"scheduled_at"]) -> None: ...

global___RescheduleMaintenanceRequest = RescheduleMaintenanceRequest
